/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.export.ElementWrapper;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExporterGridCell;

public class JRGridLayout {
    private final ExporterNature nature;
    private final int width;
    private final int height;
    private final int offsetX;
    private final int offsetY;
    private final String address;
    private List xCuts;
    private List yCuts;
    private JRExporterGridCell[][] grid;
    private boolean[] isRowNotEmpty;
    private boolean[] isColNotEmpty;
    private Map boxesCache;
    private int virtualFrameIndex = 0;

    public JRGridLayout(ExporterNature nature, List elements, int width, int height, int offsetX, int offsetY) {
        this(nature, elements, width, height, offsetX, offsetY, null);
    }

    public JRGridLayout(ExporterNature nature, List elements, int width, int height, int offsetX, int offsetY, List xCuts) {
        this.nature = nature;
        this.height = height;
        this.width = width;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.address = null;
        this.xCuts = xCuts;
        this.boxesCache = new HashMap();
        this.virtualFrameIndex = elements.size();
        this.layoutGrid(JRGridLayout.createWrappers(elements, this.address));
        if (nature.isSplitSharedRowSpan()) {
            this.splitSharedRowSpanIntoNestedGrids();
        }
    }

    protected JRGridLayout(ExporterNature nature, ElementWrapper[] wrappers, int width, int height, int offsetX, int offsetY, String address) {
        this.nature = nature;
        this.height = height;
        this.width = width;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.address = address;
        this.boxesCache = new HashMap();
        this.layoutGrid(wrappers);
        if (nature.isSplitSharedRowSpan()) {
            this.splitSharedRowSpanIntoNestedGrids();
        }
    }

    private void createNestedGrid(int row1, int col1, int row2, int col2) {
        JRBasePrintFrame frame = new JRBasePrintFrame(null);
        ArrayList<ElementWrapper> wrappers = new ArrayList<ElementWrapper>();
        for (int row = row1; row < row2; ++row) {
            for (int col = col1; col < col2; ++col) {
                JRExporterGridCell gridCell = this.grid[row][col];
                this.grid[row][col] = JRExporterGridCell.OCCUPIED_CELL;
                ElementWrapper wrapper = gridCell.getWrapper();
                if (gridCell == JRExporterGridCell.OCCUPIED_CELL || wrapper == null) continue;
                wrappers.add(wrapper);
                frame.addElement(wrapper.getElement());
            }
        }
        frame.setWidth((Integer)this.xCuts.get(col2) - (Integer)this.xCuts.get(col1));
        frame.setHeight((Integer)this.yCuts.get(row2) - (Integer)this.yCuts.get(row1));
        String virtualAddress = (this.address == null ? "" : this.address + "_") + this.getNextVirtualFrameIndex();
        JRExporterGridCell gridCell = new JRExporterGridCell(new ElementWrapper(frame, virtualAddress, null), frame.getWidth(), frame.getHeight(), col2 - col1, row2 - row1);
        gridCell.setLayout(new JRGridLayout(this.nature, wrappers.toArray(new ElementWrapper[wrappers.size()]), frame.getWidth(), frame.getHeight(), this.offsetX - (Integer)this.xCuts.get(col1), this.offsetY - (Integer)this.yCuts.get(row1), virtualAddress));
        this.grid[row1][col1] = gridCell;
    }

    protected void layoutGrid(ElementWrapper[] wrappers) {
        boolean createXCuts;
        boolean bl = createXCuts = this.xCuts == null;
        if (createXCuts) {
            this.xCuts = new SortedList();
            this.xCuts.add(new Integer(0));
            this.xCuts.add(new Integer(this.width));
        }
        this.yCuts = new SortedList();
        this.yCuts.add(new Integer(0));
        this.createCuts(wrappers, this.offsetX, this.offsetY, createXCuts);
        if (!this.nature.isIgnoreLastRow()) {
            this.yCuts.add(new Integer(this.height));
        }
        int colCount = this.xCuts.size() - 1;
        int rowCount = this.yCuts.size() - 1;
        this.grid = new JRExporterGridCell[rowCount][colCount];
        this.isRowNotEmpty = new boolean[rowCount];
        this.isColNotEmpty = new boolean[colCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < colCount; ++col) {
                this.grid[row][col] = new JRExporterGridCell(null, (Integer)this.xCuts.get(col + 1) - (Integer)this.xCuts.get(col), (Integer)this.yCuts.get(row + 1) - (Integer)this.yCuts.get(row), 1, 1);
            }
        }
        this.setGridElements(wrappers, this.offsetX, this.offsetY);
    }

    protected void createCuts(ElementWrapper[] wrappers, int elementOffsetX, int elementOffsetY, boolean createXCuts) {
        for (int elementIndex = 0; elementIndex < wrappers.length; ++elementIndex) {
            JRPrintFrame frame;
            ElementWrapper wrapper = wrappers[elementIndex];
            JRPrintElement element = wrapper.getElement();
            int x = element.getX() + elementOffsetX;
            int y = element.getY() + elementOffsetY;
            if (this.nature.isToExport(element)) {
                if (createXCuts) {
                    this.xCuts.add(new Integer(x));
                    this.xCuts.add(new Integer(x + element.getWidth()));
                }
                this.yCuts.add(new Integer(y));
                this.yCuts.add(new Integer(y + element.getHeight()));
            }
            JRPrintFrame jRPrintFrame = frame = element instanceof JRPrintFrame ? (JRPrintFrame)element : null;
            if (!this.nature.isDeep() || frame == null) continue;
            this.createCuts(wrapper.getWrappers(), x + frame.getLeftPadding(), y + frame.getTopPadding(), createXCuts);
        }
    }

    protected void setGridElements(ElementWrapper[] wrappers, int elementOffsetX, int elementOffsetY) {
        for (int elementIndex = wrappers.length - 1; elementIndex >= 0; --elementIndex) {
            JRPrintFrame frame;
            ElementWrapper wrapper = wrappers[elementIndex];
            JRPrintElement element = wrapper.getElement();
            boolean toExport = this.nature.isToExport(element);
            JRPrintFrame jRPrintFrame = frame = element instanceof JRPrintFrame ? (JRPrintFrame)element : null;
            if (!toExport && frame == null) continue;
            int x = element.getX() + elementOffsetX;
            int y = element.getY() + elementOffsetY;
            if (this.nature.isDeep() && frame != null) {
                this.setGridElements(wrapper.getWrappers(), x + frame.getLeftPadding(), y + frame.getTopPadding());
            }
            if (!toExport) continue;
            int col1 = this.xCuts.indexOf(new Integer(x));
            int row1 = this.yCuts.indexOf(new Integer(y));
            int col2 = this.xCuts.indexOf(new Integer(x + element.getWidth()));
            int row2 = this.yCuts.indexOf(new Integer(y + element.getHeight()));
            if (!this.isOverlap(row1, col1, row2, col2)) {
                this.setGridElement(wrapper, row1, col1, row2, col2);
            }
            if (!this.nature.isDeep() || frame == null) continue;
            this.setFrameCellsStyle(frame, row1, col1, row2, col2);
        }
    }

    protected boolean isOverlap(int row1, int col1, int row2, int col2) {
        boolean isOverlap;
        block4: {
            isOverlap = false;
            if (this.nature.isSpanCells()) {
                for (int row = row1; row < row2; ++row) {
                    for (int col = col1; col < col2; ++col) {
                        if (this.grid[row][col].getWrapper() == null) continue;
                        isOverlap = true;
                        break block4;
                    }
                }
            } else {
                isOverlap = this.grid[row1][col1].getWrapper() != null;
            }
        }
        return isOverlap;
    }

    protected void setGridElement(ElementWrapper wrapper, int row1, int col1, int row2, int col2) {
        if (this.nature.isSpanCells()) {
            for (int row = row1; row < row2; ++row) {
                for (int col = col1; col < col2; ++col) {
                    this.grid[row][col] = JRExporterGridCell.OCCUPIED_CELL;
                }
                this.isRowNotEmpty[row] = true;
            }
            for (int col = col1; col < col2; ++col) {
                this.isColNotEmpty[col] = true;
            }
        } else {
            this.isRowNotEmpty[row1] = true;
            this.isColNotEmpty[col1] = true;
        }
        if (col2 - col1 != 0 && row2 - row1 != 0) {
            JRPrintElement element = wrapper.getElement();
            JRPrintFrame frame = element instanceof JRPrintFrame ? (JRPrintFrame)element : null;
            JRExporterGridCell gridCell = new JRExporterGridCell(wrapper, element.getWidth(), element.getHeight(), col2 - col1, row2 - row1);
            if (frame != null) {
                gridCell.setLayout(new JRGridLayout(this.nature, wrapper.getWrappers(), frame.getWidth(), frame.getHeight(), 0, 0, wrapper.getAddress()));
            }
            JRBox cellBox = null;
            if (element instanceof JRBox) {
                cellBox = (JRBox)((Object)element);
            }
            gridCell.setBox(cellBox);
            this.grid[row1][col1] = gridCell;
        }
    }

    protected void setFrameCellsStyle(JRPrintFrame frame, int row1, int col1, int row2, int col2) {
        Color backcolor = frame.getMode() == 1 ? frame.getBackcolor() : null;
        for (int row = row1; row < row2; ++row) {
            for (int col = col1; col < col2; ++col) {
                boolean bottom;
                JRExporterGridCell cell = this.grid[row][col];
                if (cell.getBackcolor() == null && frame.getMode() == 1) {
                    cell.setBackcolor(backcolor);
                }
                if (cell.getForecolor() == null) {
                    cell.setForecolor(frame.getForecolor());
                }
                boolean left = col == col1;
                boolean right = col == col2 - cell.getColSpan();
                boolean top = row == row1;
                boolean bl = bottom = row == row2 - cell.getRowSpan();
                if (!left && !right && !top && !bottom) continue;
                JRBox cellBox = cell.getBox();
                BoxKey key = new BoxKey(frame, cellBox, left, right, top, bottom);
                JRBox modBox = (JRBox)this.boxesCache.get(key);
                if (modBox == null) {
                    modBox = new JRBaseBox(frame, left, right, top, bottom, cellBox);
                    this.boxesCache.put(key, modBox);
                }
                cell.setBox(modBox);
            }
        }
    }

    private void splitSharedRowSpanIntoNestedGrids() {
        int rowSpan;
        for (int row = 0; row < this.grid.length; row += Math.abs(rowSpan)) {
            rowSpan = this.getSharedRowSpan(row);
            if (rowSpan <= 0) continue;
            this.splitSharedColSpanIntoNestedGrids(row, row + rowSpan);
        }
    }

    private void splitSharedColSpanIntoNestedGrids(int row1, int row2) {
        int colSpan;
        for (int col = 0; col < this.grid[row1].length; col += Math.abs(colSpan)) {
            colSpan = this.getSharedColSpan(row1, row2, col);
            if (colSpan <= 0 || row1 == 0 && row2 == this.grid.length && col == 0 && colSpan == this.grid[0].length) continue;
            this.createNestedGrid(row1, col, row2, col + colSpan);
        }
    }

    private int getSharedRowSpan(int row1) {
        int rowSpan = 1;
        int sharedSpanCount = 0;
        for (int row = 0; row < rowSpan; ++row) {
            for (int col = 0; col < this.grid[0].length; ++col) {
                JRExporterGridCell gridCell = this.grid[row1 + row][col];
                if (row + gridCell.getRowSpan() <= rowSpan) continue;
                ++sharedSpanCount;
                rowSpan = row + gridCell.getRowSpan();
            }
        }
        return sharedSpanCount > 1 ? rowSpan : -rowSpan;
    }

    private int getSharedColSpan(int row1, int row2, int col1) {
        int colSpan = 1;
        boolean isSharedSpan = false;
        for (int col = 0; col < colSpan; ++col) {
            for (int row = row1; row < row2; ++row) {
                JRExporterGridCell gridCell = this.grid[row][col1 + col];
                if (col + gridCell.getColSpan() > colSpan) {
                    isSharedSpan = true;
                    colSpan = col + gridCell.getColSpan();
                    continue;
                }
                if (gridCell.getRowSpan() <= 1) continue;
                isSharedSpan = true;
            }
        }
        return isSharedSpan ? colSpan : -colSpan;
    }

    public JRExporterGridCell[][] getGrid() {
        return this.grid;
    }

    public boolean[] getIsRowNotEmpty() {
        return this.isRowNotEmpty;
    }

    public boolean isRowNotEmpty(int rowIdx) {
        return this.isRowNotEmpty[rowIdx];
    }

    public boolean[] getIsColumnNotEmpty() {
        return this.isColNotEmpty;
    }

    public List getXCuts() {
        return this.xCuts;
    }

    public List getYCuts() {
        return this.yCuts;
    }

    public int getWidth() {
        return this.width;
    }

    public int getRowHeight(int row) {
        return (Integer)this.yCuts.get(row + 1) - (Integer)this.yCuts.get(row);
    }

    public static int getRowHeight(JRExporterGridCell[] row) {
        int col;
        if (row[0].getRowSpan() == 1 && row[0] != JRExporterGridCell.OCCUPIED_CELL) {
            return row[0].getHeight();
        }
        int rowHeight = 0;
        int minSpanIdx = 0;
        int colCount = row.length;
        for (col = 0; col < colCount; ++col) {
            JRExporterGridCell cell = row[col];
            if (cell == JRExporterGridCell.OCCUPIED_CELL) continue;
            if (cell.getRowSpan() == 1) {
                rowHeight = cell.getHeight();
                break;
            }
            if (cell.getRowSpan() >= row[minSpanIdx].getRowSpan()) continue;
            minSpanIdx = col;
        }
        if (col >= colCount) {
            rowHeight = row[minSpanIdx].getHeight();
        }
        return rowHeight;
    }

    public static List calculateXCuts(ExporterNature nature, List pages, int startPageIndex, int endPageIndex, int width, int offsetX) {
        SortedList xCuts = new SortedList();
        xCuts.add(new Integer(0));
        xCuts.add(new Integer(width));
        for (int pageIndex = startPageIndex; pageIndex <= endPageIndex; ++pageIndex) {
            JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
            JRGridLayout.addXCuts(nature, page.getElements(), offsetX, xCuts);
        }
        return xCuts;
    }

    protected static void addXCuts(ExporterNature nature, List elementsList, int elementOffsetX, List xCuts) {
        Iterator it = elementsList.iterator();
        while (it.hasNext()) {
            JRPrintElement element = (JRPrintElement)it.next();
            int x = element.getX() + elementOffsetX;
            if (nature.isToExport(element)) {
                xCuts.add(new Integer(x));
                xCuts.add(new Integer(x + element.getWidth()));
            }
            if (!(element instanceof JRPrintFrame)) continue;
            JRPrintFrame frame = (JRPrintFrame)element;
            JRGridLayout.addXCuts(nature, frame.getElements(), x + frame.getLeftPadding(), xCuts);
        }
    }

    protected int getNextVirtualFrameIndex() {
        return this.virtualFrameIndex++;
    }

    private static ElementWrapper[] createWrappers(List elementsList, String parentAddress) {
        ElementWrapper[] wrappers = new ElementWrapper[elementsList.size()];
        for (int elementIndex = 0; elementIndex < elementsList.size(); ++elementIndex) {
            JRPrintElement element = (JRPrintElement)elementsList.get(elementIndex);
            String address = (parentAddress == null ? "" : parentAddress + "_") + elementIndex;
            wrappers[elementIndex] = new ElementWrapper(element, address, element instanceof JRPrintFrame ? JRGridLayout.createWrappers(((JRPrintFrame)element).getElements(), address) : null);
        }
        return wrappers;
    }

    protected static class BoxKey {
        final JRBox box;
        final JRBox cellBox;
        final boolean left;
        final boolean right;
        final boolean top;
        final boolean bottom;
        final int hashCode;

        BoxKey(JRBox box, JRBox cellBox, boolean left, boolean right, boolean top, boolean bottom) {
            this.box = box;
            this.cellBox = cellBox;
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
            int hash = box.hashCode();
            if (cellBox != null) {
                hash = 31 * hash + cellBox.hashCode();
            }
            hash = 31 * hash + (left ? 1231 : 1237);
            hash = 31 * hash + (right ? 1231 : 1237);
            hash = 31 * hash + (top ? 1231 : 1237);
            this.hashCode = hash = 31 * hash + (bottom ? 1231 : 1237);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            BoxKey b = (BoxKey)obj;
            return b.box.equals(this.box) && (b.cellBox == null ? this.cellBox == null : this.cellBox != null && b.cellBox.equals(this.cellBox)) && b.left == this.left && b.right == this.right && b.top == this.top && b.bottom == this.bottom;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    protected static class SortedList
    extends ArrayList {
        private static final long serialVersionUID = 6232843428269907513L;

        protected SortedList() {
        }

        public boolean add(Object o) {
            int idx = Collections.binarySearch(this, o);
            if (idx >= 0) {
                return false;
            }
            this.add(-idx - 1, o);
            return true;
        }

        public int indexOf(Object o) {
            int idx = Collections.binarySearch(this, o);
            if (idx < 0) {
                idx = -1;
            }
            return idx;
        }
    }
}

