/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.subdataset;

import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.subdataset.GroupDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class GroupsDialog
extends JDialog {
    private SubDataset subDataset = null;
    private JButton jButtonDeleteGroup;
    private JButton jButtonModifyGroup;
    private JButton jButtonMoveDownGroup;
    private JButton jButtonMoveUpGroup;
    private JButton jButtonNewGroup;
    private JPanel jPanelButtons;
    private JPanel jPanelFields;
    private JScrollPane jScrollPane3;
    private JTable jTableGroups;

    public GroupsDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.setSize(420, 250);
        Misc.centerFrame(this);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableGroups.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GroupsDialog.this.jTableGroupsListSelectionValueChanged(e);
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                GroupsDialog.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    public void jTableGroupsListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableGroups.getSelectedRowCount() == 1 && this.jTableGroups.getRowCount() > 1) {
            int row = this.jTableGroups.getSelectedRows()[0];
            this.jButtonMoveDownGroup.setEnabled(row != this.jTableGroups.getRowCount() - 1);
            this.jButtonMoveUpGroup.setEnabled(row != 0);
        } else {
            this.jButtonMoveDownGroup.setEnabled(false);
            this.jButtonMoveUpGroup.setEnabled(false);
        }
        if (this.jTableGroups.getSelectedRowCount() > 0) {
            this.jButtonModifyGroup.setEnabled(true);
            this.jButtonDeleteGroup.setEnabled(true);
        } else {
            this.jButtonModifyGroup.setEnabled(false);
            this.jButtonDeleteGroup.setEnabled(false);
        }
    }

    public void updateGroups() {
        if (this.getSubDataset() == null) {
            return;
        }
        int[] selectedRows = this.jTableGroups.getSelectedRows();
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedObjects.add(this.jTableGroups.getValueAt(selectedRows[i], 0));
        }
        DefaultTableModel dtm = (DefaultTableModel)this.jTableGroups.getModel();
        dtm.setRowCount(0);
        int k = 0;
        Iterator i = this.getSubDataset().getGroups().iterator();
        while (i.hasNext()) {
            Group group = (Group)i.next();
            Vector<Group> row = new Vector<Group>();
            row.addElement(group);
            dtm.addRow(row);
            if (selectedObjects.contains(group)) {
                this.jTableGroups.getSelectionModel().addSelectionInterval(k, k);
            }
            ++k;
        }
    }

    private void initComponents() {
        this.jPanelFields = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTableGroups = new JTable();
        this.jPanelButtons = new JPanel();
        this.jButtonNewGroup = new JButton();
        this.jButtonModifyGroup = new JButton();
        this.jButtonMoveUpGroup = new JButton();
        this.jButtonMoveDownGroup = new JButton();
        this.jButtonDeleteGroup = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GroupsDialog.this.closeDialog(evt);
            }
        });
        this.jPanelFields.setLayout(new BorderLayout());
        this.jScrollPane3.setBackground(new Color(255, 255, 255));
        this.jTableGroups.setModel(new DefaultTableModel(new Object[0][], new String[]{"Group name"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableGroups.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GroupsDialog.this.jTableGroupsMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTableGroups);
        this.jPanelFields.add((Component)this.jScrollPane3, "Center");
        this.jPanelButtons.setLayout(new GridBagLayout());
        this.jPanelButtons.setPreferredSize(new Dimension(100, 10));
        this.jPanelButtons.setMinimumSize(new Dimension(100, 10));
        this.jButtonNewGroup.setText("New");
        this.jButtonNewGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupsDialog.this.jButtonNewGroupActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonNewGroup, gridBagConstraints);
        this.jButtonModifyGroup.setText("Modify");
        this.jButtonModifyGroup.setEnabled(false);
        this.jButtonModifyGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupsDialog.this.jButtonModifyGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonModifyGroup, gridBagConstraints);
        this.jButtonMoveUpGroup.setText("Move Up");
        this.jButtonMoveUpGroup.setEnabled(false);
        this.jButtonMoveUpGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupsDialog.this.jButtonMoveUpGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonMoveUpGroup, gridBagConstraints);
        this.jButtonMoveDownGroup.setText("Move Down");
        this.jButtonMoveDownGroup.setEnabled(false);
        this.jButtonMoveDownGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupsDialog.this.jButtonMoveDownGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonMoveDownGroup, gridBagConstraints);
        this.jButtonDeleteGroup.setText("Delete");
        this.jButtonDeleteGroup.setEnabled(false);
        this.jButtonDeleteGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupsDialog.this.jButtonDeleteGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonDeleteGroup, gridBagConstraints);
        this.jPanelFields.add((Component)this.jPanelButtons, "East");
        this.getContentPane().add((Component)this.jPanelFields, "Center");
        this.pack();
    }

    private void jTableGroupsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                this.jButtonModifyGroupActionPerformed(null);
            }
        }
    }

    private void jButtonMoveDownGroupActionPerformed(ActionEvent evt) {
        if (this.jTableGroups.getSelectedRows().length == 1) {
            int[] rows = this.jTableGroups.getSelectedRows();
            Group grp = (Group)this.jTableGroups.getValueAt(rows[0], 0);
            int groupPos = this.getSubDataset().getGroups().indexOf(grp);
            if (groupPos < this.getSubDataset().getGroups().size() - 1) {
                this.getSubDataset().getGroups().remove(groupPos);
                this.getSubDataset().getGroups().insertElementAt(grp, groupPos + 1);
                this.updateGroups();
                this.jTableGroupsListSelectionValueChanged(null);
            }
        }
    }

    private void jButtonMoveUpGroupActionPerformed(ActionEvent evt) {
        if (this.jTableGroups.getSelectedRows().length == 1) {
            int[] rows = this.jTableGroups.getSelectedRows();
            Group grp = (Group)this.jTableGroups.getValueAt(rows[0], 0);
            int groupPos = this.getSubDataset().getGroups().indexOf(grp);
            if (groupPos > 0) {
                this.getSubDataset().getGroups().remove(groupPos);
                this.getSubDataset().getGroups().insertElementAt(grp, groupPos - 1);
                this.updateGroups();
                this.jTableGroupsListSelectionValueChanged(null);
            }
        }
    }

    private void jButtonDeleteGroupActionPerformed(ActionEvent evt) {
        int[] rows = this.jTableGroups.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.getSubDataset().getGroups().remove(this.jTableGroups.getValueAt(rows[i], 0));
        }
        this.updateGroups();
    }

    private void jButtonModifyGroupActionPerformed(ActionEvent evt) {
        Group group = (Group)this.jTableGroups.getValueAt(this.jTableGroups.getSelectedRow(), 0);
        group = GroupsDialog.modifyGroup(this.getSubDataset(), group, this);
        if (group != null) {
            this.jTableGroups.setValueAt(group, this.jTableGroups.getSelectedRow(), 0);
        }
    }

    private void jButtonNewGroupActionPerformed(ActionEvent evt) {
        GroupDialog jrpd = new GroupDialog((Dialog)this, true);
        jrpd.setSubDataset(this.getSubDataset());
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            Group g = new Group(this.getSubDataset(), jrpd.getGroupName());
            g.setGroupExpression(jrpd.getExpression());
            this.getSubDataset().getGroups().add(g);
            this.updateGroups();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
        if (subDataset == null) {
            return;
        }
        this.setTitle(subDataset.getName() + " " + I18n.getString("groupsDialog.groups", " groups..."));
        this.updateGroups();
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void applyI18n() {
        this.jButtonDeleteGroup.setText(I18n.getString("groupsDialog.buttonDeleteGroup", "Delete"));
        this.jButtonModifyGroup.setText(I18n.getString("groupsDialog.buttonModifyGroup", "Modify"));
        this.jButtonMoveDownGroup.setText(I18n.getString("groupsDialog.buttonMoveDownGroup", "Move Down"));
        this.jButtonMoveUpGroup.setText(I18n.getString("groupsDialog.buttonMoveUpGroup", "Move Up"));
        this.jButtonNewGroup.setText(I18n.getString("groupsDialog.buttonNewGroup", "New"));
        this.jTableGroups.getColumnModel().getColumn(0).setHeaderValue(I18n.getString("groupsDialog.tablecolumn.groupName", "Group name"));
    }

    public static Group modifyGroup(SubDataset subDataset, Group group, Component parent) {
        return GroupsDialog.modifyGroup(subDataset, group, parent, 0);
    }

    public static Group modifyGroup(SubDataset subDataset, Group group, Component parent, int focusComponent) {
        Window obj = null;
        if (parent != null) {
            obj = SwingUtilities.getWindowAncestor(parent);
        }
        GroupDialog jrpd = null;
        jrpd = obj != null && obj instanceof Dialog ? new GroupDialog((Dialog)obj, true) : new GroupDialog((Frame)obj, true);
        jrpd.setGroup(group);
        jrpd.setSubDataset(subDataset);
        jrpd.setFocusedExpression(focusComponent);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            JRVariable var;
            String oldName = group.getName();
            group.setName(jrpd.getGroupName());
            group.setGroupExpression(jrpd.getExpression());
            for (int k = subDataset.getVariables().size() - 1; k >= 0; --k) {
                var = (JRVariable)subDataset.getVariables().elementAt(k);
                if (!var.isBuiltin() || !var.getName().equalsIgnoreCase(oldName + "_COUNT")) continue;
                subDataset.removeVariable(var);
                break;
            }
            subDataset.addVariable(new JRVariable(group.getName() + "_COUNT", "java.lang.Integer", true));
            Enumeration e = subDataset.getVariables().elements();
            while (e.hasMoreElements()) {
                var = (JRVariable)e.nextElement();
                if (var.getResetGroup() == null || !var.getResetGroup().equals(oldName)) continue;
                var.setResetGroup(group.getName());
            }
        }
        return group;
    }
}

