/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TransformationType;
import it.businesslogic.ireport.gui.JNumberComboBox;
import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.FontsListChangedEvent;
import it.businesslogic.ireport.gui.event.FontsListChangedListener;
import it.businesslogic.ireport.gui.event.ReportBandChangedEvent;
import it.businesslogic.ireport.gui.event.ReportBandsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedListener;
import it.businesslogic.ireport.gui.event.ReportListener;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import it.businesslogic.ireport.gui.sheet.CategorySheetPanel;
import it.businesslogic.ireport.gui.sheet.ExpressionSheetPropertyComponent;
import it.businesslogic.ireport.gui.sheet.NumberComboBoxSheetProperty;
import it.businesslogic.ireport.gui.sheet.PatternSheetPropertyComponent;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.Color;
import java.awt.Point;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class ReportSheetPanel
extends CategorySheetPanel
implements ReportListener,
LanguageChangedListener,
ReportFrameActivatedListener {
    private SheetProperty spName;
    private SheetProperty spHeight;
    private SheetProperty spWidth;
    private SheetProperty spOrientation;
    private SheetProperty spMarginTop;
    private SheetProperty spMarginLeft;
    private SheetProperty spMarginRight;
    private SheetProperty spMarginBottom;
    private SheetProperty spColumns;
    private SheetProperty spColumnWidth;
    private SheetProperty spColumnSpacing;
    private SheetProperty spScriptletMode;
    private SheetProperty spScriptletClass;
    private SheetProperty spLanguage;
    private SheetProperty spTitleOnNewPage;
    private SheetProperty spSummaryOnNewPage;
    private SheetProperty spFloatingColumnFooter;
    private SheetProperty spIgnorePagination;
    private SheetProperty spPrintOrder;
    private SheetProperty spWhenNoData;
    private SheetProperty spFormatFactoryClass;
    private SheetProperty spResourceBundleBaseName;
    private SheetProperty spWhenResourceMissingType;
    public static Color mandatoryPropertiesLabelColor = Color.blue;
    public static Color notMandatoryPropertiesLabelColor = Color.black;
    private JReportFrame jrf = null;
    private boolean init = false;

    public ReportSheetPanel() {
        this.initSheetProperties();
        MainFrame mf = MainFrame.getMainInstance();
        mf.addReportListener(this);
        mf.addReportFrameActivatedListener(this);
        I18n.addOnLanguageChangedListener(this);
        MainFrame.getMainInstance().addFontsListChangedListener(new FontsListChangedListener(){

            public void fontsListChanged(FontsListChangedEvent evt) {
                boolean localinit = ReportSheetPanel.this.isInit();
                ReportSheetPanel.this.setInit(true);
                ReportSheetPanel.this.setInit(localinit);
            }
        });
    }

    public void reportFrameActivated(ReportFrameActivatedEvent evt) {
        this.updateSelection(evt.getReportFrame());
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.removeAllProperties();
        this.initSheetProperties();
        this.updateSelection();
    }

    public void updateSelection() {
        JReportFrame newJrf = MainFrame.getMainInstance().getActiveReportFrame();
        this.updateSelection(newJrf);
    }

    public void applyValueForNumbers() {
        Enumeration e = this.getProperties().elements();
        while (e.hasMoreElements()) {
            JComponent c;
            SheetProperty sp = (SheetProperty)e.nextElement();
            if (sp.getType() != 6) {
                if (sp.getType() != 1) continue;
            }
            if (!(c = sp.getEditor()).hasFocus() || !(c instanceof JNumberField)) continue;
            ((JNumberField)c).focusLost(null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelection(JReportFrame newJrf) {
        this.applyValueForNumbers();
        this.setInit(true);
        this.removeAllProperties();
        this.jrf = newJrf;
        if (this.jrf == null) {
            this.recreateSheet();
            return;
        }
        try {
            Report report = this.jrf.getReport();
            this.setGenericSheetProperty(true, report.getName(), this.spName);
            this.setTagComboBox(true, report.getOrientation(), this.spOrientation);
            this.setElementNumber(true, report.getWidth(), (JNumberField)this.spWidth.getEditor());
            this.setElementNumber(true, report.getHeight(), (JNumberField)this.spHeight.getEditor());
            this.setElementNumber(true, report.getLeftMargin(), (JNumberField)this.spMarginLeft.getEditor());
            this.setElementNumber(true, report.getRightMargin(), (JNumberField)this.spMarginRight.getEditor());
            this.setElementNumber(true, report.getTopMargin(), (JNumberField)this.spMarginTop.getEditor());
            this.setElementNumber(true, report.getBottomMargin(), (JNumberField)this.spMarginBottom.getEditor());
            this.setElementNumber(true, report.getColumnCount(), (JNumberField)this.spColumns.getEditor());
            this.setElementNumber(true, report.getColumnWidth(), (JNumberField)this.spColumnWidth.getEditor());
            this.setElementNumber(true, report.getColumnSpacing(), (JNumberField)this.spColumnSpacing.getEditor());
            this.setTagComboBox(true, report.getScriptletHandling() + "", this.spScriptletMode);
            this.setGenericSheetProperty(true, report.getScriptletClass(), this.spScriptletClass);
            if (report.getScriptletHandling() != Report.SCRIPTLET_CLASSIC_HANDLING) {
                this.spScriptletClass.setReadOnly(true);
                this.spScriptletClass.setValue("");
            } else {
                this.spScriptletClass.setReadOnly(false);
            }
            this.spScriptletClass.updateLabel();
            this.setTagComboBox(true, report.getLanguage(), this.spLanguage);
            this.setCheckBox(true, report.isIsTitleNewPage(), false, this.spTitleOnNewPage);
            this.setCheckBox(true, report.isIsSummaryNewPage(), false, this.spSummaryOnNewPage);
            this.setCheckBox(true, report.isFloatColumnFooter(), false, this.spFloatingColumnFooter);
            this.setCheckBox(true, report.isIgnorePagination(), false, this.spIgnorePagination);
            this.setTagComboBox(true, report.getPrintOrder(), this.spPrintOrder);
            this.setTagComboBox(true, report.getWhenNoDataType(), this.spWhenNoData);
            this.setTagComboBox(true, report.getFormatFactoryClass(), this.spFormatFactoryClass);
            this.setTagComboBox(true, report.getResourceBundleBaseName(), this.spResourceBundleBaseName);
            this.setTagComboBox(true, report.getWhenResourceMissingType(), this.spWhenResourceMissingType);
            this.spName.setLabelError(this.validateProperty("name", this.spName.getValue()));
            String commonStr = I18n.getString("reportPropertiesFrame.title", "Report properties");
            this.addSheetProperty(commonStr, this.spName);
            String pageStr = I18n.getString("reportPropertiesFrame.panelBorder.PageSize", "Page size");
            this.addSheetProperty(pageStr, this.spOrientation);
            this.addSheetProperty(pageStr, this.spWidth);
            this.addSheetProperty(pageStr, this.spHeight);
            String marginsStr = I18n.getString("reportPropertiesFrame.panelBorder.PageMargin", "Page margin");
            this.addSheetProperty(marginsStr, this.spMarginLeft);
            this.addSheetProperty(marginsStr, this.spMarginRight);
            this.addSheetProperty(marginsStr, this.spMarginTop);
            this.addSheetProperty(marginsStr, this.spMarginBottom);
            String columnsStr = I18n.getString("reportPropertiesFrame.panelBorder.ReportColumns", "Report columns");
            this.addSheetProperty(columnsStr, this.spColumns);
            this.addSheetProperty(columnsStr, this.spColumnWidth);
            this.addSheetProperty(columnsStr, this.spColumnSpacing);
            commonStr = I18n.getString("more", "More...");
            this.addSheetProperty(commonStr, this.spScriptletMode);
            this.addSheetProperty(commonStr, this.spScriptletClass);
            this.addSheetProperty(commonStr, this.spLanguage);
            this.addSheetProperty(commonStr, this.spTitleOnNewPage);
            this.addSheetProperty(commonStr, this.spSummaryOnNewPage);
            this.addSheetProperty(commonStr, this.spFloatingColumnFooter);
            this.addSheetProperty(commonStr, this.spIgnorePagination);
            this.addSheetProperty(commonStr, this.spPrintOrder);
            this.addSheetProperty(commonStr, this.spWhenNoData);
            this.addSheetProperty(commonStr, this.spFormatFactoryClass);
            this.addSheetProperty(commonStr, this.spResourceBundleBaseName);
            this.addSheetProperty(commonStr, this.spWhenResourceMissingType);
            this.recreateSheet();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setInit(false);
    }

    public void removeNullItem(SheetProperty comboProperty) {
        Object obj;
        JComboBox combobox;
        if (comboProperty == null) {
            return;
        }
        if (comboProperty.getEditor() instanceof JComboBox && (combobox = (JComboBox)comboProperty.getEditor()).getSelectedIndex() > 0 && ((obj = combobox.getItemAt(0)) + "").equals(I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>"))) {
            combobox.removeItemAt(0);
        }
    }

    public boolean isNullItem(SheetProperty comboProperty) {
        Object obj;
        JComboBox combobox;
        if (comboProperty == null) {
            return false;
        }
        return comboProperty.getEditor() instanceof JComboBox && (combobox = (JComboBox)comboProperty.getEditor()).getSelectedIndex() == 0 && ((obj = combobox.getItemAt(0)) + "").equals(I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>"));
    }

    public void sheetPropertyValueChanged(SheetPropertyValueChangedEvent evt) {
        if (this.isInit()) {
            return;
        }
        this.applyNewProperty(this.getJrf().getReport(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        this.repaintEditor();
    }

    private void applyNewProperty(Report report, String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            return;
        }
        if (this.isInit()) {
            return;
        }
        boolean fireEvent = true;
        if (propertyName.equals("name")) {
            String s = (String)newValue;
            this.spName.setLabelError(this.validateProperty(propertyName, newValue));
            this.spName.updateLabel();
            report.setName("" + newValue);
            MainFrame.getMainInstance().setTitle(MainFrame.constTitle + " [" + report.getName() + " " + report.getWidth() + "x" + report.getHeight() + " " + report.getFilename() + " " + (report.isReadOnly() ? "(READ ONLY) " : "") + "]");
        } else if (propertyName.equals("orientation")) {
            this.adjustSizes("" + newValue, report);
            report.setOrientation("" + newValue);
            this.recalcColumnWidth(report);
            this.updateSizeMeasures(report);
            this.getJrf().updateScrollBars();
            this.getJrf().getJPanelReport().repaint();
        } else if (propertyName.equals("width")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                report.setWidth(val);
                this.recalcColumnWidth(report);
                this.adjustOrientation(report);
                this.updateSizeMeasures(report);
            } else {
                fireEvent = false;
            }
        } else if (propertyName.equals("height")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                report.setHeight(val);
                this.adjustOrientation(report);
                this.updateSizeMeasures(report);
            } else {
                fireEvent = false;
            }
        } else if (propertyName.equals("marginTop")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                int delta = val - report.getTopMargin();
                report.setTopMargin(val);
                this.adjustElementPositions(report, delta, 0);
                this.getJrf().updateScrollBars();
                this.getJrf().getJPanelReport().repaint();
            } else {
                fireEvent = false;
            }
        } else if (propertyName.equals("marginLeft")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                int delta = val - report.getLeftMargin();
                report.setLeftMargin(val);
                this.adjustElementPositions(report, 0, delta);
                this.getJrf().updateScrollBars();
                this.getJrf().getJPanelReport().repaint();
            } else {
                fireEvent = false;
            }
        } else if (propertyName.equals("marginRight")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                int delta = val - report.getRightMargin();
                report.setRightMargin(val);
                this.getJrf().updateScrollBars();
                this.getJrf().getJPanelReport().repaint();
            } else {
                fireEvent = false;
            }
        } else if (propertyName.equals("marginBottom")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                int delta = val - report.getBottomMargin();
                report.setBottomMargin(val);
                this.getJrf().updateScrollBars();
                this.getJrf().getJPanelReport().repaint();
            } else {
                fireEvent = false;
            }
        } else if (propertyName.equals("columns")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                report.setColumnCount(val);
                this.recalcColumnWidth(report);
                this.updateSizeMeasures(report);
                this.getJrf().updateScrollBars();
                this.getJrf().getJPanelReport().repaint();
            } else {
                fireEvent = false;
            }
        } else if (propertyName.equals("columnWidth")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                report.setColumnWidth(val);
                this.recalcColumnWidth(report);
                this.updateSizeMeasures(report);
                this.getJrf().updateScrollBars();
                this.getJrf().getJPanelReport().repaint();
            } else {
                fireEvent = false;
            }
        } else if (propertyName.equals("columnSpacing")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                report.setColumnSpacing(val);
                this.recalcColumnWidth(report);
                this.updateSizeMeasures(report);
                this.getJrf().updateScrollBars();
                this.getJrf().getJPanelReport().repaint();
            } else {
                fireEvent = false;
            }
        } else if (propertyName.equals("scriptletMode")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                report.setScriptletHandling(val);
                if (val != Report.SCRIPTLET_CLASSIC_HANDLING) {
                    this.spScriptletClass.setReadOnly(true);
                    this.spScriptletClass.setValue("");
                    report.setScriptletClass("");
                } else {
                    this.spScriptletClass.setReadOnly(false);
                }
                this.spScriptletClass.updateLabel();
            } else {
                fireEvent = false;
            }
        } else if (propertyName.equals("scriptletClass")) {
            if (newValue != null) {
                report.setScriptletClass("" + newValue);
            }
        } else if (propertyName.equals("language")) {
            if (newValue != null) {
                report.setLanguage("" + newValue);
            }
        } else if (propertyName.equals("titleOnNewPage")) {
            try {
                report.setIsTitleNewPage(Boolean.valueOf(newValue + ""));
            }
            catch (Exception ex) {}
        } else if (propertyName.equals("titleOnNewPage")) {
            try {
                report.setIsTitleNewPage(Boolean.valueOf(newValue + ""));
            }
            catch (Exception ex) {}
        } else if (propertyName.equals("summaryOnNewPage")) {
            try {
                report.setIsSummaryNewPage(Boolean.valueOf(newValue + ""));
            }
            catch (Exception ex) {}
        } else if (propertyName.equals("floatingColumnFooter")) {
            try {
                report.setFloatColumnFooter(Boolean.valueOf(newValue + ""));
            }
            catch (Exception ex) {}
        } else if (propertyName.equals("ignorePagination")) {
            try {
                report.setFloatColumnFooter(Boolean.valueOf(newValue + ""));
            }
            catch (Exception ex) {}
        } else if (propertyName.equals("printOrder")) {
            if (newValue != null) {
                report.setPrintOrder("" + newValue);
            }
        } else if (propertyName.equals("whenNoData")) {
            if (newValue != null) {
                report.setWhenNoDataType("" + newValue);
            }
        } else if (propertyName.equals("formatClass")) {
            if (newValue != null) {
                report.setFormatFactoryClass("" + newValue);
            }
        } else if (propertyName.equals("resourceBundleBaseName")) {
            if (newValue != null) {
                report.setResourceBundleBaseName("" + newValue);
            }
        } else if (propertyName.equals("whenResourceMissingType") && newValue != null) {
            report.setWhenResourceMissingType("" + newValue);
        }
        if (fireEvent) {
            report.incrementReportChanges();
        }
    }

    public String validateProperty(String propertyName, Object newValue) {
        if (propertyName.equals("name")) {
            String s = (String)newValue;
            if (s.trim().length() > 0) {
                return null;
            }
            return I18n.getString("error.reportNameNull", "The report name can not be a blank string");
        }
        return null;
    }

    public void reportElementsSelectionChanged(ReportElementsSelectionEvent evt) {
    }

    public void reportElementsChanged(ReportElementChangedEvent evt) {
    }

    public void reportBandChanged(ReportBandChangedEvent evt) {
    }

    protected void initSheetProperties() {
        this.spOrientation = new SheetProperty("orientation", I18n.getString("orientation", "Orientation"), 2);
        this.spOrientation.setTags(new Tag[]{new Tag("Portrait", I18n.getString("pageOrientation.Portrait", "Portrait")), new Tag("Landscape", I18n.getString("pageOrientation.Landscape", "Landscape"))});
        this.spOrientation.setShowResetButton(false);
        this.spWidth = new SheetProperty("width", I18n.getString("gui.elementpropertiessheet.width", "Width"), 6);
        this.spWidth.setShowResetButton(false);
        this.spHeight = new SheetProperty("height", I18n.getString("gui.elementpropertiessheet.height", "Height"), 6);
        this.spHeight.setShowResetButton(false);
        this.spName = new SheetProperty("name", I18n.getString("reportName", "Report name"), 0);
        this.spName.setShowResetButton(false);
        this.spMarginTop = new SheetProperty("marginTop", I18n.getString("top", "Top"), 6);
        this.spMarginTop.setShowResetButton(false);
        this.spMarginLeft = new SheetProperty("marginLeft", I18n.getString("left", "Left"), 6);
        this.spMarginLeft.setShowResetButton(false);
        this.spMarginRight = new SheetProperty("marginRight", I18n.getString("right", "Right"), 6);
        this.spMarginRight.setShowResetButton(false);
        this.spMarginBottom = new SheetProperty("marginBottom", I18n.getString("bottom", "Bottom"), 6);
        this.spMarginBottom.setShowResetButton(false);
        this.spColumns = new SheetProperty("columns", I18n.getString("columns", "Columns"), 6);
        this.spColumns.setShowResetButton(false);
        this.spColumnWidth = new SheetProperty("columnWidth", I18n.getString("width", "Width"), 6);
        this.spColumnWidth.setShowResetButton(false);
        this.spColumnSpacing = new SheetProperty("columnSpacing", I18n.getString("spacing", "Spacing"), 6);
        this.spColumnSpacing.setShowResetButton(false);
        this.spScriptletMode = new SheetProperty("scriptletMode", I18n.getString("scriptletMode", "Scriptlet"), 2);
        this.spScriptletMode.setTags(new Tag[]{new Tag("0", I18n.getString("noScriptlet", "Don't use scriptlet")), new Tag("1", I18n.getString("iReportScriptlet", "Use iReport internal scriptlet support")), new Tag("2", I18n.getString("customScriptlet", "Use this scriptlet class..."))});
        this.spScriptletMode.setShowResetButton(false);
        this.spScriptletClass = new SheetProperty("scriptletClass", I18n.getString("scriptlet", "Scriptlet class"), 0);
        this.spScriptletClass.setShowResetButton(false);
        this.spLanguage = new SheetProperty("language", I18n.getString("reportPropertiesFrame.label18", "Language"), 2);
        this.spLanguage.setTags(new Tag[]{new Tag("java", "Java"), new Tag("groovy", "Groovy")});
        this.spLanguage.setShowResetButton(false);
        this.spTitleOnNewPage = new SheetProperty("titleOnNewPage", I18n.getString("titleOnANewPage", "Title on a new page"), 4);
        this.spTitleOnNewPage.setShowResetButton(false);
        this.spSummaryOnNewPage = new SheetProperty("summaryOnNewPage", I18n.getString("summaryInANewPage", "Summary on a new page"), 4);
        this.spSummaryOnNewPage.setShowResetButton(false);
        this.spFloatingColumnFooter = new SheetProperty("floatingColumnFooter", I18n.getString("reportPropertiesFrame.checkBoxFloatColumnFooter", "Floating column footer"), 4);
        this.spFloatingColumnFooter.setShowResetButton(false);
        this.spIgnorePagination = new SheetProperty("ignorePagination", I18n.getString("ignorePagination", "Ignore pagination"), 4);
        this.spIgnorePagination.setShowResetButton(false);
        this.spPrintOrder = new SheetProperty("printOrder", I18n.getString("printOrder", "Print order"), 2);
        this.spPrintOrder.setTags(new Tag[]{new Tag("Vertical", I18n.getString("printOrder.Vertical", "Vertical")), new Tag("Horizontal", I18n.getString("printOrder.Horizontal", "Horizontal"))});
        this.spPrintOrder.setShowResetButton(false);
        this.spWhenNoData = new SheetProperty("whenNoData", I18n.getString("whenNoData", "When no data"), 2);
        this.spWhenNoData.setTags(new Tag[]{new Tag("NoPages", I18n.getString("whenNoData.NoPages", "No pages")), new Tag("BlankPage", I18n.getString("whenNoData.BlankPage", "Blank page")), new Tag("AllSectionsNoDetail", I18n.getString("whenNoData.AllSectionsNoDetail", "All sections, no detail"))});
        this.spWhenNoData.setShowResetButton(false);
        this.spFormatFactoryClass = new SheetProperty("formatClass", I18n.getString("formatFactoryClass", "Format factory class"), 0);
        this.spFormatFactoryClass.setShowResetButton(false);
        this.spResourceBundleBaseName = new SheetProperty("resourceBundleBaseName", I18n.getString("resourceBundleBaseName", "Resource bundle base name"), 0);
        this.spResourceBundleBaseName.setShowResetButton(false);
        this.spWhenResourceMissingType = new SheetProperty("whenResourceMissingType", I18n.getString("printOrder", "Print order"), 2);
        this.spWhenResourceMissingType.setTags(new Tag[]{new Tag("Null", I18n.getString("whenResourceMissingType.Null", "Null")), new Tag("Empty", I18n.getString("whenResourceMissingType.Empty", "Empty")), new Tag("Key", I18n.getString("whenResourceMissingType.Key", "Key")), new Tag("Error", I18n.getString("whenResourceMissingType.Error", "Error"))});
        this.spWhenResourceMissingType.setShowResetButton(false);
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    protected boolean setComboBox(boolean firstTime, Object value, JComboBox comboField) {
        if (!firstTime && comboField.getSelectedItem() != value) {
            comboField.insertItemAt(I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>"), 0);
            comboField.setSelectedIndex(0);
            return false;
        }
        try {
            comboField.setSelectedItem(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setTextArea(boolean firstTime, String value, SheetProperty textProperty) {
        if (!firstTime && !textProperty.getValue().equals(value)) {
            JComponent editor = textProperty.getEditor();
            if (editor instanceof ExpressionSheetPropertyComponent) {
                ((ExpressionSheetPropertyComponent)editor).setExpression("");
                ((ExpressionSheetPropertyComponent)editor).setText(I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>"));
            }
            return false;
        }
        try {
            textProperty.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setTextPattern(boolean firstTime, Object value, SheetProperty textProperty) {
        if (!firstTime && !(textProperty.getValue() + "").equals(value)) {
            JComponent editor = textProperty.getEditor();
            if (editor instanceof PatternSheetPropertyComponent) {
                ((PatternSheetPropertyComponent)editor).setExpression("");
                ((PatternSheetPropertyComponent)editor).setText(I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>"));
            }
            return false;
        }
        try {
            textProperty.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setTagComboBox(boolean firstTime, Object value, SheetProperty sp) {
        if (firstTime) {
            this.removeNullItem(sp);
            sp.setValue(value);
            return true;
        }
        Object s = sp.getValue();
        if (s == null && value == null) {
            return true;
        }
        if (s != null && s.equals(value)) {
            return true;
        }
        sp.setSetting(true);
        JComboBox combobox = (JComboBox)sp.getEditor();
        if (combobox.getItemCount() > 0) {
            Object obj = combobox.getItemAt(0);
            sp.setValue(null);
            if (!(obj + "").equals(I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>"))) {
                ((JComboBox)sp.getEditor()).insertItemAt(new Tag(null, I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>")), 0);
            }
        }
        ((JComboBox)sp.getEditor()).setSelectedIndex(0);
        sp.setSetting(false);
        return false;
    }

    protected boolean setElementNumber(boolean firstTime, double value, JNumberField numberField) {
        if (!firstTime && numberField.getValue() != value) {
            numberField.setText("");
            return false;
        }
        try {
            numberField.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setElementNumber(boolean firstTime, int defaultValue, Object value, NumberComboBoxSheetProperty sp) {
        if (!firstTime && !(sp.getValue() + "").equals("" + value)) {
            boolean setting = sp.isSetting();
            sp.setSetting(true);
            sp.setValue(null);
            sp.setSetting(setting);
            sp.setEditorValue(sp.getEditor(), "");
            return false;
        }
        try {
            boolean setting = sp.isSetting();
            sp.setSetting(true);
            sp.setValue(value);
            if (value == null) {
                if (!firstTime && !(((JNumberComboBox)sp.getEditor()).getSelectedItem() + "").equals("" + defaultValue)) {
                    sp.setEditorValue(sp.getEditor(), "");
                } else {
                    sp.setEditorValue(sp.getEditor(), new Integer(defaultValue));
                }
            }
            sp.setSetting(setting);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setGenericSheetProperty(boolean firstTime, Object value, SheetProperty sp) {
        if (firstTime) {
            try {
                sp.setValue(value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        Object value2 = sp.getValue();
        if (value2 == value) {
            return true;
        }
        if (value2 != null && ("" + value2).equals(value + "")) {
            return true;
        }
        sp.setValue(null);
        return false;
    }

    protected boolean setColorProperty(boolean firstTime, Color color, SheetProperty sp) {
        if (firstTime) {
            try {
                sp.setValue(color);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        Color c1 = (Color)sp.getValue();
        if (c1 == color) {
            return true;
        }
        if (c1 != null && color != null && c1.getRGB() == color.getRGB()) {
            return true;
        }
        sp.setValue(null);
        return false;
    }

    protected boolean setCheckBox(boolean firstTime, boolean value, boolean isNull, SheetProperty sp) {
        if (firstTime) {
            try {
                if (isNull) {
                    sp.setValue(null);
                    sp.setSetting(true);
                    ((JCheckBox)sp.getEditor()).setSelected(value);
                    sp.setSetting(false);
                } else {
                    sp.setValue("" + value);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        if (sp.getValue() == null && isNull) {
            return true;
        }
        if (sp.getValue() != null && sp.getValue().equals("" + value)) {
            return true;
        }
        sp.setValue(null);
        return false;
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public void repaintEditor() {
        if (this.jrf == null) {
            return;
        }
        if (this.jrf.getSelectedCrosstabEditorPanel() == null) {
            this.jrf.getJPanelReport().repaint();
        } else {
            this.jrf.getSelectedCrosstabEditorPanel().repaint();
        }
    }

    public void reportBandsSelectionChanged(ReportBandsSelectionEvent evt) {
    }

    public void adjustSizes(String orientation, Report report) {
        int reportSwitch = 0;
        if (orientation.equals("Landscape")) {
            if (report.getWidth() < report.getHeight()) {
                reportSwitch = report.getHeight();
                report.setHeight(report.getWidth());
                report.setWidth(reportSwitch);
            }
        } else if (report.getWidth() > report.getHeight()) {
            reportSwitch = report.getHeight();
            report.setHeight(report.getWidth());
            report.setWidth(reportSwitch);
        }
    }

    void recalcColumnWidth(Report report) {
        int avail;
        int columns = report.getColumnCount();
        int dim = avail = report.getWidth() - report.getLeftMargin() - report.getRightMargin() - (report.getColumnCount() - 1) * report.getColumnSpacing();
        dim = (int)((double)dim / (double)columns);
        while (dim * columns > avail) {
            --dim;
        }
        report.setColumnWidth(dim);
    }

    void updateSizeMeasures(Report report) {
        boolean oldInit = this.isInit();
        this.setInit(true);
        this.setTagComboBox(true, report.getOrientation(), this.spOrientation);
        this.setElementNumber(true, report.getWidth(), (JNumberField)this.spWidth.getEditor());
        this.setElementNumber(true, report.getHeight(), (JNumberField)this.spHeight.getEditor());
        this.setElementNumber(true, report.getLeftMargin(), (JNumberField)this.spMarginLeft.getEditor());
        this.setElementNumber(true, report.getRightMargin(), (JNumberField)this.spMarginRight.getEditor());
        this.setElementNumber(true, report.getTopMargin(), (JNumberField)this.spMarginTop.getEditor());
        this.setElementNumber(true, report.getBottomMargin(), (JNumberField)this.spMarginBottom.getEditor());
        this.setElementNumber(true, report.getColumnCount(), (JNumberField)this.spColumns.getEditor());
        this.setElementNumber(true, report.getColumnWidth(), (JNumberField)this.spColumnWidth.getEditor());
        this.setElementNumber(true, report.getColumnSpacing(), (JNumberField)this.spColumnSpacing.getEditor());
        MainFrame.getMainInstance().setTitle(MainFrame.constTitle + " [" + report.getName() + " " + report.getWidth() + "x" + report.getHeight() + " " + report.getFilename() + " " + (report.isReadOnly() ? "(READ ONLY) " : "") + "]");
        this.setInit(oldInit);
    }

    public void adjustOrientation(Report report) {
        if (report.getWidth() <= report.getHeight()) {
            report.setOrientation("Portrait");
        } else {
            report.setOrientation("Landscape");
        }
    }

    public void adjustElementPositions(Report report, int differenceY, int differenceX) {
        if (differenceX != 0 || differenceY != 0) {
            Enumeration e = report.getElements().elements();
            while (e.hasMoreElements()) {
                ReportElement re = (ReportElement)e.nextElement();
                re.trasform(new Point(differenceX, differenceY), TransformationType.TRANSFORMATION_MOVE);
            }
        }
    }
}

