/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.drag.outline.x11;

public class DataBuffer {
    public static final int DEFAULT_BUFFER_SIZE = 256;
    private byte[] dataBuffer;
    private int bufferOffset;

    public DataBuffer() {
        this(256);
    }

    public DataBuffer(int initialBufferSize) {
        this.dataBuffer = new byte[initialBufferSize];
    }

    public DataBuffer(byte[] rawData) {
        this.dataBuffer = new byte[rawData.length];
        this.bufferOffset = rawData.length;
        System.arraycopy(rawData, 0, this.dataBuffer, 0, this.bufferOffset);
    }

    public void appendByte(int data) {
        this.ensureCapacity(1);
        this.dataBuffer[this.bufferOffset] = (byte)data;
        ++this.bufferOffset;
    }

    public void appendTwoBytes(int data) {
        byte[] bytes = new byte[]{(byte)(data >> 8 & 0xFF), (byte)(data & 0xFF)};
        this.appendBytesImpl(bytes);
    }

    public void appendFourBytes(int data) {
        byte[] bytes = new byte[]{(byte)(data >> 24 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data & 0xFF)};
        this.appendBytesImpl(bytes);
    }

    private void appendBytesImpl(byte[] formatted) {
        for (int i = 0; i < formatted.length; ++i) {
            this.appendByte(formatted[i]);
        }
    }

    private void ensureCapacity(int dataSize) {
        if (this.bufferOffset + dataSize >= this.dataBuffer.length) {
            byte[] tmp = new byte[this.dataBuffer.length * 2];
            System.arraycopy(this.dataBuffer, 0, tmp, 0, this.dataBuffer.length);
            this.dataBuffer = tmp;
        }
    }

    public byte[] getBytes() {
        byte[] ret = new byte[this.bufferOffset];
        System.arraycopy(this.dataBuffer, 0, ret, 0, ret.length);
        return ret;
    }

    public int readByte(int offset) {
        return this.dataBuffer[offset] & 0xFF;
    }

    public int readTwoBytes(int offset) {
        int b0 = this.readByte(offset) << 8;
        int b1 = this.readByte(offset + 1);
        return b0 | b1;
    }

    public int readFourBytes(int offset) {
        int b0 = this.readByte(offset) << 24;
        int b1 = this.readByte(offset + 1) << 16;
        int b2 = this.readByte(offset + 2) << 8;
        int b3 = this.readByte(offset + 3);
        return b0 | b1 | b2 | b3;
    }

    public byte[] getSubset(int offset, int length) {
        byte[] subset = new byte[length];
        System.arraycopy(this.dataBuffer, offset, subset, 0, length);
        return subset;
    }

    public DataBuffer getSubBuffer(int offset, int length) {
        byte[] subset = this.getSubset(offset, length);
        return new DataBuffer(subset);
    }

    public static int decode(byte[] data) {
        if (data == null || data.length == 0) {
            return -1;
        }
        int shift = 8 * (data.length - 1);
        int ret = 0;
        for (int i = 0; i < data.length; ++i) {
            int currVal = (data[i] & 0xFF) << shift;
            shift -= 8;
            ret = i == 0 ? currVal : ret | currVal;
        }
        return ret;
    }

    public static byte[] encode(int data, int byteCount) {
        if (byteCount < 0) {
            return null;
        }
        byte[] ret = new byte[byteCount];
        int shift = 8 * (byteCount - 1);
        for (int i = 0; i < byteCount; ++i) {
            ret[i] = (byte)(data >> shift & 0xFF);
            shift -= 8;
        }
        return ret;
    }

    public static int padLength(int len) {
        return len + 3 & 0xFFFFFFFC;
    }
}

