/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * JRLinkParameterDialog.java
 * 
 * Created on 9 maggio 2003, 17.25
 *
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.*;
import java.util.Vector;
/**
 *
 * @author  Administrator
 */
public class JRLinkParameterDialog extends javax.swing.JDialog {
    /** Creates new form JRParameterDialog */
    JRLinkParameter tmpParameter = null;
    
    public JRLinkParameterDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initAll();
    }
    
    public JRLinkParameterDialog(java.awt.Dialog parent, boolean modal)
    {
        super(parent, modal);
        initAll();
    }
    
    public void initAll()
    {
        initComponents();
        applyI18n();
        this.jRTextExpressionAreaDefaultExpression.setText("");   
        
        // we have to force the context of the parameter.
        this.jRTextExpressionAreaDefaultExpression.setCrosstabElements( new Vector());
        this.jRTextExpressionAreaDefaultExpression.setSubDataset( MainFrame.getMainInstance().getActiveReportFrame().getReport());
        Misc.centerFrame(this);
        
        
        javax.swing.KeyStroke escape =  javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0, false);
        javax.swing.Action escapeAction = new javax.swing.AbstractAction() {
            public void actionPerformed(java.awt.event.ActionEvent e) {
                jButtonCancelActionPerformed(e);
            }
        };
       
        getRootPane().getInputMap(javax.swing.JComponent.WHEN_IN_FOCUSED_WINDOW).put(escape, "ESCAPE");
        getRootPane().getActionMap().put("ESCAPE", escapeAction);


        //to make the default button ...
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jTextFieldName = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jRTextExpressionAreaDefaultExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();

        setTitle("Add/modify parameter");
        setResizable(false);
        setModal(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        jButtonOK.setMnemonic('o');
        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jPanel1.add(jButtonOK);

        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        jPanel1.add(jButtonCancel);

        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Link parameter name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        jPanel2.add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
        jPanel2.add(jTextFieldName, gridBagConstraints);

        jLabel3.setText("Value expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel2.add(jLabel3, gridBagConstraints);

        jRTextExpressionAreaDefaultExpression.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jRTextExpressionAreaDefaultExpression.setPreferredSize(new java.awt.Dimension(300, 80));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
        jPanel2.add(jRTextExpressionAreaDefaultExpression, gridBagConstraints);

        getContentPane().add(jPanel2, java.awt.BorderLayout.CENTER);

        setBounds(0, 0, 320, 220);
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        
        if (this.jTextFieldName.getText().trim().length() <= 0)
        {
            javax.swing.JOptionPane.showMessageDialog(this,
                    I18n.getString( "messages.jRLinkParameterDialog.notValidParameterName","Please insert a valid parameter name!"),
                    I18n.getString( "messages.jRLinkParameterDialog.notValidParameterNameCaption","Invalid parameter!"),
                    javax.swing.JOptionPane.WARNING_MESSAGE );
            return;
        }
        
        tmpParameter = new it.businesslogic.ireport.JRLinkParameter( this.jTextFieldName.getText(),this.jRTextExpressionAreaDefaultExpression.getText());
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CLOSED_OPTION);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new JRParameterDialog(new javax.swing.JFrame(), true).setVisible(true);
    }
    
    /** Getter for property tmpParameter.
     * @return Value of property tmpParameter.
     *
     */
    public it.businesslogic.ireport.JRLinkParameter getParameter() {
        return tmpParameter;
    }    
    
    /** Setter for property tmpParameter.
     * @param tmpParameter New value of property tmpParameter.
     *
     */
    public void setParameter(it.businesslogic.ireport.JRLinkParameter tmpParameter) {
        this.jTextFieldName.setText( new String(tmpParameter.getName()));
        this.jRTextExpressionAreaDefaultExpression.setText( new String(tmpParameter.getExpression()));                       
    }
    
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult() {
        return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaDefaultExpression;
    private javax.swing.JTextField jTextFieldName;
    // End of variables declaration//GEN-END:variables

    private int dialogResult;    
    
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jButtonCancel.setText(I18n.getString("jRLinkParameterDialog.buttonCancel","Cancel"));
                jButtonOK.setText(I18n.getString("jRLinkParameterDialog.buttonOK","OK"));
                jLabel1.setText(I18n.getString("jRLinkParameterDialog.label1","Link parameter name"));
                jLabel3.setText(I18n.getString("jRLinkParameterDialog.label3","Value expression"));
                // End autogenerated code ----------------------
                setTitle(I18n.getString("jRLinkParameterDialog.title","Add/modify parameter"));
                jButtonCancel.setMnemonic(I18n.getString("jRLinkParameterDialog.buttonCancelMnemonic","c").charAt(0));
                jButtonOK.setMnemonic(I18n.getString("jRLinkParameterDialog.buttonOKMnemonic","o").charAt(0));
    }
    
    
    public static final int COMPONENT_NONE=0;
    public static final int COMPONENT_PARAM_NAME=1;
    public static final int COMPONENT_PARAM_EXPRESSION=2;
    
    /**
     * This method set the focus on a specific component.
     * Valid constants are something like:
     * COMPONENT_NONE, COMPONENT_PARAM_NAME, ...
     *
     */
    public void setFocusedExpression(int expID)
    {
        try {
            switch (expID)
            {
                case COMPONENT_PARAM_EXPRESSION:
                    Misc.selectTextAndFocusArea(jRTextExpressionAreaDefaultExpression);
                    break;
                case COMPONENT_PARAM_NAME:
                    Misc.selectTextAndFocusArea(jTextFieldName);
                    break;  
            }
        } catch (Exception ex) { }
    }    
}
