/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import java.lang.reflect.Constructor;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.AsmClassGenerator;

public class ConstructorCallExpression
extends Expression {
    private Expression arguments;
    private String typeToSet;
    private Constructor constructor = null;

    public String getTypeToSet() {
        return this.typeToSet;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    protected boolean shouldContinue() {
        if (super.isResolveFailed()) {
            return false;
        }
        return this.constructor == null;
    }

    public ConstructorCallExpression(String type, Expression arguments) {
        this.typeToSet = type;
        this.setTypeResolved(false);
        this.arguments = arguments;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitConstructorCallExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new ConstructorCallExpression(this.type, transformer.transform(this.arguments));
    }

    protected void resolveType(AsmClassGenerator resolver) {
        this.arguments.resolve(resolver);
        if (this.constructor == null) {
            resolver.resolve(this);
        }
    }

    public String getType() {
        if (this.type == null) {
            if (this.typeToSet != null && this.typeToSet.length() > 0) {
                return this.typeToSet;
            }
            return "java.lang.Object";
        }
        return this.type;
    }

    public Expression getArguments() {
        return this.arguments;
    }

    public String getText() {
        return "new " + this.type + "(" + this.arguments.getText() + ")";
    }

    public String toString() {
        return super.toString() + "[type: " + this.type + " arguments: " + this.arguments + "]";
    }

    public void setConstructor(Constructor ctor) {
        this.constructor = ctor;
        super.setTypeClass(ctor.getDeclaringClass());
    }
}

