/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import groovy.lang.GString;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.Type;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.syntax.Token;

public class BinaryExpression
extends Expression {
    private Expression leftExpression;
    private Expression rightExpression;
    private Token operation;

    public BinaryExpression(Expression leftExpression, Token operation, Expression rightExpression) {
        this.leftExpression = leftExpression;
        this.operation = operation;
        this.rightExpression = rightExpression;
    }

    public Class getTypeClass() {
        this.typeClass = this.resolveThisType(this.operation);
        return this.typeClass;
    }

    public boolean isDynamic() {
        return false;
    }

    private Class resolveThisType(Token operation) {
        switch (operation.getType()) {
            case 100: {
                if (!this.leftExpression.isDynamic()) {
                    return this.leftExpression.getTypeClass();
                }
                return this.rightExpression.getTypeClass();
            }
            case 94: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 544: {
                return Boolean.TYPE;
            }
            case 162: 
            case 164: {
                return Boolean.class;
            }
            case 128: {
                return Integer.class;
            }
            case 200: 
            case 210: {
                if (this.leftExpression.getTypeClass() == String.class && this.rightExpression.getTypeClass() == String.class) {
                    return String.class;
                }
                if (this.leftExpression.getTypeClass() == GString.class && (this.rightExpression.getTypeClass() == GString.class || this.rightExpression.getTypeClass() == String.class)) {
                    return GString.class;
                }
                if (BinaryExpression.isNumber(this.leftExpression.getType()) && BinaryExpression.isNumber(this.rightExpression.getType())) {
                    return BinaryExpression.chooseWiderNumberType(this.leftExpression.getType(), this.rightExpression.getType());
                }
                if (this.leftExpression.getTypeClass() == Date.class && Number.class.isAssignableFrom(this.rightExpression.getTypeClass())) {
                    return Date.class;
                }
                if (this.leftExpression.getTypeClass() != null && Collection.class.isAssignableFrom(this.leftExpression.getTypeClass())) {
                    return List.class;
                }
                return null;
            }
            case 201: 
            case 211: {
                if (this.leftExpression.getTypeClass() == String.class) {
                    return String.class;
                }
                if (this.leftExpression instanceof GStringExpression && BinaryExpression.isNumber(this.rightExpression.getType())) {
                    return String.class;
                }
                if (BinaryExpression.isNumber(this.leftExpression.getType()) && BinaryExpression.isNumber(this.rightExpression.getType())) {
                    return BinaryExpression.chooseWiderNumberType(this.leftExpression.getType(), this.rightExpression.getType());
                }
                if (this.leftExpression.getTypeClass() != null && List.class.isAssignableFrom(this.leftExpression.getTypeClass())) {
                    return List.class;
                }
                if (this.leftExpression.getTypeClass() == Date.class && Number.class.isAssignableFrom(this.rightExpression.getTypeClass())) {
                    return Date.class;
                }
                return null;
            }
            case 202: 
            case 212: {
                if (this.leftExpression.getTypeClass() == String.class && BinaryExpression.isNumber(this.rightExpression.getType())) {
                    return String.class;
                }
                if (this.leftExpression instanceof GStringExpression && BinaryExpression.isNumber(this.rightExpression.getType())) {
                    return String.class;
                }
                if (BinaryExpression.isNumber(this.leftExpression.getType()) && BinaryExpression.isNumber(this.rightExpression.getType())) {
                    return BinaryExpression.chooseWiderNumberType(this.leftExpression.getType(), this.rightExpression.getType());
                }
                if (this.leftExpression.getTypeClass() != null && Collection.class.isAssignableFrom(this.leftExpression.getTypeClass())) {
                    return List.class;
                }
                return null;
            }
            case 203: 
            case 205: 
            case 213: 
            case 215: {
                if (BinaryExpression.isNumber(this.leftExpression.getType()) && BinaryExpression.isNumber(this.rightExpression.getType())) {
                    return BinaryExpression.chooseWiderNumberType(this.leftExpression.getType(), this.rightExpression.getType());
                }
                return null;
            }
            case 206: 
            case 216: {
                if (BinaryExpression.isNumber(this.leftExpression.getType()) && BinaryExpression.isNumber(this.rightExpression.getType())) {
                    return BinaryExpression.chooseWiderNumberType(this.leftExpression.getType(), this.rightExpression.getType());
                }
                return null;
            }
            case 280: {
                if (BinaryExpression.isNumber(this.leftExpression.getType()) && BinaryExpression.isNumber(this.rightExpression.getType())) {
                    return this.leftExpression.getTypeClass();
                }
                if (this.leftExpression.getTypeClass() != null && Collection.class.isAssignableFrom(this.leftExpression.getTypeClass())) {
                    return Collection.class;
                }
                if (this.leftExpression.getTypeClass() != null && OutputStream.class.isAssignableFrom(this.leftExpression.getTypeClass())) {
                    return Writer.class;
                }
                if (this.leftExpression.getTypeClass() != null && StringBuffer.class.isAssignableFrom(this.leftExpression.getTypeClass())) {
                    return Writer.class;
                }
                return null;
            }
            case 281: 
            case 282: {
                if (BinaryExpression.isNumber(this.leftExpression.getType()) && BinaryExpression.isNumber(this.rightExpression.getType())) {
                    return this.leftExpression.getTypeClass();
                }
                return null;
            }
            case 90: {
                return Matcher.class;
            }
            case 30: {
                Class cls = this.leftExpression.getTypeClass();
                if (cls == null) break;
                if (cls.isArray()) {
                    Class<?> elemType = cls.getComponentType();
                    return elemType;
                }
                if (this.leftExpression instanceof ListExpression) {
                    Class elemType = ((ListExpression)this.leftExpression).getComponentTypeClass();
                    return elemType;
                }
                if (this.leftExpression instanceof MapExpression) {
                    return Object.class;
                }
                if (List.class.isAssignableFrom(cls)) {
                    return Object.class;
                }
                if (!Map.class.isAssignableFrom(cls)) break;
                return Object.class;
            }
        }
        return null;
    }

    private static boolean isNumber(String type) {
        return type != null && (type.equals("int") || type.equals("short") || type.equals("byte") || type.equals("char") || type.equals("float") || type.equals("long") || type.equals("double") || type.equals("java.lang.Short") || type.equals("java.lang.Byte") || type.equals("java.lang.Character") || type.equals("java.lang.Integer") || type.equals("java.lang.Float") || type.equals("java.lang.Long") || type.equals("java.lang.Double") || type.equals("java.math.BigInteger") || type.equals("java.math.BigDecimal"));
    }

    private static Class getObjectClassForNumber(String type) {
        if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
            return Boolean.class;
        }
        if (type.equals("short") || type.equals("java.lang.Short")) {
            return Short.class;
        }
        if (type.equals("int") || type.equals("java.lang.Integer")) {
            return Integer.class;
        }
        if (type.equals("char") || type.equals("java.lang.Character")) {
            return Integer.class;
        }
        if (type.equals("long") || type.equals("java.lang.Long")) {
            return Long.class;
        }
        if (type.equals("float") || type.equals("java.lang.Float")) {
            return Float.class;
        }
        if (type.equals("double") || type.equals("java.lang.Double")) {
            return Double.class;
        }
        if (type.equals("java.math.BigInteger")) {
            return BigInteger.class;
        }
        if (type.equals("java.math.BigDecimal")) {
            return BigDecimal.class;
        }
        return null;
    }

    private static boolean isFloatingPoint(Class cls) {
        return cls == Double.class || cls == Float.class;
    }

    private static boolean isInteger(Class cls) {
        return cls == Integer.class || cls == Byte.class || cls == Short.class || cls == Character.class;
    }

    private static boolean isLong(Class cls) {
        return cls == Long.class;
    }

    private static boolean isBigDecimal(Class cls) {
        return cls == BigDecimal.class;
    }

    private static boolean isBigInteger(Class cls) {
        return cls == BigInteger.class;
    }

    private static Class chooseWiderNumberType(String lefts, String rights) {
        Class left = BinaryExpression.getObjectClassForNumber(lefts);
        Class right = BinaryExpression.getObjectClassForNumber(rights);
        if (BinaryExpression.isFloatingPoint(left) || BinaryExpression.isFloatingPoint(right)) {
            return Double.class;
        }
        if (BinaryExpression.isBigDecimal(left) || BinaryExpression.isBigDecimal(right)) {
            return BigDecimal.class;
        }
        if (BinaryExpression.isBigInteger(left) || BinaryExpression.isBigInteger(right)) {
            return BigInteger.class;
        }
        if (BinaryExpression.isLong(left) || BinaryExpression.isLong(right)) {
            return Long.class;
        }
        return Integer.class;
    }

    public String toString() {
        return super.toString() + "[" + this.leftExpression + this.operation + this.rightExpression + "]";
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new BinaryExpression(transformer.transform(this.leftExpression), this.operation, transformer.transform(this.rightExpression));
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(Expression leftExpression) {
        this.leftExpression = leftExpression;
    }

    public void setRightExpression(Expression rightExpression) {
        this.rightExpression = rightExpression;
    }

    public Token getOperation() {
        return this.operation;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public String getText() {
        if (this.operation.getType() == 30) {
            return this.leftExpression.getText() + "[" + this.rightExpression.getText() + "]";
        }
        return "(" + this.leftExpression.getText() + " " + this.operation.getText() + " " + this.rightExpression.getText() + ")";
    }

    public static BinaryExpression newAssignmentExpression(String variable, Expression rhs) {
        VariableExpression lhs = new VariableExpression(variable);
        Token operator = Token.newPlaceholder(100);
        return new BinaryExpression(lhs, operator, rhs);
    }

    public static BinaryExpression newInitializationExpression(String variable, Type type, Expression rhs) {
        VariableExpression lhs = new VariableExpression(variable);
        if (type != null) {
            lhs.setType(type.getName());
        }
        Token operator = Token.newPlaceholder(100);
        return new BinaryExpression(lhs, operator, rhs);
    }

    protected void resolveType(AsmClassGenerator resolver) {
        this.leftExpression.resolve(resolver);
        this.rightExpression.resolve(resolver);
        Class cls = this.resolveThisType(this.operation);
        if (cls != null) {
            this.setTypeClass(cls);
        } else {
            this.setResolveFailed(true);
            this.setFailure("unknown. the right expression may have not been resolved");
        }
    }
}

