/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.view.JRSaveContributor;

public class JROdtSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_ODT = ".odt";
    public static final JROdtSaveContributor INSTANCE = new JROdtSaveContributor();

    public static JROdtSaveContributor getInstance() {
        return INSTANCE;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(EXTENSION_ODT);
    }

    public String getDescription() {
        return "ODT (*.odt)";
    }

    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().endsWith(EXTENSION_ODT)) {
            file = new File(file.getAbsolutePath() + EXTENSION_ODT);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("file.exists"), file.getName()), ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("save"), 2)) {
            JROdtExporter exporter = new JROdtExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
            exporter.exportReport();
        }
    }
}

