/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.filtertree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import rex.graphics.IViewer;
import rex.graphics.TreeElement;
import rex.graphics.dimensiontree.elements.DimensionElement;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.filtertree.FilterTreeModel;
import rex.graphics.filtertree.elements.FilterTreeMemberElement;
import rex.graphics.filtertree.elements.FilterTreePopUpActions;
import rex.graphics.filtertree.elements.FilterTreeRootElement;
import rex.metadata.Query;
import rex.metadata.ServerMetadata;
import rex.metadata.UniqueNameElement;
import rex.metadata.resultelements.Member;
import rex.utils.AppColors;
import rex.utils.I18n;
import rex.utils.S;
import rex.utils.WaitCursorEventQueue;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;
import rex.xmla.XMLAObjectsFactory;

public class FilterTree
extends JPanel
implements ActionListener,
TreeWillExpandListener {
    final JTree tree;
    JPopupMenu popup;
    Query query;
    IViewer viewer;
    private DimensionTreeElement popUpSource;
    private JLabel enabledMembers;

    public FilterTree(ServerMetadata _smd, Query _q, DimensionTreeElement _filterDimension, LinkedList _enabledMembersList, IViewer _viewer) {
        this(_smd, _filterDimension, _enabledMembersList);
        this.query = _q;
        this.viewer = _viewer;
    }

    public FilterTree(ServerMetadata _smd, DimensionTreeElement _filterDimension, LinkedList _enabledMembersList) {
        FilterTreeModel treeModel = new FilterTreeModel(_smd, _filterDimension, _enabledMembersList);
        this.tree = new JTree(treeModel){
            {
                this.setOpaque(false);
            }

            public void paintComponent(Graphics g) {
                S.paintBackground(g, this);
                super.paintComponent(g);
            }
        };
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeWillExpandListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new MyRenderer2());
        this.tree.setOpaque(false);
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setOpaque(false);
        treeView.setMaximumSize(new Dimension(250, Short.MAX_VALUE));
        treeView.setMinimumSize(new Dimension(200, 400));
        this.enabledMembers = new JLabel();
        this.enabledMembers.setText(treeModel.getEnabledMembersCaption());
        this.enabledMembers.setBackground(AppColors.ENABLED_MEMBERS_LABEL_BACKGROUND);
        this.enabledMembers.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JSplitPane treeAndLabel = new JSplitPane(0, treeView, new JScrollPane(this.enabledMembers));
        treeAndLabel.setDividerSize(8);
        treeAndLabel.setContinuousLayout(true);
        treeAndLabel.setOneTouchExpandable(true);
        this.add((Component)treeAndLabel, "Center");
        this.popup = new JPopupMenu();
        this.tree.addMouseListener(new PopupListener());
        this.tree.setDragEnabled(true);
    }

    public JTree getTree() {
        return this.tree;
    }

    public boolean isDisplayedInTab() {
        return ((FilterTreeModel)this.tree.getModel()).isDisplayedInTab();
    }

    public String getCaption() {
        return ((FilterTreeModel)this.tree.getModel()).getCaption();
    }

    void loseFilter() {
        int retVal = JOptionPane.showConfirmDialog(null, I18n.getString("msgText.dropFilter"), I18n.getString("msgTitle.loseFilter"), 0);
        if (retVal != 1) {
            this.query.dropFilterFromQuery(this);
        }
    }

    public void actionPerformed(ActionEvent e) {
        boolean i = false;
        if (e.getActionCommand().equals((String)FilterTreePopUpActions.popUpCaptions.get(FilterTreePopUpActions.DISABLE_THIS_ELEMENT))) {
            ((FilterTreeModel)this.tree.getModel()).disableMember(this.popUpSource);
        } else if (e.getActionCommand().equals((String)FilterTreePopUpActions.popUpCaptions.get(FilterTreePopUpActions.ENABLE_THIS_ELEMENT))) {
            ((FilterTreeModel)this.tree.getModel()).enableMember(this.popUpSource);
        } else if (e.getActionCommand().equals((String)FilterTreePopUpActions.popUpCaptions.get(FilterTreePopUpActions.ENABLE_ALL_BUT_THIS_ELEMENT))) {
            ((FilterTreeModel)this.tree.getModel()).setAllButThisMember((UniqueNameElement)((Object)this.popUpSource));
        } else if (e.getActionCommand().equals((String)FilterTreePopUpActions.popUpCaptions.get(FilterTreePopUpActions.ENABLE_ONLY_THIS_ELEMENT))) {
            ((FilterTreeModel)this.tree.getModel()).setOnlyThisMember((UniqueNameElement)((Object)this.popUpSource));
        } else if (e.getActionCommand().equals((String)FilterTreePopUpActions.popUpCaptions.get(FilterTreePopUpActions.LOSE_FILTER))) {
            this.loseFilter();
        } else if (e.getActionCommand().equals((String)FilterTreePopUpActions.popUpCaptions.get(FilterTreePopUpActions.APPLY_FILTER))) {
            this.query.checkRunQuery();
        } else {
            if (e.getActionCommand().equals((String)FilterTreePopUpActions.popUpCaptions.get(FilterTreePopUpActions.MOVE_TO_SPLIT_PANE))) {
                ((FilterTreeRootElement)((TreeElement)this.tree.getModel().getRoot()).getUserObject()).setDisplayInTab(false);
                this.viewer.refreshFilterDisplay();
                return;
            }
            if (e.getActionCommand().equals((String)FilterTreePopUpActions.popUpCaptions.get(FilterTreePopUpActions.MOVE_TO_TAB))) {
                ((FilterTreeRootElement)((TreeElement)this.tree.getModel().getRoot()).getUserObject()).setDisplayInTab(true);
                this.viewer.refreshFilterDisplay();
                return;
            }
        }
        this.enabledMembers.setText(((FilterTreeModel)this.tree.getModel()).getEnabledMembersCaption());
        this.repaint();
        if (!((FilterTreeModel)this.tree.getModel()).isFilttering()) {
            this.loseFilter();
        }
    }

    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        TreeElement te = (TreeElement)e.getPath().getLastPathComponent();
        if (((DimensionTreeElement)te.getUserObject()).getChildrenCount() > 0 && te.getChildCount() == 0) {
            FilterTreeModel cfr_ignored_0 = (FilterTreeModel)this.tree.getModel();
            if (((DimensionTreeElement)te.getUserObject()).getChildrenCount() < FilterTreeModel.MAX_CHILDREN_COUNT_ASK) {
                ((FilterTreeModel)this.tree.getModel()).addChildrenOneLevel(te);
            } else {
                FilterTreeModel cfr_ignored_1 = (FilterTreeModel)this.tree.getModel();
                int retVal = JOptionPane.showConfirmDialog(null, I18n.getString("msgText.expandNode1") + ((DimensionTreeElement)te.getUserObject()).getChildrenCount() + I18n.getString("msgText.expandNode2"), I18n.getString("msgTitle.expandNode") + FilterTreeModel.MAX_CHILDREN_COUNT_ASK + " members.", 0);
                if (retVal == 1) {
                    throw new ExpandVetoException(e);
                }
                ((FilterTreeModel)this.tree.getModel()).addChildrenOneLevel(te);
            }
        }
    }

    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    public static void main(String[] args) {
        ServerMetadata svm = new ServerMetadata("http://localhost/xmla/msxisapi.dll");
        XMLADiscoverRestrictions restrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
        XMLADiscoverProperties properties = XMLAObjectsFactory.newXMLADiscoverProperties();
        properties.setDataSourceInfo("Local Analysis Server");
        restrictions.setCatalog("Test");
        restrictions.setCubeName("Ispit");
        restrictions.setDimensionUniqueName("[VrijemeRok]");
        properties.setCatalog("Test");
        properties.setFormat("Tabular");
        properties.setContent("SchemaData");
        JFrame frame = new JFrame("Testing FilterTree...");
        DimensionElement de = new DimensionElement(svm, restrictions, properties, "Test", "Ispit", "[Student]", "[Student]", "[Student]");
        Member enabledMember = new Member("[Student].[CistaGeneracija]", "[Student].[CistaGeneracija].[Svi studenti].[Da]", "[Da]", true);
        LinkedList<Member> enabledMembers = new LinkedList<Member>();
        enabledMembers.add(enabledMember);
        FilterTree dst = new FilterTree(svm, de, enabledMembers);
        frame.getContentPane().add(dst);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
        WaitCursorEventQueue waitQueue = new WaitCursorEventQueue(500);
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(waitQueue);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int selRow = FilterTree.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = FilterTree.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && ((TreeElement)selPath.getLastPathComponent()).getUserObject() instanceof FilterTreeMemberElement) {
                    DimensionTreeElement dte = (DimensionTreeElement)((TreeElement)selPath.getLastPathComponent()).getUserObject();
                    if (dte.isEnabled()) {
                        ((FilterTreeModel)FilterTree.this.tree.getModel()).disableMember(dte);
                    } else {
                        ((FilterTreeModel)FilterTree.this.tree.getModel()).enableMember(dte);
                    }
                    FilterTree.this.enabledMembers.setText(((FilterTreeModel)FilterTree.this.tree.getModel()).getEnabledMembersCaption());
                    FilterTree.this.repaint();
                    if (!((FilterTreeModel)FilterTree.this.tree.getModel()).isFilttering()) {
                        FilterTree.this.loseFilter();
                    }
                }
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            int selRow = FilterTree.this.tree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = FilterTree.this.tree.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1 && e.isPopupTrigger()) {
                FilterTree.this.popup.removeAll();
                FilterTree.this.popUpSource = (DimensionTreeElement)((TreeElement)selPath.getLastPathComponent()).getUserObject();
                String[] al = FilterTree.this.popUpSource.getPopUpActionList();
                for (int i = 0; al != null && i < al.length; ++i) {
                    JMenuItem menuItem = new JMenuItem((String)FilterTreePopUpActions.popUpCaptions.get(al[i]));
                    menuItem.addActionListener(FilterTree.this);
                    FilterTree.this.popup.add(menuItem);
                }
                FilterTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class MyRenderer2
    extends JLabel
    implements TreeCellRenderer {
        ImageIcon tutorialIcon;

        public MyRenderer2() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DimensionTreeElement curr = (DimensionTreeElement)((TreeElement)value).getUserObject();
            this.setText(((Object)curr).toString());
            this.setIcon(curr.getIcon());
            this.setToolTipText(curr.getToolTip());
            if (curr.isEnabled() && curr instanceof FilterTreeMemberElement) {
                this.setForeground(AppColors.ENABLED_FILTER_TREE_NODE_COLOR);
            } else {
                this.setForeground(AppColors.DISABLED_FILTER_TREE_NODE_COLOR);
            }
            return this;
        }
    }
}

