/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.Pair;

public class JRHtmlExporter
extends JRAbstractExporter {
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static final String CSS_TEXT_ALIGN_LEFT = "left";
    protected static final String CSS_TEXT_ALIGN_RIGHT = "right";
    protected static final String CSS_TEXT_ALIGN_CENTER = "center";
    protected static final String CSS_TEXT_ALIGN_JUSTIFY = "justify";
    protected static final String HTML_VERTICAL_ALIGN_TOP = "top";
    protected static final String HTML_VERTICAL_ALIGN_MIDDLE = "middle";
    protected static final String HTML_VERTICAL_ALIGN_BOTTOM = "bottom";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected Writer writer = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageMaps;
    protected Map imageNameToImageDataMap = null;
    protected List imagesToProcess = null;
    protected boolean isPxImageLoaded = false;
    protected int reportIndex = 0;
    protected int pageIndex = 0;
    protected File imagesDir = null;
    protected String imagesURI = null;
    protected boolean isOutputImagesToDir = false;
    protected boolean isRemoveEmptySpace = false;
    protected boolean isWhitePageBackground = true;
    protected String encoding = null;
    protected String sizeUnit = null;
    protected String htmlHeader = null;
    protected String betweenPagesHtml = null;
    protected String htmlFooter = null;
    protected StringProvider emptyCellStringProvider = null;
    protected static final int colorMask = Integer.parseInt("FFFFFF", 16);
    protected boolean isWrapBreakWord = false;
    protected Map fontMap = null;
    private LinkedList backcolorStack = new LinkedList();
    private Color backcolor = null;
    protected JRHyperlinkProducerFactory hyperlinkProducerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block75: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                Boolean isUsingImagesToAlignParameter;
                String uri;
                Boolean isOutputImagesToDirParameter;
                Boolean isWhitePageBackgroundParameter;
                Boolean isRemoveEmptySpaceParameter;
                String dir;
                this.setExportContext();
                this.setInput();
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.htmlHeader = (String)this.parameters.get(JRHtmlExporterParameter.HTML_HEADER);
                this.betweenPagesHtml = (String)this.parameters.get(JRHtmlExporterParameter.BETWEEN_PAGES_HTML);
                this.htmlFooter = (String)this.parameters.get(JRHtmlExporterParameter.HTML_FOOTER);
                this.imagesDir = (File)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR);
                if (this.imagesDir == null && (dir = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR_NAME)) != null) {
                    this.imagesDir = new File(dir);
                }
                if ((isRemoveEmptySpaceParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS)) != null) {
                    this.isRemoveEmptySpace = isRemoveEmptySpaceParameter;
                }
                if ((isWhitePageBackgroundParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND)) != null) {
                    this.isWhitePageBackground = isWhitePageBackgroundParameter;
                }
                if ((isOutputImagesToDirParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR)) != null) {
                    this.isOutputImagesToDir = isOutputImagesToDirParameter;
                }
                if ((uri = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_URI)) != null) {
                    this.imagesURI = uri;
                }
                this.encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
                if (this.encoding == null) {
                    this.encoding = "UTF-8";
                }
                this.rendererToImagePathMap = new HashMap();
                this.imageMaps = new HashMap();
                this.imagesToProcess = new ArrayList();
                this.isPxImageLoaded = false;
                this.imageNameToImageDataMap = (Map)this.parameters.get(JRHtmlExporterParameter.IMAGES_MAP);
                Boolean isWrapBreakWordParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_WRAP_BREAK_WORD);
                if (isWrapBreakWordParameter != null) {
                    this.isWrapBreakWord = isWrapBreakWordParameter;
                }
                this.sizeUnit = (String)this.parameters.get(JRHtmlExporterParameter.SIZE_UNIT);
                if (this.sizeUnit == null) {
                    this.sizeUnit = "px";
                }
                if ((isUsingImagesToAlignParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN)) == null) {
                    isUsingImagesToAlignParameter = Boolean.TRUE;
                }
                if (isUsingImagesToAlignParameter.booleanValue()) {
                    this.emptyCellStringProvider = new StringProvider(){

                        public String getStringForCollapsedTD(Object value, int width, int height, String sizeUnit) {
                            return "><img alt=\"\" src=\"" + value + "px\" style=\"width: " + width + sizeUnit + "; height: " + height + sizeUnit + ";\"/>";
                        }

                        public String getStringForEmptyTD(Object value) {
                            return "<img alt=\"\" src=\"" + value + "px\" border=\"0\"/>";
                        }
                    };
                    this.loadPxImage();
                } else {
                    this.emptyCellStringProvider = new StringProvider(){

                        public String getStringForCollapsedTD(Object value, int width, int height, String sizeUnit) {
                            return " style=\"width: " + width + sizeUnit + "; height: " + height + sizeUnit + ";\">";
                        }

                        public String getStringForEmptyTD(Object value) {
                            return "";
                        }
                    };
                }
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setHyperlinkProducerFactory();
                StringBuffer sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                if (sb != null) {
                    try {
                        this.writer = new StringWriter();
                        this.exportReportToWriter();
                        sb.append(this.writer.toString());
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), e);
                    }
                    finally {
                        if (this.writer != null) {
                            try {
                                this.writer.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (this.writer != null) {
                    try {
                        this.exportReportToWriter();
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
                    }
                }
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.writer = new OutputStreamWriter(os, this.encoding);
                        this.exportReportToWriter();
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), e);
                    }
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.writer = new OutputStreamWriter(os, this.encoding);
                }
                catch (IOException e) {
                    throw new JRException("Error creating to file writer : " + this.jasperPrint.getName(), e);
                }
                if (this.imagesDir == null) {
                    this.imagesDir = new File(destFile.getParent(), destFile.getName() + "_files");
                }
                if (isOutputImagesToDirParameter == null) {
                    this.isOutputImagesToDir = true;
                }
                if (this.imagesURI == null) {
                    this.imagesURI = this.imagesDir.getName() + "/";
                }
                try {
                    this.exportReportToWriter();
                }
                catch (IOException e) {
                    throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), e);
                }
                finally {
                    if (this.writer != null) {
                        try {
                            this.writer.close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (!this.isOutputImagesToDir) break block75;
                if (this.imagesDir == null) {
                    throw new JRException("The images directory was not specified for the exporter.");
                }
                if (!this.isPxImageLoaded && (this.imagesToProcess == null || this.imagesToProcess.size() <= 0)) break block75;
                if (!this.imagesDir.exists()) {
                    this.imagesDir.mkdir();
                }
                if (this.isPxImageLoaded) {
                    JRRenderable pxRenderer = JRImageRenderer.getInstance("net/sf/jasperreports/engine/images/pixel.GIF", (byte)1);
                    byte[] imageData = pxRenderer.getImageData();
                    File imageFile = new File(this.imagesDir, "px");
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(imageFile);
                        fos.write(imageData, 0, imageData.length);
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to image file : " + imageFile, e);
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                Iterator it = this.imagesToProcess.iterator();
                while (it.hasNext()) {
                    JRPrintElementIndex imageIndex = (JRPrintElementIndex)it.next();
                    JRPrintImage image = JRHtmlExporter.getImage(this.jasperPrintList, imageIndex);
                    JRRenderable renderer = image.getRenderer();
                    if (renderer.getType() == 1) {
                        renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), 1 == image.getMode() ? image.getBackcolor() : null);
                    }
                    byte[] imageData = renderer.getImageData();
                    File imageFile = new File(this.imagesDir, JRHtmlExporter.getImageName(imageIndex));
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(imageFile);
                        fos.write(imageData, 0, imageData.length);
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to image file : " + imageFile, e);
                    }
                    finally {
                        if (fos == null) continue;
                        try {
                            fos.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
    }

    public static JRPrintImage getImage(List jasperPrintList, String imageName) {
        return JRHtmlExporter.getImage(jasperPrintList, JRHtmlExporter.getPrintElementIndex(imageName));
    }

    public static JRPrintImage getImage(List jasperPrintList, JRPrintElementIndex imageIndex) {
        JasperPrint report = (JasperPrint)jasperPrintList.get(imageIndex.getReportIndex());
        JRPrintPage page = (JRPrintPage)report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getElementIndexes();
        Object element = page.getElements().get(elementIndexes[0]);
        for (int i = 1; i < elementIndexes.length; ++i) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
        }
        return (JRPrintImage)element;
    }

    protected void exportReportToWriter() throws JRException, IOException {
        if (this.htmlHeader == null) {
            this.writer.write("<html>\n");
            this.writer.write("<head>\n");
            this.writer.write("  <title></title>\n");
            this.writer.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.encoding + "\"/>\n");
            this.writer.write("  <style type=\"text/css\">\n");
            this.writer.write("    a {text-decoration: none}\n");
            this.writer.write("  </style>\n");
            this.writer.write("</head>\n");
            this.writer.write("<body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
            this.writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            this.writer.write("<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">\n");
            this.writer.write("\n");
        } else {
            this.writer.write(this.htmlHeader);
        }
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                JRPrintPage page = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = (JRPrintPage)pages.get(this.pageIndex);
                    this.writer.write("<a name=\"JR_PAGE_ANCHOR_" + this.reportIndex + "_" + (this.pageIndex + 1) + "\"/>\n");
                    this.exportPage(page);
                    if (this.reportIndex < this.jasperPrintList.size() - 1 || this.pageIndex < this.endPageIndex) {
                        if (this.betweenPagesHtml == null) {
                            this.writer.write("<br/>\n<br/>\n");
                        } else {
                            this.writer.write(this.betweenPagesHtml);
                        }
                    }
                    this.writer.write("\n");
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        if (this.htmlFooter == null) {
            this.writer.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            this.writer.write("</table>\n");
            this.writer.write("</body>\n");
            this.writer.write("</html>\n");
        } else {
            this.writer.write(this.htmlFooter);
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        JRGridLayout layout = this.getPageGridLayout(page);
        this.exportGrid(layout, this.isWhitePageBackground);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportGrid(JRGridLayout gridLayout, boolean whitePageBackground) throws IOException, JRException {
        List xCuts = gridLayout.getXCuts();
        JRExporterGridCell[][] grid = gridLayout.getGrid();
        boolean[] isRowNotEmpty = gridLayout.getIsRowNotEmpty();
        this.writer.write("<table style=\"width: " + gridLayout.getWidth() + this.sizeUnit + "\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"");
        if (whitePageBackground) {
            this.writer.write(" bgcolor=\"white\"");
        }
        this.writer.write(">\n");
        if (whitePageBackground) {
            this.setBackcolor(Color.white);
        }
        this.writer.write("<tr>\n");
        int width = 0;
        for (int i = 1; i < xCuts.size(); ++i) {
            width = (Integer)xCuts.get(i) - (Integer)xCuts.get(i - 1);
            this.writer.write("  <td" + this.emptyCellStringProvider.getStringForCollapsedTD(this.imagesURI, width, 1, this.sizeUnit) + "</td>\n");
        }
        this.writer.write("</tr>\n");
        JRPrintElement element = null;
        for (int y = 0; y < grid.length; ++y) {
            if (!isRowNotEmpty[y] && this.isRemoveEmptySpace) continue;
            JRExporterGridCell[] gridRow = grid[y];
            int emptyCellColSpan = 0;
            int emptyCellWidth = 0;
            int rowHeight = JRGridLayout.getRowHeight(gridRow);
            boolean hasEmptyCell = this.hasEmptyCell(gridRow);
            this.writer.write("<tr valign=\"top\"");
            if (!hasEmptyCell) {
                this.writer.write(" style=\"height:" + rowHeight + this.sizeUnit + "\"");
            }
            this.writer.write(">\n");
            for (int x = 0; x < gridRow.length; ++x) {
                JRExporterGridCell gridCell = gridRow[x];
                if (gridCell.element != null) {
                    if (emptyCellColSpan > 0) {
                        this.writeEmptyCell(emptyCellColSpan, emptyCellWidth, rowHeight);
                        emptyCellColSpan = 0;
                        emptyCellWidth = 0;
                    }
                    if ((element = gridCell.element) instanceof JRPrintLine) {
                        this.exportLine((JRPrintLine)element, gridCell);
                    } else if (element instanceof JRPrintRectangle) {
                        this.exportRectangle(element, gridCell);
                    } else if (element instanceof JRPrintEllipse) {
                        this.exportRectangle(element, gridCell);
                    } else if (element instanceof JRPrintImage) {
                        this.exportImage((JRPrintImage)element, gridCell);
                    } else if (element instanceof JRPrintText) {
                        this.exportText((JRPrintText)element, gridCell);
                    } else if (element instanceof JRPrintFrame) {
                        this.exportFrame((JRPrintFrame)element, gridCell);
                    }
                    x += gridCell.colSpan - 1;
                    continue;
                }
                ++emptyCellColSpan;
                emptyCellWidth += gridCell.width;
            }
            if (emptyCellColSpan > 0) {
                this.writeEmptyCell(emptyCellColSpan, emptyCellWidth, rowHeight);
            }
            this.writer.write("</tr>\n");
        }
        if (whitePageBackground) {
            this.restoreBackcolor();
        }
        this.writer.write("</table>\n");
    }

    private boolean hasEmptyCell(JRExporterGridCell[] gridRow) {
        if (gridRow[0].element == null) {
            return true;
        }
        boolean hasEmptyCell = false;
        for (int x = 1; x < gridRow.length; ++x) {
            if (gridRow[x].element != null) continue;
            hasEmptyCell = true;
            break;
        }
        return hasEmptyCell;
    }

    private void writeEmptyCell(int emptyCellColSpan, int emptyCellWidth, int rowHeight) throws IOException {
        this.writer.write("  <td");
        if (emptyCellColSpan > 1) {
            this.writer.write(" colspan=\"" + emptyCellColSpan + "\"");
        }
        this.writer.write(this.emptyCellStringProvider.getStringForCollapsedTD(this.imagesURI, emptyCellWidth, rowHeight, this.sizeUnit) + "</td>\n");
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell) throws IOException {
        this.writeCellTDStart(gridCell);
        if (line.getForecolor().getRGB() != Color.white.getRGB()) {
            this.writer.write(" bgcolor=\"#");
            String hexa = Integer.toHexString(line.getForecolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.writer.write(hexa);
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        this.writer.write("</td>\n");
    }

    protected void writeCellTDStart(JRExporterGridCell gridCell) throws IOException {
        this.writer.write("  <td");
        if (gridCell.colSpan > 1) {
            this.writer.write(" colspan=\"" + gridCell.colSpan + "\"");
        }
        if (gridCell.rowSpan > 1) {
            this.writer.write(" rowspan=\"" + gridCell.rowSpan + "\"");
        }
    }

    protected void exportRectangle(JRPrintElement element, JRExporterGridCell gridCell) throws IOException {
        this.writeCellTDStart(gridCell);
        if ((this.backcolor == null || element.getBackcolor().getRGB() != this.backcolor.getRGB()) && element.getMode() == 1) {
            this.writer.write(" bgcolor=\"#");
            String hexa = Integer.toHexString(element.getBackcolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.writer.write(hexa);
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        this.writer.write("</td>\n");
    }

    protected void exportStyledText(JRStyledText styledText) throws IOException {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            this.exportStyledTextRun(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit));
            iterator.setIndex(runLimit);
        }
    }

    protected void exportStyledTextRun(Map attributes, String text) throws IOException {
        Color runBackcolor;
        String fontFamilyAttr = (String)attributes.get(TextAttribute.FAMILY);
        String fontFamily = this.fontMap != null && this.fontMap.containsKey(fontFamilyAttr) ? (String)this.fontMap.get(fontFamilyAttr) : fontFamilyAttr;
        this.writer.write("<span style=\"font-family: ");
        this.writer.write(fontFamily);
        this.writer.write("; ");
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        if (!Color.black.equals(forecolor)) {
            this.writer.write("color: #");
            String hexa = Integer.toHexString(forecolor.getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.writer.write(hexa);
            this.writer.write("; ");
        }
        if ((runBackcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null) {
            this.writer.write("background-color: #");
            String hexa = Integer.toHexString(runBackcolor.getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.writer.write(hexa);
            this.writer.write("; ");
        }
        this.writer.write("font-size: ");
        this.writer.write(String.valueOf(attributes.get(TextAttribute.SIZE)));
        this.writer.write(this.sizeUnit);
        this.writer.write(";");
        if (TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT))) {
            this.writer.write(" font-weight: bold;");
        }
        if (TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE))) {
            this.writer.write(" font-style: italic;");
        }
        if (TextAttribute.UNDERLINE_ON.equals(attributes.get(TextAttribute.UNDERLINE))) {
            this.writer.write(" text-decoration: underline;");
        }
        if (TextAttribute.STRIKETHROUGH_ON.equals(attributes.get(TextAttribute.STRIKETHROUGH))) {
            this.writer.write(" text-decoration: line-through;");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: super;");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: sub;");
        }
        this.writer.write("\">");
        this.writer.write(JRStringUtil.htmlEncode(text));
        this.writer.write("</span>");
    }

    protected void exportText(JRPrintText text, JRExporterGridCell gridCell) throws IOException {
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        this.writeCellTDStart(gridCell);
        String verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
        switch (text.getVerticalAlignment()) {
            case 3: {
                verticalAlignment = HTML_VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case 2: {
                verticalAlignment = HTML_VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
            }
        }
        if (!verticalAlignment.equals(HTML_VERTICAL_ALIGN_TOP)) {
            this.writer.write(" valign=\"");
            this.writer.write(verticalAlignment);
            this.writer.write("\"");
        }
        if (text.getRunDirection() == 1) {
            this.writer.write(" dir=\"rtl\"");
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.appendBackcolorStyle(text, styleBuffer);
        this.appendBorderStyle(text, text, styleBuffer);
        String horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
        if (textLength > 0) {
            switch (text.getHorizontalAlignment()) {
                case 3: {
                    horizontalAlignment = CSS_TEXT_ALIGN_RIGHT;
                    break;
                }
                case 2: {
                    horizontalAlignment = CSS_TEXT_ALIGN_CENTER;
                    break;
                }
                case 4: {
                    horizontalAlignment = CSS_TEXT_ALIGN_JUSTIFY;
                    break;
                }
                default: {
                    horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
                }
            }
            if (text.getRunDirection() == 0 && !horizontalAlignment.equals(CSS_TEXT_ALIGN_LEFT) || text.getRunDirection() == 1 && !horizontalAlignment.equals(CSS_TEXT_ALIGN_RIGHT)) {
                styleBuffer.append("text-align: ");
                styleBuffer.append(horizontalAlignment);
                styleBuffer.append(";");
            }
        }
        if (this.isWrapBreakWord) {
            styleBuffer.append("width: " + gridCell.width + this.sizeUnit + "; ");
            styleBuffer.append("word-wrap: break-word; ");
        }
        if (text.getLineSpacing() != 0) {
            styleBuffer.append("line-height: " + text.getLineSpacingFactor() + "; ");
        }
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (text.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(text.getAnchorName());
            this.writer.write("\"/>");
        }
        boolean startedHyperlink = this.startHyperlink(text);
        if (textLength > 0) {
            this.exportStyledText(styledText);
        } else {
            this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        }
        if (startedHyperlink) {
            this.endHyperlink();
        }
        this.writer.write("</td>\n");
    }

    protected boolean startHyperlink(JRPrintHyperlink link) throws IOException {
        String href = this.getHyperlinkURL(link);
        if (href != null) {
            this.writer.write("<a href=\"");
            this.writer.write(href);
            this.writer.write("\"");
            String target = this.getHyperlinkTarget(link);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
            if (link.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(link.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write(">");
        }
        return href != null;
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target = null;
        switch (link.getHyperlinkTarget()) {
            case 2: {
                target = "_blank";
                break;
            }
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block12: {
                href = null;
                customHandler = this.getCustomHandler(link);
                if (customHandler != null) break block12;
                switch (link.getHyperlinkType()) {
                    case 2: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case 3: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case 4: {
                        if (link.getHyperlinkPage() != null) {
                            href = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case 5: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case 6: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected JRHyperlinkProducer getCustomHandler(JRPrintHyperlink link) {
        JRHyperlinkProducer customHandler = this.hyperlinkProducerFactory == null ? null : this.hyperlinkProducerFactory.getHandler(link.getLinkType());
        customHandler = this.hyperlinkProducerFactory == null ? null : this.hyperlinkProducerFactory.getHandler(link.getLinkType());
        return customHandler;
    }

    protected void endHyperlink() throws IOException {
        this.writer.write("</a>");
    }

    protected void appendBorderStyle(JRPrintElement element, JRBox box, StringBuffer styleBuffer) {
        if (box != null) {
            this.appendBorder(styleBuffer, box.getTopBorder(), box.getTopBorderColor() == null ? element.getForecolor() : box.getTopBorderColor(), box.getTopPadding(), HTML_VERTICAL_ALIGN_TOP);
            this.appendBorder(styleBuffer, box.getLeftBorder(), box.getLeftBorderColor() == null ? element.getForecolor() : box.getLeftBorderColor(), box.getLeftPadding(), CSS_TEXT_ALIGN_LEFT);
            this.appendBorder(styleBuffer, box.getBottomBorder(), box.getBottomBorderColor() == null ? element.getForecolor() : box.getBottomBorderColor(), box.getBottomPadding(), HTML_VERTICAL_ALIGN_BOTTOM);
            this.appendBorder(styleBuffer, box.getRightBorder(), box.getRightBorderColor() == null ? element.getForecolor() : box.getRightBorderColor(), box.getRightPadding(), CSS_TEXT_ALIGN_RIGHT);
        }
    }

    protected Color appendBackcolorStyle(JRPrintElement element, StringBuffer styleBuffer) {
        if (element.getMode() == 1 && (this.backcolor == null || element.getBackcolor().getRGB() != this.backcolor.getRGB())) {
            styleBuffer.append("background-color: #");
            String hexa = Integer.toHexString(element.getBackcolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            styleBuffer.append(hexa);
            styleBuffer.append("; ");
            return element.getBackcolor();
        }
        return null;
    }

    protected void exportImage(JRPrintImage image, JRExporterGridCell gridCell) throws JRException, IOException {
        int imageHeight;
        JRRenderable renderer;
        this.writeCellTDStart(gridCell);
        String horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
        switch (image.getHorizontalAlignment()) {
            case 3: {
                horizontalAlignment = CSS_TEXT_ALIGN_RIGHT;
                break;
            }
            case 2: {
                horizontalAlignment = CSS_TEXT_ALIGN_CENTER;
                break;
            }
            default: {
                horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
            }
        }
        if (!horizontalAlignment.equals(CSS_TEXT_ALIGN_LEFT)) {
            this.writer.write(" align=\"");
            this.writer.write(horizontalAlignment);
            this.writer.write("\"");
        }
        String verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
        switch (image.getVerticalAlignment()) {
            case 3: {
                verticalAlignment = HTML_VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case 2: {
                verticalAlignment = HTML_VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
            }
        }
        if (!verticalAlignment.equals(HTML_VERTICAL_ALIGN_TOP)) {
            this.writer.write(" valign=\"");
            this.writer.write(verticalAlignment);
            this.writer.write("\"");
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.appendBackcolorStyle(image, styleBuffer);
        this.appendBorderStyle(image, image, styleBuffer);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (image.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(image.getAnchorName());
            this.writer.write("\"/>");
        }
        JRRenderable originalRenderer = renderer = image.getRenderer();
        boolean imageMapRenderer = renderer != null && renderer instanceof JRImageMapRenderer;
        boolean startedHyperlink = !imageMapRenderer && this.startHyperlink(image);
        this.writer.write("<img");
        String imagePath = null;
        String imageMapName = null;
        List imageMapAreas = null;
        int scaleImage = image.getScaleImage();
        if (renderer != null) {
            if (renderer.getType() == 0 && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                imagePath = (String)this.rendererToImagePathMap.get(renderer.getId());
            } else {
                if (image.isLazy()) {
                    imagePath = ((JRImageRenderer)renderer).getImageLocation();
                } else {
                    JRPrintElementIndex imageIndex = this.getElementIndex(gridCell);
                    this.imagesToProcess.add(imageIndex);
                    String imageName = JRHtmlExporter.getImageName(imageIndex);
                    imagePath = this.imagesURI + imageName;
                    if (this.imageNameToImageDataMap != null) {
                        if (renderer.getType() == 1) {
                            renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), 1 == image.getMode() ? image.getBackcolor() : null);
                        }
                        this.imageNameToImageDataMap.put(imageName, renderer.getImageData());
                    }
                }
                this.rendererToImagePathMap.put(renderer.getId(), imagePath);
            }
            if (imageMapRenderer) {
                Rectangle renderingArea = new Rectangle(image.getWidth(), image.getHeight());
                if (renderer.getType() == 0) {
                    imageMapName = (String)this.imageMaps.get(new Pair(renderer.getId(), renderingArea));
                }
                if (imageMapName == null) {
                    imageMapName = "map_" + this.getElementIndex(gridCell).toString();
                    imageMapAreas = ((JRImageMapRenderer)originalRenderer).getImageAreaHyperlinks(renderingArea);
                    if (renderer.getType() == 0) {
                        this.imageMaps.put(new Pair(renderer.getId(), renderingArea), imageMapName);
                    }
                }
            }
        } else {
            this.loadPxImage();
            imagePath = this.imagesURI + "px";
            scaleImage = 2;
        }
        this.writer.write(" src=\"");
        if (imagePath != null) {
            this.writer.write(imagePath);
        }
        this.writer.write("\"");
        int borderWidth = 0;
        switch (image.getPen()) {
            case 4: {
                borderWidth = 1;
                break;
            }
            case 3: {
                borderWidth = 4;
                break;
            }
            case 2: {
                borderWidth = 2;
                break;
            }
            case 0: {
                borderWidth = 0;
                break;
            }
            case 5: {
                borderWidth = 1;
                break;
            }
            default: {
                borderWidth = 1;
            }
        }
        this.writer.write(" border=\"");
        this.writer.write(String.valueOf(borderWidth));
        this.writer.write("\"");
        int imageWidth = image.getWidth() - image.getLeftPadding() - image.getRightPadding();
        if (imageWidth < 0) {
            imageWidth = 0;
        }
        if ((imageHeight = image.getHeight() - image.getTopPadding() - image.getBottomPadding()) < 0) {
            imageHeight = 0;
        }
        switch (scaleImage) {
            case 2: {
                this.writer.write(" style=\"width: ");
                this.writer.write(String.valueOf(imageWidth));
                this.writer.write(this.sizeUnit);
                this.writer.write("; height: ");
                this.writer.write(String.valueOf(imageHeight));
                this.writer.write(this.sizeUnit);
                this.writer.write("\"");
                break;
            }
            default: {
                Dimension2D dimension;
                double normalWidth = imageWidth;
                double normalHeight = imageHeight;
                if (!image.isLazy() && (dimension = renderer.getDimension()) != null) {
                    normalWidth = dimension.getWidth();
                    normalHeight = dimension.getHeight();
                }
                if (imageHeight <= 0) break;
                double ratio = normalWidth / normalHeight;
                if (ratio > (double)imageWidth / (double)imageHeight) {
                    this.writer.write(" style=\"width: ");
                    this.writer.write(String.valueOf(imageWidth));
                    this.writer.write(this.sizeUnit);
                    this.writer.write("\"");
                    break;
                }
                this.writer.write(" style=\"height: ");
                this.writer.write(String.valueOf(imageHeight));
                this.writer.write(this.sizeUnit);
                this.writer.write("\"");
            }
        }
        if (imageMapName != null) {
            this.writer.write(" usemap=\"#" + imageMapName + "\"");
        }
        this.writer.write(" alt=\"\"/>");
        if (startedHyperlink) {
            this.endHyperlink();
        }
        if (imageMapAreas != null) {
            this.writer.write("\n");
            this.writeImageMap(imageMapName, image, imageMapAreas);
        }
        this.writer.write("</td>\n");
    }

    protected JRPrintElementIndex getElementIndex(JRExporterGridCell gridCell) {
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.elementIndex);
        return imageIndex;
    }

    protected void writeImageMap(String imageMapName, JRPrintHyperlink mainHyperlink, List imageMapAreas) throws IOException {
        this.writer.write("<map name=\"" + imageMapName + "\">\n");
        Iterator it = imageMapAreas.iterator();
        while (it.hasNext()) {
            JRPrintImageAreaHyperlink areaHyperlink = (JRPrintImageAreaHyperlink)it.next();
            JRPrintImageArea area = areaHyperlink.getArea();
            this.writer.write("  <area shape=\"" + JRPrintImageArea.getHtmlShape(area.getShape()) + "\"");
            this.writeImageAreaCoordinates(area);
            this.writeImageAreaHyperlink(areaHyperlink.getHyperlink());
            this.writer.write("/>\n");
        }
        if (mainHyperlink.getHyperlinkType() != 1) {
            this.writer.write("  <area shape=\"default\"");
            this.writeImageAreaHyperlink(mainHyperlink);
            this.writer.write("/>\n");
        }
        this.writer.write("</map>\n");
    }

    protected void writeImageAreaCoordinates(JRPrintImageArea area) throws IOException {
        int[] coords = area.getCoordinates();
        if (coords != null && coords.length > 0) {
            StringBuffer coordsEnum = new StringBuffer(coords.length * 4);
            coordsEnum.append(coords[0]);
            for (int i = 1; i < coords.length; ++i) {
                coordsEnum.append(',');
                coordsEnum.append(coords[i]);
            }
            this.writer.write(" coords=\"" + coordsEnum + "\"");
        }
    }

    protected void writeImageAreaHyperlink(JRPrintHyperlink hyperlink) throws IOException {
        String href = this.getHyperlinkURL(hyperlink);
        if (href == null) {
            this.writer.write(" nohref=\"nohref\"");
        } else {
            this.writer.write(" href=\"" + href + "\"");
            String target = this.getHyperlinkTarget(hyperlink);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
        }
        if (hyperlink.getHyperlinkTooltip() != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(hyperlink.getHyperlinkTooltip()));
            this.writer.write("\"");
        }
    }

    protected JRGridLayout getPageGridLayout(JRPrintPage page) {
        JRGridLayout layout = new JRGridLayout(page.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, JRGridLayout.UNIVERSAL_EXPORTER, false, true, true, null);
        return layout;
    }

    protected void loadPxImage() throws JRException {
        this.isPxImageLoaded = true;
        if (this.imageNameToImageDataMap != null && !this.imageNameToImageDataMap.containsKey("px")) {
            JRRenderable pxRenderer = JRImageRenderer.getInstance("net/sf/jasperreports/engine/images/pixel.GIF", (byte)1);
            this.rendererToImagePathMap.put(pxRenderer.getId(), this.imagesURI + "px");
            this.imageNameToImageDataMap.put("px", pxRenderer.getImageData());
        }
    }

    private void appendBorder(StringBuffer sb, byte pen, Color borderColor, int padding, String side) {
        String borderStyle = null;
        String borderWidth = null;
        switch (pen) {
            case 4: {
                borderStyle = "dashed";
                borderWidth = "1";
                break;
            }
            case 3: {
                borderStyle = "solid";
                borderWidth = "4";
                break;
            }
            case 2: {
                borderStyle = "solid";
                borderWidth = "2";
                break;
            }
            case 5: {
                borderStyle = "solid";
                borderWidth = "1";
                break;
            }
            case 0: {
                break;
            }
            default: {
                borderStyle = "solid";
                borderWidth = "1";
            }
        }
        if (borderWidth != null) {
            sb.append("border-");
            sb.append(side);
            sb.append("-style: ");
            sb.append(borderStyle);
            sb.append("; ");
            sb.append("border-");
            sb.append(side);
            sb.append("-width: ");
            sb.append(borderWidth);
            sb.append(this.sizeUnit);
            sb.append("; ");
            sb.append("border-");
            sb.append(side);
            sb.append("-color: #");
            String hexa = Integer.toHexString(borderColor.getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            sb.append(hexa);
            sb.append("; ");
        }
        if (padding > 0) {
            sb.append("padding-");
            sb.append(side);
            sb.append(": ");
            sb.append(padding);
            sb.append(this.sizeUnit);
            sb.append("; ");
        }
    }

    public static String getImageName(JRPrintElementIndex printElementIndex) {
        return IMAGE_NAME_PREFIX + printElementIndex.toString();
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("Invalid image name: " + imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell) throws IOException, JRException {
        this.writeCellTDStart(gridCell);
        StringBuffer styleBuffer = new StringBuffer();
        Color frameBackcolor = this.appendBackcolorStyle(frame, styleBuffer);
        this.appendBorderStyle(frame, frame, styleBuffer);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">\n");
        if (frameBackcolor != null) {
            this.setBackcolor(frameBackcolor);
        }
        try {
            JRGridLayout layout = new JRGridLayout(frame.getElements(), frame.getWidth(), frame.getHeight(), 0, 0, JRGridLayout.UNIVERSAL_EXPORTER, false, true, true, gridCell.elementIndex);
            this.exportGrid(layout, false);
        }
        finally {
            if (frameBackcolor != null) {
                this.restoreBackcolor();
            }
        }
        this.writer.write("</td>\n");
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = (Color)this.backcolorStack.removeLast();
    }

    protected static interface StringProvider {
        public String getStringForCollapsedTD(Object var1, int var2, int var3, String var4);

        public String getStringForEmptyTD(Object var1);
    }
}

