/*
 * Decompiled with CFR 0.152.
 */
package rex.utils;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.utils.S;

public class DOM {
    public static final String[] typeName = new String[]{"none", "Element", "Attr", "Text", "CDATA", "EntityRef", "Entity", "ProcInstr", "Comment", "Document", "DocType", "DocFragment", "Notation"};
    public static final short ELEMENT_TYPE = 1;
    public static final short ATTR_TYPE = 2;
    public static final short TEXT_TYPE = 3;
    public static final short CDATA_TYPE = 4;
    public static final short ENTITYREF_TYPE = 5;
    public static final short ENTITY_TYPE = 6;
    public static final short PROCINSTR_TYPE = 7;
    public static final short COMMENT_TYPE = 8;
    public static final short DOCUMENT_TYPE = 9;
    public static final short DOCTYPE_TYPE = 10;
    public static final short DOCFRAG_TYPE = 11;
    public static final short NOTATION_TYPE = 12;

    public static String getTextFromDOMElement(Node node) {
        String retVal = "";
        if (node.getNodeType() != 1) {
            return "";
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            retVal = retVal + nodeList.item(i).getNodeValue();
        }
        return retVal;
    }

    public static final void dumpNodeAttributes(NamedNodeMap attrs) {
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                S.out("attr(" + i + ") :" + " name=" + attrs.item(i).getNodeName() + " type=" + attrs.item(i).getNodeType() + " value=" + attrs.item(i).getNodeValue());
            }
        } else {
            S.out("node has no attributes (IS NULL!)");
        }
    }

    public static final void dumpChildNodes(Node n) {
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            S.out("node(" + i + ")" + " (" + typeName[nl.item(i).getNodeType()] + ") " + " = " + nl.item(i).getNodeName() + " (" + DOM.getTextFromDOMElement(nl.item(i)) + ")");
        }
    }

    public static Node getFirstChildNodeWithName(Node n, String nodeName) {
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals(nodeName)) continue;
            return nl.item(i);
        }
        return null;
    }

    public static int getCountOfChildNodesOfType(Node n, short type) {
        NodeList allChildren = n.getChildNodes();
        int count = 0;
        for (int i = 0; i < allChildren.getLength(); ++i) {
            if (allChildren.item(i).getNodeType() != type) continue;
            ++count;
        }
        return count;
    }
}

