/*
 * Decompiled with CFR 0.152.
 */
package rex.metadata;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import rex.bidirectional.AxisEmpty;
import rex.graphics.IViewer;
import rex.graphics.dimensiontree.DimensionTree;
import rex.graphics.filtertree.FilterTree;
import rex.graphics.filtertree.FilterTreeModel;
import rex.graphics.mdxeditor.MdxResultViewer;
import rex.graphics.mdxeditor.mdxbuilder.MdxBuilderTree;
import rex.metadata.ExecuteResult;
import rex.metadata.OrderFunction;
import rex.metadata.QueryDimensionElement;
import rex.metadata.QueryElement;
import rex.metadata.QueryElementImpl;
import rex.metadata.resultelements.Axis;
import rex.metadata.resultelements.Member;
import rex.utils.I18n;
import rex.utils.S;

public class Query {
    private boolean queryCanExecute;
    private LinkedList onColumns;
    private LinkedList onRows;
    private LinkedList onPages;
    private LinkedList onMeasures;
    private LinkedList filters;
    private LinkedList onColumnsForQuery;
    private LinkedList onRowsForQuery;
    private LinkedList onPagesForQuery;
    private Axis slicerAxis;
    private LinkedList onSlicer;
    private LinkedList queryLevels;
    private String cubeName;
    private IViewer viewer;
    private Member memberToSortBy = null;
    private String sortType;
    private String lastQueryGenerated;
    OrderFunction fun;
    AxisEmpty axisEmpty;
    private boolean showOnMBT;
    private int measureAxis = -1;

    public void setQuery(ExecuteResult er) {
        this.queryCanExecute = true;
        this.onColumns.clear();
        this.onMeasures.clear();
        this.onRows.clear();
        this.onPages.clear();
        this.onColumnsForQuery.clear();
        this.onRowsForQuery.clear();
        this.onPagesForQuery.clear();
        this.onSlicer.clear();
        this.queryLevels.clear();
        this.showOnMBT = false;
        for (int axis = 0; axis < er.getAxisCount(); ++axis) {
            for (int i = 0; i < er.getTupleCount(axis); ++i) {
                block12: for (int j = 0; j < er.getAxis("Axis" + axis).getTupleAt(i).getMemberCount(); ++j) {
                    Member member = er.getAxis("Axis" + axis).getTupleAt(i).getMemberAt(j);
                    this.addToLevels(member.getLname());
                    String QMExp = member.getQueryMembersExpression();
                    String HUName = member.getHierarchyUniqueName();
                    QueryElementImpl qe = new QueryElementImpl(QMExp, HUName);
                    if (qe.getHierarchyUniqueName().toLowerCase().indexOf("measures") > 0) {
                        this.addToMeasuresNoRun(qe);
                        this.measureAxis = axis;
                        switch (axis) {
                            case 0: {
                                this.addToColumnsForQueryNoRun(qe);
                                break;
                            }
                            case 1: {
                                this.addToRowsForQueryNoRun(qe);
                                break;
                            }
                            case 2: {
                                this.addToPagesForQueryNoRun(qe);
                            }
                        }
                        continue;
                    }
                    switch (axis) {
                        case 0: {
                            this.addToColumnsNoRun(qe);
                            this.addToColumnsForQueryNoRun(qe);
                            continue block12;
                        }
                        case 1: {
                            this.addToRowsNoRun(qe);
                            this.addToRowsForQueryNoRun(qe);
                            continue block12;
                        }
                        case 2: {
                            this.addToPagesNoRun(qe);
                            this.addToPagesForQueryNoRun(qe);
                        }
                    }
                }
            }
        }
        this.slicerAxis = er.getAxis("SlicerAxis");
    }

    public Query(String _cubeName, IViewer _v) {
        this.viewer = _v;
        this.queryCanExecute = false;
        this.onColumns = new LinkedList();
        this.onRows = new LinkedList();
        this.onPages = new LinkedList();
        this.onMeasures = new LinkedList();
        this.onColumnsForQuery = new LinkedList();
        this.onRowsForQuery = new LinkedList();
        this.onPagesForQuery = new LinkedList();
        this.onSlicer = new LinkedList();
        this.queryLevels = new LinkedList();
        this.cubeName = _cubeName;
    }

    public Query(String _cubeName, IViewer _v, MdxBuilderTree builderTree, DimensionTree dimTree) {
        this(_cubeName, _v);
        this.fun = new OrderFunction(dimTree, builderTree, this);
    }

    public void addToLevels(Object obj) {
        Iterator it = this.queryLevels.iterator();
        while (it.hasNext()) {
            if (((String)it.next()).compareTo((String)obj) != 0) continue;
            return;
        }
        this.queryLevels.addLast(obj);
    }

    public void addToColumns(QueryElement qe) {
        this.addToColumnsNoRun(qe);
        this.addToColumnsForQueryNoRun(qe);
        this.checkRunQuery();
    }

    public void addToColumnsForQueryNoRun(QueryElement qe) {
        for (QueryDimensionElement qde : this.onColumnsForQuery) {
            if (!qde.getHierarchyUniqueName().startsWith(qe.getHierarchyUniqueName()) && !qe.getHierarchyUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            qde.addMemberToList(qe);
            return;
        }
        this.onColumnsForQuery.addLast(new QueryDimensionElement(qe));
    }

    public void addToRowsForQueryNoRun(QueryElement qe) {
        for (QueryDimensionElement qde : this.onRowsForQuery) {
            if (!qde.getHierarchyUniqueName().startsWith(qe.getHierarchyUniqueName()) && !qe.getHierarchyUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            qde.addMemberToList(qe);
            return;
        }
        this.onRowsForQuery.addLast(new QueryDimensionElement(qe));
    }

    public void addToPagesForQueryNoRun(QueryElement qe) {
        for (QueryDimensionElement qde : this.onPagesForQuery) {
            if (!qde.getHierarchyUniqueName().startsWith(qe.getHierarchyUniqueName()) && !qe.getHierarchyUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            qde.addMemberToList(qe);
            return;
        }
        this.onPagesForQuery.addLast(new QueryDimensionElement(qe));
    }

    public void addToColumnsNoRun(QueryElement qe) {
        for (QueryDimensionElement qde : this.onColumns) {
            if (!qde.getHierarchyUniqueName().startsWith(qe.getHierarchyUniqueName()) && !qe.getHierarchyUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            qde.addMemberToList(qe);
            return;
        }
        this.onColumns.addLast(new QueryDimensionElement(qe));
    }

    public void addToRows(QueryElement qe) {
        this.addToRowsNoRun(qe);
        this.addToRowsForQueryNoRun(qe);
        this.checkRunQuery();
    }

    public void addToRowsNoRun(QueryElement qe) {
        for (QueryDimensionElement qde : this.onRows) {
            if (!qde.getHierarchyUniqueName().startsWith(qe.getHierarchyUniqueName()) && !qe.getHierarchyUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            qde.addMemberToList(qe);
            return;
        }
        this.onRows.addLast(new QueryDimensionElement(qe));
    }

    public void addToPages(QueryElement qe) {
        this.addToPagesNoRun(qe);
        this.addToPagesForQueryNoRun(qe);
        this.checkRunQuery();
    }

    public void addToPagesNoRun(QueryElement qe) {
        for (QueryDimensionElement qde : this.onPages) {
            if (!qde.getHierarchyUniqueName().startsWith(qe.getHierarchyUniqueName()) && !qe.getHierarchyUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            qde.addMemberToList(qe);
            return;
        }
        this.onPages.addLast(new QueryDimensionElement(qe));
    }

    public void addToMeasures(QueryElement qe) {
        this.addToMeasuresNoRun(qe);
        this.addToColumnsForQueryNoRun(qe);
        this.measureAxis = 0;
        this.checkRunQuery();
    }

    public void addToMeasuresNoRun(QueryElement qe) {
        for (QueryDimensionElement qde : this.onMeasures) {
            if (!qde.getHierarchyUniqueName().startsWith(qe.getHierarchyUniqueName()) && !qe.getHierarchyUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            qde.addMemberToList(qe);
            return;
        }
        this.onMeasures.addLast(new QueryDimensionElement(qe));
    }

    public String getCaptionForRows() {
        Iterator it = this.onRows.iterator();
        String retVal = "";
        if (!it.hasNext()) {
            return I18n.getString("str.dropRowsHere");
        }
        while (it.hasNext()) {
            retVal = retVal + ((QueryElement)it.next()).getHierarchyUniqueName() + " * ";
        }
        return retVal.substring(0, retVal.length() - 3);
    }

    public String getCaptionForPages() {
        Iterator it = this.onPages.iterator();
        String retVal = "";
        if (!it.hasNext()) {
            return I18n.getString("str.dropRowsHere");
        }
        while (it.hasNext()) {
            retVal = retVal + ((QueryElement)it.next()).getHierarchyUniqueName() + " * ";
        }
        return retVal.substring(0, retVal.length() - 3);
    }

    public String getCaptionForColumns() {
        Iterator it = this.onColumns.iterator();
        String retVal = "";
        if (!it.hasNext()) {
            return I18n.getString("str.dropRowsHere");
        }
        while (it.hasNext()) {
            retVal = retVal + ((QueryElement)it.next()).getHierarchyUniqueName() + " * ";
        }
        return retVal.substring(0, retVal.length() - 3);
    }

    public String getCaptionForMeasures() {
        Iterator it = this.onMeasures.iterator();
        String retVal = "";
        if (!it.hasNext()) {
            return I18n.getString("str.dropRowsHere");
        }
        while (it.hasNext()) {
            retVal = retVal + ((QueryElement)it.next()).getHierarchyUniqueName() + " * ";
        }
        return retVal.substring(0, retVal.length() - 3);
    }

    public void checkRunQuery() {
        this.viewer.refreshQuery();
    }

    public boolean canExecute() {
        return this.onRowsForQuery.size() * this.onColumnsForQuery.size() > 0;
    }

    public boolean canExecuteOrder() {
        return this.onRowsForQuery.size() * this.onColumnsForQuery.size() > 0;
    }

    private String getAxisQueryExpression(LinkedList axDims) {
        Iterator it = axDims.iterator();
        String retVal = "     ";
        while (it.hasNext()) {
            retVal = retVal + "{" + ((QueryDimensionElement)it.next()).getQueryMembersExpression() + "}\n * ";
        }
        return retVal.substring(0, retVal.length() - 3);
    }

    public void toggleRowsDrillState(Member member) {
        for (QueryDimensionElement qde : this.onRows) {
            if (!member.getUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            qde.toggleDrillState(member);
            break;
        }
        this.checkRunQuery();
    }

    public void togglePagesDrillState(Member member) {
        for (QueryDimensionElement qde : this.onPages) {
            if (!member.getUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            qde.toggleDrillState(member);
            break;
        }
        this.checkRunQuery();
    }

    public void toggleColumnsDrillState(Member member) {
        for (QueryDimensionElement qde : this.onColumns) {
            if (!member.getUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            qde.toggleDrillState(member);
            break;
        }
        this.checkRunQuery();
    }

    public void moveColumnDimensionUp(Member member) {
        this.moveDimensionUp(member, this.onColumns);
    }

    public void moveRowDimensionUp(Member member) {
        this.moveDimensionUp(member, this.onRows);
    }

    public void movePageDimensionUp(Member member) {
        this.moveDimensionUp(member, this.onPages);
    }

    private void moveDimensionUp(Member member, LinkedList linkList) {
        ListIterator it = linkList.listIterator();
        while (it.hasNext()) {
            QueryDimensionElement qde = (QueryDimensionElement)it.next();
            if (!member.getUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            Object element = it.previous();
            if (!it.hasPrevious()) break;
            Object previousElement = it.previous();
            it.remove();
            it.next();
            it.add(previousElement);
            this.checkRunQuery();
            break;
        }
    }

    public void moveColumnDimensionFirst(Member member) {
        this.moveDimensionFirst(member, this.onColumns);
    }

    public void moveRowDimensionFirst(Member member) {
        this.moveDimensionFirst(member, this.onRows);
    }

    public void movePageDimensionFirst(Member member) {
        this.moveDimensionFirst(member, this.onPages);
    }

    private void moveDimensionFirst(Member member, LinkedList linkList) {
        ListIterator it = linkList.listIterator();
        while (it.hasNext()) {
            QueryDimensionElement qde = (QueryDimensionElement)it.next();
            if (!member.getUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            Object element = it.previous();
            if (!it.hasPrevious()) break;
            it.remove();
            linkList.addFirst(element);
            this.checkRunQuery();
            break;
        }
    }

    public void moveColumnDimensionLast(Member member) {
        this.moveDimensionLast(member, this.onColumns);
    }

    public void moveRowDimensionLast(Member member) {
        this.moveDimensionLast(member, this.onRows);
    }

    public void movePageDimensionLast(Member member) {
        this.moveDimensionLast(member, this.onPages);
    }

    private void moveDimensionLast(Member member, LinkedList linkList) {
        ListIterator it = linkList.listIterator();
        while (it.hasNext()) {
            QueryDimensionElement qde = (QueryDimensionElement)it.next();
            if (!member.getUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            if (!it.hasNext()) break;
            it.previous();
            it.remove();
            linkList.addLast(qde);
            this.checkRunQuery();
            break;
        }
    }

    public void removeFilterRowDimensionFromQuery(Member member) {
        this.removeDimensionFromQuery(member, this.onRows, false);
        this.removeDimensionFromQuery(member, this.onRowsForQuery, false);
    }

    public void removeFilterColumnDimensionFromQuery(Member member) {
        this.removeDimensionFromQuery(member, this.onColumns, false);
        this.removeDimensionFromQuery(member, this.onColumnsForQuery, false);
    }

    public void removeFilterPageDimensionFromQuery(Member member) {
        this.removeDimensionFromQuery(member, this.onPages, false);
        this.removeDimensionFromQuery(member, this.onPagesForQuery, false);
    }

    public void removeRowDimensionFromQuery(Member member) {
        this.removeDimensionFromQuery(member, this.onRows, true);
        this.removeDimensionFromQuery(member, this.onRowsForQuery, true);
    }

    public void removeColumnDimensionFromQuery(Member member) {
        this.removeDimensionFromQuery(member, this.onColumns, true);
        this.removeDimensionFromQuery(member, this.onColumnsForQuery, true);
    }

    public void removePageDimensionFromQuery(Member member) {
        this.removeDimensionFromQuery(member, this.onPages, true);
        this.removeDimensionFromQuery(member, this.onPagesForQuery, true);
    }

    private void removeDimensionFromQuery(Member member, LinkedList linkList, boolean enableTreeElements) {
        ListIterator it = linkList.listIterator();
        while (it.hasNext()) {
            QueryDimensionElement qde = (QueryDimensionElement)it.next();
            if (!member.getUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            it.previous();
            it.remove();
            if (enableTreeElements) {
                this.viewer.enableTreeElements(qde);
            }
            this.checkRunQuery();
            break;
        }
    }

    public void removeRowMemberFromQuery(Member memberToRemove) {
        this.removeMemberFromQuery(memberToRemove, this.onRows);
        this.removeMemberFromQuery(memberToRemove, this.onRowsForQuery);
    }

    public void removeColumnMemberFromQuery(Member memberToRemove) {
        this.removeMemberFromQuery(memberToRemove, this.onColumns);
        this.removeMemberFromQuery(memberToRemove, this.onColumnsForQuery);
    }

    public void removeMeasureMemberFromQuery(Member memberToRemove) {
        this.removeMemberFromQuery(memberToRemove, this.onMeasures);
        switch (this.measureAxis) {
            case 0: {
                this.removeMemberFromQuery(memberToRemove, this.onColumnsForQuery);
                break;
            }
            case 1: {
                this.removeMemberFromQuery(memberToRemove, this.onRowsForQuery);
                break;
            }
            case 2: {
                this.removeMemberFromQuery(memberToRemove, this.onPagesForQuery);
                break;
            }
            case -1: {
                this.removeMemberFromQuery(memberToRemove, this.onColumnsForQuery);
            }
        }
    }

    public void removePageMemberFromQuery(Member memberToRemove) {
        this.removeMemberFromQuery(memberToRemove, this.onPages);
        this.removeMemberFromQuery(memberToRemove, this.onPagesForQuery);
    }

    public void removeMemberFromQuery(Member memberToRemove, LinkedList linkList) {
        ListIterator it = linkList.listIterator();
        if (this.memberToSortBy != null && this.memberToSortBy == memberToRemove) {
            this.loseSort();
        }
        while (it.hasNext()) {
            QueryDimensionElement qde = (QueryDimensionElement)it.next();
            S.out("memberToRemove.getUniqueName() = " + memberToRemove.getUniqueName());
            S.out("qde.getHierarchyUniqueName()=" + qde.getHierarchyUniqueName());
            if (!memberToRemove.getUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            qde.removeMember(memberToRemove);
            if (qde.isValid()) break;
            it.previous();
            it.remove();
            break;
        }
        this.viewer.enableTreeElements(memberToRemove);
        this.checkRunQuery();
    }

    public void keepThisMemberOnlyOnRows(Member memberToKeep) {
        this.keepThisMemberOnly(memberToKeep, this.onRows);
        this.keepThisMemberOnly(memberToKeep, this.onRowsForQuery);
    }

    public void keepThisMemberOnlyOnColumns(Member memberToKeep) {
        this.keepThisMemberOnly(memberToKeep, this.onColumns);
        this.keepThisMemberOnly(memberToKeep, this.onColumnsForQuery);
    }

    public void keepThisMemberOnlyOnMeasures(Member memberToKeep) {
        this.keepThisMemberOnly(memberToKeep, this.onMeasures);
        switch (this.measureAxis) {
            case 0: {
                this.keepThisMemberOnly(memberToKeep, this.onColumnsForQuery);
                break;
            }
            case 1: {
                this.keepThisMemberOnly(memberToKeep, this.onRowsForQuery);
                break;
            }
            case 2: {
                this.keepThisMemberOnly(memberToKeep, this.onPagesForQuery);
                break;
            }
            case -1: {
                this.keepThisMemberOnly(memberToKeep, this.onColumnsForQuery);
            }
        }
    }

    public void keepThisMemberOnlyOnPages(Member memberToKeep) {
        this.keepThisMemberOnly(memberToKeep, this.onPages);
        this.keepThisMemberOnly(memberToKeep, this.onPagesForQuery);
    }

    public void keepThisMemberOnly(Member memberToKeep, LinkedList linkList) {
        ListIterator it = linkList.listIterator();
        if (this.memberToSortBy != null && this.memberToSortBy.getSortingExpression().equals(memberToKeep.getSortingExpression())) {
            this.loseSort();
        }
        while (it.hasNext()) {
            QueryDimensionElement qde = (QueryDimensionElement)it.next();
            if (!memberToKeep.getUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            qde.keepThisMemberOnly(memberToKeep);
            break;
        }
        this.checkRunQuery();
    }

    public void clearRowAxis() {
        this.enableAxisMembers(this.onRows);
        this.onRows.clear();
        this.onRowsForQuery.clear();
        this.checkRunQuery();
    }

    public void clearColumnAxis() {
        this.enableAxisMembers(this.onColumns);
        this.enableAxisMembers(this.onMeasures);
        this.onColumns.clear();
        this.onMeasures.clear();
        this.onColumnsForQuery.clear();
        this.checkRunQuery();
    }

    private void enableAxisMembers(LinkedList list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.viewer.enableTreeElements((QueryElement)it.next());
        }
    }

    public void sortByThisMember(Member _memberToSortBy, String _sortType) {
        this.memberToSortBy = _memberToSortBy;
        this.sortType = _sortType;
        this.checkRunQuery();
    }

    public void loseSort() {
        this.memberToSortBy = null;
    }

    public void addRowMemberToFilter(Member filterMember) {
        if (this.onRows.size() == 1 && this.viewer instanceof MdxResultViewer) {
            JOptionPane.showMessageDialog(null, I18n.getString("msgText.dimensionFilter"), I18n.getString("msgTitle.sendMember"), 1);
            return;
        }
        if (this.filters == null) {
            this.filters = new LinkedList();
        }
        this.filters.add(this.viewer.addMemberToFilter(filterMember));
        this.removeFilterRowDimensionFromQuery(filterMember);
    }

    public void addColumnMemberToFilter(Member filterMember) {
        if (this.onColumns.size() == 1 && this.viewer instanceof MdxResultViewer) {
            JOptionPane.showMessageDialog(null, I18n.getString("msgText.dimensionFilter"), I18n.getString("msgTitle.sendMember"), 1);
            return;
        }
        if (this.filters == null) {
            this.filters = new LinkedList();
        }
        this.filters.add(this.viewer.addMemberToFilter(filterMember));
        this.removeFilterColumnDimensionFromQuery(filterMember);
    }

    public void addPageMemberToFilter(Member filterMember) {
        if (this.filters == null) {
            this.filters = new LinkedList();
        }
        this.filters.add(this.viewer.addMemberToFilter(filterMember));
        this.removeFilterPageDimensionFromQuery(filterMember);
    }

    public void dropFilterFromQuery(FilterTree filterToDrop) {
        ListIterator it = this.filters.listIterator();
        while (it.hasNext()) {
            FilterTreeModel ftm = (FilterTreeModel)it.next();
            if (ftm != (FilterTreeModel)filterToDrop.getTree().getModel()) continue;
            it.previous();
            it.remove();
            this.viewer.dropFilterTree(filterToDrop);
            this.viewer.enableTreeElements(ftm.getAnyQueryElement());
            this.checkRunQuery();
            return;
        }
        S.out("assert: Query:dropFilterFromQuery:Couldn't find filter to drop!");
    }

    public void updateQueryWithResults(ExecuteResult er) {
        for (QueryDimensionElement qde : this.onRows) {
            if (!qde.isToggled()) continue;
            qde.updateWithResult(er.getAxis("Axis1"));
        }
        for (QueryDimensionElement qde : this.onColumns) {
            if (!qde.isToggled()) continue;
            qde.updateWithResult(er.getAxis("Axis0"));
        }
        if (this.onPages.size() > 0) {
            for (QueryDimensionElement qde : this.onPages) {
                if (!qde.isToggled()) continue;
                qde.updateWithResult(er.getAxis("Axis2"));
            }
        }
    }

    public String[] getMDXWith() {
        String[] mdxElement = null;
        if (this.canExecute() && this.filters != null && this.filters.size() > 0) {
            mdxElement = new String[this.filters.size()];
            int countWith = 0;
            ListIterator it = this.filters.listIterator();
            while (it.hasNext()) {
                mdxElement[countWith] = "" + ((FilterTreeModel)it.next()).getQueryWithMemberExpression();
                ++countWith;
            }
            return mdxElement;
        }
        return null;
    }

    public String[] getMDXColumnsOnSelect() {
        int counter;
        LinkedList list = null;
        String[] colElements = null;
        int colSize = 0;
        int colCounter = 0;
        for (counter = 0; counter < this.onColumnsForQuery.size(); ++counter) {
            list = ((QueryDimensionElement)this.onColumnsForQuery.get(counter)).getMember();
            colSize += list.size();
        }
        colElements = new String[colSize];
        for (counter = 0; counter < this.onColumnsForQuery.size(); ++counter) {
            list = ((QueryDimensionElement)this.onColumnsForQuery.get(counter)).getMember();
            for (int jj = 0; jj < list.size(); ++jj) {
                colElements[colCounter] = ((QueryElement)list.get(jj)).getQueryMembersExpression();
                ++colCounter;
            }
        }
        return colElements;
    }

    public String[] getMDXRowsOnSelect() {
        int counter;
        LinkedList list = null;
        String[] rowElements = null;
        int rowSize = 0;
        int rowCounter = 0;
        for (counter = 0; counter < this.onRowsForQuery.size(); ++counter) {
            list = ((QueryDimensionElement)this.onRowsForQuery.get(counter)).getMember();
            rowSize += list.size();
        }
        rowElements = new String[rowSize];
        for (counter = 0; counter < this.onRowsForQuery.size(); ++counter) {
            list = ((QueryDimensionElement)this.onRowsForQuery.get(counter)).getMember();
            for (int jj = 0; jj < list.size(); ++jj) {
                rowElements[rowCounter] = ((QueryElement)list.get(jj)).getQueryMembersExpression();
                ++rowCounter;
            }
        }
        return rowElements;
    }

    public String[] getMDXPagesOnSelect() {
        LinkedList list = null;
        String[] pageElements = null;
        int pageSize = 0;
        int pageCounter = 0;
        if (this.onPagesForQuery.size() > 0) {
            int counter;
            for (counter = 0; counter < this.onPagesForQuery.size(); ++counter) {
                list = ((QueryDimensionElement)this.onPagesForQuery.get(counter)).getMember();
                pageSize += list.size();
            }
            pageElements = new String[pageSize];
            for (counter = 0; counter < this.onPagesForQuery.size(); ++counter) {
                list = ((QueryDimensionElement)this.onPagesForQuery.get(counter)).getMember();
                for (int jj = 0; jj < list.size(); ++jj) {
                    pageElements[pageCounter] = ((QueryElement)list.get(jj)).getQueryMembersExpression();
                    ++pageCounter;
                }
            }
            return pageElements;
        }
        return null;
    }

    public String getMDXFrom() {
        return this.cubeName;
    }

    public String[] getMDXWhere() {
        String[] mdxElement = null;
        if (this.canExecute() && this.filters != null && this.filters.size() > 0) {
            ListIterator it = this.filters.listIterator();
            mdxElement = new String[this.filters.size()];
            int countWith = 0;
            while (it.hasNext()) {
                if (!it.hasPrevious()) {
                    mdxElement[countWith] = "" + ((FilterTreeModel)it.next()).getQueryWhereExpression();
                    continue;
                }
                mdxElement[countWith] = "," + ((FilterTreeModel)it.next()).getQueryWhereExpression();
            }
            return mdxElement;
        }
        return null;
    }

    public String[] getMDXRows() {
        int counter;
        LinkedList list = null;
        String[] rowElements = null;
        int rowSize = 0;
        int rowCounter = 0;
        for (counter = 0; counter < this.onRows.size(); ++counter) {
            list = ((QueryDimensionElement)this.onRows.get(counter)).getMember();
            rowSize += list.size();
        }
        rowElements = new String[rowSize];
        for (counter = 0; counter < this.onRows.size(); ++counter) {
            list = ((QueryDimensionElement)this.onRows.get(counter)).getMember();
            for (int jj = 0; jj < list.size(); ++jj) {
                rowElements[rowCounter] = ((QueryElement)list.get(jj)).getQueryMembersExpression();
                ++rowCounter;
            }
        }
        return rowElements;
    }

    public String[] getMDXColumns() {
        int counter;
        LinkedList list = null;
        String[] colElements = null;
        int colSize = 0;
        int colCounter = 0;
        for (counter = 0; counter < this.onColumns.size(); ++counter) {
            list = ((QueryDimensionElement)this.onColumns.get(counter)).getMember();
            colSize += list.size();
        }
        colElements = new String[colSize];
        for (counter = 0; counter < this.onColumns.size(); ++counter) {
            list = ((QueryDimensionElement)this.onColumns.get(counter)).getMember();
            for (int jj = 0; jj < list.size(); ++jj) {
                colElements[colCounter] = ((QueryElement)list.get(jj)).getQueryMembersExpression();
                ++colCounter;
            }
        }
        return colElements;
    }

    public String[] getMDXMeasures() {
        int counter;
        LinkedList list = null;
        String[] measureElements = null;
        int measureSize = 0;
        int measureCounter = 0;
        for (counter = 0; counter < this.onMeasures.size(); ++counter) {
            list = ((QueryDimensionElement)this.onMeasures.get(counter)).getMember();
            measureSize += list.size();
        }
        measureElements = new String[measureSize];
        for (counter = 0; counter < this.onMeasures.size(); ++counter) {
            list = ((QueryDimensionElement)this.onMeasures.get(counter)).getMember();
            for (int jj = 0; jj < list.size(); ++jj) {
                measureElements[measureCounter] = ((QueryElement)list.get(jj)).getQueryMembersExpression();
                ++measureCounter;
            }
        }
        return measureElements;
    }

    public String[] getSlicer() {
        int count = 0;
        String[] temp = null;
        if (this.onSlicer != null && this.onSlicer.size() > 0) {
            temp = new String[this.onSlicer.size()];
            ListIterator it = this.onSlicer.listIterator();
            while (it.hasNext()) {
                temp[count] = (String)it.next();
                ++count;
            }
        }
        return temp;
    }

    public String getQuery() {
        String mdx = "";
        if (this.onColumnsForQuery.size() * this.onRowsForQuery.size() > 0) {
            ListIterator it;
            if (this.filters != null && this.filters.size() > 0) {
                it = this.filters.listIterator();
                mdx = mdx + "WITH";
                while (it.hasNext()) {
                    mdx = mdx + "\n" + ((FilterTreeModel)it.next()).getQueryWithMemberExpression();
                }
                mdx = mdx + "\n";
            }
            mdx = mdx + "SELECT ";
            mdx = mdx + this.getColumnsEmptyStatus();
            if (this.memberToSortBy == null) {
                if (this.measureAxis == -1) {
                    mdx = mdx + "{\n      {" + this.getAxisQueryExpression(this.onColumns) + "}" + "\n}  ON COLUMNS, \n";
                    mdx = mdx + this.getRowsEmptyStatus();
                    mdx = mdx + "{\n" + this.getAxisQueryExpression(this.onRows) + "\n} ON ROWS";
                }
                if (this.measureAxis == 0) {
                    mdx = this.onColumns.size() > 0 ? mdx + "{\n      {" + this.getAxisQueryExpression(this.onColumns) + "}" + "\n    * {" + this.getAxisQueryExpression(this.onMeasures) + "}" + "\n}  ON COLUMNS, \n" : mdx + "{\n\n    {" + this.getAxisQueryExpression(this.onMeasures) + "}" + "\n}  ON COLUMNS, \n";
                    mdx = mdx + this.getRowsEmptyStatus();
                    mdx = mdx + "{\n" + this.getAxisQueryExpression(this.onRows) + "\n} ON ROWS";
                }
                if (this.measureAxis == 1) {
                    mdx = mdx + "{\n      {" + this.getAxisQueryExpression(this.onColumns) + "}" + "\n}  ON COLUMNS, \n";
                    mdx = mdx + this.getRowsEmptyStatus();
                    mdx = this.onRows.size() > 0 ? mdx + "{\n      {" + this.getAxisQueryExpression(this.onRows) + "}" + "\n    * {" + this.getAxisQueryExpression(this.onMeasures) + "}" + "\n} ON ROWS" : mdx + "{\n\n    {" + this.getAxisQueryExpression(this.onMeasures) + "}" + "\n} ON ROWS";
                }
            } else {
                int queryAxisSort = this.getMemberAxis(this.memberToSortBy);
                if (queryAxisSort == -1) {
                    JOptionPane.showMessageDialog(null, this.memberToSortBy.getUniqueName() + I18n.getString("str.notOnAxis"));
                    return null;
                }
                if (this.showOnMBT) {
                    this.fun.addChildrenLevel(this.queryLevels);
                    this.fun.setAxisEmpty(this.axisEmpty);
                    this.fun.setMemberToSort(this.memberToSortBy);
                    this.fun.setSortType(this.sortType);
                    this.fun.removeNode();
                    this.fun.setColumnsMember(this.getMDXColumnsOnSelect());
                    this.fun.setColumnsMemberWOM(this.getMDXColumns());
                    this.fun.setRowsMember(this.getMDXRowsOnSelect());
                    this.fun.setRowsMemberWOM(this.getMDXRows());
                    this.fun.setMeasures(this.getMDXMeasures());
                    this.fun.setSlicer(this.getSlicer());
                }
                if (queryAxisSort == 0) {
                    if (this.measureAxis == -1) {
                        mdx = mdx + "{\n      {" + this.getAxisQueryExpression(this.onColumns) + "}" + "\n}  ON COLUMNS, \n";
                        mdx = mdx + this.getRowsEmptyStatus();
                        mdx = mdx + "{\n   Order( {\n" + this.getAxisQueryExpression(this.onRows) + "\n       }" + "\n   , " + this.memberToSortBy.getUniqueName() + "\n   , " + this.sortType + ")" + "\n} ON ROWS";
                        if (this.showOnMBT) {
                            this.fun.generateOrderCombination1();
                        }
                    }
                    if (this.measureAxis == 0) {
                        if (this.onColumns.size() > 0) {
                            mdx = mdx + "{\n      {" + this.getAxisQueryExpression(this.onColumns) + "}" + "\n    * {" + this.getAxisQueryExpression(this.onMeasures) + "}" + "\n}  ON COLUMNS, \n";
                            if (this.showOnMBT) {
                                this.fun.generateOrderCombination2();
                            }
                        } else {
                            mdx = mdx + "{\n\n    {" + this.getAxisQueryExpression(this.onMeasures) + "}" + "\n}  ON COLUMNS, \n";
                            if (this.showOnMBT) {
                                this.fun.generateOrderCombination3();
                            }
                        }
                        mdx = mdx + this.getRowsEmptyStatus();
                        mdx = mdx + "{\n   Order( {\n" + this.getAxisQueryExpression(this.onRows) + "\n       }" + "\n   , " + this.memberToSortBy.getUniqueName() + "\n   , " + this.sortType + ")" + "\n} ON ROWS";
                    }
                    if (this.measureAxis == 1) {
                        mdx = mdx + "{\n      {" + this.getAxisQueryExpression(this.onColumns) + "}" + "\n}  ON COLUMNS, \n";
                        mdx = mdx + this.getRowsEmptyStatus();
                        if (this.onRows.size() > 0) {
                            mdx = mdx + "{\n   Order( {\n" + this.getAxisQueryExpression(this.onRows) + "\n    * {" + this.getAxisQueryExpression(this.onMeasures) + "}" + "\n       }" + "\n   , " + this.memberToSortBy.getUniqueName() + "\n   , " + this.sortType + ")" + "\n} ON ROWS";
                            if (this.showOnMBT) {
                                this.fun.generateOrderCombination4();
                            }
                        } else {
                            mdx = mdx + "{\n   Order( {\n\n    {" + this.getAxisQueryExpression(this.onMeasures) + "}" + "\n       }" + "\n   , " + this.memberToSortBy.getUniqueName() + "\n   , " + this.sortType + ")" + "\n} ON ROWS";
                            if (this.showOnMBT) {
                                this.fun.generateOrderCombination5();
                            }
                        }
                    }
                }
                if (queryAxisSort == 1) {
                    if (this.measureAxis == -1) {
                        mdx = mdx + "{\n   Order( {\n" + this.getAxisQueryExpression(this.onColumns) + "\n       }" + "\n   , " + this.memberToSortBy.getUniqueName() + "\n   , " + this.sortType + ")" + "\n} ON COLUMNS,";
                        mdx = mdx + this.getRowsEmptyStatus();
                        mdx = mdx + "{\n      {" + this.getAxisQueryExpression(this.onRows) + "}" + "\n}  ON ROWS \n";
                        if (this.showOnMBT) {
                            this.fun.generateOrderCombination6();
                        }
                    }
                    if (this.measureAxis == 0) {
                        if (this.onColumns.size() > 0) {
                            mdx = mdx + "{\n   Order( {\n" + this.getAxisQueryExpression(this.onColumns) + "\n    * {" + this.getAxisQueryExpression(this.onMeasures) + "}" + "\n       }" + "\n   , " + this.memberToSortBy.getUniqueName() + "\n   , " + this.sortType + ")" + "\n} ON COLUMNS,";
                            if (this.showOnMBT) {
                                this.fun.generateOrderCombination7();
                            }
                        } else {
                            mdx = mdx + "{\n   Order( {\n\n     {" + this.getAxisQueryExpression(this.onMeasures) + "}" + "\n       }" + "\n   , " + this.memberToSortBy.getUniqueName() + "\n   , " + this.sortType + ")" + "\n} ON COLUMNS,";
                            if (this.showOnMBT) {
                                this.fun.generateOrderCombination8();
                            }
                        }
                        mdx = mdx + this.getRowsEmptyStatus();
                        mdx = mdx + "{\n      {" + this.getAxisQueryExpression(this.onRows) + "}" + "\n}  ON ROWS \n";
                    }
                    if (this.measureAxis == 1) {
                        mdx = mdx + "{\n   Order( {\n" + this.getAxisQueryExpression(this.onColumns) + "\n       }" + "\n   , " + this.memberToSortBy.getUniqueName() + "\n   , " + this.sortType + ")" + "\n} ON COLUMNS,";
                        mdx = mdx + this.getRowsEmptyStatus();
                        if (this.onRows.size() > 0) {
                            mdx = mdx + "{\n      {" + this.getAxisQueryExpression(this.onRows) + "}" + "\n    * {" + this.getAxisQueryExpression(this.onMeasures) + "}" + "\n}  ON ROWS \n";
                            if (this.showOnMBT) {
                                this.fun.generateOrderCombination9();
                            }
                        } else {
                            mdx = mdx + "{\n\n    {" + this.getAxisQueryExpression(this.onMeasures) + "}" + "\n}  ON ROWS \n";
                            if (this.showOnMBT) {
                                this.fun.generateOrderCombination10();
                            }
                        }
                    }
                }
            }
            if (this.onPages.size() > 0) {
                mdx = mdx + ",";
                mdx = mdx + "\nNON EMPTY\n";
                mdx = mdx + "   {\n" + this.getAxisQueryExpression(this.onPages) + "\n   } ON PAGES";
            }
            mdx = mdx + "\nFROM [" + this.cubeName + "]";
            if (this.filters != null && this.filters.size() > 0) {
                it = this.filters.listIterator();
                mdx = mdx + "\nWHERE\n   (";
                while (it.hasNext()) {
                    if (!it.hasPrevious()) {
                        mdx = mdx + "\n    " + ((FilterTreeModel)it.next()).getQueryWhereExpression();
                        continue;
                    }
                    mdx = mdx + "\n    , " + ((FilterTreeModel)it.next()).getQueryWhereExpression();
                }
                mdx = mdx + "\n    )\n";
            } else if (this.onSlicer != null && this.onSlicer.size() > 0) {
                it = this.onSlicer.listIterator();
                mdx = mdx + "\nWHERE\n   (";
                while (it.hasNext()) {
                    if (!it.hasPrevious()) {
                        mdx = mdx + "\n    " + (String)it.next();
                        continue;
                    }
                    mdx = mdx + "\n    ," + (String)it.next();
                }
                mdx = mdx + "\n    )\n";
            }
            S.out("GENERATED QUERY:\n---------------------------\n\n" + mdx + "\n\n------------------------------");
            this.lastQueryGenerated = mdx;
            this.memberToSortBy = null;
            return mdx;
        }
        this.memberToSortBy = null;
        return null;
    }

    public void setQueryForWhere(String query) {
        this.axisEmpty = new AxisEmpty(query);
        if (query != null && query.length() > 0 && query.indexOf("WHERE") != -1) {
            query = query.substring(query.indexOf("WHERE"), query.length());
            for (int i = 0; i < this.slicerAxis.getTupleCount(); ++i) {
                for (int j = 0; j < this.slicerAxis.getTupleAt(i).getMemberCount(); ++j) {
                    if (query.indexOf(this.slicerAxis.getTupleAt(i).getMemberAt(j).getUniqueName()) == -1) continue;
                    this.onSlicer.addLast(this.slicerAxis.getTupleAt(i).getMemberAt(j).getUniqueName());
                }
            }
        }
    }

    public void updateMBTree(boolean bool) {
        this.showOnMBT = bool;
    }

    private String getColumnsEmptyStatus() {
        if (this.axisEmpty != null) {
            return this.axisEmpty.isColumnEmpty() ? "\n\n" : "\nNON EMPTY\n";
        }
        return "\nNON EMPTY\n";
    }

    private String getRowsEmptyStatus() {
        if (this.axisEmpty != null) {
            return this.axisEmpty.isRowEmpty() ? "\n\n" : "\nNON EMPTY\n";
        }
        return "\nNON EMPTY\n";
    }

    private int getMemberAxis(Member member) {
        for (QueryDimensionElement qde : this.onColumnsForQuery) {
            if (!qde.getHierarchyUniqueName().startsWith(member.getHierarchyUniqueName()) && !member.getHierarchyUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            return 0;
        }
        for (QueryDimensionElement qde : this.onRowsForQuery) {
            if (!qde.getHierarchyUniqueName().startsWith(member.getHierarchyUniqueName()) && !member.getHierarchyUniqueName().startsWith(qde.getHierarchyUniqueName())) continue;
            return 1;
        }
        return -1;
    }

    public String toString() {
        return this.getQuery();
    }

    public String getLastQueryGenerated() {
        return this.lastQueryGenerated;
    }
}

