/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.TonicUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class ProgressBarUI
extends BasicProgressBarUI {
    private static final Dimension PREFERRED_INNER_HORIZONTAL = new Dimension(146, 12);
    private static final Dimension PREFERRED_INNER_VERTICAL = new Dimension(12, 146);
    private static boolean ADJUSTTIMER = true;
    private static boolean DEBUGALL = false;
    private static boolean DEBUGTIMER = false;
    private static boolean BASICDEBUG = false;
    private static boolean LOGSTATS = false;
    private int cachedPercent;
    private int cellLength;
    private int cellSpacing;
    private Color selectionForeground;
    private Color selectionBackground;
    private boolean isIndeterminate = false;
    private Animator animator;
    private PropertyChangeListener propertyListener;
    protected JProgressBar progressBar;
    protected ChangeListener changeListener;
    private int animationIndex = 0;
    private int numFrames;
    private int repaintInterval;
    private int cycleTime;
    private long startTime = 0L;
    private long lastLoopTime = 0L;
    private int numLoops = 0;
    private Rectangle boxRect;
    private Rectangle nextPaintRect;
    private Rectangle componentInnards;
    private Rectangle oldComponentInnards;
    private double delta = 0.0;
    private int maxPosition = 0;

    public static ComponentUI createUI(JComponent component) {
        return new ProgressBarUI();
    }

    public void installUI(JComponent c) {
        this.progressBar = (JProgressBar)c;
        this.installDefaults();
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.stopAnimationTimer();
        this.progressBar = null;
    }

    protected void installDefaults() {
        this.progressBar.setOpaque(true);
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        this.cellLength = UIManager.getInt("ProgressBar.cellLength");
        this.cellSpacing = UIManager.getInt("ProgressBar.cellSpacing");
        this.selectionForeground = UIManager.getColor("ProgressBar.selectionForeground");
        this.selectionBackground = UIManager.getColor("ProgressBar.selectionBackground");
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.progressBar);
    }

    protected void installListeners() {
        this.changeListener = new ChangeHandler();
        this.progressBar.addChangeListener(this.changeListener);
        this.propertyListener = new PropertyChangeHandler();
        this.progressBar.addPropertyChangeListener(this.propertyListener);
    }

    protected void startAnimationTimer() {
        if (this.animator == null) {
            this.animator = new Animator();
        }
        this.animator.start(this.getRepaintInterval());
    }

    protected void stopAnimationTimer() {
        if (this.animator != null) {
            this.animator.stop();
        }
    }

    protected void uninstallListeners() {
        this.progressBar.removeChangeListener(this.changeListener);
        this.progressBar.removePropertyChangeListener(this.propertyListener);
    }

    protected Dimension getPreferredInnerHorizontal() {
        return PREFERRED_INNER_HORIZONTAL;
    }

    protected Dimension getPreferredInnerVertical() {
        return PREFERRED_INNER_VERTICAL;
    }

    protected Color getSelectionForeground() {
        return this.selectionForeground;
    }

    protected Color getSelectionBackground() {
        return this.selectionBackground;
    }

    private int getCachedPercent() {
        return this.cachedPercent;
    }

    private void setCachedPercent(int cachedPercent) {
        this.cachedPercent = cachedPercent;
    }

    protected int getCellLength() {
        if (this.progressBar.isStringPainted()) {
            return 1;
        }
        return this.cellLength;
    }

    protected void setCellLength(int cellLen) {
        this.cellLength = cellLen;
    }

    protected int getCellSpacing() {
        if (this.progressBar.isStringPainted()) {
            return 0;
        }
        return this.cellSpacing;
    }

    protected void setCellSpacing(int cellSpace) {
        this.cellSpacing = cellSpace;
    }

    protected int getAmountFull(Insets b, int width, int height) {
        int amountFull = 0;
        BoundedRangeModel model = this.progressBar.getModel();
        if (model.getMaximum() - model.getMinimum() != 0) {
            amountFull = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)width * this.progressBar.getPercentComplete()) : (int)Math.round((double)height * this.progressBar.getPercentComplete());
        }
        return amountFull;
    }

    public void paint(Graphics g, JComponent c) {
        if (this.isIndeterminate) {
            this.paintIndeterminate(g, c);
        } else {
            this.paintDeterminate(g, c);
        }
    }

    protected Rectangle getBox(Rectangle r) {
        int currentFrame = this.getAnimationIndex();
        int middleFrame = this.numFrames / 2;
        if (DEBUGALL) {
            System.out.println("----begin getBox----");
            System.out.println("    getBox argument: " + r);
            System.out.println("    currentFrame = " + currentFrame);
            System.out.println("    middleFrame = " + middleFrame);
        }
        if (this.sizeChanged() || this.delta == 0.0 || (double)this.maxPosition == 0.0) {
            this.updateSizes();
        }
        if ((r = this.getGenericBox(r)) == null) {
            if (DEBUGALL) {
                System.out.println("    Exiting because r is null");
            }
            return null;
        }
        if (middleFrame <= 0) {
            if (DEBUGALL) {
                System.out.println("    Exiting because middleFrame <= 0.");
            }
            return null;
        }
        if (this.progressBar.getOrientation() == 0) {
            r.x = currentFrame < middleFrame ? this.componentInnards.x + (int)Math.round(this.delta * (double)currentFrame) : this.maxPosition - (int)Math.round(this.delta * (double)(currentFrame - middleFrame));
        } else {
            r.y = currentFrame < middleFrame ? this.componentInnards.y + (int)Math.round(this.delta * (double)currentFrame) : this.maxPosition - (int)Math.round(this.delta * (double)(currentFrame - middleFrame));
        }
        if (DEBUGALL) {
            System.out.println("    getBox return value: " + r);
            System.out.println("----end getBox----");
        }
        return r;
    }

    private void updateSizes() {
        if (DEBUGALL) {
            System.out.println("----begin updateSizes----");
        }
        int length = 0;
        if (this.progressBar.getOrientation() == 0) {
            length = this.getBoxLength(this.componentInnards.width, this.componentInnards.height);
            this.maxPosition = this.componentInnards.x + this.componentInnards.width - length;
        } else {
            length = this.getBoxLength(this.componentInnards.height, this.componentInnards.width);
            this.maxPosition = this.componentInnards.y + this.componentInnards.height - length;
        }
        if (DEBUGALL) {
            System.out.println("    Updating delta.");
        }
        this.delta = 2.0 * (double)this.maxPosition / (double)this.numFrames;
        if (BASICDEBUG) {
            System.out.println("    delta: " + this.delta);
            System.out.println("    maxPosition: " + this.maxPosition);
        }
        if (DEBUGALL) {
            System.out.println("----end updateSizes----");
        }
    }

    private Rectangle getGenericBox(Rectangle r) {
        if (DEBUGALL) {
            System.out.println("----begin getGenericBox----");
            System.out.println("    argument: " + r);
        }
        if (r == null) {
            r = new Rectangle();
        }
        if (this.progressBar.getOrientation() == 0) {
            r.width = this.getBoxLength(this.componentInnards.width, this.componentInnards.height);
            if (r.width < 0) {
                r = null;
            } else {
                r.height = this.componentInnards.height;
                r.y = this.componentInnards.y;
            }
        } else {
            r.height = this.getBoxLength(this.componentInnards.height, this.componentInnards.width);
            if (r.height < 0) {
                r = null;
            } else {
                r.width = this.componentInnards.width;
                r.x = this.componentInnards.x;
            }
        }
        if (DEBUGALL) {
            System.out.println("    getGenericBox returns: " + r);
            System.out.println("----end getGenericBox----");
        }
        return r;
    }

    private int getBoxLength(int availableLength, int otherDimension) {
        return (int)Math.round((double)availableLength / 6.0);
    }

    protected void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Graphics2D g2 = (Graphics2D)g;
        if (DEBUGALL) {
            System.out.println();
            System.out.println("basic: paintIndeterminate");
        }
        this.boxRect = this.getBox(this.boxRect);
        if (this.boxRect != null) {
            g2.setColor(this.progressBar.getForeground());
            g2.fillRect(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height);
        } else if (DEBUGALL) {
            System.out.println("boxRect == null; returning");
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g2, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.x, this.boxRect.width, b);
            } else {
                this.paintString(g2, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.y, this.boxRect.height, b);
            }
        }
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int cellLength = this.getCellLength();
        int cellSpacing = this.getCellSpacing();
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.progressBar.getForeground());
        if (this.progressBar.getOrientation() == 0) {
            if (cellSpacing == 0 && amountFull > 0) {
                g2.setStroke(new BasicStroke(barRectHeight, 0, 2));
            } else {
                g2.setStroke(new BasicStroke(barRectHeight, 0, 2, 0.0f, new float[]{cellLength, cellSpacing}, 0.0f));
            }
            if (TonicUtils.isLeftToRight(c)) {
                g2.drawLine(b.left, barRectHeight / 2 + b.top, amountFull + b.left, barRectHeight / 2 + b.top);
            } else {
                g2.drawLine(barRectWidth + b.left, barRectHeight / 2 + b.top, barRectWidth + b.left - amountFull, barRectHeight / 2 + b.top);
            }
        } else {
            if (cellSpacing == 0 && amountFull > 0) {
                g2.setStroke(new BasicStroke(barRectWidth, 0, 2));
            } else {
                g2.setStroke(new BasicStroke(barRectWidth, 0, 2, 0.0f, new float[]{cellLength, cellSpacing}, 0.0f));
            }
            g2.drawLine(barRectWidth / 2 + b.left, b.top + barRectHeight, barRectWidth / 2 + b.left, b.top + barRectHeight - amountFull);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    protected void paintString(Graphics g, int x, int y, int width, int height, int amountFull, Insets b) {
        if (this.progressBar.getOrientation() == 0) {
            if (TonicUtils.isLeftToRight(this.progressBar)) {
                this.paintString(g, x, y, width, height, x, amountFull, b);
            } else {
                this.paintString(g, x, y, width, height, x + width - amountFull, amountFull, b);
            }
        } else {
            this.paintString(g, x, y, width, height, y + height - amountFull, amountFull, b);
        }
    }

    private void paintString(Graphics g, int x, int y, int width, int height, int fillStart, int amountFull, Insets b) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.progressBar.getString();
        g2.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
        Rectangle oldClip = g2.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g2.setColor(this.getSelectionBackground());
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(fillStart, y, amountFull, height);
            g.drawString(progressString, renderLocation.x, renderLocation.y);
        } else {
            g2.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g2.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(x, fillStart, width, amountFull);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
        }
        g2.setClip(oldClip);
    }

    protected Point getStringPlacement(Graphics g, String progressString, int x, int y, int width, int height) {
        FontMetrics fontSizer = this.progressBar.getFontMetrics(this.progressBar.getFont());
        int stringWidth = fontSizer.stringWidth(progressString);
        if (this.progressBar.getOrientation() == 0) {
            return new Point(x + Math.round(width / 2 - stringWidth / 2), y + (height + fontSizer.getAscent() - fontSizer.getLeading() - fontSizer.getDescent()) / 2);
        }
        return new Point(x + (width - fontSizer.getAscent() + fontSizer.getLeading() + fontSizer.getDescent()) / 2, y + Math.round(height / 2 - stringWidth / 2));
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension size;
        Insets border = this.progressBar.getInsets();
        FontMetrics fontSizer = this.progressBar.getFontMetrics(this.progressBar.getFont());
        if (this.progressBar.getOrientation() == 0) {
            size = new Dimension(this.getPreferredInnerHorizontal());
            if (this.progressBar.isStringPainted()) {
                int stringHeight;
                String progString = this.progressBar.getString();
                int stringWidth = fontSizer.stringWidth(progString);
                if (stringWidth > size.width) {
                    size.width = stringWidth;
                }
                if ((stringHeight = fontSizer.getHeight() + fontSizer.getDescent()) > size.height) {
                    size.height = stringHeight;
                }
            }
        } else {
            size = new Dimension(this.getPreferredInnerVertical());
            if (this.progressBar.isStringPainted()) {
                int stringWidth;
                String progString = this.progressBar.getString();
                int stringHeight = fontSizer.getHeight() + fontSizer.getDescent();
                if (stringHeight > size.width) {
                    size.width = stringHeight;
                }
                if ((stringWidth = fontSizer.stringWidth(progString)) > size.height) {
                    size.height = stringWidth;
                }
            }
        }
        size.width += border.left + border.right;
        size.height += border.top + border.bottom;
        return size;
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension pref = this.getPreferredSize(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            pref.width = 10;
        } else {
            pref.height = 10;
        }
        return pref;
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension pref = this.getPreferredSize(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            pref.width = Short.MAX_VALUE;
        } else {
            pref.height = Short.MAX_VALUE;
        }
        return pref;
    }

    protected int getAnimationIndex() {
        return this.animationIndex;
    }

    protected void setAnimationIndex(int newValue) {
        if (DEBUGALL) {
            System.out.println("----begin setAnimationIndex----");
            System.out.println("    argument = " + newValue);
        }
        if (this.animationIndex != newValue) {
            if (DEBUGALL) {
                System.out.println("    Changing animation index from " + this.animationIndex + " to " + newValue);
            }
            if (this.sizeChanged()) {
                if (DEBUGALL) {
                    System.out.println("    size changed; resetting maxPosition, delta");
                }
                this.animationIndex = newValue;
                this.maxPosition = 0;
                this.delta = 0.0;
                this.progressBar.repaint();
                return;
            }
            this.nextPaintRect = this.getBox(this.nextPaintRect);
            if (DEBUGALL) {
                System.out.println("    previous paint rect =  " + this.nextPaintRect);
                System.out.println("    before setting, boxRect =  " + this.boxRect);
            }
            this.animationIndex = newValue;
            if (this.nextPaintRect != null) {
                this.boxRect = this.getBox(this.boxRect);
                if (this.boxRect != null) {
                    this.nextPaintRect.add(this.boxRect);
                }
            }
            if (DEBUGALL) {
                System.out.println("    after setting, boxRect =  " + this.boxRect);
                System.out.println("    after setting, nextPaintRect =  " + this.nextPaintRect);
            }
        } else {
            if (DEBUGALL) {
                System.out.println("    No change in value");
                System.out.println("----end setAnimationIndex----");
            }
            return;
        }
        if (this.nextPaintRect != null) {
            this.progressBar.repaint(this.nextPaintRect);
        } else {
            this.progressBar.repaint();
            if (DEBUGALL) {
                System.out.println("    repaint without args");
            }
        }
        if (DEBUGALL) {
            System.out.println("----end setAnimationIndex----");
        }
    }

    private boolean sizeChanged() {
        if (this.oldComponentInnards == null || this.componentInnards == null) {
            return true;
        }
        this.oldComponentInnards.setRect(this.componentInnards);
        this.componentInnards = SwingUtilities.calculateInnerArea(this.progressBar, this.componentInnards);
        return !this.oldComponentInnards.equals(this.componentInnards);
    }

    protected void incrementAnimationIndex() {
        int newValue = this.getAnimationIndex() + 1;
        if (DEBUGALL) {
            System.out.println();
            System.out.println("----begin incrementAnimationIndex----");
            System.out.println("    newValue = " + newValue);
            System.out.println("    numFrames = " + this.numFrames);
        }
        if (newValue < this.numFrames) {
            this.setAnimationIndex(newValue);
        } else {
            this.setAnimationIndex(0);
            if (LOGSTATS) {
                ++this.numLoops;
                long time = System.currentTimeMillis();
                System.out.println("Loop #" + this.numLoops + ": " + (time - this.lastLoopTime) + " (" + (time - this.startTime) + " total)");
                this.lastLoopTime = time;
            }
        }
        if (DEBUGALL) {
            System.out.println("----end incrementAnimationIndex----");
        }
    }

    private int getRepaintInterval() {
        return this.repaintInterval;
    }

    private int initRepaintInterval() {
        this.repaintInterval = UIManager.getInt("ProgressBar.repaintInterval");
        if (BASICDEBUG) {
            System.out.println("    value of ProgressBar.repaintInterval is " + this.repaintInterval);
        }
        return this.repaintInterval;
    }

    private int getCycleTime() {
        return this.cycleTime;
    }

    private int initCycleTime() {
        this.cycleTime = UIManager.getInt("ProgressBar.cycleTime");
        if (BASICDEBUG) {
            System.out.println("    value of ProgressBar.cycleTime is " + this.cycleTime);
        }
        return this.cycleTime;
    }

    private void initIndeterminateDefaults() {
        if (DEBUGALL) {
            System.out.println("----begin initIndeterminateDefaults----");
        }
        this.initRepaintInterval();
        this.initCycleTime();
        if (this.repaintInterval <= 0) {
            this.repaintInterval = 100;
        }
        if (this.repaintInterval > this.cycleTime) {
            this.cycleTime = this.repaintInterval * 20;
            if (DEBUGALL) {
                System.out.println("cycleTime changed to " + this.cycleTime);
            }
        } else {
            int newCycleTime;
            int factor = (int)Math.ceil((double)this.cycleTime / ((double)this.repaintInterval * 2.0));
            if (DEBUGALL && this.cycleTime != (newCycleTime = this.repaintInterval * factor * 2)) {
                System.out.println("cycleTime being changed to " + newCycleTime);
            }
            this.cycleTime = this.repaintInterval * factor * 2;
        }
        if (BASICDEBUG) {
            System.out.println("    cycle length: " + this.cycleTime);
            System.out.println("    repaint interval: " + this.repaintInterval);
        }
        if (DEBUGALL) {
            System.out.println("----end initIndeterminateDefaults----");
        }
    }

    private void initIndeterminateValues() {
        if (DEBUGALL) {
            System.out.println();
            System.out.println("----begin initIndeterminateValues----");
        }
        if (LOGSTATS) {
            this.startTime = this.lastLoopTime = System.currentTimeMillis();
            this.numLoops = 0;
        }
        if (BASICDEBUG) {
            System.out.println("ADJUSTTIMER = " + ADJUSTTIMER);
        }
        this.initIndeterminateDefaults();
        this.numFrames = this.cycleTime / this.repaintInterval;
        this.initAnimationIndex();
        this.boxRect = new Rectangle();
        this.nextPaintRect = new Rectangle();
        this.componentInnards = new Rectangle();
        this.oldComponentInnards = new Rectangle();
        if (BASICDEBUG) {
            System.out.println("    numFrames: " + this.numFrames);
        }
        if (DEBUGALL) {
            System.out.println("----end initIndeterminateValues----");
        }
    }

    private void cleanUpIndeterminateValues() {
        if (DEBUGALL) {
            System.out.println();
            System.out.println("----begin cleanUpIndeterminateValues----");
        }
        this.repaintInterval = 0;
        this.cycleTime = 0;
        this.animationIndex = 0;
        this.numFrames = 0;
        this.maxPosition = 0;
        this.delta = 0.0;
        this.nextPaintRect = null;
        this.boxRect = null;
        this.oldComponentInnards = null;
        this.componentInnards = null;
        if (LOGSTATS) {
            this.numLoops = 0;
            this.startTime = this.lastLoopTime = (long)0;
        }
        if (DEBUGALL) {
            System.out.println("----end cleanUpIndeterminateValues----");
        }
    }

    private void initAnimationIndex() {
        if (this.progressBar.getOrientation() == 0 && TonicUtils.isLeftToRight(this.progressBar)) {
            this.setAnimationIndex(0);
        } else {
            this.setAnimationIndex(this.numFrames / 2);
        }
    }

    private class Animator
    implements ActionListener {
        private Timer timer;
        private long previousDelay;
        private int interval;
        private long lastCall;
        private int MINIMUM_DELAY = 5;

        Animator() {
        }

        private void start(int interval) {
            this.previousDelay = interval;
            this.lastCall = 0L;
            if (this.timer == null) {
                this.timer = new Timer(interval, this);
            } else {
                this.timer.setDelay(interval);
            }
            if (ADJUSTTIMER) {
                this.timer.setRepeats(false);
                this.timer.setCoalesce(false);
            }
            this.timer.start();
        }

        private void stop() {
            this.timer.stop();
        }

        public void actionPerformed(ActionEvent e) {
            if (ADJUSTTIMER) {
                long time = System.currentTimeMillis();
                if (this.lastCall > 0L) {
                    int nextDelay = (int)(this.previousDelay - time + this.lastCall + (long)ProgressBarUI.this.getRepaintInterval());
                    if (nextDelay < this.MINIMUM_DELAY) {
                        nextDelay = this.MINIMUM_DELAY;
                    }
                    this.timer.setInitialDelay(nextDelay);
                    this.previousDelay = nextDelay;
                    if (DEBUGTIMER) {
                        System.out.println("---------------------");
                        System.out.println("actual delay = " + (time - this.lastCall));
                        System.out.println("next delay = " + nextDelay);
                    }
                }
                this.timer.start();
                this.lastCall = time;
            }
            ProgressBarUI.this.incrementAnimationIndex();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if ("indeterminate".equals(prop)) {
                ProgressBarUI.this.isIndeterminate = ProgressBarUI.this.progressBar.isIndeterminate();
                if (ProgressBarUI.this.isIndeterminate) {
                    ProgressBarUI.this.initIndeterminateValues();
                    ProgressBarUI.this.startAnimationTimer();
                } else {
                    ProgressBarUI.this.stopAnimationTimer();
                    ProgressBarUI.this.cleanUpIndeterminateValues();
                }
                ProgressBarUI.this.progressBar.repaint();
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            int oldPercent;
            BoundedRangeModel model = ProgressBarUI.this.progressBar.getModel();
            int newRange = model.getMaximum() - model.getMinimum();
            int newPercent = newRange > 0 ? (int)(100L * (long)model.getValue() / (long)newRange) : 0;
            if (newPercent != (oldPercent = ProgressBarUI.this.getCachedPercent())) {
                ProgressBarUI.this.setCachedPercent(newPercent);
                ProgressBarUI.this.progressBar.repaint();
            }
        }
    }
}

