/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.chart.MeterInterval;
import it.businesslogic.ireport.gui.sheet.MeterIntervalDialog;
import it.businesslogic.ireport.gui.sheet.MeterIntervalTableCellRenderer;
import it.businesslogic.ireport.gui.sheet.SeriesColorsDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;

public class MeterIntervalsDialog
extends JDialog {
    private int dialogResult = 2;
    private List meterIntervals = null;
    public static List clipboard = new ArrayList();
    public static List lastIntervals = new ArrayList();
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonCopyInterval;
    private JButton jButtonDelete;
    private JButton jButtonModify;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonOk;
    private JButton jButtonPasteInterval;
    private JButton jButtonUseLast;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTable1;
    static /* synthetic */ Class class$java$lang$String;

    public MeterIntervalsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public MeterIntervalsDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.applyI18n();
        this.jButtonPasteInterval.setEnabled(clipboard.size() > 0);
        this.jButtonUseLast.setEnabled(lastIntervals.size() > 0);
        ((DefaultTableColumnModel)this.jTable1.getColumnModel()).getColumn(0).setCellRenderer(new MeterIntervalTableCellRenderer());
        ((DefaultTableColumnModel)this.jTable1.getColumnModel()).getColumn(1).setPreferredWidth(50);
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        dtcr.setHorizontalAlignment(0);
        ((DefaultTableColumnModel)this.jTable1.getColumnModel()).getColumn(1).setCellRenderer(dtcr);
        this.pack();
        Misc.centerFrame(this);
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                MeterIntervalsDialog.this.jTable1ValueChanged(e);
            }
        });
    }

    private void jTable1ValueChanged(ListSelectionEvent evt) {
        if (this.jTable1.getSelectedRowCount() > 0) {
            this.jButtonDelete.setEnabled(true);
            this.jButtonModify.setEnabled(true);
            this.jButtonMoveUp.setEnabled(this.jTable1.getSelectedRow() > 0);
            this.jButtonMoveDown.setEnabled(this.jTable1.getSelectedRow() < this.jTable1.getRowCount() - 1);
        } else {
            this.jButtonModify.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
            this.jButtonMoveUp.setEnabled(false);
            this.jButtonMoveDown.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel2 = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jButtonCopyInterval = new JButton();
        this.jButtonPasteInterval = new JButton();
        this.jButtonUseLast = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Label", "Alpha", "Low exp", "High exp"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MeterIntervalsDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MeterIntervalsDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MeterIntervalsDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MeterIntervalsDialog.class$("java.lang.String")) : class$java$lang$String};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MeterIntervalsDialog.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(150, 150));
        this.jPanel2.setPreferredSize(new Dimension(100, 283));
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalsDialog.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonModify.setText("Modify");
        this.jButtonModify.setEnabled(false);
        this.jButtonModify.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalsDialog.this.jButtonModifyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonModify, gridBagConstraints);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setEnabled(false);
        this.jButtonDelete.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalsDialog.this.jButtonDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonDelete, gridBagConstraints);
        this.jButtonMoveUp.setText("Move up");
        this.jButtonMoveUp.setEnabled(false);
        this.jButtonMoveUp.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalsDialog.this.jButtonMoveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonMoveUp, gridBagConstraints);
        this.jButtonMoveDown.setText("Move down");
        this.jButtonMoveDown.setEnabled(false);
        this.jButtonMoveDown.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalsDialog.this.jButtonMoveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 14, 4);
        this.jPanel2.add((Component)this.jButtonMoveDown, gridBagConstraints);
        this.jButtonCopyInterval.setText("Copy intervals");
        this.jButtonCopyInterval.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonCopyInterval.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalsDialog.this.jButtonCopyIntervalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonCopyInterval, gridBagConstraints);
        this.jButtonPasteInterval.setText("Paste intervals");
        this.jButtonPasteInterval.setEnabled(false);
        this.jButtonPasteInterval.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonPasteInterval.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalsDialog.this.jButtonPasteIntervalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonPasteInterval, gridBagConstraints);
        this.jButtonUseLast.setText("Use last");
        this.jButtonUseLast.setEnabled(false);
        this.jButtonUseLast.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonUseLast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalsDialog.this.jButtonPasteIntervalActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonUseLast, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(0, 2));
        this.jSeparator1.setPreferredSize(new Dimension(3, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setPreferredSize(new Dimension(320, 23));
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalsDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalsDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButtonCancel, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.jButtonModifyActionPerformed(null);
        }
    }

    private void jButtonPasteIntervalActionPerformed1(ActionEvent evt) {
        if (lastIntervals.size() > 0) {
            for (int i = 0; i < lastIntervals.size(); ++i) {
                this.addRowValues(((MeterInterval)lastIntervals.get(i)).cloneMe());
            }
        }
    }

    private void jButtonPasteIntervalActionPerformed(ActionEvent evt) {
        if (clipboard.size() > 0) {
            for (int i = 0; i < clipboard.size(); ++i) {
                this.addRowValues(((MeterInterval)clipboard.get(i)).cloneMe());
            }
        }
    }

    private void jButtonCopyIntervalActionPerformed(ActionEvent evt) {
        if (this.jTable1.getRowCount() > 0) {
            clipboard.clear();
            for (int i = 0; i < this.jTable1.getRowCount(); ++i) {
                clipboard.add(((MeterInterval)this.jTable1.getValueAt(i, 0)).cloneMe());
            }
        }
        this.jButtonPasteInterval.setEnabled(true);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        ArrayList<MeterInterval> temp_list = new ArrayList<MeterInterval>();
        lastIntervals.clear();
        for (int i = 0; i < this.jTable1.getRowCount(); ++i) {
            temp_list.add(((MeterInterval)this.jTable1.getValueAt(i, 0)).cloneMe());
            lastIntervals.add(((MeterInterval)this.jTable1.getValueAt(i, 0)).cloneMe());
        }
        this.setMeterIntervals(temp_list);
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonMoveDownActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedRowCount() > 0) {
            DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
            int[] indices = this.jTable1.getSelectedRows();
            for (int i = indices.length - 1; i >= 0; --i) {
                if (indices[i] >= this.jTable1.getRowCount() - 1) continue;
                Object val = this.jTable1.getValueAt(indices[i], 0);
                dtm.removeRow(indices[i]);
                dtm.insertRow(indices[i] + 1, new Object[5]);
                this.setRowValues((MeterInterval)val, indices[i] + 1);
                int n = i;
                indices[n] = indices[n] + 1;
            }
            DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTable1.getSelectionModel();
            dlsm.setValueIsAdjusting(true);
            dlsm.clearSelection();
            for (int i = 0; i < indices.length; ++i) {
                dlsm.addSelectionInterval(indices[i], indices[i]);
            }
            dlsm.setValueIsAdjusting(false);
        }
    }

    private void jButtonMoveUpActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedRow() > 0) {
            DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
            int[] indices = this.jTable1.getSelectedRows();
            for (int i = indices.length - 1; i >= 0; --i) {
                if (indices[i] == 0) continue;
                Object val = this.jTable1.getValueAt(indices[i], 0);
                dtm.removeRow(indices[i]);
                dtm.insertRow(indices[i] - 1, new Object[5]);
                this.setRowValues((MeterInterval)val, indices[i] - 1);
                int n = i;
                indices[n] = indices[n] - 1;
            }
            DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTable1.getSelectionModel();
            dlsm.setValueIsAdjusting(true);
            dlsm.clearSelection();
            for (int i = 0; i < indices.length; ++i) {
                dlsm.addSelectionInterval(indices[i], indices[i]);
            }
            dlsm.setValueIsAdjusting(false);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] indexes = this.jTable1.getSelectedRows();
        for (int i = indexes.length - 1; i >= 0; --i) {
            ((DefaultTableModel)this.jTable1.getModel()).removeRow(indexes[i]);
        }
        this.jTable1.updateUI();
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        int index = this.jTable1.getSelectedRow();
        if (index >= 0) {
            MeterInterval c = (MeterInterval)this.jTable1.getValueAt(this.jTable1.getSelectedRow(), 0);
            MeterIntervalDialog cc = new MeterIntervalDialog((Dialog)this, true);
            cc.setMeterInterval(c);
            cc.setVisible(true);
            if (cc.getDialogResult() == 0) {
                this.setRowValues(c, index);
            }
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        MeterIntervalDialog cc = new MeterIntervalDialog((Dialog)this, true);
        cc.setVisible(true);
        if (cc.getDialogResult() == 0) {
            this.addRowValues(cc.getMeterInterval());
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new SeriesColorsDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setRowValues(MeterInterval mi, int row) {
        DecimalFormat dnf = new DecimalFormat("0.00");
        this.jTable1.setValueAt(mi, row, 0);
        this.jTable1.setValueAt(dnf.format(mi.getAlpha()), row, 1);
        this.jTable1.setValueAt(mi.getDataRange().getLowExpression(), row, 2);
        this.jTable1.setValueAt(mi.getDataRange().getHighExpression(), row, 3);
        this.jTable1.updateUI();
    }

    public void addRowValues(MeterInterval mi) {
        DecimalFormat dnf = new DecimalFormat("0.00");
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        dtm.addRow(new Object[]{mi, dnf.format(mi.getAlpha()), mi.getDataRange().getLowExpression(), mi.getDataRange().getHighExpression()});
        this.jTable1.updateUI();
    }

    public List getMeterIntervals() {
        return this.meterIntervals;
    }

    public void setMeterIntervals(List meterIntervals) {
        this.meterIntervals = meterIntervals;
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        dtm.setRowCount(0);
        for (int i = 0; i < meterIntervals.size(); ++i) {
            this.addRowValues(((MeterInterval)meterIntervals.get(i)).cloneMe());
        }
        this.jTable1.updateUI();
    }

    public void applyI18n() {
        this.jButtonAdd.setText(I18n.getString("meterIntervalsDialog.buttonAdd", "Add"));
        this.jButtonCancel.setText(I18n.getString("meterIntervalsDialog.buttonCancel", "Cancel"));
        this.jButtonCopyInterval.setText(I18n.getString("meterIntervalsDialog.buttonCopyInterval", "Copy intervals"));
        this.jButtonDelete.setText(I18n.getString("meterIntervalsDialog.buttonDelete", "Delete"));
        this.jButtonModify.setText(I18n.getString("meterIntervalsDialog.buttonModify", "Modify"));
        this.jButtonMoveDown.setText(I18n.getString("meterIntervalsDialog.buttonMoveDown", "Move down"));
        this.jButtonMoveUp.setText(I18n.getString("meterIntervalsDialog.buttonMoveUp", "Move up"));
        this.jButtonOk.setText(I18n.getString("meterIntervalsDialog.buttonOk", "OK"));
        this.jButtonPasteInterval.setText(I18n.getString("meterIntervalsDialog.buttonPasteInterval", "Paste intervals"));
        this.jButtonUseLast.setText(I18n.getString("meterIntervalsDialog.buttonUseLast", "Use last"));
        this.jTable1.getColumnModel().getColumn(0).setHeaderValue(I18n.getString("meterIntervalsDialog.tablecolumn.label", "Label"));
        this.jTable1.getColumnModel().getColumn(1).setHeaderValue(I18n.getString("meterIntervalsDialog.tablecolumn.alpha", "Alpha"));
        this.jTable1.getColumnModel().getColumn(2).setHeaderValue(I18n.getString("meterIntervalsDialog.tablecolumn.lowExp", "Low exp"));
        this.jTable1.getColumnModel().getColumn(3).setHeaderValue(I18n.getString("meterIntervalsDialog.tablecolumn.highExp", "High exp"));
        this.jButtonCancel.setMnemonic(I18n.getString("meterIntervalsDialog.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonOk.setMnemonic(I18n.getString("meterIntervalsDialog.buttonOkMnemonic", "o").charAt(0));
    }
}

