/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import bsh.EvalError;
import bsh.Interpreter;
import it.businesslogic.ireport.FieldsProvider;
import it.businesslogic.ireport.FieldsProviderEditor;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.connection.JRCSVDataSourceConnection;
import it.businesslogic.ireport.connection.JRDataSourceProviderConnection;
import it.businesslogic.ireport.data.BeanInspectorPanel;
import it.businesslogic.ireport.data.CincomMDXFieldsProvider;
import it.businesslogic.ireport.data.EJBQLFieldsProvider;
import it.businesslogic.ireport.data.HQLFieldsProvider;
import it.businesslogic.ireport.data.MDXFieldsProvider;
import it.businesslogic.ireport.data.SQLFieldsProvider;
import it.businesslogic.ireport.gui.JRSQLExpressionArea;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.queryexecuters.QueryExecuterDef;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.gui.subdataset.FilterExpressionDialog;
import it.businesslogic.ireport.gui.subdataset.SortFieldsDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRProperties;

public class ReportQueryDialog
extends JDialog
implements ClipboardOwner {
    private BeanInspectorPanel bip1 = null;
    private FieldsProvider fieldsProvider = null;
    protected static String[] standard_types = new String[]{"java.lang.String", "java.lang.Object", "java.lang.Boolean", "java.lang.Byte", "java.util.Date", "java.sql.Timestamp", "java.sql.Time", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.io.InputStream", "java.lang.Long", "java.lang.Short", "java.math.BigDecimal"};
    public FieldReader readerThread = null;
    public static int num = 1;
    Timer stoppedChanging = new Timer(500, new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (ReportQueryDialog.this.automaticlyReadFieldsCheckBox.isSelected()) {
                ReportQueryDialog.this.processQueryChanged(ReportQueryDialog.this.jRSQLExpressionArea1.getText().trim());
            }
        }
    });
    Map parameterNameToExpressionID = null;
    private JCheckBox automaticlyReadFieldsCheckBox;
    private JButton cancelButton;
    private JLabel columnsErrorMsgLabel;
    private JScrollPane columnsErrorScrollPane;
    private JScrollPane columnsScrollPane;
    private JButton exportQueryButton;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButtonLoadQuery;
    private JButton jButtonOpenDesigner;
    private JButton jButtonReadBeanAttributes3;
    private JButton jButtonSaveQuery;
    private JComboBox jComboBoxQueryType;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabelStatusSQL;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelQueryArea;
    private JPanel jPanelSQL;
    private JRSQLExpressionArea jRSQLExpressionArea1;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JTable jTableFields;
    private JTextField jTextFieldBeanClass1;
    private JButton okButton;
    private JButton readFieldsButton;
    private boolean isSettingSQLExpression = false;
    private SubDataset subDataset;

    public JLabel getJLabelStatusSQL() {
        return this.jLabelStatusSQL;
    }

    public ReportQueryDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(800, 550);
        Misc.centerFrame(this);
        this.stoppedChanging.setRepeats(false);
        this.jRSQLExpressionArea1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.stoppedChanging.restart();
            }

            public void insertUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.stoppedChanging.restart();
            }

            public void removeUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.stoppedChanging.restart();
            }
        });
        this.setColumnsError("Please open a report.");
        if (MainFrame.getMainInstance().getProperties().getProperty("beanClass") != null) {
            this.jTextFieldBeanClass1.setText(MainFrame.getMainInstance().getProperties().getProperty("beanClass") + "");
        }
        this.jComboBoxQueryType.addItem(new Tag("sql", "SQL"));
        this.jComboBoxQueryType.addItem(new Tag("hql", "Hibernate Query Language (HQL)"));
        this.jComboBoxQueryType.addItem(new Tag("xPath", "XPath"));
        this.jComboBoxQueryType.addItem(new Tag("ejbql", "EJBQL"));
        this.jComboBoxQueryType.addItem(new Tag("mdx", "MDX"));
        this.jComboBoxQueryType.addItem(new Tag("xmla-mdx", "XMLA-MDX"));
        Enumeration e = MainFrame.getMainInstance().getQueryExecuters().elements();
        while (e.hasMoreElements()) {
            QueryExecuterDef qe = (QueryExecuterDef)e.nextElement();
            this.jComboBoxQueryType.addItem(new Tag(qe, qe.getLanguage()));
        }
        this.okButton.setEnabled(false);
        this.bip1 = new BeanInspectorPanel();
        this.bip1.setComboVisible(false);
        this.bip1.setJTableFields(this.jTableFields);
        this.bip1.setPathOnDescription(true);
        this.jPanel11.add((Component)this.bip1, "Center");
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReportQueryDialog.this.cancelButtonActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.applyI18n();
        I18n.addOnLanguageChangedListener(new LanguageChangedListener(){

            public void languageChanged(LanguageChangedEvent evt) {
                ReportQueryDialog.this.applyI18n();
            }
        });
    }

    private void processQueryChanged(String query) {
        if (this.isSettingSQLExpression) {
            return;
        }
        if (this.subDataset == null) {
            this.setColumnsError("Please open a report.");
            return;
        }
        if (query.length() == 0) {
            this.setColumnsError("You must insert a valid query first");
            return;
        }
        IReportConnection conn = (IReportConnection)MainFrame.getMainInstance().getProperties().get("DefaultConnection");
        Object obj = this.jComboBoxQueryType.getSelectedItem();
        String queryLanguage = "sql";
        queryLanguage = obj != null && obj instanceof Tag ? "" + ((Tag)obj).getValue() : "" + obj;
        try {
            if (this.readerThread != null && this.readerThread.isAlive()) {
                this.readerThread.interrupt();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.readerThread = new FieldReader(query, conn, queryLanguage);
        this.readerThread.start();
    }

    public void setColumns(List cols) {
        this.columnsErrorMsgLabel.setText("");
        this.jPanel2.remove(this.columnsErrorScrollPane);
        this.jPanel2.add((Component)this.columnsScrollPane, "Center");
        this.jPanel2.revalidate();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        dtm.getDataVector().clear();
        for (int i = 0; i < cols.size(); ++i) {
            Object[] row = (Object[])cols.get(i);
            dtm.addRow(row);
        }
        this.jTableFields.selectAll();
        this.okButton.setEnabled(true);
    }

    public void setColumnsError(String msg) {
        this.columnsErrorMsgLabel.setText(msg);
        this.jPanel2.remove(this.columnsScrollPane);
        this.jPanel2.add((Component)this.columnsErrorScrollPane, "Center");
        this.jPanel2.revalidate();
        this.columnsErrorMsgLabel.repaint();
    }

    private FieldsProvider getFieldsProvider() {
        return this.fieldsProvider;
    }

    private void setFieldsProvider(FieldsProvider fieldsProvider) {
        this.fieldsProvider = fieldsProvider;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelSQL = new JPanel();
        this.jPanel14 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxQueryType = new JComboBox();
        this.jPanel16 = new JPanel();
        this.jButtonLoadQuery = new JButton();
        this.jButtonSaveQuery = new JButton();
        this.jPanelQueryArea = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel7 = new JPanel();
        this.jRSQLExpressionArea1 = new JRSQLExpressionArea();
        this.jLabelStatusSQL = new JLabel();
        this.automaticlyReadFieldsCheckBox = new JCheckBox();
        this.readFieldsButton = new JButton();
        this.jButtonOpenDesigner = new JButton();
        this.exportQueryButton = new JButton();
        this.jPanel8 = new JPanel();
        this.jTextFieldBeanClass1 = new JTextField();
        this.jLabel3 = new JLabel();
        this.jButtonReadBeanAttributes3 = new JButton();
        this.jPanel11 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jPanel6 = new JPanel();
        this.jButton2 = new JButton();
        this.jPanel15 = new JPanel();
        this.jButton3 = new JButton();
        this.jPanel2 = new JPanel();
        this.columnsScrollPane = new JScrollPane();
        this.jTableFields = new JTable();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel9 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton4 = new JButton();
        this.columnsErrorScrollPane = new JScrollPane();
        this.columnsErrorMsgLabel = new JLabel();
        this.setTitle("Report query");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ReportQueryDialog.this.closeDialog(evt);
            }

            public void windowOpened(WindowEvent evt) {
                ReportQueryDialog.this.formWindowOpened(evt);
            }
        });
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setMinimumSize(new Dimension(10, 100));
        this.jPanel1.setPreferredSize(new Dimension(10, 350));
        this.jTabbedPane1.setMinimumSize(new Dimension(154, 350));
        this.jTabbedPane1.setPreferredSize(new Dimension(154, 350));
        this.jPanelSQL.setLayout(new GridBagLayout());
        this.jPanelSQL.setMinimumSize(new Dimension(1, 100));
        this.jPanelSQL.setPreferredSize(new Dimension(1, 350));
        this.jPanel14.setLayout(new GridBagLayout());
        this.jLabel1.setText("Query language");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel14.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboBoxQueryType.setEditable(true);
        this.jComboBoxQueryType.setMinimumSize(new Dimension(200, 18));
        this.jComboBoxQueryType.setPreferredSize(new Dimension(200, 22));
        this.jComboBoxQueryType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jComboBoxQueryTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel14.add((Component)this.jComboBoxQueryType, gridBagConstraints);
        this.jPanel16.setLayout(new GridBagLayout());
        this.jButtonLoadQuery.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/folder_database.png")));
        this.jButtonLoadQuery.setText("Load query");
        this.jButtonLoadQuery.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonLoadQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonLoadQueryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel16.add((Component)this.jButtonLoadQuery, gridBagConstraints);
        this.jButtonSaveQuery.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/database_save.png")));
        this.jButtonSaveQuery.setText("Save query");
        this.jButtonSaveQuery.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonSaveQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonSaveQueryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel16.add((Component)this.jButtonSaveQuery, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel14.add((Component)this.jPanel16, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelSQL.add((Component)this.jPanel14, gridBagConstraints);
        this.jPanelQueryArea.setLayout(new BorderLayout());
        this.jSplitPane2.setBorder(null);
        this.jSplitPane2.setDividerSize(6);
        this.jSplitPane2.setResizeWeight(0.5);
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jPanel7.setLayout(new GridBagLayout());
        this.jRSQLExpressionArea1.setBorder(BorderFactory.createEtchedBorder());
        this.jRSQLExpressionArea1.setMinimumSize(new Dimension(50, 200));
        this.jRSQLExpressionArea1.setPreferredSize(new Dimension(661, 340));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.jRSQLExpressionArea1, gridBagConstraints);
        this.jLabelStatusSQL.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelStatusSQL.setMinimumSize(new Dimension(4, 20));
        this.jLabelStatusSQL.setPreferredSize(new Dimension(4, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.jLabelStatusSQL, gridBagConstraints);
        this.automaticlyReadFieldsCheckBox.setSelected(true);
        this.automaticlyReadFieldsCheckBox.setText("Automatically Retrieve Fields");
        this.automaticlyReadFieldsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.automaticlyReadFieldsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.jPanel7.add((Component)this.automaticlyReadFieldsCheckBox, gridBagConstraints);
        this.readFieldsButton.setText("Read Fields");
        this.readFieldsButton.setEnabled(false);
        this.readFieldsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.readFieldsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        this.jPanel7.add((Component)this.readFieldsButton, gridBagConstraints);
        this.jButtonOpenDesigner.setText("Query designer");
        this.jButtonOpenDesigner.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonOpenDesignerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        this.jPanel7.add((Component)this.jButtonOpenDesigner, gridBagConstraints);
        this.exportQueryButton.setText("Send to clipboard");
        this.exportQueryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.exportQueryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        this.jPanel7.add((Component)this.exportQueryButton, gridBagConstraints);
        this.jSplitPane2.setLeftComponent(this.jPanel7);
        this.jPanelQueryArea.add((Component)this.jSplitPane2, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.jPanelSQL.add((Component)this.jPanelQueryArea, gridBagConstraints);
        this.jTabbedPane1.addTab("Report query ", this.jPanelSQL);
        this.jPanel8.setLayout(new GridBagLayout());
        this.jPanel8.setMinimumSize(new Dimension(235, 30));
        this.jPanel8.setPreferredSize(new Dimension(215, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel8.add((Component)this.jTextFieldBeanClass1, gridBagConstraints);
        this.jLabel3.setText("Class name");
        this.jLabel3.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 5, 3);
        this.jPanel8.add((Component)this.jLabel3, gridBagConstraints);
        this.jButtonReadBeanAttributes3.setText("Read attributes");
        this.jButtonReadBeanAttributes3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonReadBeanAttributes3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel8.add((Component)this.jButtonReadBeanAttributes3, gridBagConstraints);
        this.jPanel11.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.jPanel8.add((Component)this.jPanel11, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(0, 4));
        this.jSeparator1.setPreferredSize(new Dimension(0, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel8.add((Component)this.jSeparator1, gridBagConstraints);
        this.jTabbedPane1.addTab("JavaBean Datasource", this.jPanel8);
        this.jButton2.setText("Get fields from datasource");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton2);
        this.jTabbedPane1.addTab("DataSource Provider", this.jPanel6);
        this.jButton3.setText("Get fields from datasource");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButton2ActionPerformed1(evt);
            }
        });
        this.jPanel15.add(this.jButton3);
        this.jTabbedPane1.addTab("CSV Datasource", this.jPanel15);
        this.jPanel1.add((Component)this.jTabbedPane1, "Center");
        this.jSplitPane1.setTopComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setPreferredSize(new Dimension(453, 150));
        this.columnsScrollPane.setPreferredSize(new Dimension(453, 150));
        this.jTableFields.setModel(new DefaultTableModel(new Object[0][], new String[]{"Field name", "Field type", "Description"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableFields.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                ReportQueryDialog.this.jTableFieldsKeyReleased(evt);
            }
        });
        this.columnsScrollPane.setViewportView(this.jTableFields);
        this.jPanel2.add((Component)this.columnsScrollPane, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.setPreferredSize(new Dimension(10, 34));
        this.jPanel3.setMinimumSize(new Dimension(10, 34));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setPreferredSize(new Dimension(150, 10));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.setMaximumSize(new Dimension(67, 25));
        this.okButton.setMinimumSize(new Dimension(67, 25));
        this.okButton.setPreferredSize(new Dimension(67, 25));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel4.add((Component)this.cancelButton, gridBagConstraints);
        this.jPanel3.add((Component)this.jPanel4, "East");
        this.jPanel9.setLayout(new GridBagLayout());
        this.jPanel9.setMinimumSize(new Dimension(100, 20));
        this.jButton1.setText("Filter expression...");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel9.add((Component)this.jButton1, gridBagConstraints);
        this.jButton4.setText("Sort options...");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButton1ActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel9.add((Component)this.jButton4, gridBagConstraints);
        this.jPanel3.add((Component)this.jPanel9, "Center");
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.columnsErrorMsgLabel.setText("jLabel1");
        this.columnsErrorMsgLabel.setVerticalAlignment(1);
        this.columnsErrorMsgLabel.setVerticalTextPosition(1);
        this.columnsErrorScrollPane.setViewportView(this.columnsErrorMsgLabel);
        this.jPanel2.add((Component)this.columnsErrorScrollPane, "Center");
        this.jSplitPane1.setBottomComponent(this.jPanel2);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    private void jButtonOpenDesignerActionPerformed(ActionEvent evt) {
        if (this.getFieldsProvider() != null && this.getFieldsProvider().hasQueryDesigner()) {
            try {
                String newQuery = this.getFieldsProvider().designQuery((IReportConnection)MainFrame.getMainInstance().getProperties().get("DefaultConnection"), this.jRSQLExpressionArea1.getText(), this);
                if (newQuery != null && !this.jRSQLExpressionArea1.getText().equals(newQuery)) {
                    this.jRSQLExpressionArea1.setText(newQuery);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(null, ex.getMessage());
            }
        }
    }

    private void jButton1ActionPerformed1(ActionEvent evt) {
        SortFieldsDialog sfd = new SortFieldsDialog((Dialog)this, true);
        sfd.setSubDataset(this.getSubDataset());
        sfd.setVisible(true);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.getSubDataset() == null) {
            return;
        }
        FilterExpressionDialog fed = new FilterExpressionDialog((Dialog)this, true);
        fed.setFilterExpression(this.getSubDataset().getFilterExpression(), this.getSubDataset());
        fed.setVisible(true);
        if (fed.getDialogResult() == 0) {
            this.getSubDataset().setFilterExpression(fed.getFilterExpression());
        }
    }

    private void jButtonSaveQueryActionPerformed(ActionEvent evt) {
        Misc.saveSQLQuery(this.jRSQLExpressionArea1.getText(), this);
    }

    private void jButtonLoadQueryActionPerformed(ActionEvent evt) {
        String query = Misc.loadSQLQuery(this);
        if (query != null) {
            this.jRSQLExpressionArea1.setText(query);
        }
    }

    private void jComboBoxQueryTypeActionPerformed(ActionEvent evt) {
        boolean autoReadFields = this.automaticlyReadFieldsCheckBox.isSelected();
        this.readFieldsButton.setEnabled(false);
        this.automaticlyReadFieldsCheckBox.setSelected(false);
        this.readFieldsButton.setEnabled(false);
        String language = "sql";
        if (this.jComboBoxQueryType.getSelectedItem() != null && this.jComboBoxQueryType.getSelectedItem() instanceof Tag) {
            language = "" + ((Tag)this.jComboBoxQueryType.getSelectedItem()).getValue();
        } else if (this.jComboBoxQueryType.getSelectedItem() != null) {
            language = "" + this.jComboBoxQueryType.getSelectedItem();
        }
        this.getJLabelStatusSQL().setText("Looking for a valid Fields provider for " + language + " queries....");
        this.setFieldsProvider(null);
        Enumeration enum_qe = MainFrame.getMainInstance().getQueryExecuters().elements();
        while (enum_qe.hasMoreElements()) {
            QueryExecuterDef qed = (QueryExecuterDef)enum_qe.nextElement();
            if (!qed.getLanguage().equals(language) || qed.getFieldsProvider() == null || qed.getFieldsProvider().length() <= 0) continue;
            try {
                JRProperties.setProperty((String)("net.sf.jasperreports.query.executer.factory." + language), (String)qed.getClassName());
                this.setFieldsProvider((FieldsProvider)Class.forName(qed.getFieldsProvider(), true, MainFrame.getMainInstance().getReportClassLoader()).newInstance());
            }
            catch (Throwable t) {
                this.getJLabelStatusSQL().setText("Error creating the fields provider " + t.getMessage());
            }
        }
        this.exportQueryButton.setEnabled(language.equals("sql"));
        if (this.getFieldsProvider() == null && language.equals("sql")) {
            this.setFieldsProvider(new SQLFieldsProvider());
        } else if (this.getFieldsProvider() == null && language.equals("hql")) {
            this.setFieldsProvider(new HQLFieldsProvider());
        } else if (this.getFieldsProvider() == null && language.equals("ejbql")) {
            this.setFieldsProvider(new EJBQLFieldsProvider());
        } else if (this.getFieldsProvider() == null && language.equals("mdx")) {
            this.setFieldsProvider(new MDXFieldsProvider());
        } else if (this.getFieldsProvider() == null && language.equals("xmla-mdx")) {
            this.setFieldsProvider(new CincomMDXFieldsProvider());
        }
        boolean isSettingSQLExpressionOldValue = this.isSettingSQLExpression;
        this.isSettingSQLExpression = true;
        if (this.getFieldsProvider() == null) {
            this.setSpecialLanguageComponent(null);
            this.readFieldsButton.setEnabled(false);
            this.jButtonOpenDesigner.setEnabled(false);
            this.automaticlyReadFieldsCheckBox.setEnabled(false);
            this.automaticlyReadFieldsCheckBox.setSelected(autoReadFields);
            this.getJLabelStatusSQL().setText("No Fields Provider available for " + language + " queries!");
        } else {
            this.readFieldsButton.setEnabled(true);
            this.automaticlyReadFieldsCheckBox.setEnabled(this.getFieldsProvider().supportsAutomaticQueryExecution());
            this.automaticlyReadFieldsCheckBox.setSelected(autoReadFields);
            this.jButtonOpenDesigner.setEnabled(this.getFieldsProvider().hasQueryDesigner());
            if (this.getFieldsProvider().hasEditorComponent()) {
                FieldsProviderEditor fpe = this.getFieldsProvider().getEditorComponent(this);
                if (fpe instanceof Component) {
                    this.setSpecialLanguageComponent((Component)((Object)fpe));
                }
            } else {
                this.setSpecialLanguageComponent(null);
            }
            this.getJLabelStatusSQL().setText("Fields provider for " + language + " queries ready.");
        }
        this.isSettingSQLExpression = isSettingSQLExpressionOldValue;
    }

    public void setSpecialLanguageComponent(Component c) {
        if (c == null) {
            if (this.jPanelQueryArea.getComponent(0) != this.jPanel7) {
                this.jPanelQueryArea.removeAll();
                this.jPanelQueryArea.add((Component)this.jPanel7, "Center");
            }
        } else if (this.jPanelQueryArea.getComponent(0) != this.jSplitPane2 || this.jSplitPane2.getRightComponent() != c) {
            this.jPanelQueryArea.removeAll();
            this.jSplitPane2.setLeftComponent(this.jPanel7);
            this.jSplitPane2.setRightComponent(c);
            this.jPanelQueryArea.add((Component)this.jSplitPane2, "Center");
        }
        this.jPanelQueryArea.updateUI();
        this.jRSQLExpressionArea1.requestFocusInWindow();
        this.jRSQLExpressionArea1.requestFocus();
    }

    private void jButton2ActionPerformed1(ActionEvent evt) {
        IReportConnection conn = (IReportConnection)MainFrame.getMainInstance().getProperties().get("DefaultConnection");
        if (conn == null || !(conn instanceof JRCSVDataSourceConnection)) {
            this.setColumnsError("The active connection is not a JasperReports CSV DataSource.");
            return;
        }
        JRCSVDataSourceConnection ic = (JRCSVDataSourceConnection)conn;
        try {
            Vector names = ic.getColumnNames();
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            dtm.setRowCount(0);
            for (int nd = 0; nd < names.size(); ++nd) {
                String fieldName = "" + names.elementAt(nd);
                JRField field = new JRField(fieldName, "java.lang.String");
                field.setDescription("");
                Vector<Object> row = new Vector<Object>();
                row.addElement(field);
                row.addElement(field.getClassType());
                row.addElement(field.getDescription());
                dtm.addRow(row);
            }
            this.jTableFields.setRowSelectionInterval(0, names.size() - 1);
        }
        catch (Exception ex) {
            this.setColumnsError("" + ex.getMessage());
        }
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        IReportConnection conn = (IReportConnection)MainFrame.getMainInstance().getProperties().get("DefaultConnection");
        if (conn == null || !(conn instanceof JRDataSourceProviderConnection)) {
            this.setColumnsError("The active connection is not a JasperReports DataSource provider.");
            return;
        }
        JRDataSourceProviderConnection ic = (JRDataSourceProviderConnection)conn;
        try {
            int i;
            Report rep = MainFrame.getMainInstance().getActiveReportFrame().getReport();
            JasperDesign report = new JasperDesign();
            JRDesignQuery queryDes = new JRDesignQuery();
            queryDes.setText(this.jRSQLExpressionArea1.getText());
            String queryLanguage = "sql";
            Object obj = this.jComboBoxQueryType.getSelectedItem();
            queryLanguage = obj != null && obj instanceof Tag ? "" + ((Tag)obj).getValue() : "" + obj;
            queryDes.setLanguage(queryLanguage);
            report.setQuery(queryDes);
            for (i = 0; i < rep.getJRproperties().size(); ++i) {
                JRProperty property = (JRProperty)rep.getJRproperties().elementAt(i);
                report.setProperty(property.getName(), property.getValue());
            }
            for (i = 0; i < rep.getParameters().size(); ++i) {
                JRParameter ireportParam = (JRParameter)rep.getParameters().elementAt(i);
                if (ireportParam.isBuiltin()) continue;
                JRDesignParameter param = new JRDesignParameter();
                param.setName(ireportParam.getName());
                JRDesignExpression de = new JRDesignExpression();
                de.setText(ireportParam.getDefaultValueExpression());
                de.setValueClassName(ireportParam.getClassType());
                param.setDefaultValueExpression((JRExpression)de);
                param.setForPrompting(ireportParam.isIsForPrompting());
                param.setValueClassName(ireportParam.getClassType());
                report.addParameter((net.sf.jasperreports.engine.JRParameter)param);
            }
            try {
                report.setName(rep.getName());
            }
            catch (Exception ex) {
                // empty catch block
            }
            JasperReport jr = new JasperReport((JRReport)report, "", null, null, "");
            net.sf.jasperreports.engine.JRField[] jrfields = ic.getDataSourceProvider().getFields(jr);
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            dtm.setRowCount(0);
            for (int i2 = 0; i2 < jrfields.length; ++i2) {
                JRField field = new JRField(jrfields[i2].getName(), jrfields[i2].getValueClassName());
                field.setDescription(Misc.nvl(jrfields[i2].getDescription(), ""));
                Vector<Object> row = new Vector<Object>();
                row.addElement(field);
                row.addElement(field.getClassType());
                row.addElement(field.getDescription());
                dtm.addRow(row);
            }
        }
        catch (Exception ex) {
            this.setColumnsError("" + ex.getMessage());
        }
    }

    private void exportQueryButtonActionPerformed(ActionEvent evt) {
        FieldReader fr = new FieldReader(this.jRSQLExpressionArea1.getText(), null);
        String query = fr.interpretQuery();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection fieldContent = new StringSelection(query);
        clipboard.setContents(fieldContent, this);
    }

    private void jButtonReadBeanAttributes3ActionPerformed(ActionEvent evt) {
        this.bip1.setClassName(this.jTextFieldBeanClass1.getText().trim());
    }

    protected void getFieldsFromClass(Class clazz, String path) throws Exception {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        Method[] methods = clazz.getMethods();
        Field[] fields = clazz.getFields();
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isPublic(methods[i].getModifiers()) || !methods[i].getDeclaringClass().getName().equals(clazz.getName()) || Modifier.isNative(methods[i].getModifiers()) || !methods[i].getName().startsWith("get") || methods[i].getReturnType().isPrimitive() || methods[i].getReturnType().isArray()) continue;
            String fieldName = methods[i].getName().substring(3);
            for (int f = 0; f < fields.length; ++f) {
                if (!fields[f].getName().equalsIgnoreCase(fieldName)) continue;
                fieldName = fields[f].getName();
                break;
            }
            String returnType = methods[i].getReturnType().getName();
            boolean found = false;
            for (int cc = 0; cc < standard_types.length; ++cc) {
                if (!returnType.equalsIgnoreCase(standard_types[cc])) continue;
                JRField field = new JRField(fieldName, returnType);
                field.setDescription(path + "" + fieldName);
                Vector<Object> row = new Vector<Object>();
                row.addElement(field);
                row.addElement(field.getClassType());
                row.addElement(field.getDescription());
                dtm.addRow(row);
                found = true;
                break;
            }
            if (found) continue;
            JRField field = new JRField(fieldName, "java.lang.Object");
            field.setDescription(path + "" + fieldName);
            Vector<Object> row = new Vector<Object>();
            row.addElement(field);
            row.addElement(field.getClassType());
            row.addElement(field.getDescription());
            dtm.addRow(row);
            Class<?> subClazz = Class.forName(returnType);
            this.getFieldsFromClass(subClazz, path + fieldName + ".");
        }
    }

    private void automaticlyReadFieldsCheckBoxActionPerformed(ActionEvent evt) {
        if (this.automaticlyReadFieldsCheckBox.isSelected()) {
            this.readFieldsButton.setEnabled(false);
            if (!this.isSettingSQLExpression) {
                this.processQueryChanged(this.jRSQLExpressionArea1.getText().trim());
            }
        } else {
            this.readFieldsButton.setEnabled(true);
            this.jLabelStatusSQL.setText("Enter your query above. Then use the Read Fields button to retrieve the list of fields.");
        }
        MainFrame.getMainInstance().getProperties().setProperty("UseAutoRegiesterFields", "" + this.automaticlyReadFieldsCheckBox.isSelected());
    }

    private void readFieldsButtonActionPerformed(ActionEvent evt) {
        this.processQueryChanged(this.jRSQLExpressionArea1.getText().trim());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        ++num;
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.stoppedChanging != null) {
                this.stoppedChanging.stop();
            }
            if (this.getSubDataset() != null) {
                ++num;
                Object obj = this.jComboBoxQueryType.getSelectedItem();
                if (obj != null && obj instanceof Tag) {
                    this.subDataset.setQueryLanguage("" + ((Tag)obj).getValue());
                } else {
                    this.subDataset.setQueryLanguage("" + obj);
                }
                this.subDataset.setQuery(this.jRSQLExpressionArea1.getText());
                if (this.jTableFields.getRowCount() > 0) {
                    this.subDataset.getFields().clear();
                    int[] selectedRows = this.jTableFields.getSelectedRows();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        if (selectedRows[i] > this.jTableFields.getRowCount()) continue;
                        JRField field = (JRField)this.jTableFields.getValueAt(selectedRows[i], 0);
                        Enumeration e = this.subDataset.getFields().elements();
                        boolean found = false;
                        while (e.hasMoreElements()) {
                            JRField f = (JRField)e.nextElement();
                            if (!f.getName().equalsIgnoreCase(field.getName())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.subDataset.addField(field);
                    }
                    if (this.subDataset instanceof Report) {
                        MainFrame.getMainInstance().getValuesDialog().getValuesPanel().updateFields();
                    }
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.setVisible(false);
    }

    private void jTableFieldsKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            while (this.jTableFields.getSelectedRow() >= 0) {
                dtm.removeRow(this.jTableFields.getSelectedRow());
            }
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new ReportQueryDialog((Frame)new JFrame(), true).setVisible(true);
    }

    private Interpreter prepareExpressionEvaluator() throws EvalError {
        Interpreter interpreter = new Interpreter();
        interpreter.setClassLoader(interpreter.getClass().getClassLoader());
        StringTokenizer st = new StringTokenizer(MainFrame.getMainInstance().getProperties().getProperty("classpath", ""), "\n");
        interpreter.eval("String tmp;");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token == null || token.trim().length() <= 0) continue;
            interpreter.set("tmp", (Object)token.trim());
            interpreter.eval("addClassPath(tmp);");
        }
        Enumeration imps = MainFrame.getMainInstance().getActiveReportFrame().getReport().getImports().elements();
        while (imps.hasMoreElements()) {
            String var = (String)imps.nextElement();
            interpreter.eval("import " + var + ";");
        }
        return interpreter;
    }

    private Class classStringToClass(String classType) {
        Class c = null;
        if (classType.equals("java.lang.String")) {
            c = String.class;
        } else if (classType.equals("java.lang.Integer")) {
            c = Integer.class;
        } else if (classType.equals("java.lang.Boolean")) {
            c = Boolean.class;
        } else if (classType.equals("java.lang.Byte")) {
            c = Byte.class;
        } else if (classType.equals("java.util.Date")) {
            c = Date.class;
        } else if (classType.equals("java.sql.Timestamp")) {
            c = Timestamp.class;
        } else if (classType.equals("java.sql.Time")) {
            c = Time.class;
        } else if (classType.equals("java.lang.Double")) {
            c = Double.class;
        } else if (classType.equals("java.lang.Float")) {
            c = Float.class;
        } else if (classType.equals("java.lang.Long")) {
            c = Long.class;
        } else if (classType.equals("java.lang.Short")) {
            c = Short.class;
        } else if (classType.equals("java.math.BigDecimal")) {
            c = BigDecimal.class;
        }
        return c;
    }

    public void lostOwnership(Clipboard parClipboard, Transferable parTransferable) {
    }

    public static Object recursiveInterpreter(Interpreter interpreter, String expression, Vector parameters) throws EvalError {
        return ReportQueryDialog.recursiveInterpreter(interpreter, expression, parameters, 0);
    }

    public static Object recursiveInterpreter(Interpreter interpreter, String expression, Vector parameters, int recursion_level) throws EvalError {
        if (++recursion_level > 100) {
            return null;
        }
        if (expression != null && expression.trim().length() > 0) {
            while (expression.indexOf("$P{") >= 0) {
                int start_index = expression.indexOf("$P{") + 3;
                String param_name = expression.substring(start_index, expression.indexOf("}", start_index));
                String param_expression = "";
                for (int i = 0; i < parameters.size(); ++i) {
                    JRParameter p = (JRParameter)parameters.elementAt(i);
                    if (!p.getName().equals(param_name)) continue;
                    param_expression = p.getDefaultValueExpression();
                    break;
                }
                expression = Misc.string_replace(param_name, "$P{" + param_name + "}", expression);
                interpreter.set(param_name, ReportQueryDialog.recursiveInterpreter(interpreter, param_expression, parameters, recursion_level));
            }
            Object res = interpreter.eval(expression);
            return res;
        }
        return null;
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubDataset(SubDataset subDataset) {
        this.isSettingSQLExpression = true;
        try {
            this.subDataset = subDataset;
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            dtm.setRowCount(0);
            ++num;
            this.jLabelStatusSQL.setText("");
            this.jRSQLExpressionArea1.setText("");
            try {
                this.automaticlyReadFieldsCheckBox.setSelected(Boolean.valueOf(MainFrame.getMainInstance().getProperties().getProperty("UseAutoRegiesterFields", "true")));
                this.automaticlyReadFieldsCheckBoxActionPerformed(null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (subDataset == null) {
                this.jRSQLExpressionArea1.setText("");
            } else {
                this.jRSQLExpressionArea1.setText(this.subDataset.getQuery());
                ArrayList<Object[]> columns = new ArrayList<Object[]>();
                Iterator i = subDataset.getFields().iterator();
                while (i.hasNext()) {
                    JRField field = (JRField)i.next();
                    columns.add(new Object[]{field, field.getClassType(), field.getDescription()});
                }
                this.setColumns(columns);
                for (int ix = 0; ix < this.jComboBoxQueryType.getItemCount(); ++ix) {
                    if (this.jComboBoxQueryType.getItemAt(ix) instanceof Tag) continue;
                    this.jComboBoxQueryType.removeItemAt(ix);
                    --ix;
                }
                boolean found = false;
                for (int ix = 0; ix < this.jComboBoxQueryType.getItemCount(); ++ix) {
                    Tag t = (Tag)this.jComboBoxQueryType.getItemAt(ix);
                    if (!t.getValue().equals(subDataset.getQueryLanguage())) continue;
                    found = true;
                    this.jComboBoxQueryType.setSelectedIndex(ix);
                    break;
                }
                if (!found) {
                    this.jComboBoxQueryType.setEditable(true);
                    this.jComboBoxQueryType.setSelectedItem(subDataset.getQueryLanguage());
                }
                this.jLabelStatusSQL.setText("");
            }
        }
        finally {
            this.isSettingSQLExpression = false;
        }
    }

    public void applyI18n() {
        this.automaticlyReadFieldsCheckBox.setText(I18n.getString("reportQueryDialog.utomaticlyReadFieldsCheckBox", "Automatically Retrieve Fields"));
        this.cancelButton.setText(I18n.getString("reportQueryDialog.ancelButton", "Cancel"));
        this.exportQueryButton.setText(I18n.getString("reportQueryDialog.xportQueryButton", "Send to clipboard"));
        this.jButton1.setText(I18n.getString("reportQueryDialog.button1", "Filter expression..."));
        this.jButton2.setText(I18n.getString("reportQueryDialog.button2", "Get fields from datasource"));
        this.jButton3.setText(I18n.getString("reportQueryDialog.button3", "Get fields from datasource"));
        this.jButton4.setText(I18n.getString("reportQueryDialog.button4", "Sort options..."));
        this.jButtonLoadQuery.setText(I18n.getString("reportQueryDialog.buttonLoadQuery", "Load query"));
        this.jButtonReadBeanAttributes3.setText(I18n.getString("reportQueryDialog.buttonReadBeanAttributes3", "Read attributes"));
        this.jButtonSaveQuery.setText(I18n.getString("reportQueryDialog.buttonSaveQuery", "Save query"));
        this.jLabel1.setText(I18n.getString("reportQueryDialog.label1", "Query language"));
        this.jLabel3.setText(I18n.getString("reportQueryDialog.label3", "Class name"));
        this.okButton.setText(I18n.getString("reportQueryDialog.kButton", "OK"));
        this.readFieldsButton.setText(I18n.getString("reportQueryDialog.eadFieldsButton", "Read Fields"));
        this.jTableFields.getColumnModel().getColumn(0).setHeaderValue(I18n.getString("reportQueryDialog.tablecolumn.fieldName", "Field name"));
        this.jTableFields.getColumnModel().getColumn(1).setHeaderValue(I18n.getString("reportQueryDialog.tablecolumn.fieldType", "Field type"));
        this.jTableFields.getColumnModel().getColumn(2).setHeaderValue(I18n.getString("reportQueryDialog.tablecolumn.description", "Description"));
        this.jTabbedPane1.setTitleAt(0, I18n.getString("reportQueryDialog.tab.ReportQuery", "Report query"));
        this.jTabbedPane1.setTitleAt(1, I18n.getString("reportQueryDialog.tab.JavaBeanDatasource", "JavaBean Datasource"));
        this.jTabbedPane1.setTitleAt(2, I18n.getString("reportQueryDialog.tab.DataSourceProvider", "DataSource Provider"));
        this.jTabbedPane1.setTitleAt(3, I18n.getString("reportQueryDialog.tab.CSVDatasource", "CSV Datasource"));
        this.setTitle(I18n.getString("reportQueryDialog.title", "Report query"));
        this.cancelButton.setMnemonic(I18n.getString("reportQueryDialog.cancelButtonMnemonic", "c").charAt(0));
        this.okButton.setMnemonic(I18n.getString("reportQueryDialog.okButtonMnemonic", "o").charAt(0));
    }

    public JRSQLExpressionArea getSQLExpressionArea() {
        return this.jRSQLExpressionArea1;
    }

    public JTable getFieldsTable() {
        return this.jTableFields;
    }

    class FieldReader
    extends Thread {
        String src_query;
        String src_query_language = "sql";
        IReportConnection conn;

        public FieldReader(String query, IReportConnection conn) {
            this(query, conn, "sql");
        }

        public FieldReader(String query, IReportConnection conn, String query_language) {
            this.src_query = query;
            this.conn = conn;
            this.src_query_language = query_language;
        }

        public void setColumnsFromWorker(final List columns) {
            try {
                Runnable r = new Runnable(){

                    public void run() {
                        String str = ReportQueryDialog.this.jRSQLExpressionArea1.getText().trim();
                        if (str.compareTo(FieldReader.this.src_query) == 0) {
                            ReportQueryDialog.this.setColumns(columns);
                        }
                    }
                };
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeAndWait(r);
                } else {
                    r.run();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setColumnErrorFromWork(final String error_msg) {
            try {
                Runnable r = new Runnable(){

                    public void run() {
                        String str = ReportQueryDialog.this.jRSQLExpressionArea1.getText().trim();
                        if (str.compareTo(FieldReader.this.src_query) == 0) {
                            ReportQueryDialog.this.setColumnsError(error_msg);
                            ReportQueryDialog.this.jRSQLExpressionArea1.requestFocusInWindow();
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeAndWait(r);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String interpretQuery() {
            String query = this.src_query;
            try {
                Interpreter interpreter = ReportQueryDialog.this.prepareExpressionEvaluator();
                ArrayList queryParams = new ArrayList();
                Enumeration enumParams = ReportQueryDialog.this.subDataset.getParameters().elements();
                while (enumParams.hasMoreElements()) {
                    JRParameter parameter = (JRParameter)enumParams.nextElement();
                    String p1 = "$P{" + parameter.getName() + "}";
                    String p2 = "$P!{" + parameter.getName() + "}";
                    Object defValue = parameter.getDefaultValueExpression() != null && !parameter.getDefaultValueExpression().equals("") ? ReportQueryDialog.recursiveInterpreter(interpreter, parameter.getDefaultValueExpression(), ReportQueryDialog.this.subDataset.getParameters()) : null;
                    int ip1 = query.indexOf(p1);
                    while (ip1 != -1) {
                        if (defValue == null) {
                            throw new IllegalArgumentException("Please set a default value for the parameter '" + parameter.getName() + "'");
                        }
                        String before = query.substring(0, ip1);
                        String after = query.substring(ip1 + p1.length());
                        if (parameter.getClassType().equals("java.lang.String")) {
                            String stt = defValue.toString();
                            stt = Misc.string_replace("''", "'", stt);
                            query = before + "'" + stt + "'" + after;
                        } else {
                            query = before + "" + defValue.toString() + "" + after;
                        }
                        ip1 = query.indexOf(p1);
                    }
                    int ip2 = query.indexOf(p2);
                    while (ip2 != -1) {
                        if (defValue == null) {
                            throw new IllegalArgumentException("Please set a default value for the parameter '" + parameter.getName() + "'");
                        }
                        String before = query.substring(0, ip2);
                        String after = query.substring(ip2 + p2.length());
                        query = before + "" + defValue.toString() + "" + after;
                        ip2 = query.indexOf(p2);
                    }
                }
                return query;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
                return "";
            }
        }

        public void run() {
            String error_msg = "";
            int in = ++num;
            FieldsProvider fp = ReportQueryDialog.this.getFieldsProvider();
            if (fp == null) {
                return;
            }
            if (fp.hasEditorComponent()) {
                FieldsProviderEditor editor = fp.getEditorComponent(ReportQueryDialog.this);
                editor.queryChanged(this.src_query);
            }
            if (in < num) {
                return;
            }
            if (fp.supportsGetFieldsOperation()) {
                try {
                    Report rep = MainFrame.getMainInstance().getActiveReportFrame().getReport();
                    JasperDesign report = new JasperDesign();
                    JRDesignQuery queryDes = new JRDesignQuery();
                    queryDes.setText(this.src_query);
                    queryDes.setLanguage(this.src_query_language);
                    report.setQuery(queryDes);
                    for (int i = 0; i < rep.getJRproperties().size(); ++i) {
                        JRProperty property = (JRProperty)rep.getJRproperties().elementAt(i);
                        report.setProperty(property.getName(), property.getValue());
                    }
                    Interpreter interpreter = ReportQueryDialog.this.prepareExpressionEvaluator();
                    HashMap<String, Object> parametersValues = new HashMap<String, Object>();
                    for (int i = 0; i < rep.getParameters().size(); ++i) {
                        JRParameter ireportParam = (JRParameter)rep.getParameters().elementAt(i);
                        if (ireportParam.isBuiltin()) continue;
                        JRDesignParameter param = new JRDesignParameter();
                        param.setName(ireportParam.getName());
                        JRDesignExpression de = new JRDesignExpression();
                        de.setText(ireportParam.getDefaultValueExpression());
                        de.setValueClassName(ireportParam.getClassType());
                        param.setDefaultValueExpression((JRExpression)de);
                        param.setForPrompting(ireportParam.isIsForPrompting());
                        param.setValueClassName(ireportParam.getClassType());
                        report.addParameter((net.sf.jasperreports.engine.JRParameter)param);
                        Object defValue = ireportParam.getDefaultValueExpression() != null && !ireportParam.getDefaultValueExpression().equals("") ? ReportQueryDialog.recursiveInterpreter(interpreter, ireportParam.getDefaultValueExpression(), ReportQueryDialog.this.subDataset.getParameters()) : null;
                        parametersValues.put(ireportParam.getName(), defValue);
                    }
                    try {
                        report.setName(rep.getName());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (in < num) {
                        return;
                    }
                    net.sf.jasperreports.engine.JRField[] jrFields = fp.getFields(this.conn, report.getMainDataset(), parametersValues);
                    if (in < num) {
                        return;
                    }
                    ArrayList<Object[]> columns = new ArrayList<Object[]>();
                    for (int i = 0; i < jrFields.length; ++i) {
                        JRField field = new JRField(jrFields[i].getName(), jrFields[i].getValueClassName());
                        field.setDescription(jrFields[i].getDescription());
                        columns.add(new Object[]{field, field.getClassType(), field.getDescription()});
                    }
                    if (in < num) {
                        return;
                    }
                    this.setColumnsFromWorker(columns);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.setColumnErrorFromWork("Error: " + ex.getMessage());
                }
                ReportQueryDialog.this.getJLabelStatusSQL().setText("Ready");
            }
        }
    }
}

