/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class JRVariableDialog
extends JDialog {
    JRVariable tmpVariable = null;
    private SubDataset subDataset = null;
    private String originalName = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxCalculationType;
    private JComboBox jComboBoxClassType;
    private JComboBox jComboBoxIncrementGroup;
    private JComboBox jComboBoxIncrementType;
    private JComboBox jComboBoxResetGroup;
    private JComboBox jComboBoxResetType;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JRTextExpressionArea jRTextExpressionAreaExpression;
    private JRTextExpressionArea jRTextExpressionAreaInitialExpression;
    private JTextField jTextFieldName;
    private JTextField jTextFieldNameIncrementerFactoryClass;
    private int dialogResult;

    public JRVariableDialog(SubDataset report, Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSubDataset(report);
        this.updateGroups();
        this.jRTextExpressionAreaExpression.setText("");
        this.jRTextExpressionAreaInitialExpression.setText("");
        this.setTypes();
        this.jComboBoxClassType.setSelectedItem("java.lang.String");
        Misc.setComboboxSelectedTagValue(this.jComboBoxCalculationType, "Nothing");
        Misc.setComboboxSelectedTagValue(this.jComboBoxResetType, "Report");
        Misc.setComboboxSelectedTagValue(this.jComboBoxIncrementType, "None");
        this.updateGroups();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRVariableDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.applyI18n();
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.pack();
    }

    public void setTypes() {
        this.jComboBoxClassType.addItem("java.lang.String");
        this.jComboBoxClassType.addItem("java.lang.Object");
        this.jComboBoxClassType.addItem("java.lang.Boolean");
        this.jComboBoxClassType.addItem("java.lang.Byte");
        this.jComboBoxClassType.addItem("java.util.Date");
        this.jComboBoxClassType.addItem("java.sql.Timestamp");
        this.jComboBoxClassType.addItem("java.sql.Time");
        this.jComboBoxClassType.addItem("java.lang.Double");
        this.jComboBoxClassType.addItem("java.lang.Float");
        this.jComboBoxClassType.addItem("java.lang.Integer");
        this.jComboBoxClassType.addItem("java.io.InputStream");
        this.jComboBoxClassType.addItem("java.lang.Long");
        this.jComboBoxClassType.addItem("java.lang.Short");
        this.jComboBoxClassType.addItem("java.math.BigDecimal");
        this.jComboBoxClassType.addItem("net.sf.jasperreports.engine.JREmptyDataSource");
        this.jComboBoxCalculationType.addItem(new Tag("Nothing", I18n.getString("variable.calculationType.Nothing", "Nothing")));
        this.jComboBoxCalculationType.addItem(new Tag("Count", I18n.getString("variable.calculationType.Count", "Count")));
        this.jComboBoxCalculationType.addItem(new Tag("DistinctCount", I18n.getString("variable.calculationType.DistinctCount", "Distinct count")));
        this.jComboBoxCalculationType.addItem(new Tag("Sum", I18n.getString("variable.calculationType.Sum", "Sum")));
        this.jComboBoxCalculationType.addItem(new Tag("Average", I18n.getString("variable.calculationType.Average", "Average")));
        this.jComboBoxCalculationType.addItem(new Tag("Lowest", I18n.getString("variable.calculationType.Lowest", "Lowest")));
        this.jComboBoxCalculationType.addItem(new Tag("Highest", I18n.getString("variable.calculationType.Highest", "Highest")));
        this.jComboBoxCalculationType.addItem(new Tag("StandardDeviation", I18n.getString("variable.calculationType.StandardDeviation", "Standard deviation")));
        this.jComboBoxCalculationType.addItem(new Tag("Variance", I18n.getString("variable.calculationType.Variance", "Variance")));
        this.jComboBoxCalculationType.addItem(new Tag("System", I18n.getString("variable.calculationType.System", "System")));
        this.jComboBoxCalculationType.addItem(new Tag("First", I18n.getString("variable.calculationType.First", "First")));
        this.jComboBoxResetType.addItem(new Tag("None", I18n.getString("resetType.None", "None")));
        this.jComboBoxResetType.addItem(new Tag("Report", I18n.getString("resetType.Report", "Report")));
        this.jComboBoxResetType.addItem(new Tag("Page", I18n.getString("resetType.Page", "Page")));
        this.jComboBoxResetType.addItem(new Tag("Column", I18n.getString("resetType.Column", "Column")));
        this.jComboBoxResetType.addItem(new Tag("Group", I18n.getString("resetType.Group", "Group")));
        this.jComboBoxIncrementType.addItem(new Tag("None", I18n.getString("incrementType.None", "None")));
        this.jComboBoxIncrementType.addItem(new Tag("Report", I18n.getString("incrementType.Report", "Report")));
        this.jComboBoxIncrementType.addItem(new Tag("Page", I18n.getString("incrementType.Page", "Page")));
        this.jComboBoxIncrementType.addItem(new Tag("Column", I18n.getString("incrementType.Column", "Column")));
        this.jComboBoxIncrementType.addItem(new Tag("Group", I18n.getString("incrementType.Group", "Group")));
    }

    public void updateGroups() {
        if (this.getSubDataset() == null) {
            this.jComboBoxResetGroup.removeAllItems();
            this.jComboBoxResetGroup.addItem("");
        } else {
            Misc.updateStringComboBox(this.jComboBoxResetGroup, this.getSubDataset().getGroups(), false);
            Misc.updateStringComboBox(this.jComboBoxIncrementGroup, this.getSubDataset().getGroups(), false);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBoxResetGroup = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBoxResetType = new JComboBox();
        this.jComboBoxCalculationType = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jComboBoxClassType = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jRTextExpressionAreaExpression = new JRTextExpressionArea();
        this.jRTextExpressionAreaInitialExpression = new JRTextExpressionArea();
        this.jLabel8 = new JLabel();
        this.jTextFieldNameIncrementerFactoryClass = new JTextField();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jComboBoxIncrementType = new JComboBox();
        this.jComboBoxIncrementGroup = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify variable");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRVariableDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Variable name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel2.setText("Calculation type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxResetGroup, gridBagConstraints);
        this.jLabel3.setText("Variable expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Initial value expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Variable class type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.jComboBoxResetType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRVariableDialog.this.jComboBoxResetTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxResetType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxCalculationType, gridBagConstraints);
        this.jLabel6.setText("Reset group");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.jComboBoxClassType.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxClassType, gridBagConstraints);
        this.jLabel7.setText("Reset type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel7, gridBagConstraints);
        this.jRTextExpressionAreaExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaExpression.setCaretVisible(false);
        this.jRTextExpressionAreaExpression.setElectricScroll(0);
        this.jRTextExpressionAreaExpression.setMinimumSize(new Dimension(657, 100));
        this.jRTextExpressionAreaExpression.setNextFocusableComponent(this.jRTextExpressionAreaInitialExpression);
        this.jRTextExpressionAreaExpression.setPreferredSize(new Dimension(325, 70));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jRTextExpressionAreaExpression, gridBagConstraints);
        this.jRTextExpressionAreaInitialExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaInitialExpression.setCaretVisible(false);
        this.jRTextExpressionAreaInitialExpression.setElectricScroll(0);
        this.jRTextExpressionAreaInitialExpression.setFont(new Font("Tahoma", 0, 12));
        this.jRTextExpressionAreaInitialExpression.setMinimumSize(new Dimension(657, 100));
        this.jRTextExpressionAreaInitialExpression.setPreferredSize(new Dimension(325, 70));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jRTextExpressionAreaInitialExpression, gridBagConstraints);
        this.jLabel8.setText("Custom Incrementer Factory Class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        this.jTextFieldNameIncrementerFactoryClass.setNextFocusableComponent(this.jRTextExpressionAreaExpression);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldNameIncrementerFactoryClass, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRVariableDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRVariableDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel9.setText("Increment type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setText("Increment group");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel10, gridBagConstraints);
        this.jComboBoxIncrementType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRVariableDialog.this.jComboBoxIncrementTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxIncrementType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxIncrementGroup, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jComboBoxIncrementTypeActionPerformed(ActionEvent evt) {
        Object t = this.jComboBoxIncrementType.getSelectedItem();
        String val = t + "";
        if (t != null && t instanceof Tag) {
            val = "" + ((Tag)t).getValue();
        }
        this.jComboBoxIncrementGroup.setEnabled(val.equals("Group"));
        if (this.jComboBoxIncrementGroup.isEnabled() && this.jComboBoxIncrementGroup.getSelectedItem() == null && this.jComboBoxIncrementGroup.getItemCount() > 0) {
            this.jComboBoxIncrementGroup.setSelectedIndex(0);
        }
    }

    private void jComboBoxResetTypeActionPerformed(ActionEvent evt) {
        Object t = this.jComboBoxResetType.getSelectedItem();
        String val = t + "";
        if (t != null && t instanceof Tag) {
            val = "" + ((Tag)t).getValue();
        }
        this.jComboBoxResetGroup.setEnabled(val.equals("Group"));
        if (this.jComboBoxResetGroup.isEnabled() && this.jComboBoxResetGroup.getSelectedItem() == null && this.jComboBoxResetGroup.getItemCount() > 0) {
            this.jComboBoxResetGroup.setSelectedIndex(0);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.jRVariableDialog.notValidName", "Please insert a valid variable name!"), I18n.getString("messages.jRVariableDialog.notValidNameCaption", "Invalid variable!"), 2);
            return;
        }
        this.tmpVariable = new JRVariable(this.jTextFieldName.getText(), false);
        this.tmpVariable.setClassType(this.jComboBoxClassType.getSelectedItem() + "");
        Object t = this.jComboBoxCalculationType.getSelectedItem();
        if (t != null && t instanceof Tag) {
            this.tmpVariable.setCalculation(((Tag)t).getValue() + "");
        }
        if ((t = this.jComboBoxResetType.getSelectedItem()) != null && t instanceof Tag) {
            this.tmpVariable.setResetType(((Tag)t).getValue() + "");
        }
        if ((t = this.jComboBoxIncrementType.getSelectedItem()) != null && t instanceof Tag) {
            this.tmpVariable.setIncrementType(((Tag)t).getValue() + "");
        }
        this.tmpVariable.setIncrementerFactoryClass(this.jTextFieldNameIncrementerFactoryClass.getText());
        if (this.jComboBoxClassType.getSelectedItem().toString().trim().length() == 0) {
            this.tmpVariable.setClassType("java.lang.String");
        } else {
            this.tmpVariable.setClassType(this.jComboBoxClassType.getSelectedItem().toString().trim());
        }
        if (this.tmpVariable.getResetType().equals("Group")) {
            if (this.jComboBoxResetGroup.getSelectedItem() == null || this.jComboBoxResetGroup.getSelectedItem().equals("")) {
                JOptionPane.showMessageDialog(this, I18n.getString("messages.jRVariableDialog.notValidGroup", "Please choose a valid group for the reset type selected!"), I18n.getString("messages.jRVariableDialog.notValidGroupCaption", "Invalid group!"), 2);
                return;
            }
            this.tmpVariable.setResetGroup(this.jComboBoxResetGroup.getSelectedItem() + "");
        }
        if (this.tmpVariable.getIncrementType().equals("Group")) {
            if (this.jComboBoxIncrementGroup.getSelectedItem() == null || this.jComboBoxIncrementGroup.getSelectedItem().equals("")) {
                JOptionPane.showMessageDialog(this, I18n.getString("messages.jRVariableDialog.notValidGroupIncrementType", "Please choose a valid group for the increment type selected!"), I18n.getString("messages.jRVariableDialog.notValidGroupIncrementTypeCaption", "Invalid group!"), 2);
                return;
            }
            this.tmpVariable.setIncrementGroup(this.jComboBoxIncrementGroup.getSelectedItem() + "");
        }
        if (this.getSubDataset() != null) {
            String newName = this.jTextFieldName.getText();
            if (this.getOriginalName() == null || !this.getOriginalName().equals(newName)) {
                for (int i = 0; i < this.getSubDataset().getVariables().size(); ++i) {
                    JRVariable f = (JRVariable)this.getSubDataset().getVariables().get(i);
                    if (!f.getName().equals(newName)) continue;
                    JOptionPane.showMessageDialog(this, I18n.getString("messages.JRVariableDialog.DuplicatedVariableName", "A variable with this name already exists!"), I18n.getString("messages.JRVariableDialog.notValidVariableNameCaption", "Invalid variable!"), 2);
                    return;
                }
            }
        }
        this.tmpVariable.setExpression(this.jRTextExpressionAreaExpression.getText());
        this.tmpVariable.setInitialValueExpression(this.jRTextExpressionAreaInitialExpression.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRParameterDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public JRVariable getVariable() {
        return this.tmpVariable;
    }

    public void setVariable(JRVariable tmpVariable) {
        this.originalName = tmpVariable.getName();
        this.jTextFieldName.setText(new String(tmpVariable.getName()));
        this.jComboBoxClassType.setSelectedItem(new String(tmpVariable.getClassType()));
        Misc.setComboboxSelectedTagValue(this.jComboBoxResetType, tmpVariable.getResetType());
        Misc.setComboboxSelectedTagValue(this.jComboBoxIncrementType, tmpVariable.getIncrementType());
        Misc.setComboboxSelectedTagValue(this.jComboBoxCalculationType, tmpVariable.getCalculation());
        this.jComboBoxResetGroup.setSelectedItem(tmpVariable.getResetGroup());
        this.jComboBoxIncrementGroup.setSelectedItem(tmpVariable.getIncrementGroup());
        this.jRTextExpressionAreaExpression.setText(new String(tmpVariable.getExpression()));
        this.jRTextExpressionAreaInitialExpression.setText(new String(tmpVariable.getInitialValueExpression()));
        this.jTextFieldNameIncrementerFactoryClass.setText(new String(tmpVariable.getIncrementerFactoryClass()));
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
        this.jRTextExpressionAreaExpression.setSubDataset(subDataset);
        this.jRTextExpressionAreaInitialExpression.setSubDataset(subDataset);
        this.jRTextExpressionAreaExpression.getTokenMarker().setKeywordLookup(subDataset.getKeywordLookup());
        this.jRTextExpressionAreaInitialExpression.getTokenMarker().setKeywordLookup(subDataset.getKeywordLookup());
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("jRVariableDialog.buttonCancel", "Cancel"));
        this.jButtonOK.setText(I18n.getString("jRVariableDialog.buttonOK", "OK"));
        this.jLabel1.setText(I18n.getString("jRVariableDialog.label1", "Variable name"));
        this.jLabel10.setText(I18n.getString("jRVariableDialog.label10", "Increment group"));
        this.jLabel2.setText(I18n.getString("jRVariableDialog.label2", "Calculation type"));
        this.jLabel3.setText(I18n.getString("jRVariableDialog.label3", "Variable expression"));
        this.jLabel4.setText(I18n.getString("jRVariableDialog.label4", "Initial value expression"));
        this.jLabel5.setText(I18n.getString("jRVariableDialog.label5", "Variable class type"));
        this.jLabel6.setText(I18n.getString("jRVariableDialog.label6", "Reset group"));
        this.jLabel7.setText(I18n.getString("jRVariableDialog.label7", "Reset type"));
        this.jLabel8.setText(I18n.getString("jRVariableDialog.label8", "Custom Incrementer Factory Class"));
        this.jLabel9.setText(I18n.getString("jRVariableDialog.label9", "Increment type"));
        this.setTitle(I18n.getString("jRVariableDialog.title", "Add/modify variable"));
        this.jButtonCancel.setMnemonic(I18n.getString("jRVariableDialog.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonOK.setMnemonic(I18n.getString("jRVariableDialog.buttonOKMnemonic", "o").charAt(0));
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }
}

