/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.util.Misc;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class JavaBeanDataSourceConnection
extends IReportConnection {
    public static String BEAN_ARRAY = "BEAN_ARRAY";
    public static String BEAN_COLLECTION = "BEAN_COLLECTION";
    private String name;
    private String factoryClass;
    private String methodToCall;
    private boolean useFieldDescription;
    private String type = "BEAN_COLLECTION";

    public Connection getConnection() {
        return null;
    }

    public boolean isJDBCConnection() {
        return false;
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("FactoryClass", Misc.nvl(this.getFactoryClass(), ""));
        map.put("MethodToCall", Misc.nvl(this.getMethodToCall(), ""));
        map.put("Type", Misc.nvl(this.getType(), ""));
        map.put("UseFieldDescription", "" + this.isUseFieldDescription());
        return map;
    }

    public void loadProperties(HashMap map) {
        this.setFactoryClass((String)map.get("FactoryClass"));
        this.setMethodToCall((String)map.get("MethodToCall"));
        if (map.containsKey("UseFieldDescription")) {
            this.setUseFieldDescription(((String)map.get("UseFieldDescription")).equals("true"));
        }
        if (map.containsKey("Type")) {
            this.setType((String)map.get("Type"));
        }
    }

    public String getDescription() {
        return "JavaBean set datasource";
    }

    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    public String getFactoryClass() {
        return this.factoryClass;
    }

    public void setFactoryClass(String factoryClass) {
        this.factoryClass = factoryClass;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public JRDataSource getJRDataSource() {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.factoryClass);
            Object obj = clazz.newInstance();
            Object return_obj = obj.getClass().getMethod(this.methodToCall, new Class[0]).invoke(null, new Object[0]);
            if (return_obj != null) {
                if (Misc.nvl(this.getType(), "").equals(BEAN_ARRAY)) {
                    return new JRBeanArrayDataSource((Object[])return_obj, this.isUseFieldDescription());
                }
                if (Misc.nvl(this.getType(), "").equals(BEAN_COLLECTION)) {
                    return new JRBeanCollectionDataSource((Collection)return_obj, this.isUseFieldDescription());
                }
            }
            return new JREmptyDataSource();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return super.getJRDataSource();
        }
    }

    public boolean isUseFieldDescription() {
        return this.useFieldDescription;
    }

    public void setUseFieldDescription(boolean useFieldDescription) {
        this.useFieldDescription = useFieldDescription;
    }
}

