/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.BoxElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import java.awt.Graphics2D;

public class FrameReportElement
extends ReportElement
implements BoxElement {
    private Box box = null;

    public FrameReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setBox(new Box());
        this.setKey("frame");
        this.transparentDefault = "Transparent";
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.position.x -= 10;
        this.position.y -= 10;
        x_shift_origin -= 10;
        y_shift_origin -= 10;
        this.zoom_factor = zoom_factor;
        g.setColor(this.getBgcolor());
        if (!this.getTransparent().equalsIgnoreCase("Transparent")) {
            g.fillRoundRect(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.width), this.getZoomedDim(this.height), 0, 0);
        }
        g.setColor(this.getFgcolor());
        this.position.x += 10;
        this.position.y += 10;
        this.drawBorder(g, zoom_factor, x_shift_origin += 10, y_shift_origin += 10);
        this.drawBorder(g, zoom_factor, x_shift_origin, y_shift_origin, this.getBox());
    }

    public ReportElement cloneMe() {
        FrameReportElement newReportElement = new FrameReportElement(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof BoxElement && source instanceof BoxElement) {
            ((BoxElement)((Object)destination)).setBox(((BoxElement)((Object)source)).getBox().cloneMe());
        }
    }

    public Box getBox() {
        return this.box;
    }

    public void setBox(Box box) {
        this.box = box;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        if (style != null) {
            if (style.getAttributeString("border", null, true) != null) {
                this.getBox().setBorder(style.getAttributeString("border", null, true));
            }
            if (style.getAttributeColor("borderColor", null, true) != null) {
                this.getBox().setBorderColor(style.getAttributeColor("borderColor", null, true));
            }
            if (style.getAttributeString("padding", null, true) != null) {
                this.getBox().setPadding(Integer.parseInt(style.getAttributeString("padding", null, true)));
            }
            if (style.getAttributeString("topBorder", null, true) != null) {
                this.getBox().setTopBorder(style.getAttributeString("topBorder", null, true));
            }
            if (style.getAttributeColor("topBorderColor", null, true) != null) {
                this.getBox().setTopBorderColor(style.getAttributeColor("topBorderColor", null, true));
            }
            if (style.getAttributeString("topPadding", null, true) != null) {
                this.getBox().setTopPadding(Integer.parseInt(style.getAttributeString("topPadding", null, true)));
            }
            if (style.getAttributeString("leftBorder", null, true) != null) {
                this.getBox().setLeftBorder(style.getAttributeString("leftBorder", null, true));
            }
            if (style.getAttributeColor("leftBorderColor", null, true) != null) {
                this.getBox().setLeftBorderColor(style.getAttributeColor("leftBorderColor", null, true));
            }
            if (style.getAttributeString("leftPadding", null, true) != null) {
                this.getBox().setLeftPadding(Integer.parseInt(style.getAttributeString("leftPadding", null, true)));
            }
            if (style.getAttributeString("rightBorder", null, true) != null) {
                this.getBox().setRightBorder(style.getAttributeString("rightBorder", null, true));
            }
            if (style.getAttributeColor("rightBorderColor", null, true) != null) {
                this.getBox().setRightBorderColor(style.getAttributeColor("rightBorderColor", null, true));
            }
            if (style.getAttributeString("rightPadding", null, true) != null) {
                this.getBox().setRightPadding(Integer.parseInt(style.getAttributeString("rightPadding", null, true)));
            }
            if (style.getAttributeString("bottomBorder", null, true) != null) {
                this.getBox().setBottomBorder(style.getAttributeString("bottomBorder", null, true));
            }
            if (style.getAttributeColor("bottomBorderColor", null, true) != null) {
                this.getBox().setBottomBorderColor(style.getAttributeColor("bottomBorderColor", null, true));
            }
            if (style.getAttributeString("bottomPadding", null, true) != null) {
                this.getBox().setBottomPadding(Integer.parseInt(style.getAttributeString("bottomPadding", null, true)));
            }
        }
    }
}

