/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpCacheDescriptor;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.Type;

public class CacheFunDef
extends FunDefBase {
    private final Type type;
    private static final String NAME = "$Cache";
    private static final String SIGNATURE = "$Cache(<<Exp>>)";
    private static final String DESCRIPTION = "Evaluates and returns its sole argument, applying statement-level caching";
    private static final Syntax SYNTAX;
    private ExpCacheDescriptor cacheDescriptor;
    static final /* synthetic */ boolean $assertionsDisabled;

    CacheFunDef(String name, String signature, String description, Syntax syntax, int category, Type type) {
        super(name, signature, description, syntax, category, new int[]{category});
        this.type = type;
    }

    public void unparse(Exp[] args, PrintWriter pw) {
        args[0].unparse(pw);
    }

    public Object evaluate(Evaluator evaluator, Exp[] args) {
        if (this.cacheDescriptor == null) {
            this.cacheDescriptor = new ExpCacheDescriptor(args[0], evaluator);
        } else if (!$assertionsDisabled && args[0] != this.cacheDescriptor.getExp()) {
            throw new AssertionError();
        }
        Object o = evaluator.getCachedResult(this.cacheDescriptor);
        return o;
    }

    static {
        $assertionsDisabled = !CacheFunDef.class.desiredAssertionStatus();
        SYNTAX = Syntax.Internal;
    }

    public static class CacheFunResolver
    extends ResolverBase {
        CacheFunResolver() {
            super(CacheFunDef.NAME, CacheFunDef.SIGNATURE, CacheFunDef.DESCRIPTION, SYNTAX);
        }

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            if (args.length != 1) {
                return null;
            }
            Exp exp = args[0];
            int category = exp.getCategory();
            Type type = exp.getTypeX();
            return new CacheFunDef(CacheFunDef.NAME, CacheFunDef.SIGNATURE, CacheFunDef.DESCRIPTION, SYNTAX, category, type);
        }

        public boolean requiresExpression(int k) {
            return false;
        }
    }
}

