/*
 * Copyright (C) 2005 - 2006 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * SubDatasetDialog.java
 * 
 * Created on 5 dicembre 2005, 20.17
 *
 */

package it.businesslogic.ireport.gui.subdataset;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.PropertiesDialog;
import it.businesslogic.ireport.gui.ReportQueryDialog;
import it.businesslogic.ireport.gui.ValuesDialog;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedEvent;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.Misc;
import java.util.Enumeration;
import it.businesslogic.ireport.util.I18n;
/**
 *
 * @author  Administrator
 */
public class SubDatasetDialog extends javax.swing.JDialog {
    
    
    private SubDataset subDataset = null;
    private int dialogResult = javax.swing.JOptionPane.CANCEL_OPTION;
    
    /** Creates new form SubDatasetDialog */
    public SubDatasetDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        afterInit();
    }
    
    public SubDatasetDialog(java.awt.Dialog parent, boolean modal) {
        super(parent, modal);
        initComponents();
        afterInit();
    }
    
    public void afterInit()
    {
        //this.setSize(620, 320);
        
        this.pack();
        // Open in center...
        it.businesslogic.ireport.util.Misc.centerFrame(this);
        
        this.jComboBoxWhenResourceMissingType.addItem(new Tag("Null",it.businesslogic.ireport.util.I18n.getString("whenResourceMissingType.Null","Null")));
        this.jComboBoxWhenResourceMissingType.addItem(new Tag("Empty",it.businesslogic.ireport.util.I18n.getString("whenResourceMissingType.Empty","Empty")));
        this.jComboBoxWhenResourceMissingType.addItem(new Tag("Key",it.businesslogic.ireport.util.I18n.getString("whenResourceMissingType.Key","Key")));
        this.jComboBoxWhenResourceMissingType.addItem(new Tag("Error",it.businesslogic.ireport.util.I18n.getString("whenResourceMissingType.Error","Error")));

        applyI18n();
        
        it.businesslogic.ireport.util.Misc.setComboboxSelectedTagValue(jComboBoxWhenResourceMissingType, "Null"); 
        
        
        boolean found = true;
        for (int i=1; found; ++i)
        {
            found = false;
            Enumeration e = it.businesslogic.ireport.gui.MainFrame.getMainInstance().getActiveReportFrame().getReport().getSubDatasets().elements();
            while (e.hasMoreElements() && !found)
            {
                SubDataset dataset = (SubDataset)e.nextElement();
                if (dataset.getName().equals("SubDataset" + i))
                {
                    found = true;
                }
            }
            if (!found)
            {
                jTextFieldName.setText("SubDataset" + i);
            }
        }
        
        jTextFieldResourceBoundle.setText( it.businesslogic.ireport.gui.MainFrame.getMainInstance().getActiveReportFrame().getReport().getResourceBundleBaseName());
        
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel4 = new javax.swing.JPanel();
        jLabelName = new javax.swing.JLabel();
        jTextFieldName = new javax.swing.JTextField();
        jLabelResourceBoundle = new javax.swing.JLabel();
        jTextFieldResourceBoundle = new javax.swing.JTextField();
        jLabelScriptletClass = new javax.swing.JLabel();
        jTextFieldScriptletClass = new javax.swing.JTextField();
        jLabelWhenResourceMissingType = new javax.swing.JLabel();
        jComboBoxWhenResourceMissingType = new javax.swing.JComboBox();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jButtonOk = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jLabelScriptletClass1 = new javax.swing.JLabel();
        jRTextExpressionAreaFilterExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jPanel1 = new javax.swing.JPanel();
        jButtonFields = new javax.swing.JButton();
        jButtonVariables = new javax.swing.JButton();
        jButtonParameters = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();
        jButtonQuery = new javax.swing.JButton();
        jButtonGroups = new javax.swing.JButton();
        jSeparator2 = new javax.swing.JSeparator();
        jButtonProperties = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("SubDataset");
        jPanel4.setLayout(new java.awt.GridBagLayout());

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Subdataset properties", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
        jLabelName.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelName.setText("Datasource name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 0);
        jPanel4.add(jLabelName, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanel4.add(jTextFieldName, gridBagConstraints);

        jLabelResourceBoundle.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelResourceBoundle.setText("Resource Boundle");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(16, 4, 0, 0);
        jPanel4.add(jLabelResourceBoundle, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(16, 4, 4, 4);
        jPanel4.add(jTextFieldResourceBoundle, gridBagConstraints);

        jLabelScriptletClass.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelScriptletClass.setText("Scriptlet class");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(16, 4, 4, 0);
        jPanel4.add(jLabelScriptletClass, gridBagConstraints);

        jTextFieldScriptletClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldScriptletClassActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(16, 4, 4, 4);
        jPanel4.add(jTextFieldScriptletClass, gridBagConstraints);

        jLabelWhenResourceMissingType.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelWhenResourceMissingType.setText("When resource missing type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 0);
        jPanel4.add(jLabelWhenResourceMissingType, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanel4.add(jComboBoxWhenResourceMissingType, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/subdatasource.png")));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 4);
        jPanel2.add(jLabel1, gridBagConstraints);

        jButtonOk.setText("Create");
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 4, 4);
        jPanel2.add(jButtonOk, gridBagConstraints);

        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 4, 4);
        jPanel2.add(jButtonCancel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add(jPanel2, gridBagConstraints);

        jLabelScriptletClass1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelScriptletClass1.setText("Filter expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 0);
        jPanel4.add(jLabelScriptletClass1, gridBagConstraints);
        jLabelScriptletClass1.getAccessibleContext().setAccessibleName("Filter expression");

        jRTextExpressionAreaFilterExpression.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jRTextExpressionAreaFilterExpression.setCaretVisible(false);
        jRTextExpressionAreaFilterExpression.setElectricScroll(0);
        jRTextExpressionAreaFilterExpression.setMinimumSize(new java.awt.Dimension(657, 50));
        jRTextExpressionAreaFilterExpression.setPreferredSize(new java.awt.Dimension(325, 100));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
        jPanel4.add(jRTextExpressionAreaFilterExpression, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jPanel4, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder()));
        jButtonFields.setText("Fields");
        jButtonFields.setEnabled(false);
        jButtonFields.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFieldsActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jButtonFields, gridBagConstraints);

        jButtonVariables.setText("Variables");
        jButtonVariables.setEnabled(false);
        jButtonVariables.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonVariablesActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jButtonVariables, gridBagConstraints);

        jButtonParameters.setText("Parameters");
        jButtonParameters.setEnabled(false);
        jButtonParameters.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonParametersActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jButtonParameters, gridBagConstraints);

        jSeparator1.setMinimumSize(new java.awt.Dimension(0, 2));
        jSeparator1.setPreferredSize(new java.awt.Dimension(2, 2));
        jSeparator1.setRequestFocusEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        jPanel1.add(jSeparator1, gridBagConstraints);

        jButtonQuery.setText("Query");
        jButtonQuery.setEnabled(false);
        jButtonQuery.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonQueryActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jButtonQuery, gridBagConstraints);

        jButtonGroups.setText("Groups");
        jButtonGroups.setEnabled(false);
        jButtonGroups.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonGroupsActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jButtonGroups, gridBagConstraints);

        jSeparator2.setMinimumSize(new java.awt.Dimension(0, 2));
        jSeparator2.setPreferredSize(new java.awt.Dimension(2, 2));
        jSeparator2.setRequestFocusEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        jPanel1.add(jSeparator2, gridBagConstraints);

        jButtonProperties.setText("Properties");
        jButtonProperties.setEnabled(false);
        jButtonProperties.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonParametersActionPerformed1(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jButtonProperties, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jPanel6, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 4, 6, 4);
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jTextFieldScriptletClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldScriptletClassActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldScriptletClassActionPerformed

    private void jButtonParametersActionPerformed1(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonParametersActionPerformed1

            PropertiesDialog pd = new PropertiesDialog(this, true);
            pd.setDataset( this.getSubDataset() );
            pd.updateProperties();
            
            pd.setVisible(true);
        
        
    }//GEN-LAST:event_jButtonParametersActionPerformed1

    private void jButtonGroupsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonGroupsActionPerformed
        GroupsDialog grd = new GroupsDialog(this, true);
        grd.setSubDataset( this.getSubDataset());
        grd.setVisible(true); 
    }//GEN-LAST:event_jButtonGroupsActionPerformed

    private void jButtonQueryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonQueryActionPerformed

        ReportQueryDialog rqd = new ReportQueryDialog(MainFrame.getMainInstance(), true);
        rqd.setSubDataset( this.getSubDataset());
        rqd.setVisible(true);        
    }//GEN-LAST:event_jButtonQueryActionPerformed

    private void jButtonParametersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonParametersActionPerformed
        openValuesDialog("Parameters");
    }//GEN-LAST:event_jButtonParametersActionPerformed

    private void jButtonVariablesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonVariablesActionPerformed
        openValuesDialog("Variables");
    }//GEN-LAST:event_jButtonVariablesActionPerformed

    private void jButtonFieldsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFieldsActionPerformed

        openValuesDialog("Fields");
        
    }//GEN-LAST:event_jButtonFieldsActionPerformed

    public void openValuesDialog(String tab)
    {
        ValuesDialog vd = new ValuesDialog(this, true);
        vd.getValuesPanel().setSubDataset( getSubDataset() );
        vd.setTitle(getSubDataset() + ": values");
        vd.getValuesPanel().gotoTab(tab);
        getSubDataset().addSubDatasetObjectChangedListener( vd );
        vd.setVisible(true);
        getSubDataset().removeSubDatasetObjectChangedListener( vd );
    }
    
    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed

        this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        setVisible(false);
        dispose();
        
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed

        if (this.jTextFieldName.getText().trim().length() <= 0)
        {
            javax.swing.JOptionPane.showMessageDialog(this,
                    I18n.getString( "messages.subDatasetDialog.notValidName","Please insert a valid SubDataset name!"),
                    I18n.getString( "messages.subDatasetDialog.notValidNameCaption","Invalid name!"),
                    javax.swing.JOptionPane.WARNING_MESSAGE );
            return;
        }
        
        String newName = this.jTextFieldName.getText().trim();
        // check for duplicate name....
        Enumeration e = it.businesslogic.ireport.gui.MainFrame.getMainInstance().getActiveReportFrame().getReport().getSubDatasets().elements();
        while (e.hasMoreElements())
        {
            SubDataset dataset = (SubDataset)e.nextElement();
            if (dataset.getName().equals(newName) && dataset != getSubDataset())
            {
                javax.swing.JOptionPane.showMessageDialog(this,
                        I18n.getFormattedString( "messages.subDatasetDialog.nameAlreadyInUse","The name \"{0}\" is already in use!\nPlease change it.", new Object[]{newName}),
                        I18n.getString( "messages.subDatasetDialog.notValidNameCaption","Invalid name!"),javax.swing.JOptionPane.WARNING_MESSAGE );
                return;
            }
        }

        if (getSubDataset() == null)
        {
            this.subDataset = new SubDataset();
        }
        
        SubDataset subdataset = getSubDataset();
        subdataset.setName( jTextFieldName.getText() );
        subdataset.setScriptletClass( jTextFieldScriptletClass.getText());
        subdataset.setResourceBundleBaseName( jTextFieldResourceBoundle.getText());
        subdataset.setFilterExpression( jRTextExpressionAreaFilterExpression.getText());
        
        if (jComboBoxWhenResourceMissingType.getSelectedItem() != null)
        {
            Tag val = (Tag)jComboBoxWhenResourceMissingType.getSelectedItem();
            subdataset.setWhenResourceMissingType( val.getValue()+"" );
        }
        
        if (this.jButtonOk.getText().equals(I18n.getString("subDatasetDialog.buttonCreate","Create")))
        {
            if (this.getParent() instanceof SubDatasetsDialog)
            {
                ((SubDatasetsDialog)this.getParent()).addSubDataset( this.getSubDataset());
            }    
            this.setSubDataset(subdataset);
            MainFrame.getMainInstance().getActiveReportFrame().getReport().addSubDataset(subdataset);
            return;
        }
        else
        {
            MainFrame.getMainInstance().getActiveReportFrame().getReport().fireReportSubDatasetChangedListenerReportSubDatasetChanged(
                        new ReportSubDatasetChangedEvent(
                            MainFrame.getMainInstance().getActiveReportFrame().getReport(),
                            getSubDataset(),
                            ReportSubDatasetChangedEvent.CHANGED,
                            ReportSubDatasetChangedEvent.OBJECT_SUBDATASET) );
        }
        MainFrame.getMainInstance().getActiveReportFrame().getReport().incrementReportChanges();
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        setVisible(false);
        dispose();
        
    }//GEN-LAST:event_jButtonOkActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new SubDatasetDialog(new javax.swing.JFrame(), true).setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonFields;
    private javax.swing.JButton jButtonGroups;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JButton jButtonParameters;
    private javax.swing.JButton jButtonProperties;
    private javax.swing.JButton jButtonQuery;
    private javax.swing.JButton jButtonVariables;
    private javax.swing.JComboBox jComboBoxWhenResourceMissingType;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabelName;
    private javax.swing.JLabel jLabelResourceBoundle;
    private javax.swing.JLabel jLabelScriptletClass;
    private javax.swing.JLabel jLabelScriptletClass1;
    private javax.swing.JLabel jLabelWhenResourceMissingType;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel6;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaFilterExpression;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JTextField jTextFieldName;
    private javax.swing.JTextField jTextFieldResourceBoundle;
    private javax.swing.JTextField jTextFieldScriptletClass;
    // End of variables declaration//GEN-END:variables

    public SubDataset getSubDataset() {
        return subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
        this.jTextFieldName.setText( subDataset.getName());
        this.jTextFieldScriptletClass.setText( subDataset.getScriptletClass() );
        this.jTextFieldResourceBoundle.setText( subDataset.getResourceBundleBaseName() );
        this.jRTextExpressionAreaFilterExpression.setText( subDataset.getFilterExpression() );
        if (subDataset != null)
        {
            jRTextExpressionAreaFilterExpression.setSubDataset( subDataset );
        }
        
        Misc.setComboboxSelectedTagValue( jComboBoxWhenResourceMissingType, subDataset.getWhenResourceMissingType());
        jButtonFields.setEnabled( true );
        jButtonVariables.setEnabled( true );
        jButtonParameters.setEnabled( true );
        jButtonQuery.setEnabled( true );
        jButtonGroups.setEnabled( true );
        jButtonProperties.setEnabled( true );
        this.jButtonOk.setText(I18n.getString("subDatasetDialog.buttonOk","Ok"));
    }

    public int getDialogResult() {
        return dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jButtonCancel.setText(I18n.getString("subDatasetDialog.buttonCancel","Cancel"));
                jButtonFields.setText(I18n.getString("subDatasetDialog.buttonFields","Fields"));
                jButtonGroups.setText(I18n.getString("subDatasetDialog.buttonGroups","Groups"));
                jButtonOk.setText(I18n.getString("subDatasetDialog.buttonCreate","Create"));
                jButtonParameters.setText(I18n.getString("subDatasetDialog.buttonParameters","Parameters"));
                jButtonProperties.setText(I18n.getString("subDatasetDialog.buttonProperties","Properties"));
                jButtonQuery.setText(I18n.getString("subDatasetDialog.buttonQuery","Query"));
                jButtonVariables.setText(I18n.getString("subDatasetDialog.buttonVariables","Variables"));
                jLabelName.setText(I18n.getString("subDatasetDialog.labelName","Datasource name"));
                jLabelResourceBoundle.setText(I18n.getString("subDatasetDialog.labelResourceBoundle","Resource Boundle"));
                jLabelScriptletClass.setText(I18n.getString("subDatasetDialog.labelScriptletClass","Scriptlet class"));
                jLabelScriptletClass1.setText(I18n.getString("subDatasetDialog.labelScriptletClass1","Filter expression"));
                jLabelWhenResourceMissingType.setText(I18n.getString("subDatasetDialog.labelWhenResourceMissingType","When resource missing type"));
                // End autogenerated code ----------------------
                
                ((javax.swing.border.TitledBorder)jPanel4.getBorder()).setTitle(I18n.getString("subDatasetDialog.panelBorder.SubdatasetProperties","Subdataset properties") );
                
                //
                this.setTitle(I18n.getString("subDatasetDialog.title","SubDataset"));
                //
    }
}
