/*
 * Copyright (C) 2005 - 2006 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * GroupByFieldPanel.java
 * 
 * Created on January 27, 2006, 3:33 PM
 *
 */

package it.businesslogic.ireport.crosstab.gui;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.util.Misc;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.border.TitledBorder;
import it.businesslogic.ireport.util.I18n;

/**
 *
 * @author  gtoffoli
 */
public class GroupByFieldPanel extends javax.swing.JPanel {
    
    private Vector objects = new Vector(); 
    
    /** Creates new form GroupByFieldPanel */
    public GroupByFieldPanel() {
        initComponents();
        applyI18n();
    }
    
    public void addVoidItem()
    {
        if (jComboBoxColumnGroup1.getItemCount() == 0 ||
            jComboBoxColumnGroup1.getSelectedItem() instanceof WizardFieldObject)
        {
            jComboBoxColumnGroup1.insertItemAt("",0);
        }
        jComboBoxColumnGroup1.setSelectedIndex(0);
    }
    
    public void setTitle(String title)
    {
        ((TitledBorder)this.getBorder()).setTitle(title);
    }
    
    public void addObject(Object obj)
    {
        if (obj == null) return;
        
        WizardFieldObject wo = new WizardFieldObject(obj);
        jComboBoxColumnGroup1.addItem(wo);
       
        //jComboBoxColumnGroup1ActionPerformed(null);
    
    }
    
    /**
     * Return the name used as Group name...
     */
    public String getFieldName()
    {
        if (jComboBoxColumnGroup1.getSelectedItem() != null && jComboBoxColumnGroup1.getSelectedItem() instanceof WizardFieldObject)
        {
           return ((WizardFieldObject)jComboBoxColumnGroup1.getSelectedItem()).getName();
        }
        
        return null;
    }
    
    public String getExpression()
    {
        if (jComboBoxColumnGroup1.getSelectedItem() != null && jComboBoxColumnGroup1.getSelectedItem() instanceof WizardFieldObject)
        {
           return ((WizardFieldObject)jComboBoxColumnGroup1.getSelectedItem()).getExpression(jComboBoxColumnGroupBy1.getSelectedItem()+"");
        }
        
        return "";
    }
    
    public String getExpressionClass()
    {
        if (jComboBoxColumnGroup1.getSelectedItem() != null && jComboBoxColumnGroup1.getSelectedItem() instanceof WizardFieldObject)
        {
           return ((WizardFieldObject)jComboBoxColumnGroup1.getSelectedItem()).getExpressionClass(jComboBoxColumnGroupBy1.getSelectedItem()+"");
        }
        
        return "java.lang.String";
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelColumnGroup1 = new javax.swing.JLabel();
        jComboBoxColumnGroup1 = new javax.swing.JComboBox();
        jComboBoxColumnGroupBy1 = new javax.swing.JComboBox();
        jLabelColumnGroupBy1 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
        jLabelColumnGroup1.setText("Group");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        add(jLabelColumnGroup1, gridBagConstraints);

        jComboBoxColumnGroup1.setPreferredSize(new java.awt.Dimension(55, 20));
        jComboBoxColumnGroup1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxColumnGroup1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jComboBoxColumnGroup1, gridBagConstraints);

        jComboBoxColumnGroupBy1.setEnabled(false);
        jComboBoxColumnGroupBy1.setPreferredSize(new java.awt.Dimension(55, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(jComboBoxColumnGroupBy1, gridBagConstraints);

        jLabelColumnGroupBy1.setText("Group by");
        jLabelColumnGroupBy1.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 0);
        add(jLabelColumnGroupBy1, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    public void populateBySubdataset(SubDataset sd)
    {
        populateBySubdataset(sd, false);
    }
    
    public void populateBySubdataset(SubDataset sd, boolean addVoidEntry)
    {
        jComboBoxColumnGroup1.removeAllItems();
        if (addVoidEntry) addVoidItem();
        for (int i=0; i<sd.getFields().size(); ++i)
        {
            addObject(sd.getFields().get(i));
        }
        for (int i=0; i<sd.getVariables().size(); ++i)
        {
            addObject(sd.getVariables().get(i));
        }
        for (int i=0; i<sd.getParameters().size(); ++i)
        {
            addObject(sd.getParameters().get(i));
        }
        
        if (jComboBoxColumnGroup1.getItemCount() > 0)
        {
            jComboBoxColumnGroup1.setSelectedIndex(0);
        }
    }
    
    private void jComboBoxColumnGroup1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxColumnGroup1ActionPerformed

        
        jComboBoxColumnGroupBy1.removeAllItems();
        if (jComboBoxColumnGroup1.getSelectedItem() != null && jComboBoxColumnGroup1.getSelectedItem() instanceof WizardFieldObject)
        {
           Vector itemsGroupByValues =  ((WizardFieldObject)jComboBoxColumnGroup1.getSelectedItem()).getGroupByValues();
           Misc.updateComboBox( jComboBoxColumnGroupBy1,itemsGroupByValues,false);
        }
        
        if (jComboBoxColumnGroupBy1.getItemCount() <= 1)
        {
            jComboBoxColumnGroupBy1.setEnabled(false);
            jLabelColumnGroupBy1.setEnabled(false);
        }
        else
        {
            jComboBoxColumnGroupBy1.setEnabled(true);
            jLabelColumnGroupBy1.setEnabled(true);
        }
        
        this.fireActionListenerActionPerformed(new ActionEvent(this,0,""));
        
    }//GEN-LAST:event_jComboBoxColumnGroup1ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBoxColumnGroup1;
    private javax.swing.JComboBox jComboBoxColumnGroupBy1;
    private javax.swing.JLabel jLabelColumnGroup1;
    private javax.swing.JLabel jLabelColumnGroupBy1;
    // End of variables declaration//GEN-END:variables

    /**
     * Utility field used by event firing mechanism.
     */
    private javax.swing.event.EventListenerList listenerList =  null;

    /**
     * Registers ActionListener to receive events.
     * @param listener The listener to register.
     */
    public synchronized void addActionListener(java.awt.event.ActionListener listener) {

        if (listenerList == null ) {
            listenerList = new javax.swing.event.EventListenerList();
        }
        listenerList.add (java.awt.event.ActionListener.class, listener);
    }

    /**
     * Removes ActionListener from the list of listeners.
     * @param listener The listener to remove.
     */
    public synchronized void removeActionListener(java.awt.event.ActionListener listener) {

        listenerList.remove (java.awt.event.ActionListener.class, listener);
    }

    /**
     * Notifies all registered listeners about the event.
     * 
     * @param event The event to be fired
     */
    private void fireActionListenerActionPerformed(java.awt.event.ActionEvent event) {

        if (listenerList == null) return;
        Object[] listeners = listenerList.getListenerList ();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i]==java.awt.event.ActionListener.class) {
                ((java.awt.event.ActionListener)listeners[i+1]).actionPerformed (event);
            }
        }
    }
    
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jLabelColumnGroup1.setText(I18n.getString("groupByFieldPanel.labelColumnGroup1","Group"));
                jLabelColumnGroupBy1.setText(I18n.getString("groupByFieldPanel.labelColumnGroupBy1","Group by"));
                // End autogenerated code ----------------------
    }
}
