/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.gui.ListView;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.util.Classpath;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.explorer.DialogChooseColumns;
import nickyb.sqleonardo.environment.ctrl.explorer.DialogDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.DialogDriver;
import nickyb.sqleonardo.environment.ctrl.explorer.DialogExport;
import nickyb.sqleonardo.environment.ctrl.explorer.SideNavigator;
import nickyb.sqleonardo.environment.ctrl.explorer.SideSearchCriteria;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDriver;
import nickyb.sqleonardo.environment.ctrl.explorer.UoLinks;

public class MetadataExplorer
extends BorderLayoutPanel
implements ChangeListener,
TreeSelectionListener {
    private CardLayout cv;
    private JTabbedPane tp;
    private SideNavigator navigator;
    private SideSearchCriteria search;

    public MetadataExplorer() {
        super(2, 2);
        this.getActionMap().put("new-driver", new ActionNewDriver());
        this.getActionMap().put("new-datasorce", new ActionNewDatasource());
        this.getActionMap().put("delete", new ActionDelete());
        this.getActionMap().put("properties", new ActionProperties());
        this.getActionMap().put("choose-columns", new ActionChooseColumns());
        this.getActionMap().put("list-copy", new ActionCopyList());
        this.getActionMap().put("list-export", new ActionExportList());
        this.getActionMap().put("list-refresh", new ActionRefreshList());
        this.initComponents();
        this.loadNavigator();
    }

    private void initComponents() {
        this.navigator = new SideNavigator();
        this.search = new SideSearchCriteria();
        JSplitPane split = new JSplitPane();
        split.setDividerLocation(250);
        split.setOneTouchExpandable(true);
        this.setComponentCenter(split);
        Container container = new Container();
        this.cv = new CardLayout();
        container.setLayout(this.cv);
        container.add("first", this.navigator.getRightView());
        container.add("last", this.search.getRightView());
        split.setRightComponent(container);
        this.tp = new JTabbedPane(3);
        this.tp.addTab("browse", this.navigator);
        this.tp.addTab("search", this.search);
        this.tp.addChangeListener(this);
        split.setLeftComponent(this.tp);
    }

    public SideNavigator getNavigator() {
        return this.navigator;
    }

    private void loadNavigator() {
        Application.session.mount("$JDBC");
        Application.session.home();
        Enumeration eDv = Application.session.jumps();
        while (eDv.hasMoreElements()) {
            UoDriver uoDv = new UoDriver();
            uoDv.name = eDv.nextElement().toString();
            Application.session.jump(uoDv.name);
            Object[] dvInfo = (Object[])Application.session.jump().get(0);
            uoDv.library = dvInfo[0] == null ? "" : dvInfo[0].toString();
            uoDv.classname = dvInfo[1] == null ? "" : dvInfo[1].toString();
            uoDv.example = dvInfo[2] == null ? "" : dvInfo[2].toString();
            this.navigator.add(uoDv);
            try {
                ConnectionAssistant.declare(uoDv.library, uoDv.classname, !Classpath.isRuntime(uoDv.library));
            }
            catch (Exception e) {
                Application.println(e, false);
            }
            Enumeration eDs = Application.session.jumps();
            while (eDs.hasMoreElements()) {
                UoDatasource uoDs = new UoDatasource(uoDv);
                uoDs.name = eDs.nextElement().toString();
                this.navigator.add(uoDs);
                Application.session.home();
                Application.session.jump(new String[]{uoDv.name, uoDs.name});
                Object[] dsInfo = (Object[])Application.session.jump().get(0);
                uoDs.url = dsInfo[0] == null ? "" : dsInfo[0].toString();
                String string = uoDs.uid = dsInfo[1] == null ? "" : dsInfo[1].toString();
                uoDs.pwd = dsInfo.length == 3 && (uoDs.remember = dsInfo[2] != null) ? dsInfo[2].toString() : "";
                UoLinks uoLk = (UoLinks)this.navigator.getSelectionNode().getLastLeaf().getUserObject();
                Enumeration eLk = Application.session.jumps();
                while (eLk.hasMoreElements()) {
                    String group = eLk.nextElement().toString();
                    Application.session.home();
                    Application.session.jump(new String[]{uoDv.name, uoDs.name, group});
                    for (int i = 0; i < Application.session.jump().size(); ++i) {
                        Object[] link = (Object[])Application.session.jump().get(i);
                        uoLk.add(group, link[0] == null ? null : link[0].toString(), link[1].toString(), link[2].toString());
                    }
                }
            }
            Application.session.home();
        }
        this.navigator.clearSelection();
        this.navigator.addTreeSelectionListener(this);
    }

    public void unloadNavigator() {
        Application.session.umount("$JDBC");
        Application.session.mount("$JDBC");
        DefaultMutableTreeNode root = this.navigator.getRootNode();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
            UoDriver uoDv = (UoDriver)node.getUserObject();
            Application.session.jump(uoDv.name).add(new String[]{uoDv.library, uoDv.classname, uoDv.example});
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(j);
                UoDatasource uoDs = (UoDatasource)child.getUserObject();
                if (uoDs.isConnected()) {
                    try {
                        uoDs.disconnect();
                    }
                    catch (Exception e) {
                        Application.println(e, false);
                    }
                }
                Application.session.home();
                Application.session.jump(new String[]{uoDv.name, uoDs.name});
                Application.session.jump().add(new String[]{uoDs.url, uoDs.uid, uoDs.remember ? uoDs.pwd : null});
                UoLinks uoLk = (UoLinks)child.getLastLeaf().getUserObject();
                Iterator iG = uoLk.getGroups().iterator();
                while (iG.hasNext()) {
                    String group = iG.next().toString();
                    Application.session.home();
                    Application.session.jump(new String[]{uoDv.name, uoDs.name, group});
                    Iterator iK = uoLk.getLinks(group).iterator();
                    while (iK.hasNext()) {
                        Application.session.jump().add(iK.next());
                    }
                }
            }
            Application.session.home();
        }
    }

    public void setPreferences() {
        this.navigator.setPreferences();
        this.search.setPreferences();
    }

    private void onSomethingChanged() {
        boolean bUoSelected = !this.navigator.isSelectionEmpty() && this.navigator.getSelectionPath().getPathCount() < 4;
        boolean bListLoaded = !this.navigator.isSelectionEmpty() && !this.navigator.getSelectionNode().getAllowsChildren();
        this.getActionMap().get("new-driver").setEnabled(this.tp.getSelectedIndex() == 0);
        this.getActionMap().get("new-datasorce").setEnabled(this.tp.getSelectedIndex() == 0);
        this.getActionMap().get("delete").setEnabled(this.tp.getSelectedIndex() == 0 && bUoSelected);
        this.getActionMap().get("properties").setEnabled(this.tp.getSelectedIndex() == 0 && bUoSelected);
        if (!this.navigator.isSelectionEmpty() && this.navigator.getSelectionNode().getUserObject() instanceof UoLinks) {
            this.getActionMap().get("choose-columns").setEnabled(false);
        } else {
            this.getActionMap().get("choose-columns").setEnabled(this.tp.getSelectedIndex() == 0 && bListLoaded);
        }
        boolean bList = this.tp.getSelectedIndex() == 0 && bListLoaded || this.tp.getSelectedIndex() == 1;
        this.getActionMap().get("list-copy").setEnabled(bList);
        this.getActionMap().get("list-export").setEnabled(bList);
        this.getActionMap().get("list-refresh").setEnabled(this.tp.getSelectedIndex() == 0 && bListLoaded);
    }

    private void showFirst() {
        this.cv.first((Container)((JSplitPane)this.getComponent(0)).getRightComponent());
    }

    private void showLast() {
        this.cv.last((Container)((JSplitPane)this.getComponent(0)).getRightComponent());
    }

    public void stateChanged(ChangeEvent ce) {
        if (this.tp.getSelectedIndex() == 0) {
            this.showFirst();
        } else {
            this.showLast();
        }
        this.onSomethingChanged();
    }

    public void valueChanged(TreeSelectionEvent tse) {
        this.onSomethingChanged();
    }

    private class ActionRefreshList
    extends AbstractAction {
        private ActionRefreshList() {
            this.putValue("Name", "refresh");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
        }

        public void actionPerformed(ActionEvent ae) {
            TreePath path = MetadataExplorer.this.navigator.getSelectionPath();
            MetadataExplorer.this.navigator.clearSelection();
            MetadataExplorer.this.navigator.setSelectionPath(path);
        }
    }

    private class ActionExportList
    extends AbstractAction {
        private ActionExportList() {
            this.putValue("Name", "export list...");
        }

        public void actionPerformed(ActionEvent ae) {
            ListView lv = null;
            if (MetadataExplorer.this.tp.getSelectedIndex() == 0) {
                int last = MetadataExplorer.this.navigator.getRightView().getComponentCount() - 1;
                lv = (ListView)MetadataExplorer.this.navigator.getRightView().getComponent(last);
            } else {
                lv = (ListView)MetadataExplorer.this.search.getRightView();
            }
            new DialogExport(lv).show();
        }
    }

    private class ActionCopyList
    extends AbstractAction {
        private ActionCopyList() {
            this.putValue("Name", "copy list");
        }

        public void actionPerformed(ActionEvent ae) {
            if (MetadataExplorer.this.tp.getSelectedIndex() == 0) {
                for (int i = 0; i < MetadataExplorer.this.navigator.getRightView().getComponentCount(); ++i) {
                    Component c = MetadataExplorer.this.navigator.getRightView().getComponent(i);
                    if (!c.isShowing() || !(c instanceof ListView)) continue;
                    ((ListView)c).copyAllRows();
                }
            } else {
                ((ListView)MetadataExplorer.this.search.getRightView()).copyAllRows();
            }
        }
    }

    private class ActionChooseColumns
    extends AbstractAction {
        private ActionChooseColumns() {
            this.putValue("Name", "choose columns...");
        }

        public void actionPerformed(ActionEvent ae) {
            String dvname = MetadataExplorer.this.navigator.getSelectionNode().getPath()[1].toString();
            new DialogChooseColumns(dvname, "table types").show();
        }
    }

    private class ActionProperties
    extends AbstractAction {
        private ActionProperties() {
            this.putValue("Name", "properties...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (MetadataExplorer.this.navigator.isSelectionEmpty()) {
                return;
            }
            DefaultMutableTreeNode node = MetadataExplorer.this.navigator.getSelectionNode();
            if (node.getUserObject() instanceof UoDriver) {
                DialogDriver dlg = new DialogDriver(MetadataExplorer.this.navigator, true);
                dlg.show();
            } else if (node.getUserObject() instanceof UoDatasource) {
                DialogDatasource dlg = new DialogDatasource(MetadataExplorer.this.navigator, true);
                dlg.show();
            }
        }
    }

    private class ActionDelete
    extends AbstractAction {
        private ActionDelete() {
            this.putValue("Name", "delete");
        }

        public void actionPerformed(ActionEvent ae) {
            MetadataExplorer.this.navigator.remove();
        }
    }

    private class ActionNewDatasource
    extends AbstractAction {
        private ActionNewDatasource() {
            this.putValue("Name", "new datasource...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (MetadataExplorer.this.navigator.isSelectionEmpty()) {
                Application.alert("SQLeonardo", "select one driver!");
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)MetadataExplorer.this.navigator.getSelectionPath().getPathComponent(1);
            MetadataExplorer.this.navigator.setSelectionNode(node);
            DialogDatasource dlg = new DialogDatasource(MetadataExplorer.this.navigator, false);
            dlg.show();
        }
    }

    private class ActionNewDriver
    extends AbstractAction {
        private ActionNewDriver() {
            this.putValue("Name", "new driver...");
        }

        public void actionPerformed(ActionEvent ae) {
            DialogDriver dlg = new DialogDriver(MetadataExplorer.this.navigator, false);
            dlg.show();
        }
    }
}

