/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.event;

import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Stack;
import org.flexdock.event.Event;
import org.flexdock.event.EventHandler;
import org.flexdock.event.RegistrationHandler;

public class EventManager {
    private static final EventManager SINGLETON = new EventManager();
    private Stack handlers = new Stack();

    public static EventManager getInstance() {
        return SINGLETON;
    }

    private EventManager() {
    }

    public static void addHandler(EventHandler handler) {
        EventManager.getInstance().addEventHandler(handler);
    }

    public static void removeHandler(EventHandler handler) {
        EventManager.getInstance().removeEventHandler(handler);
    }

    public static void addListener(EventListener listener) {
        EventManager.getInstance().addEventListener(listener);
    }

    public static void removeListener(EventListener listener) {
        EventManager.getInstance().removeEventListener(listener);
    }

    public static void dispatch(Event evt) {
        EventManager.getInstance().dispatchEvent(evt);
    }

    public static void dispatch(Event evt, Object target) {
        EventManager.getInstance().dispatchEvent(evt, target);
    }

    public static void dispatch(Event evt, Object[] targets) {
        EventManager.getInstance().dispatchEvent(evt, targets);
    }

    public void addEventHandler(EventHandler handler) {
        if (handler != null) {
            this.handlers.push(handler);
        }
    }

    public void removeEventHandler(EventHandler handler) {
        if (handler != null) {
            this.handlers.remove(handler);
        }
    }

    private EventHandler getHandler(Event evt) {
        Iterator it = this.handlers.iterator();
        while (it.hasNext()) {
            EventHandler handler = (EventHandler)it.next();
            if (!handler.acceptsEvent(evt)) continue;
            return handler;
        }
        return null;
    }

    private EventHandler getHandler(EventListener listener) {
        Iterator it = this.handlers.iterator();
        while (it.hasNext()) {
            EventHandler handler = (EventHandler)it.next();
            if (!handler.acceptsListener(listener)) continue;
            return handler;
        }
        return null;
    }

    public void addEventListener(EventListener listener) {
        EventHandler handler;
        EventHandler eventHandler = handler = listener == null ? null : this.getHandler(listener);
        if (handler != null) {
            handler.addListener(listener);
        }
    }

    public void removeEventListener(EventListener listener) {
        EventHandler handler;
        EventHandler eventHandler = handler = listener == null ? null : this.getHandler(listener);
        if (handler != null) {
            handler.removeListener(listener);
        }
    }

    public void dispatchEvent(Event evt) {
        this.dispatchEvent(evt, null);
    }

    public void dispatchEvent(Event evt, Object target) {
        Object[] targets = null;
        if (target instanceof Collection) {
            targets = ((Collection)target).toArray();
        } else if (target != null) {
            targets = new Object[]{target};
        }
        this.dispatchEvent(evt, targets);
    }

    public void dispatchEvent(Event evt, Object[] targets) {
        EventHandler handler;
        EventHandler eventHandler = handler = evt == null ? null : this.getHandler(evt);
        if (handler != null) {
            handler.handleEvent(evt, targets);
        }
    }

    static {
        EventManager.addHandler(new RegistrationHandler());
    }
}

