/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.event.hierarchy;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.event.hierarchy.RootDockingPortInfo;
import org.flexdock.util.RootWindow;

public class DockingPortTracker
implements HierarchyListener {
    private static final DockingPortTracker SINGLETON = new DockingPortTracker();
    private static WeakHashMap TRACKERS_BY_WINDOW = new WeakHashMap();
    private static WeakHashMap DOCKING_PORTS = new WeakHashMap();
    private static final Object NULL = new Object();

    public static HierarchyListener getInstance() {
        return SINGLETON;
    }

    public static RootDockingPortInfo getRootDockingPortInfo(Component c) {
        RootWindow window = RootWindow.getRootContainer(c);
        return DockingPortTracker.getRootDockingPortInfo(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RootDockingPortInfo getRootDockingPortInfo(RootWindow window) {
        if (window == null) {
            return null;
        }
        RootDockingPortInfo info = (RootDockingPortInfo)TRACKERS_BY_WINDOW.get(window);
        if (info == null) {
            WeakHashMap weakHashMap = TRACKERS_BY_WINDOW;
            synchronized (weakHashMap) {
                info = new RootDockingPortInfo(window);
                TRACKERS_BY_WINDOW.put(window, info);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DockingPort findById(String portId) {
        if (portId == null) {
            return null;
        }
        WeakHashMap weakHashMap = TRACKERS_BY_WINDOW;
        synchronized (weakHashMap) {
            Iterator it = TRACKERS_BY_WINDOW.values().iterator();
            while (it.hasNext()) {
                RootDockingPortInfo info = (RootDockingPortInfo)it.next();
                DockingPort port = info.getPort(portId);
                if (port == null) continue;
                return port;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RootDockingPortInfo findInfoByPort(DockingPort port) {
        if (port == null) {
            return null;
        }
        WeakHashMap weakHashMap = TRACKERS_BY_WINDOW;
        synchronized (weakHashMap) {
            Iterator it = TRACKERS_BY_WINDOW.values().iterator();
            while (it.hasNext()) {
                RootDockingPortInfo info = (RootDockingPortInfo)it.next();
                if (!info.contains(port)) continue;
                return info;
            }
        }
        return null;
    }

    public static DockingPort findByWindow(Component comp) {
        RootWindow window = RootWindow.getRootContainer(comp);
        return DockingPortTracker.findByWindow(window);
    }

    public static DockingPort findByWindow(RootWindow window) {
        RootDockingPortInfo info = DockingPortTracker.getRootDockingPortInfo(window);
        if (info == null) {
            return null;
        }
        return info.getPort(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateIndex(DockingPort port) {
        if (port == null) {
            return;
        }
        WeakHashMap weakHashMap = DOCKING_PORTS;
        synchronized (weakHashMap) {
            DOCKING_PORTS.put(port, NULL);
        }
        RootDockingPortInfo info = DockingPortTracker.findInfoByPort(port);
        if (info != null) {
            info.remove(port);
            info.add(port);
        }
    }

    private boolean isParentChange(HierarchyEvent evt) {
        return evt.getID() == 1400 && evt.getChangeFlags() == 1L;
    }

    private boolean isRemoval(HierarchyEvent evt) {
        return evt.getChanged().getParent() == null;
    }

    public void hierarchyChanged(HierarchyEvent evt) {
        if (!(evt.getSource() instanceof DockingPort)) {
            return;
        }
        DockingPort port = (DockingPort)evt.getSource();
        if (!port.isRoot()) {
            return;
        }
        if (!this.isParentChange(evt)) {
            return;
        }
        Container changedParent = evt.getChangedParent();
        RootWindow window = RootWindow.getRootContainer(changedParent);
        if (window == null) {
            return;
        }
        boolean removal = this.isRemoval(evt);
        if (removal) {
            this.dockingPortRemoved(window, port);
        } else {
            this.dockingPortAdded(window, port);
        }
    }

    public void dockingPortAdded(RootWindow window, DockingPort port) {
        RootDockingPortInfo info = DockingPortTracker.getRootDockingPortInfo(window);
        if (info != null) {
            info.add(port);
        }
    }

    public void dockingPortRemoved(RootWindow window, DockingPort port) {
        RootDockingPortInfo info = DockingPortTracker.getRootDockingPortInfo(window);
        if (info != null) {
            info.remove(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getDockingWindows() {
        WeakHashMap weakHashMap = TRACKERS_BY_WINDOW;
        synchronized (weakHashMap) {
            return new HashSet(TRACKERS_BY_WINDOW.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getDockingPorts() {
        HashSet globalSet = new HashSet();
        WeakHashMap weakHashMap = DOCKING_PORTS;
        synchronized (weakHashMap) {
            Iterator it = DOCKING_PORTS.keySet().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                globalSet.add(obj);
            }
        }
        return globalSet;
    }

    public static Set getRootDockingPorts() {
        HashSet<DockingPort> rootSet = new HashSet<DockingPort>();
        Set globalSet = DockingPortTracker.getDockingPorts();
        Iterator it = globalSet.iterator();
        while (it.hasNext()) {
            DockingPort port = (DockingPort)it.next();
            if (!port.isRoot()) continue;
            rootSet.add(port);
        }
        return rootSet;
    }

    public static DockingPort getRootDockingPort(Dockable dockable) {
        if (dockable == null || !DockingManager.isDocked(dockable)) {
            return null;
        }
        DockingPort port = dockable.getDockingPort();
        Container parent = ((Component)((Object)port)).getParent();
        while (!DockingPortTracker.isWindowRoot(parent)) {
            if (parent instanceof DockingPort) {
                port = (DockingPort)((Object)parent);
            }
            parent = parent.getParent();
        }
        return port;
    }

    private static boolean isWindowRoot(Component comp) {
        return comp instanceof Window || comp instanceof Applet;
    }
}

