/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ClassEditor
extends PropertyEditorSupport {
    private final ClassLoader classLoader;

    public ClassEditor() {
        this(null);
    }

    public ClassEditor(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText(text)) {
            try {
                this.setValue(ClassUtils.forName(text.trim(), this.classLoader));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Class not found: " + ex.getMessage());
            }
        } else {
            this.setValue(null);
        }
    }

    public String getAsText() {
        Class clazz = (Class)this.getValue();
        if (clazz == null) {
            return "";
        }
        if (clazz.isArray()) {
            return clazz.getComponentType().getName() + "[]";
        }
        return clazz.getName();
    }
}

