/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRSubreportReturnValue;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class JRSubreportReturnValueDialog
extends JDialog {
    private JRSubreportReturnValue subreportReturnValue = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxCalculationType;
    private JComboBox jComboBoxSubreportVariable;
    private JComboBox jComboBoxVariable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JTextField jTextFieldNameIncrementerFactoryClass;
    private int dialogResult;

    public JRSubreportReturnValueDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.setTypes();
        this.updateVariables();
        this.jComboBoxSubreportVariable.setSelectedItem("");
        this.setSize(380, 260);
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRSubreportReturnValueDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public void setTypes() {
        this.jComboBoxCalculationType.addItem(new Tag("Nothing", I18n.getString("variable.calculationType.Nothing", "Nothing")));
        this.jComboBoxCalculationType.addItem(new Tag("Count", I18n.getString("variable.calculationType.Count", "Count")));
        this.jComboBoxCalculationType.addItem(new Tag("DistinctCount", I18n.getString("variable.calculationType.DistinctCount", "Distinct count")));
        this.jComboBoxCalculationType.addItem(new Tag("Sum", I18n.getString("variable.calculationType.Sum", "Sum")));
        this.jComboBoxCalculationType.addItem(new Tag("Average", I18n.getString("variable.calculationType.Average", "Average")));
        this.jComboBoxCalculationType.addItem(new Tag("Lowest", I18n.getString("variable.calculationType.Lowest", "Lowest")));
        this.jComboBoxCalculationType.addItem(new Tag("Highest", I18n.getString("variable.calculationType.Highest", "Highest")));
        this.jComboBoxCalculationType.addItem(new Tag("StandardDeviation", I18n.getString("variable.calculationType.StandardDeviation", "Standard deviation")));
        this.jComboBoxCalculationType.addItem(new Tag("Variance", I18n.getString("variable.calculationType.Variance", "Variance")));
        this.jComboBoxCalculationType.addItem(new Tag("System", I18n.getString("variable.calculationType.System", "System")));
        this.jComboBoxCalculationType.addItem(new Tag("First", I18n.getString("variable.calculationType.First", "First")));
    }

    public void updateVariables() {
        try {
            Misc.updateComboBox(this.jComboBoxVariable, MainFrame.getMainInstance().getActiveReportFrame().getReport().getVariables(), false);
            for (int i = 0; i < this.jComboBoxVariable.getItemCount(); ++i) {
                Object var = this.jComboBoxVariable.getItemAt(i);
                if (!(var instanceof JRVariable) || !((JRVariable)var).isBuiltin()) continue;
                this.jComboBoxSubreportVariable.addItem(var + "");
                this.jComboBoxVariable.removeItem(var);
                --i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBoxCalculationType = new JComboBox();
        this.jComboBoxVariable = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jTextFieldNameIncrementerFactoryClass = new JTextField();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jComboBoxSubreportVariable = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify variable");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRSubreportReturnValueDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Subreport variable");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Calculation type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel5.setText("Local destination variable");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxCalculationType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxVariable, gridBagConstraints);
        this.jLabel8.setText("Custom Incrementer Factory Class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldNameIncrementerFactoryClass, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRSubreportReturnValueDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRSubreportReturnValueDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jComboBoxSubreportVariable.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jComboBoxSubreportVariable, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if ((this.jComboBoxSubreportVariable.getSelectedItem() + "").trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.jRSubreportReturnValueDialog.notValidName", "Please insert a valid subreport variable name!"), I18n.getString("messages.jRSubreportReturnValueDialog.notValidNameCaption", "Invalid variable!"), 2);
            return;
        }
        this.subreportReturnValue = new JRSubreportReturnValue();
        this.subreportReturnValue.setSubreportVariable(this.jComboBoxSubreportVariable.getSelectedItem() + "");
        if (this.jComboBoxVariable.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.jRSubreportReturnValueDialog.notValidLocalVariable", "Please insert a valid local variable! If no variables are available, please close this dialog and create one."), I18n.getString("messages.jRSubreportReturnValueDialog.notValidLocalVariableCaption", "Invalid variable!"), 2);
            return;
        }
        this.subreportReturnValue.setToVariable(this.jComboBoxVariable.getSelectedItem() + "");
        Object t = this.jComboBoxCalculationType.getSelectedItem();
        if (t != null && t instanceof Tag) {
            this.subreportReturnValue.setCalculation(((Tag)t).getValue() + "");
        }
        this.subreportReturnValue.setIncrementFactoryClass(this.jTextFieldNameIncrementerFactoryClass.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public JRSubreportReturnValue getSubreportReturnValue() {
        return this.subreportReturnValue;
    }

    public void setSubreportReturnValue(JRSubreportReturnValue tmpSubreportReturnValue) {
        this.jComboBoxSubreportVariable.setSelectedItem(new String(tmpSubreportReturnValue.getSubreportVariable()));
        for (int i = 0; i < this.jComboBoxVariable.getItemCount(); ++i) {
            Object var = this.jComboBoxVariable.getItemAt(i);
            if (!(var + "").equals(tmpSubreportReturnValue.getToVariable())) continue;
            this.jComboBoxVariable.setSelectedIndex(i);
            break;
        }
        Misc.setComboboxSelectedTagValue(this.jComboBoxCalculationType, tmpSubreportReturnValue.getCalculation());
        this.jTextFieldNameIncrementerFactoryClass.setText(tmpSubreportReturnValue.getIncrementFactoryClass());
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("jRSubreportReturnValueDialog.buttonCancel", "Cancel"));
        this.jButtonOK.setText(I18n.getString("jRSubreportReturnValueDialog.buttonOK", "OK"));
        this.jLabel1.setText(I18n.getString("jRSubreportReturnValueDialog.label1", "Subreport variable"));
        this.jLabel2.setText(I18n.getString("jRSubreportReturnValueDialog.label2", "Calculation type"));
        this.jLabel5.setText(I18n.getString("jRSubreportReturnValueDialog.label5", "Local destination variable"));
        this.jLabel8.setText(I18n.getString("jRSubreportReturnValueDialog.label8", "Custom Incrementer Factory Class"));
    }
}

