/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import it.businesslogic.ireport.connection.NullConnection;
import it.businesslogic.ireport.util.Misc;
import java.sql.Connection;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;

public class JREmptyDatasourceConnection
extends NullConnection {
    private int records = 1;

    public JREmptyDatasourceConnection() {
        this.setName("Empty datasource connection");
    }

    public Connection getConnection() {
        return null;
    }

    public boolean isJDBCConnection() {
        return false;
    }

    public boolean isJRDataSource() {
        return true;
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("records", "" + this.getRecords());
        return map;
    }

    public void loadProperties(HashMap map) {
        this.setRecords(Integer.parseInt(Misc.nvl((String)map.get("records"), "1")));
    }

    public String getDescription() {
        return "Empty datasource";
    }

    public JRDataSource getJRDataSource() {
        return new JREmptyDataSource(this.getRecords());
    }

    public int getRecords() {
        return this.records;
    }

    public void setRecords(int records) {
        this.records = records;
    }
}

