/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart.gui;

import it.businesslogic.ireport.chart.Chart;
import it.businesslogic.ireport.chart.ChartDescriptor;
import it.businesslogic.ireport.chart.gui.ChartCellRenderer;
import it.businesslogic.ireport.gui.listview.JListView;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChartSelectionJDialog
extends JDialog {
    private int dialogResult = 2;
    private JListView jListView = null;
    private JList jList1 = null;
    private Chart chart = null;
    private boolean multiAxisMode = false;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JLabel jLabelChartNameVal;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanelChartType;

    public ChartSelectionJDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public ChartSelectionJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void updateCharts() {
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        dlm.removeAllElements();
        if (!this.isMultiAxisMode()) {
            dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/pie.png", "Pie", "it.businesslogic.ireport.chart.PieChart"));
        }
        if (!this.isMultiAxisMode()) {
            dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/pie3d.png", "Pie 3D", "it.businesslogic.ireport.chart.Pie3DChart"));
        }
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/bar.png", "Bar", "it.businesslogic.ireport.chart.BarChart"));
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/bar3d.png", "Bar 3D", "it.businesslogic.ireport.chart.Bar3DChart"));
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/xybar.png", "YX Bar", "it.businesslogic.ireport.chart.XYBarChart"));
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/stackedbar.png", "Stacked Bar", "it.businesslogic.ireport.chart.StackedBarChart"));
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/stackedbar3d.png", "Stacked Bar 3D", "it.businesslogic.ireport.chart.StackedBar3DChart"));
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/line.png", "Line", "it.businesslogic.ireport.chart.LineChart"));
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/xyline.png", "XY Line", "it.businesslogic.ireport.chart.XYLineChart"));
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/area.png", "Area", "it.businesslogic.ireport.chart.AreaChart"));
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/xyarea.png", "YX Area", "it.businesslogic.ireport.chart.XYAreaChart"));
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/scatter.png", "Scatter", "it.businesslogic.ireport.chart.ScatterChart"));
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/bubble.png", "Bubble", "it.businesslogic.ireport.chart.BubbleChart"));
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/timeseries.png", "Time Series", "it.businesslogic.ireport.chart.TimeSeriesChart"));
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/highlow.png", "High Low", "it.businesslogic.ireport.chart.HighLowChart"));
        dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/candlestick.png", "Candlestick", "it.businesslogic.ireport.chart.CandlestickChart"));
        if (!this.isMultiAxisMode()) {
            dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/meter.png", "Meter", "it.businesslogic.ireport.chart.MeterChart"));
        }
        if (!this.isMultiAxisMode()) {
            dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/thermometer.png", "Thermometer", "it.businesslogic.ireport.chart.ThermometerChart"));
        }
        if (!this.isMultiAxisMode()) {
            dlm.addElement(new ChartDescriptor("/it/businesslogic/ireport/icons/charts/multiaxis.png", "Multi Axis", "it.businesslogic.ireport.chart.MultiAxisChart"));
        }
        this.jList1.updateUI();
    }

    public void initAll() {
        this.initComponents();
        this.applyI18n();
        this.setDialogResult(2);
        this.jListView = new JListView();
        this.jList1 = this.jListView.getList();
        this.jPanelChartType.add((Component)this.jListView, "Center");
        DefaultListModel dlm = new DefaultListModel();
        this.jList1.setModel(dlm);
        this.jList1.setCellRenderer(new ChartCellRenderer());
        this.updateCharts();
        this.jList1.setLayoutOrientation(2);
        this.setSize(400, 400);
        Misc.centerFrame(this);
        this.jList1.setSelectionMode(0);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ChartSelectionJDialog.this.selectedChart();
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ChartSelectionJDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOk);
    }

    private void initComponents() {
        this.jPanelChartType = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabelChartNameVal = new JLabel();
        this.jPanel6 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanelChartType.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel5.setBorder(new TitledBorder(new EtchedBorder(), "Chart info"));
        this.jPanel5.setMinimumSize(new Dimension(10, 50));
        this.jPanel5.setPreferredSize(new Dimension(10, 50));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel5.add((Component)this.jLabelChartNameVal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanelChartType.add((Component)this.jPanel5, "South");
        this.getContentPane().add((Component)this.jPanelChartType, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(10, 30));
        this.jPanel1.setPreferredSize(new Dimension(10, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jButtonOk.setText("OK");
        this.jButtonOk.setEnabled(false);
        this.jButtonOk.setMaximumSize(new Dimension(200, 25));
        this.jButtonOk.setPreferredSize(new Dimension(100, 25));
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChartSelectionJDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 2, 4, 4);
        this.jPanel1.add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChartSelectionJDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 2, 4, 2);
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.setDialogResult(0);
        ChartDescriptor cd = (ChartDescriptor)this.jList1.getSelectedValue();
        try {
            this.getClass();
            this.setChart((Chart)Class.forName(cd.getImplementationClass()).newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(true);
        this.dispose();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    void selectedChart() {
        if (this.jList1.getSelectedIndex() >= 0) {
            ChartDescriptor cd = (ChartDescriptor)this.jList1.getSelectedValue();
            this.jLabelChartNameVal.setText(cd.getName());
            this.jButtonOk.setEnabled(true);
        } else {
            this.jButtonOk.setEnabled(false);
        }
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }

    public boolean isMultiAxisMode() {
        return this.multiAxisMode;
    }

    public void setMultiAxisMode(boolean multiAxisMode) {
        this.multiAxisMode = multiAxisMode;
        this.updateCharts();
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("chartSelectionJDialog.buttonCancel", "Cancel"));
        this.jButtonOk.setText(I18n.getString("chartSelectionJDialog.buttonOk", "OK"));
        ((TitledBorder)this.jPanel5.getBorder()).setTitle(I18n.getString("chartSelectionJDialog.panelBorder.ChartInfo", "Chart info"));
    }
}

