/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.mdi;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.Preferences;
import nickyb.sqleonardo._Constants;
import nickyb.sqleonardo.api.gui.BorderLayoutPanel;
import nickyb.sqleonardo.api.gui.UWindow;
import nickyb.sqleonardo.mdi.ClientMetadataExplorer;
import nickyb.sqleonardo.mdi.MDIActions;
import nickyb.sqleonardo.mdi.MDIClient;
import nickyb.sqleonardo.mdi.MDIMenubar;
import nickyb.sqleonardo.mdi.MDIToolbar;
import nickyb.sqleonardo.mdi._MoreConnectionListener;
import nickyb.sqleonardo.mdi._OneConnectionListener;

public class MDIWindow
extends JFrame
implements _Constants {
    private JDesktopPane desktop;
    public MDIMenubar menubar;
    public MDIToolbar toolbar;
    private ArrayList oneListeners;
    private ArrayList moreListeners;

    public final void dispose() {
        ClientMetadataExplorer cme = (ClientMetadataExplorer)this.getClient("metadata explorer");
        cme.dispose();
        Preferences.set("window.height", new Integer(this.getSize().height));
        Preferences.set("window.width", new Integer(this.getSize().width));
        super.dispose();
    }

    public Action getAction(String key) {
        return this.getRootPane().getActionMap().get(key);
    }

    private void initActions() {
        this.getRootPane().getActionMap().put("action.052", new MDIActions.NewQuery());
        this.getRootPane().getActionMap().put("action.053", new MDIActions.LoadQuery());
        this.getRootPane().getActionMap().put("action.051", new MDIActions.Exit());
        this.getRootPane().getActionMap().put("action.050", new MDIActions.About());
        this.getRootPane().getActionMap().put("action.100", new MDIActions.ShowPreferences());
        this.getRootPane().getActionMap().put("action.102", new MDIActions.ShowMetadataExplorer());
        this.getRootPane().getActionMap().put("action.101", new MDIActions.ShowCommandBoard());
        this.getRootPane().getActionMap().put("action.112", new MDIActions.CloseAllClients());
        this.getRootPane().getActionMap().put("action.110", new MDIActions.CascadeClients());
        this.getRootPane().getActionMap().put("action.111", new MDIActions.TileClients());
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                Application.shutdown();
            }
        });
        this.setTitle(null);
        this.setSize(Preferences.getInteger("window.width"), Preferences.getInteger("window.height"));
        UWindow.centerOnScreen(this);
        BorderLayoutPanel content = new BorderLayoutPanel();
        this.toolbar = new MDIToolbar();
        content.setComponentNorth(this.toolbar);
        this.desktop = new JDesktopPane();
        content.setComponentCenter(this.desktop);
        this.desktop.setDragMode(1);
        this.menubar = new MDIMenubar();
        this.setJMenuBar(this.menubar);
        this.setContentPane(content);
    }

    public final void show() {
        this.oneListeners = new ArrayList();
        this.moreListeners = new ArrayList();
        this.initActions();
        this.initComponents();
        super.show();
        this.add(new ClientMetadataExplorer());
    }

    public final void setTitle(String title) {
        title = title == null ? Application.getVersion2() : Application.getVersion2() + " - " + title;
        super.setTitle(title);
    }

    public void add(MDIClient client) {
        this.desktop.add(client);
        try {
            client.addInternalFrameListener(this.menubar);
            client.setVisible(true);
            client.setMaximum(true);
            client.setSelected(true);
            client.setPreferences();
        }
        catch (PropertyVetoException e) {
            Application.println(e, false);
        }
    }

    public void closeAllClients() {
        JInternalFrame[] clients = this.desktop.getAllFrames();
        for (int i = 0; i < clients.length; ++i) {
            if (!clients[i].isClosable()) continue;
            clients[i].doDefaultCloseAction();
        }
    }

    public MDIClient getClient(String name) {
        JInternalFrame[] clients = this.desktop.getAllFrames();
        for (int i = 0; i < clients.length; ++i) {
            if (clients[i].getName() == null || !clients[i].getName().equals(name)) continue;
            return (MDIClient)clients[i];
        }
        return null;
    }

    public boolean showClient(MDIClient client) {
        if (client == null) {
            return false;
        }
        try {
            client.setSelected(true);
            client.toFront();
        }
        catch (PropertyVetoException e) {
            Application.println(e, false);
        }
        return true;
    }

    public boolean showClient(String name) {
        return this.showClient(this.getClient(name));
    }

    private MDIClient[] getClientsForResize() {
        Vector<JInternalFrame> clients = new Vector<JInternalFrame>();
        JInternalFrame[] frames = this.desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isMaximizable()) continue;
            clients.add(frames[i]);
        }
        return clients.toArray(new MDIClient[clients.size()]);
    }

    public void cascadeClients() {
        int offset = 20;
        int x = 0;
        int y = 0;
        MDIClient[] clients = this.getClientsForResize();
        int h = this.desktop.getBounds().height - 5 - clients.length * offset;
        int w = this.desktop.getBounds().width - 5 - clients.length * offset;
        for (int i = clients.length - 1; i >= 0; --i) {
            if (!clients[i].isMaximizable() && !clients[i].isResizable()) continue;
            try {
                clients[i].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                Application.println(e, false);
            }
            clients[i].setSize(w, h);
            clients[i].setLocation(x, y);
            x += offset;
            y += offset;
            this.showClient(clients[i]);
        }
    }

    public void tileClients() {
        MDIClient[] clients = this.getClientsForResize();
        if (clients.length > 0) {
            int h = this.desktop.getBounds().height / clients.length;
            int w = this.desktop.getBounds().width;
            int y = 0;
            for (int i = 0; i < clients.length; ++i) {
                if (!clients[i].isMaximizable() && !clients[i].isResizable()) continue;
                try {
                    clients[i].setMaximum(false);
                }
                catch (PropertyVetoException e) {
                    Application.println(e, false);
                }
                clients[i].setSize(w, h);
                clients[i].setLocation(0, y);
                y += h;
                this.showClient(clients[i]);
            }
        }
    }

    public void addListener(_OneConnectionListener one) {
        this.oneListeners.add(one);
        String keycah = Application.window.toolbar.getActiveConnection();
        if (keycah != null) {
            one.onConnectionActivated(keycah);
        }
    }

    public void addListener(_MoreConnectionListener more) {
        this.moreListeners.add(more);
    }

    public void connectionActivated(String keycah) {
        Iterator iter = this.oneListeners.iterator();
        while (iter.hasNext()) {
            ((_OneConnectionListener)iter.next()).onConnectionActivated(keycah);
        }
    }

    public void connectionClosed(String keycah) {
        Iterator iter = this.moreListeners.iterator();
        while (iter.hasNext()) {
            ((_MoreConnectionListener)iter.next()).onConnectionClosed(keycah);
        }
    }

    public void connectionOpened(String keycah) {
        Iterator iter = this.moreListeners.iterator();
        while (iter.hasNext()) {
            ((_MoreConnectionListener)iter.next()).onConnectionOpened(keycah);
        }
    }
}

