/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.querybuilder;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import nickyb.sqleonardo.ctrl.querybuilder.BasePanel;
import nickyb.sqleonardo.ctrl.querybuilder.BrowserDnD;
import nickyb.sqleonardo.ctrl.querybuilder.BrowserItems;
import nickyb.sqleonardo.ctrl.querybuilder.BrowserPopup;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramEntity;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramRelation;
import nickyb.sqleonardo.ctrl.querybuilder.QueryBuilder;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryExpression;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QuerySpecification;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.SubQuery;

public class ViewBrowser
extends BasePanel
implements TreeSelectionListener {
    private boolean loading = false;
    private QueryBuilder builder;
    private JTree tree;
    private BrowserItems.AbstractQueryTreeItem queryItem;

    ViewBrowser(QueryBuilder builder) {
        this.builder = builder;
        this.tree = new JTree(this.createTreeModel());
        this.setComponentCenter(new JScrollPane(this.tree));
        this.tree.addMouseListener(new BrowserPopup(builder));
        this.tree.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        DefaultTreeCellRenderer cell = new DefaultTreeCellRenderer();
        cell.setFont(this.tree.getFont());
        this.tree.setCellRenderer(cell);
        BrowserDnD.init(this.tree);
        this.expandAll();
    }

    private void expandAll() {
        this.expandAll((TreeNode)this.tree.getModel().getRoot());
    }

    private void expandAll(TreeNode node) {
        this.expand(node);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.expandAll(node.getChildAt(i));
        }
    }

    private void expand(TreeNode node) {
        TreePath path = new TreePath(((DefaultMutableTreeNode)node).getPath());
        this.tree.expandPath(path);
    }

    private void nodeChanged(TreeNode node) {
        ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
    }

    private void reload(TreeNode node) {
        ((DefaultTreeModel)this.tree.getModel()).reload(node);
    }

    void refreshSelection() {
        TreeNode node = (TreeNode)this.tree.getSelectionPath().getLastPathComponent();
        this.nodeChanged(node);
    }

    private void add(int idx, QueryTokens.Join token) {
        BrowserItems.DefaultTreeItem item = (BrowserItems.DefaultTreeItem)this.getQueryItem().getChildAt(idx);
        for (int i = 0; i < 2; ++i) {
            Object userObject = i == 0 ? token.getPrimary().getTable() : token.getForeign().getTable();
            BrowserItems.DefaultTreeItem child = item.findChild(userObject);
            userObject = "{ " + userObject + " }";
            if (child == null) {
                child = item.findChild(userObject);
            }
            if (child == null) {
                child = new BrowserItems.TableTreeItem(userObject);
                item.add(child);
            } else {
                child.setUserObject(userObject);
            }
            ((BrowserItems.TableTreeItem)child).joined();
        }
    }

    private void add(int idx, QueryTokens._Base token) {
        BrowserItems.DefaultTreeItem item = (BrowserItems.DefaultTreeItem)this.getQueryItem().getChildAt(idx);
        BrowserItems.AbstractQueryTreeItem qi = null;
        if (token instanceof QueryTokens.Join) {
            this.add(idx, (QueryTokens.Join)token);
        } else if (token instanceof QueryTokens.Table) {
            item.add(new BrowserItems.TableTreeItem(token));
        } else if (token instanceof SubQuery) {
            qi = new BrowserItems.QueryTreeItem("SUBQUERY", (SubQuery)token);
            item.add(qi);
        } else if (token instanceof QueryTokens.Condition && ((QueryTokens.Condition)token).getRight() instanceof SubQuery) {
            qi = new BrowserItems.ConditionQueryTreeItem((QueryTokens.Condition)token);
            item.add(qi);
        } else {
            item.addChild(token);
        }
        if (this.loading) {
            if (qi != null) {
                this.onLoad(qi);
            }
            return;
        }
        this.reload(item);
        this.expand(item);
    }

    private void add(int idx, QueryTokens._Base[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            this.add(idx, tokens[i]);
        }
    }

    private void add(QueryTokens.Sort[] tokens) {
        BrowserItems.DefaultTreeItem root = (BrowserItems.DefaultTreeItem)this.tree.getModel().getRoot();
        BrowserItems.DefaultTreeItem item = (BrowserItems.DefaultTreeItem)root.getChildAt(1);
        for (int i = 0; i < tokens.length; ++i) {
            item.addChild(tokens[i]);
        }
    }

    private void remove(int idx, QueryTokens.Join token) {
        BrowserItems.DefaultTreeItem item = (BrowserItems.DefaultTreeItem)this.getQueryItem().getChildAt(idx);
        for (int i = 0; i < 2; ++i) {
            Object userObject = i == 0 ? token.getPrimary().getTable() : token.getForeign().getTable();
            userObject = "{ " + userObject + " }";
            BrowserItems.DefaultTreeItem child = item.findChild(userObject);
            if (child == null) continue;
            ((BrowserItems.TableTreeItem)child).unjoined();
            if (((BrowserItems.TableTreeItem)child).isJoined()) continue;
            child.setUserObject(i == 0 ? token.getPrimary().getTable() : token.getForeign().getTable());
            this.getQuerySpecification().addFromClause(i == 0 ? token.getPrimary().getTable() : token.getForeign().getTable());
        }
    }

    private void remove(int idx, QueryTokens._Base token) {
        BrowserItems.DefaultTreeItem item = (BrowserItems.DefaultTreeItem)this.getQueryItem().getChildAt(idx);
        if (token instanceof SubQuery || token instanceof QueryTokens.Condition && ((QueryTokens.Condition)token).getRight() instanceof SubQuery) {
            BrowserItems.DefaultTreeItem itemSub = (BrowserItems.DefaultTreeItem)item.getParent();
            item = (BrowserItems.DefaultTreeItem)itemSub.getParent();
            this.tree.setSelectionPath(new TreePath(item.getPath()));
            itemSub.removeFromParent();
        } else if (token instanceof QueryTokens.Join) {
            this.remove(idx, (QueryTokens.Join)token);
        } else {
            item.removeChild(token);
        }
        if (this.loading) {
            return;
        }
        this.reload(item);
        this.expand(item);
    }

    void addSelectList(QueryTokens._Expression token) {
        if (this.loading) {
            return;
        }
        this.getQuerySpecification().addSelectList(token);
        this.add(0, token);
    }

    void addFromClause(QueryTokens._TableReference token) {
        if (this.loading) {
            return;
        }
        if (token instanceof QueryTokens.Join) {
            this.getQuerySpecification().removeFromClause(((QueryTokens.Join)token).getPrimary().getTable());
            this.getQuerySpecification().removeFromClause(((QueryTokens.Join)token).getForeign().getTable());
        }
        this.getQuerySpecification().addFromClause(token);
        this.add(1, token);
    }

    void addWhereClause(QueryTokens.Condition token) {
        if (this.loading) {
            return;
        }
        if (token.getAppend() == null && this.getQuerySpecification().getWhereClause().length > 0) {
            token.setAppend("AND");
        }
        this.getQuerySpecification().addWhereClause(token);
        this.add(2, token);
    }

    void addGroupByClause(QueryTokens.Group token) {
        if (this.loading) {
            return;
        }
        this.getQuerySpecification().addGroupByClause(token);
        this.add(3, token);
    }

    void addHavingClause(QueryTokens.Condition token) {
        if (this.loading) {
            return;
        }
        if (token.getAppend() == null && this.getQuerySpecification().getHavingClause().length > 0) {
            token.setAppend("AND");
        }
        this.getQuerySpecification().addHavingClause(token);
        this.add(4, token);
    }

    void addOrderByClause(QueryTokens.Sort token) {
        if (this.loading) {
            return;
        }
        this.builder.getModel().addOrderByClause(token);
        BrowserItems.DefaultTreeItem root = (BrowserItems.DefaultTreeItem)this.tree.getModel().getRoot();
        BrowserItems.DefaultTreeItem item = (BrowserItems.DefaultTreeItem)root.getChildAt(1);
        item.addChild(token);
        this.reload(item);
        this.expand(item);
    }

    void setUnion(QueryExpression qe) {
        BrowserItems.AbstractQueryTreeItem item = this.getQueryItem();
        if (qe == null) {
            BrowserItems.AbstractQueryTreeItem itemU = item;
            item = (BrowserItems.AbstractQueryTreeItem)item.getParent();
            this.tree.setSelectionPath(new TreePath(item.getPath()));
            itemU.removeFromParent();
        } else {
            item.add(new BrowserItems.UnionQueryTreeItem(qe));
        }
        this.reload(item);
        this.expand(item);
        item.getQueryExpression().setUnion(qe);
    }

    void removeSelectList(QueryTokens._Expression token) {
        QuerySpecification qs = this.getQuerySpecification();
        if (token instanceof SubQuery) {
            BrowserItems.AbstractQueryTreeItem itemSub = (BrowserItems.AbstractQueryTreeItem)this.tree.getSelectionPath().getLastPathComponent();
            BrowserItems.AbstractQueryTreeItem itemQry = (BrowserItems.AbstractQueryTreeItem)itemSub.getParent().getParent();
            qs = itemQry.getQueryExpression().getQuerySpecification();
        }
        qs.removeSelectList(token);
        this.remove(0, token);
    }

    void removeFromClause(QueryTokens._TableReference token) {
        this.getQuerySpecification().removeFromClause(token);
        this.remove(1, token);
    }

    void removeWhereClause(QueryTokens.Condition token) {
        QuerySpecification qs = this.getQuerySpecification();
        if (token.getRight() instanceof SubQuery) {
            BrowserItems.AbstractQueryTreeItem itemSub = (BrowserItems.AbstractQueryTreeItem)this.tree.getSelectionPath().getLastPathComponent();
            BrowserItems.AbstractQueryTreeItem itemQry = (BrowserItems.AbstractQueryTreeItem)itemSub.getParent().getParent();
            qs = itemQry.getQueryExpression().getQuerySpecification();
        }
        qs.removeWhereClause(token);
        if (qs.getWhereClause().length > 0) {
            qs.getWhereClause()[0].setAppend(null);
        }
        this.remove(2, token);
    }

    void removeGroupByClause(QueryTokens.Group token) {
        this.getQuerySpecification().removeGroupByClause(token);
        this.remove(3, token);
    }

    void removeHavingClause(QueryTokens.Condition token) {
        QuerySpecification qs = this.getQuerySpecification();
        if (token.getRight() instanceof SubQuery) {
            BrowserItems.AbstractQueryTreeItem itemSub = (BrowserItems.AbstractQueryTreeItem)this.tree.getSelectionPath().getLastPathComponent();
            BrowserItems.AbstractQueryTreeItem itemQry = (BrowserItems.AbstractQueryTreeItem)itemSub.getParent().getParent();
            qs = itemQry.getQueryExpression().getQuerySpecification();
        }
        qs.removeHavingClause(token);
        if (qs.getHavingClause().length > 0) {
            qs.getHavingClause()[0].setAppend(null);
        }
        this.remove(4, token);
    }

    void removeOrderByClause(QueryTokens.Sort token) {
        this.builder.getModel().removeOrderByClause(token);
        BrowserItems.DefaultTreeItem root = (BrowserItems.DefaultTreeItem)this.tree.getModel().getRoot();
        BrowserItems.DefaultTreeItem item = (BrowserItems.DefaultTreeItem)root.getChildAt(1);
        item.removeChild(token);
        this.reload(item);
        this.expand(item);
    }

    QuerySpecification getQuerySpecification() {
        return this.getQueryExpression().getQuerySpecification();
    }

    QueryExpression getQueryExpression() {
        return this.getQueryItem().getQueryExpression();
    }

    private DefaultTreeModel createTreeModel() {
        this.queryItem = null;
        BrowserItems.DefaultTreeItem root = new BrowserItems.DefaultTreeItem("QUERY-TREE-MODEL");
        root.add(new BrowserItems.QueryTreeItem("ROOTQUERY", this.builder.getModel().getQueryExpression()));
        root.add(new BrowserItems.ClauseTreeItem("ORDER BY"));
        DefaultTreeModel model = new DefaultTreeModel(root){

            public void nodesWereInserted(TreeNode node, int[] childIndices) {
                ((BrowserItems.ClauseTreeItem)node).onDropPerformed(ViewBrowser.this.builder);
                this.reload(node);
            }
        };
        return model;
    }

    private BrowserItems.AbstractQueryTreeItem getRootQueryItem() {
        BrowserItems.DefaultTreeItem root = (BrowserItems.DefaultTreeItem)this.tree.getModel().getRoot();
        return (BrowserItems.AbstractQueryTreeItem)root.getFirstChild();
    }

    BrowserItems.AbstractQueryTreeItem getQueryItem() {
        return this.queryItem != null ? this.queryItem : (this.queryItem = this.getRootQueryItem());
    }

    private void onLoad(BrowserItems.AbstractQueryTreeItem qi) {
        this.queryItem = qi;
        this.add(0, qi.getQueryExpression().getQuerySpecification().getSelectList());
        this.add(1, qi.getQueryExpression().getQuerySpecification().getFromClause());
        this.add(2, qi.getQueryExpression().getQuerySpecification().getWhereClause());
        this.add(3, qi.getQueryExpression().getQuerySpecification().getGroupByClause());
        this.add(4, qi.getQueryExpression().getQuerySpecification().getHavingClause());
        QueryExpression qe = qi.getQueryExpression().getUnion();
        if (qe != null) {
            BrowserItems.UnionQueryTreeItem itemU = new BrowserItems.UnionQueryTreeItem(qe);
            qi.add(itemU);
            this.onLoad(itemU);
        }
        this.queryItem = null;
    }

    void onModelChanged() {
        this.loading = true;
        this.tree.setModel(this.createTreeModel());
        this.onLoad(this.getRootQueryItem());
        this.expand(this.getRootQueryItem());
        this.add(this.builder.getModel().getOrderByClause());
        this.tree.setSelectionPath(new TreePath(this.getRootQueryItem().getPath()));
        this.loading = false;
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        BrowserItems.AbstractQueryTreeItem nextQueryItem = null;
        for (int i = 0; i < path.getPathCount(); ++i) {
            if (!(path.getPathComponent(i) instanceof BrowserItems.AbstractQueryTreeItem)) continue;
            nextQueryItem = (BrowserItems.AbstractQueryTreeItem)path.getPathComponent(i);
        }
        if (nextQueryItem == null) {
            nextQueryItem = this.getRootQueryItem();
        }
        if (this.queryItem != null) {
            if (nextQueryItem == this.queryItem) {
                return;
            }
            BrowserItems.FromTreeItem item = (BrowserItems.FromTreeItem)this.queryItem.getChildAt(1);
            item.setSelected(false);
            this.nodeChanged(item);
            DiagramEntity[] entities = this.builder.diagram.getEntities();
            DiagramRelation[] relations = this.builder.diagram.getRelations();
            Component[] all = new JComponent[entities.length + relations.length];
            System.arraycopy(entities, 0, all, 0, entities.length);
            System.arraycopy(relations, 0, all, entities.length, relations.length);
            item.setDiagramObjects(all);
            for (int i = 0; i < all.length; ++i) {
                this.builder.diagram.remove(all[i]);
            }
            this.builder.diagram.repaint();
            this.builder.diagram.doResizeDesktop();
        }
        this.queryItem = nextQueryItem;
        BrowserItems.FromTreeItem item = (BrowserItems.FromTreeItem)this.queryItem.getChildAt(1);
        item.setSelected(true);
        this.nodeChanged(item);
        Component[] toFlush = item.getDiagramObjects();
        if (toFlush != null) {
            for (int i = 0; i < toFlush.length; ++i) {
                this.builder.diagram.add(toFlush[i]);
            }
        } else {
            this.loading = true;
            this.builder.onLoad();
            this.loading = false;
        }
        this.builder.diagram.doResizeDesktop();
    }
}

