/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.querybuilder;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramField;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramLoader;
import nickyb.sqleonardo.ctrl.querybuilder.MaskReferences;
import nickyb.sqleonardo.ctrl.querybuilder.QueryBuilder;
import nickyb.sqleonardo.ctrl.querybuilder.ViewDiagram;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;

public class DiagramEntity
extends JInternalFrame {
    private JMenu header;
    private JPanel fields;
    Vector filterdFields = new Vector();
    QueryBuilder builder;
    QueryTokens.Table querytoken;

    DiagramEntity(QueryBuilder builder, QueryTokens.Table qtoken) {
        super(qtoken.getName(), false, true);
        this.builder = builder;
        this.querytoken = qtoken;
        this.setLayer(JDesktopPane.PALETTE_LAYER);
        this.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        this.fields = new JPanel(new GridLayout(0, 1, 0, 0));
        this.getContentPane().add(this.fields);
        this.setJMenuBar(new JMenuBar());
        this.header = new JMenu(this.querytoken.getReference());
        this.getJMenuBar().add(this.header);
        this.header.add(new MenuItemSortByName());
        this.header.add(new MenuItemPack());
        this.header.addSeparator();
        this.header.add(new ActionSelectAll());
        this.header.add(new ActionDeselectAll());
        this.header.addSeparator();
        this.header.add(new ActionOpenAllForeignTables());
        this.header.add(new ActionOpenAllPrimaryTables());
        this.header.addSeparator();
        this.header.add(new ActionReferences());
    }

    DiagramField addField(int ordinalPosition, String label, Object key, String tip) {
        DiagramField field = new DiagramField(this, label, key != null);
        field.position = ordinalPosition;
        field.setToolTipText((key != null ? "[ " + key + " ] " : "") + label + (tip != null ? " : " + tip : ""));
        field.setBackground(ViewDiagram.BGCOLOR_DEFAULT);
        this.fields.add(field);
        return field;
    }

    private int findField(String label, boolean unpack) {
        DiagramField field;
        int i;
        if (unpack) {
            for (i = 0; i < this.filterdFields.size(); ++i) {
                field = (DiagramField)this.filterdFields.get(i);
                if (!field.getName().equalsIgnoreCase(label)) continue;
                this.fields.add(field);
                this.filterdFields.remove(field);
                this.doSort();
                this.pack();
                break;
            }
        }
        for (i = 0; i < this.fields.getComponentCount(); ++i) {
            field = (DiagramField)this.fields.getComponent(i);
            if (!field.getName().equalsIgnoreCase(label)) continue;
            return i;
        }
        return -1;
    }

    DiagramField getField(String label) {
        return this.getField(label, false);
    }

    DiagramField getField(String label, boolean unpack) {
        int index = this.findField(label, unpack);
        return index != -1 ? (DiagramField)this.fields.getComponent(index) : null;
    }

    void onCreate() {
        this.builder.browser.addFromClause(this.querytoken);
        this.doFlush();
    }

    void onDestroy() {
        ((JMenuItem)this.header.getMenuComponent(4)).getAction().actionPerformed(null);
        this.builder.diagram.removeAllRelation(this);
        this.builder.browser.removeFromClause(this.querytoken);
    }

    void onSelectionChanged(DiagramField field) {
        if (field.isSelected()) {
            this.builder.browser.addSelectList(field.querytoken);
        } else {
            this.builder.browser.removeSelectList(field.querytoken);
        }
        this.doPack();
    }

    void doFlush() {
        for (int i = 0; i < this.fields.getComponentCount(); ++i) {
            DiagramField field = (DiagramField)this.fields.getComponent(i);
            field.setBackground(this.builder.isJoinMode() && field.isJoined() ? ViewDiagram.BGCOLOR_JOINED : ViewDiagram.BGCOLOR_DEFAULT);
            field.setEnabled(!this.builder.isJoinMode());
        }
    }

    void doSort() {
        JCheckBoxMenuItem mItem = (JCheckBoxMenuItem)this.header.getMenuComponent(0);
        if (mItem.isSelected()) {
            for (int i = 0; i < this.fields.getComponentCount() - 1; ++i) {
                String master = ((DiagramField)this.fields.getComponent(i)).getName();
                for (int j = i + 1; j < this.fields.getComponentCount(); ++j) {
                    String slave = ((DiagramField)this.fields.getComponent(j)).getName();
                    if (master.compareTo(slave) <= 0) continue;
                    DiagramField field = (DiagramField)this.fields.getComponent(j);
                    this.fields.remove(field);
                    this.fields.add((Component)field, i);
                    master = slave;
                }
            }
        } else {
            for (int i = 0; i < this.fields.getComponentCount() - 1; ++i) {
                int master = ((DiagramField)this.fields.getComponent((int)i)).position;
                for (int j = i + 1; j < this.fields.getComponentCount(); ++j) {
                    int slave = ((DiagramField)this.fields.getComponent((int)j)).position;
                    if (master <= slave) continue;
                    DiagramField field = (DiagramField)this.fields.getComponent(j);
                    this.fields.remove(field);
                    this.fields.add((Component)field, i);
                    master = slave;
                }
            }
        }
        this.builder.diagram.repaint();
        this.builder.diagram.validate();
        this.builder.diagram.doResize();
    }

    void setSort(boolean b) {
        JCheckBoxMenuItem mItem = (JCheckBoxMenuItem)this.header.getMenuComponent(0);
        mItem.setSelected(b);
        this.doSort();
    }

    void doPack() {
        boolean changed = false;
        JCheckBoxMenuItem mItem = (JCheckBoxMenuItem)this.header.getMenuComponent(1);
        if (mItem.isSelected()) {
            for (int i = 0; i < this.fields.getComponentCount(); ++i) {
                DiagramField field = (DiagramField)this.fields.getComponent(i);
                if (field.isSelected() || field.isJoined()) continue;
                this.filterdFields.add(field);
                this.fields.remove(field);
                --i;
                changed = true;
            }
        } else {
            while (this.filterdFields.size() > 0) {
                this.fields.add((DiagramField)this.filterdFields.get(0));
                this.filterdFields.remove(0);
                changed = true;
            }
            this.doSort();
        }
        if (changed) {
            this.pack();
            this.builder.diagram.doResize();
        }
    }

    void setPack(boolean b) {
        JCheckBoxMenuItem mItem = (JCheckBoxMenuItem)this.header.getMenuComponent(1);
        mItem.setSelected(b);
        this.doPack();
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.header.setEnabled(b);
    }

    private class ActionReferences
    extends AbstractAction {
        private ActionReferences() {
            super("references...");
        }

        public void actionPerformed(ActionEvent e) {
            new MaskReferences(DiagramEntity.this).showDialog();
        }
    }

    private class ActionOpenAllPrimaryTables
    extends AbstractAction {
        private ActionOpenAllPrimaryTables() {
            super("open all primary tables");
        }

        public void actionPerformed(ActionEvent e) {
            DiagramLoader.run(2, DiagramEntity.this.builder, DiagramEntity.this.querytoken, true);
        }
    }

    private class ActionOpenAllForeignTables
    extends AbstractAction {
        private ActionOpenAllForeignTables() {
            super("open all foreign tables");
        }

        public void actionPerformed(ActionEvent e) {
            DiagramLoader.run(1, DiagramEntity.this.builder, DiagramEntity.this.querytoken, true);
        }
    }

    private class ActionDeselectAll
    extends AbstractAction {
        private ActionDeselectAll() {
            super("deselect all");
        }

        public void actionPerformed(ActionEvent e) {
            DiagramEntity.this.setPack(false);
            for (int i = 0; i < DiagramEntity.this.fields.getComponentCount(); ++i) {
                ((DiagramField)DiagramEntity.this.fields.getComponent(i)).setSelected(false);
            }
        }
    }

    private class ActionSelectAll
    extends AbstractAction {
        private ActionSelectAll() {
            super("select all");
        }

        public void actionPerformed(ActionEvent e) {
            DiagramEntity.this.setPack(false);
            for (int i = 0; i < DiagramEntity.this.fields.getComponentCount(); ++i) {
                ((DiagramField)DiagramEntity.this.fields.getComponent(i)).setSelected(true);
            }
        }
    }

    private class MenuItemPack
    extends JCheckBoxMenuItem
    implements ActionListener {
        private MenuItemPack() {
            super("pack");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            DiagramEntity.this.doPack();
        }
    }

    private class MenuItemSortByName
    extends JCheckBoxMenuItem
    implements ActionListener {
        private MenuItemSortByName() {
            super("sort by name");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            DiagramEntity.this.doSort();
        }
    }
}

