/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.mde;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.gui.CommandButton;
import nickyb.sqleonardo.ctrl.mde.ViewSearchResult;
import nickyb.sqleonardo.mdi._MoreConnectionListener;

public class SideSearchCriteria
extends JPanel
implements ActionListener,
_MoreConnectionListener {
    private String[] operators = new String[]{"equals", "contains", "starts with", "ends with"};
    private ViewSearchResult rView;
    private JComboBox cbxConnections;
    private JComboBox[] cbx;
    private JTextField[] txt;

    public SideSearchCriteria() {
        Application.window.addListener(this);
        this.setBackground(Color.white);
        this.setBorder(LineBorder.createGrayLineBorder());
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.cbx = new JComboBox[3];
        this.txt = new JTextField[3];
        this.addCriteria(0, gbl, "schema", 25);
        this.addCriteria(1, gbl, "table", 5);
        this.addCriteria(2, gbl, "column", 5);
        this.addConnection(gbl);
        this.addStarter(gbl);
        this.rView = new ViewSearchResult();
    }

    private void addCriteria(int idx, GridBagLayout gbl, String where, int top_gap) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(top_gap, 5, 1, 5);
        JLabel lbl = new JLabel(where + ":");
        gbl.setConstraints(lbl, gbc);
        this.add(lbl);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.cbx[idx] = new JComboBox<String>(this.operators);
        gbl.setConstraints(this.cbx[idx], gbc);
        this.add(this.cbx[idx]);
        gbc.insets = new Insets(0, 5, 0, 5);
        this.txt[idx] = new JTextField();
        gbl.setConstraints(this.txt[idx], gbc);
        this.add(this.txt[idx]);
        this.cbx[idx].setPreferredSize(this.txt[idx].getPreferredSize());
    }

    private void addConnection(GridBagLayout gbl) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 1, 5);
        JLabel lbl = new JLabel("use connection:");
        gbl.setConstraints(lbl, gbc);
        this.add(lbl);
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 8, 5);
        this.cbxConnections = new JComboBox();
        gbl.setConstraints(this.cbxConnections, gbc);
        this.add(this.cbxConnections);
    }

    private void addStarter(GridBagLayout gbl) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(10, 2, 0, 2);
        CommandButton cb = new CommandButton("start", this);
        gbl.setConstraints(cb, gbc);
        this.add(cb);
        gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        JPanel pnl = new JPanel();
        pnl.setOpaque(false);
        gbl.setConstraints(pnl, gbc);
        this.add(pnl);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("start")) {
            if (this.cbxConnections.getSelectedIndex() == -1) {
                return;
            }
            String schema = this.getSearchString(0);
            String table = this.getSearchString(1);
            String column = this.getSearchString(2);
            this.rView.list(this.cbxConnections.getSelectedItem().toString(), schema, table, column);
        }
    }

    private String getSearchString(int idx) {
        String operator = this.cbx[idx].getSelectedItem().toString();
        String value = this.txt[idx].getText();
        if (value == null || value.length() == 0) {
            return null;
        }
        if (operator.toString().equals(this.operators[1])) {
            if (!value.toString().startsWith("%")) {
                value = "%" + value.toString();
            }
            if (!value.toString().endsWith("%")) {
                value = value.toString() + "%";
            }
        } else if (operator.toString().equals(this.operators[2])) {
            if (!value.toString().endsWith("%")) {
                value = value.toString() + "%";
            }
        } else if (operator.toString().equals(this.operators[3]) && !value.toString().startsWith("%")) {
            value = "%" + value.toString();
        }
        return value.toString().toUpperCase();
    }

    public JComponent getRightView() {
        return this.rView;
    }

    public void setPreferences() {
    }

    public void onConnectionClosed(String keycah) {
        this.cbxConnections.removeItem(keycah);
    }

    public void onConnectionOpened(String keycah) {
        this.cbxConnections.addItem(keycah);
    }
}

