/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.grid;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.util.Text;
import nickyb.sqleonardo.ctrl.grid.AbstractMaskPerform;
import nickyb.sqleonardo.ctrl.grid.DataGridView;

public class MaskExport
extends AbstractMaskPerform {
    private AbstractExport exporter;

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (int i = 0; i < this.exporter.getComponentCount(); ++i) {
            this.exporter.getComponent(i).setEnabled(b);
        }
    }

    void setType(short type, String content, String filename) {
        if (this.exporter != null) {
            this.remove(this.exporter);
        }
        this.progress.setValue(0);
        this.progress.setMaximum(0);
        if (type == 2) {
            if (!filename.endsWith(".htm") && !filename.endsWith(".html")) {
                filename = filename + ".html";
            }
            this.exporter = new WebExporter();
            this.setComponentCenter(this.exporter);
        } else if (type == 0) {
            if (!filename.endsWith(".sql")) {
                filename = filename + ".sql";
            }
            this.exporter = new SqlExporter(content);
            this.setComponentCenter(this.exporter);
        } else if (type == 1) {
            if (!filename.endsWith(".txt")) {
                filename = filename + ".txt";
            }
            this.exporter = new TxtExporter();
            this.setComponentCenter(this.exporter);
        }
        this.lblFile.setText("file: " + filename);
    }

    void init(DataGridView gbv) {
        super.init(gbv);
        this.progress.setValue(0);
        this.progress.setMaximum(gbv.getFlatRowCount());
        this.exporter.open();
    }

    void next() {
        this.exporter.handle(this.gbv.getFlatValueAt(this.progress.getValue()));
        this.progress.setValue(this.progress.getValue() + 1);
    }

    boolean finished() {
        if (this.progress.getValue() == this.progress.getMaximum()) {
            this.exporter.close();
            this.btnStop.setEnabled(false);
            this.lblMsg.setText("ready!");
            return true;
        }
        return false;
    }

    private class TxtExporter
    extends AbstractExport {
        JCheckBox cbxHeader;
        JCheckBox cbxTab;
        JTextField txtDelimiter;

        TxtExporter() {
            super("options");
            GridBagLayout gbl = new GridBagLayout();
            this.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            this.cbxHeader = new JCheckBox("with header");
            gbl.setConstraints(this.cbxHeader, gbc);
            this.add(this.cbxHeader);
            this.cbxTab = new JCheckBox("tab delimited");
            this.cbxTab.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    TxtExporter.this.txtDelimiter.setEditable(!TxtExporter.this.cbxTab.isSelected());
                    TxtExporter.this.txtDelimiter.setEnabled(!TxtExporter.this.cbxTab.isSelected());
                }
            });
            gbl.setConstraints(this.cbxTab, gbc);
            this.add(this.cbxTab);
            gbc.gridwidth = -1;
            gbc.anchor = 18;
            gbc.insets = new Insets(5, 3, 0, 0);
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            JLabel lbl = new JLabel("other delimiter:");
            gbl.setConstraints(lbl, gbc);
            this.add(lbl);
            this.txtDelimiter = new JTextField(";", 5);
            gbl.setConstraints(this.txtDelimiter, gbc);
            this.add(this.txtDelimiter);
        }

        private String getDelimiter() {
            if (this.cbxTab.isSelected()) {
                return "\t";
            }
            return this.txtDelimiter.getText();
        }

        void open() {
            super.open();
            if (this.cbxHeader.isSelected()) {
                StringBuffer buffer = new StringBuffer();
                for (int col = 1; col < MaskExport.this.gbv.getColumnCount(); ++col) {
                    buffer.append(MaskExport.this.gbv.getColumnName(col) + this.getDelimiter());
                }
                if (buffer.length() > 0) {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                this.println(buffer.toString());
            }
        }

        void handle(Object[] vals) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < vals.length; ++i) {
                String val = vals[i] == null ? "null" : vals[i].toString();
                buffer.append(val + this.getDelimiter());
            }
            if (buffer.length() > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            this.println(buffer.toString());
        }
    }

    private class SqlExporter
    extends AbstractExport {
        JCheckBox cbxDelete;
        JTextField txtTable;
        String insert;

        SqlExporter(String content) {
            super("options");
            this.insert = null;
            GridBagLayout gbl = new GridBagLayout();
            this.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            this.cbxDelete = new JCheckBox("with delete statement");
            gbl.setConstraints(this.cbxDelete, gbc);
            this.add(this.cbxDelete);
            gbc.gridwidth = -1;
            gbc.anchor = 18;
            gbc.insets = new Insets(5, 3, 0, 3);
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            JLabel lbl = new JLabel("table name:");
            gbl.setConstraints(lbl, gbc);
            this.add(lbl);
            gbc.fill = 2;
            this.txtTable = new JTextField(content, 10);
            gbl.setConstraints(this.txtTable, gbc);
            this.add(this.txtTable);
        }

        void open() {
            super.open();
            if (this.cbxDelete.isSelected()) {
                this.println("DELETE FROM " + this.txtTable.getText() + ";");
            }
            StringBuffer buffer = new StringBuffer("INSERT INTO " + this.txtTable.getText() + " (");
            for (int col = 1; col < MaskExport.this.gbv.getColumnCount(); ++col) {
                buffer.append(MaskExport.this.gbv.getColumnName(col) + ",");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            this.insert = buffer.toString() + ")";
        }

        void handle(Object[] vals) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < vals.length; ++i) {
                buffer.append(this.toSQLValue(vals[i], i + 1) + ",");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            this.println(this.insert + " VALUES (" + buffer.toString() + ");");
        }

        private String toSQLValue(Object value, int col) {
            if (value == null) {
                return "null";
            }
            switch (MaskExport.this.gbv.getColumnType(col)) {
                case 1: 
                case 12: {
                    value = Text.replaceText(value.toString(), "'", "\\'");
                    return "'" + value.toString() + "'";
                }
                case 91: {
                    return "{d '" + value.toString() + "'}";
                }
                case 92: {
                    return "{t '" + value.toString() + "'}";
                }
                case 93: {
                    return "{ts '" + value.toString() + "'}";
                }
            }
            return value.toString();
        }
    }

    private class WebExporter
    extends AbstractExport {
        JCheckBox cbxHeader;

        WebExporter() {
            super("options");
            this.setLayout(new FlowLayout(0));
            this.cbxHeader = new JCheckBox("with header");
            this.add(this.cbxHeader);
        }

        void open() {
            super.open();
            this.println("<html><body><table border=1>");
            if (this.cbxHeader.isSelected()) {
                this.print("<tr>");
                for (int col = 1; col < MaskExport.this.gbv.getColumnCount(); ++col) {
                    this.print("<th>" + MaskExport.this.gbv.getColumnName(col) + "</th>");
                }
                this.println("</tr>");
            }
        }

        void handle(Object[] vals) {
            this.print("<tr>");
            for (int i = 0; i < vals.length; ++i) {
                String val = vals[i] == null ? "null" : vals[i].toString();
                this.print("<td>" + val + "</td>");
            }
            this.println("</tr>");
        }

        void close() {
            this.println("</table></body></html>");
            super.close();
        }
    }

    private abstract class AbstractExport
    extends JPanel {
        private PrintStream stream;

        AbstractExport(String title) {
            this.setBorder(new TitledBorder(title));
        }

        void open() {
            try {
                this.stream = new PrintStream(new FileOutputStream(MaskExport.this.lblFile.getText().substring(6)));
            }
            catch (FileNotFoundException e) {
                Application.println(e, true);
            }
        }

        abstract void handle(Object[] var1);

        void close() {
            this.stream.close();
        }

        void print(String s) {
            this.stream.print(s);
        }

        void println(String s) {
            this.stream.println(s);
        }
    }
}

