/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.cmd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import nickyb.sqleonardo.ctrl.cmd._ClauseOwner;

public class BaseDynamicTable
extends JTable {
    _ClauseOwner owner;

    BaseDynamicTable(_ClauseOwner owner, int col) {
        this.owner = owner;
        this.initTableModel(col);
    }

    void initTableModel(int col) {
        DefaultTableModel model = new DefaultTableModel(1, col + 1){

            public boolean isCellEditable(int row, int column) {
                return row < this.getRowCount() - 1 || column == 0;
            }
        };
        this.setModel(model);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setDefaultRenderer(Object.class, new InternalCellRenderer());
        this.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.getTableHeader().setVisible(false);
        TableColumn tableColumn = this.getColumn(0);
        tableColumn.setCellEditor(new ButtonCell());
        tableColumn.setCellRenderer(new ButtonCell());
        tableColumn.setPreferredWidth(15);
        tableColumn.setMaxWidth(15);
        tableColumn.setResizable(false);
    }

    protected TableColumn getColumn(int index) {
        return this.getColumn(this.getColumnName(index));
    }

    public int addRow() {
        int row = this.getRowCount() - 1;
        this.editingStopped(new ChangeEvent(this));
        ((DefaultTableModel)this.getModel()).insertRow(row, new Object[this.getColumnCount()]);
        return row;
    }

    public void removeRow() {
        this.editingCanceled(new ChangeEvent(this));
        ((DefaultTableModel)this.getModel()).removeRow(this.getSelectedRow());
    }

    public void removeRows() {
        this.editingStopped(new ChangeEvent(this));
        int i = 0;
        while (this.getRowCount() > 1) {
            ((DefaultTableModel)this.getModel()).removeRow(0);
            ++i;
        }
    }

    public final void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.owner != null) {
            this.owner.fireQueryChanged();
        }
    }

    private class ButtonCell
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer,
    ActionListener {
        private JButton button = new JButton();

        private ButtonCell() {
            this.button.addActionListener(this);
            this.button.setBorder(null);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.button.getText().equals("+")) {
                BaseDynamicTable.this.addRow();
                this.setMinus();
            } else {
                BaseDynamicTable.this.removeRow();
            }
        }

        private void setMinus() {
            this.button.setToolTipText("remove");
            this.button.setText("-");
        }

        private void setPlus() {
            this.button.setToolTipText("add");
            this.button.setText("+");
        }

        private Component getCell(JTable table, int row) {
            if (row == table.getRowCount() - 1) {
                this.setPlus();
            } else {
                this.setMinus();
            }
            return this.button;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.getCell(table, row);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.getCell(table, row);
        }

        public Object getCellEditorValue() {
            return this.button.getText();
        }
    }

    private class InternalCellRenderer
    extends DefaultTableCellRenderer {
        private InternalCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.isCellEditable(row, column)) {
                super.setBackground(UIManager.getColor("Table.background"));
            } else {
                super.setBackground(UIManager.getColor("TableHeader.background"));
            }
            this.setFont(table.getFont());
            this.setValue(value);
            return this;
        }
    }
}

