/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class JRXmlWriteHelper {
    private final Writer writer;
    private final List indents;
    private int indent;
    private final List elementStack;
    private StringBuffer buffer;
    private StackElement lastElement;
    protected static final int COLOR_MASK = Integer.parseInt("FFFFFF", 16);

    public JRXmlWriteHelper(Writer writer) {
        this.writer = writer;
        this.indents = new ArrayList();
        this.indent = 0;
        this.elementStack = new ArrayList();
        this.lastElement = null;
        this.clearBuffer();
    }

    public void writeProlog(String encoding) throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n");
    }

    public void writePublicDoctype(String rootElement, String description, String dtdLocation) throws IOException {
        this.writer.write("<!DOCTYPE " + rootElement + " PUBLIC \"" + description + "\" \"" + dtdLocation + "\">\n\n");
    }

    public void startElement(String name) {
        ++this.indent;
        this.lastElement = new StackElement(name);
        this.elementStack.add(this.lastElement);
    }

    protected void writeParents(boolean content) throws IOException {
        int stackSize = this.elementStack.size();
        for (int startWrite = stackSize - 1; startWrite >= 0; --startWrite) {
            StackElement element = (StackElement)this.elementStack.get(startWrite);
            if (element.hasChildren) break;
            if (startWrite < stackSize - 1) {
                element.hasChildren = true;
                continue;
            }
            element.hasChildren |= content;
        }
        for (int i = startWrite + 1; i < stackSize; ++i) {
            StackElement element = (StackElement)this.elementStack.get(i);
            this.writeElementAttributes(element, i);
        }
    }

    public void writeCDATA(String data) throws IOException {
        if (data != null) {
            this.writeParents(true);
            this.buffer.append(this.getIndent(this.indent));
            this.buffer.append("<![CDATA[");
            this.buffer.append(data);
            this.buffer.append("]]>\n");
            this.flushBuffer();
        }
    }

    public void writeCDATAElement(String name, String data) throws IOException {
        if (data != null) {
            this.writeParents(true);
            this.buffer.append(this.getIndent(this.indent));
            this.buffer.append('<');
            this.buffer.append(name);
            this.buffer.append("><![CDATA[");
            this.buffer.append(data);
            this.buffer.append("]]></");
            this.buffer.append(name);
            this.buffer.append(">\n");
            this.flushBuffer();
        }
    }

    public void writeCDATAElement(String name, String data, String attName, String attValue) throws IOException {
        if (data != null) {
            this.writeParents(true);
            this.buffer.append(this.getIndent(this.indent));
            this.buffer.append('<');
            this.buffer.append(name);
            this.buffer.append(' ');
            this.buffer.append(attName);
            this.buffer.append("=\"");
            this.buffer.append(attValue);
            this.buffer.append("\"><![CDATA[");
            this.buffer.append(data);
            this.buffer.append("]]></");
            this.buffer.append(name);
            this.buffer.append(">\n");
            this.flushBuffer();
        }
    }

    protected void writeElementAttributes(StackElement element, int level) throws IOException {
        this.buffer.append(this.getIndent(level));
        this.buffer.append('<');
        this.buffer.append(element.name);
        Iterator i = element.atts.iterator();
        while (i.hasNext()) {
            Attribute att = (Attribute)i.next();
            this.buffer.append(' ');
            this.buffer.append(att.name);
            this.buffer.append("=\"");
            this.buffer.append(att.value);
            this.buffer.append('\"');
        }
        if (element.hasChildren) {
            this.buffer.append(">\n");
        } else {
            this.buffer.append("/>\n");
        }
        this.flushBuffer();
    }

    public void closeElement() throws IOException {
        this.closeElement(false);
    }

    public void closeElement(boolean skipIfEmpty) throws IOException {
        --this.indent;
        if (skipIfEmpty && this.lastElement.atts.size() == 0 && !this.lastElement.hasChildren) {
            this.clearBuffer();
        } else {
            this.writeParents(false);
            if (this.lastElement.hasChildren) {
                this.buffer.append(this.getIndent(this.indent));
                this.buffer.append("</");
                this.buffer.append(this.lastElement.name);
                this.buffer.append(">\n");
                this.flushBuffer();
            }
        }
        this.elementStack.remove(this.indent);
        this.lastElement = this.indent > 0 ? (StackElement)this.elementStack.get(this.indent - 1) : null;
    }

    protected char[] getIndent(int level) {
        if (level >= this.indents.size()) {
            for (int i = this.indents.size(); i <= level; ++i) {
                char[] str = new char[i];
                Arrays.fill(str, '\t');
                this.indents.add(str);
            }
        }
        return (char[])this.indents.get(level);
    }

    protected void flushBuffer() throws IOException {
        this.writer.write(this.buffer.toString());
        this.clearBuffer();
    }

    protected void clearBuffer() {
        this.buffer = new StringBuffer();
    }

    public void writeExpression(String name, JRExpression expression, boolean writeClass) throws IOException {
        this.writeExpression(name, expression, writeClass, null);
    }

    public void writeExpression(String name, JRExpression expression, boolean writeClass, String defaultClassName) throws IOException {
        if (expression != null) {
            if (writeClass && (defaultClassName == null || !defaultClassName.equals(expression.getValueClassName()))) {
                this.writeCDATAElement(name, expression.getText(), "class", expression.getValueClassName());
            } else {
                this.writeCDATAElement(name, expression.getText());
            }
        }
    }

    protected void writeAttribute(String name, String value) {
        this.lastElement.addAttribute(name, value);
    }

    public void addAttribute(String name, String value) {
        if (value != null) {
            this.writeAttribute(name, value);
        }
    }

    public void addEncodedAttribute(String name, String value) {
        if (value != null) {
            this.writeAttribute(name, JRStringUtil.xmlEncode(value));
        }
    }

    public void addAttribute(String name, String value, String defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            this.writeAttribute(name, value);
        }
    }

    public void addEncodedAttribute(String name, String value, String defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            this.writeAttribute(name, JRStringUtil.xmlEncode(value));
        }
    }

    public void addAttribute(String name, Object value) {
        if (value != null) {
            this.writeAttribute(name, String.valueOf(value));
        }
    }

    public void addAttribute(String name, int value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void addAttributePositive(String name, int value) {
        if (value > 0) {
            this.writeAttribute(name, String.valueOf(value));
        }
    }

    public void addAttribute(String name, float value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void addAttribute(String name, float value, float defaultValue) {
        if (value != defaultValue) {
            this.writeAttribute(name, String.valueOf(value));
        }
    }

    public void addAttribute(String name, double value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void addAttribute(String name, double value, double defaultValue) {
        if (value != defaultValue) {
            this.writeAttribute(name, String.valueOf(value));
        }
    }

    public void addAttribute(String name, int value, int defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(String name, boolean value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void addAttribute(String name, boolean value, boolean defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(String name, Color value) {
        if (value != null) {
            this.writeAttribute(name, "#" + JRXmlWriteHelper.getHexaColor(value));
        }
    }

    public void addAttribute(String name, Color value, Color defaultValue) {
        if (value != null && value.getRGB() != defaultValue.getRGB()) {
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(String name, byte value, Map xmlValues) {
        String xmlValue = (String)xmlValues.get(new Byte(value));
        this.writeAttribute(name, xmlValue);
    }

    public void addAttribute(String name, int value, Map xmlValues) {
        String xmlValue = (String)xmlValues.get(new Integer(value));
        this.writeAttribute(name, xmlValue);
    }

    public void addAttribute(String name, byte value, Map xmlValues, byte defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value, xmlValues);
        }
    }

    public void addAttribute(String name, Object value, Map xmlValues) {
        if (value != null) {
            String xmlValue = (String)xmlValues.get(value);
            this.writeAttribute(name, xmlValue);
        }
    }

    public void addAttribute(String name, Object value, Map xmlValues, Object defaultValue) {
        if (!value.equals(defaultValue)) {
            this.addAttribute(name, value, xmlValues);
        }
    }

    protected static String getHexaColor(Color color) {
        String hexa = Integer.toHexString(color.getRGB() & COLOR_MASK).toUpperCase();
        return ("000000" + hexa).substring(hexa.length());
    }

    protected static class StackElement {
        String name;
        List atts;
        boolean hasChildren;

        StackElement(String name) {
            this.name = name;
            this.atts = new ArrayList();
            this.hasChildren = false;
        }

        void addAttribute(String attName, String value) {
            this.atts.add(new Attribute(attName, value));
        }
    }

    protected static class Attribute {
        String name;
        String value;

        Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

