/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.List;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.ColumnConstraint;

public class CellRequest {
    private final RolapStar.Measure measure;
    private final List columnList = new ArrayList();
    private final List valueList = new ArrayList();
    private RolapStar.Column[] columns = null;
    private BitKey bitKey;

    public CellRequest(RolapStar.Measure measure) {
        this.measure = measure;
        this.columnList.add(measure.getStar());
        this.bitKey = BitKey.Factory.makeBitKey(measure.getStar().getColumnCount());
    }

    public void addConstrainedColumn(RolapStar.Column column, Object value) {
        this.columnList.add(column);
        this.bitKey.setByPos(column.getBitPosition());
        if (value != null) {
            value = new ColumnConstraint(value);
        }
        this.valueList.add(value);
    }

    public RolapStar.Measure getMeasure() {
        return this.measure;
    }

    public RolapStar.Column[] getColumns() {
        if (this.columns == null) {
            this.makeColumns();
        }
        return this.columns;
    }

    private void makeColumns() {
        this.columns = new RolapStar.Column[this.columnList.size() - 1];
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = (RolapStar.Column)this.columnList.get(i + 1);
        }
    }

    public BitKey getBatchKey() {
        return this.bitKey;
    }

    public List getValueList() {
        return this.valueList;
    }

    public Object[] getSingleValues() {
        Object[] a = new Object[this.valueList.size()];
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            ColumnConstraint constr = (ColumnConstraint)this.valueList.get(i);
            a[i] = constr.getValue();
        }
        return a;
    }
}

