/*
 * Copyright (C) 2005 - 2006 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * FontSheetPropertyComponent.java
 * 
 * Created on 15 agosto 2005, 13.32
 *
 */

package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.gui.JRFontDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;

/**
 *
 * @author  Administrator
 */
public class FontSheetPropertyComponent extends javax.swing.JPanel {
    
    String expression = "";
    private java.awt.Font font = null;
    private IReportFont ireportFont = null;
        
    /** Creates new form ExpressionSheetPanel */
    public FontSheetPropertyComponent() {
        initComponents();
        font = jLabelFont.getFont();
        applyI18n();
    }
    
    public void fontChanged()
    {
        java.awt.event.ActionEvent event = new java.awt.event.ActionEvent(this,0,"");
        fireActionListenerActionPerformed(event);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelFont = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setBackground(new java.awt.Color(255, 255, 255));
        jLabelFont.setBackground(new java.awt.Color(255, 255, 255));
        jLabelFont.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        add(jLabelFont, gridBagConstraints);

        jButton1.setText("...");
        jButton1.setMaximumSize(new java.awt.Dimension(19, 10));
        jButton1.setMinimumSize(new java.awt.Dimension(19, 10));
        jButton1.setPreferredSize(new java.awt.Dimension(19, 10));
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(jButton1, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed

        
        it.businesslogic.ireport.gui.JRFontDialog jrfd = new it.businesslogic.ireport.gui.JRFontDialog(MainFrame.getMainInstance(), true);
        
        jrfd.updateFonts( it.businesslogic.ireport.gui.MainFrame.getMainInstance().getTtfFonts());
        jrfd.setReportFontMode(fontMode);
        if (ireportFont != null)
        {
            jrfd.setIReportFont( (IReportFont)ireportFont.clone() );
        }
        else
        {
            jrfd.setIReportFont( new IReportFont() );
        }
        
        jrfd.setVisible(true);
        if (jrfd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            setIreportFont( jrfd.getIReportFont() );
            fontChanged();
        }
         
    }//GEN-LAST:event_jButton1ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabelFont;
    // End of variables declaration//GEN-END:variables

    /**
     * Utility field used by event firing mechanism.
     */
    private javax.swing.event.EventListenerList listenerList =  null;

    /**
     * Registers ActionListener to receive events.
     * @param listener The listener to register.
     */
    public synchronized void addActionListener(java.awt.event.ActionListener listener) {

        if (listenerList == null ) {
            listenerList = new javax.swing.event.EventListenerList();
        }
        listenerList.add (java.awt.event.ActionListener.class, listener);
    }

    /**
     * Removes ActionListener from the list of listeners.
     * @param listener The listener to remove.
     */
    public synchronized void removeActionListener(java.awt.event.ActionListener listener) {

        listenerList.remove (java.awt.event.ActionListener.class, listener);
    }

    /**
     * Notifies all registered listeners about the event.
     * 
     * @param event The event to be fired
     */
    private void fireActionListenerActionPerformed(java.awt.event.ActionEvent event) {

        if (listenerList == null) return;
        Object[] listeners = listenerList.getListenerList ();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i]==java.awt.event.ActionListener.class) {
                ((java.awt.event.ActionListener)listeners[i+1]).actionPerformed (event);
            }
        }
    }

    public IReportFont getIreportFont() {
        return ireportFont;
    }

    public void setIreportFont(IReportFont ireportFont) {
        this.ireportFont = ireportFont;
        
        
        if (ireportFont == null) ireportFont = new IReportFont();

        jLabelFont.setFont(ireportFont.getJavaAWTFont());
        String bold = (ireportFont.isBold() ? " bold" : "");
        jLabelFont.setText(ireportFont.getFontName() + " " + ireportFont.getFontSize() + bold);
        
    }
    
    // 0 = element font
    // 1 = report font
    // 2 = style font
    private int fontMode = 0;
    public int getFontMode() {
        return fontMode;
    }

    public void setFontMode(int fontMode) {
        this.fontMode = fontMode;
    }
    
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jButton1.setText(I18n.getString("fontSheetPropertyComponent.button1","..."));
                // End autogenerated code ----------------------
    }
}
