/**   
 * Copyright (C) 2005, 2006 CINCOM SYSTEMS, INC.
 * All Rights Reserved
 * www.cincom.com
 *
 * JRXMLADataSourceConnection.java
 * @authors MPenningroth, HMays.
 */

package it.businesslogic.ireport.connection;
import it.businesslogic.ireport.util.*;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.query.JRXmlaQueryExecuterFactory;
import rex.graphics.datasourcetree.elements.*;

public class JRXMLADataSourceConnection extends it.businesslogic.ireport.IReportConnection {
    
    private String url;
    
    
    /** Creates a new instance of JRXMLADataSourceConnection */
    public JRXMLADataSourceConnection() {
        
    }
    
    /**
     * Returns the url of XMLA Server.
     * @return Value of property url.
     */
    public String getUrl() {
        return this.url;
    }
    
    /**
     * Setter method for url.
     * @param <code>String</code> assigns value of the  <code>url </code>
     */
    public void setUrl(String url) {
        this.url = url;
    }
    /**
     * Returns XMLA Datasource
     */
    public String getDescription(){ return "XMLA Datasource"; }
    
    public java.util.HashMap getProperties() {
        java.util.HashMap map = new java.util.HashMap();
        map.put("url", Misc.nvl(this.getUrl(),"") );
        map.put("datasource", Misc.nvl(this.getDatasource(),"") );
        map.put("catalog", Misc.nvl(this.getCatalog(),"") );
        map.put("cube", Misc.nvl(this.getCube(),"") ); 
        return map;
    }
    /**
     * Assigns the values of Url, Datasource, Catalog, Cube
     */
    public void loadProperties(java.util.HashMap map) {
        this.setUrl( (String)map.get("url"));
        this.setDatasource((String)map.get("datasource"));
        this.setCatalog((String)map.get("catalog"));
        this.setCube((String)map.get("cube")); 
    }
    
    /**
     * Holds value of property datasource.
     */
    private String datasource;
    
    /**
     * Getter for property datasource.
     * @return Value of property datasource.
     */
    public String getDatasource() {
        return this.datasource;
    }
    
    /**
     * Setter for property datasource.
     * @param datasource New value of property datasource.
     */
    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }
    
    /**
     * Holds value of property catalog.
     */
    private String catalog;
    
    /**
     * Getter for property catalog.
     * @return Value of property catalog.
     */
    public String getCatalog() {
        return this.catalog;
    }
    
    /**
     * Setter for property catalog.
     * @param catalog New value of property catalog.
     */
    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }
    
    /**
     * Holds value of property cube.
     */
    private String cube;
    
    /**
     * Getter for property cube.
     * @return Value of property cube.
     */
    public String getCube() {
        return this.cube;
    }
    
    /**
     * Setter for property cube.
     * @param cube New value of property cube.
     */
    public void setCube(String cube) {
        this.cube = cube;
    }
    

    /*
   * Return true if this ireport connection can be used using getJRDataSource
   * I.E. you can see JDBCConnection
   */
  public boolean isJRDataSource() { return false; }
  

  /**
     * This method is call before the datasource is used and permit to add special parameters to the map
     *
     */
    public Map getSpecialParameters(Map map) throws net.sf.jasperreports.engine.JRException
    {
       //System.out.println("Starting XMLA MDX Query");
        map.put(JRXmlaQueryExecuterFactory.PARAM_XMLA_URL, getUrl());
        map.put(JRXmlaQueryExecuterFactory.PARAM_XMLA_DS, getDatasource());
        map.put(JRXmlaQueryExecuterFactory.PARAM_XMLA_CAT, getCatalog());
        
        
        map.put(net.sf.jasperreports.olap.xmla.JRXmlaQueryExecuterFactory.PARAMETER_XMLA_URL, getUrl());
        map.put(net.sf.jasperreports.olap.xmla.JRXmlaQueryExecuterFactory.PARAMETER_XMLA_DATASOURCE, getDatasource());
        map.put(net.sf.jasperreports.olap.xmla.JRXmlaQueryExecuterFactory.PARAMETER_XMLA_CATALOG, getCatalog());

        //System.out.println("XMLA MDX Query completed");
        
        return map;
    }
    
    /**
     * This method is call after the datasource is used to dispose special parameters
     * (i.e. closing an Hibernate session create as parameter with a getSpecialParameters...
     *
     */
    public Map disposeSpecialParameters(Map map)
    {
        return map;
    }
}
