/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.javaflow.bytecode.transformation.ResourceTransformer;
import org.apache.commons.javaflow.bytecode.transformation.bcel.BcelClassTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ContinuationClassLoader
extends URLClassLoader {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$javaflow$ContinuationClassLoader == null ? (class$org$apache$commons$javaflow$ContinuationClassLoader = ContinuationClassLoader.class$("org.apache.commons.javaflow.ContinuationClassLoader")) : class$org$apache$commons$javaflow$ContinuationClassLoader));
    private final ResourceTransformer transformer;
    private boolean parentFirst = true;
    private List systemPackages = new ArrayList();
    private List loaderPackages = new ArrayList();
    private boolean ignoreBase = false;
    private final AccessControlContext acc;
    private static final int BUFFER_SIZE = 4096;
    static /* synthetic */ Class class$org$apache$commons$javaflow$ContinuationClassLoader;

    public ContinuationClassLoader(URL[] urls, ClassLoader parent, ResourceTransformer transformer) {
        super(urls, ContinuationClassLoader.fixNullParent(parent));
        if (transformer == null) {
            throw new IllegalArgumentException();
        }
        this.transformer = transformer;
        this.acc = AccessController.getContext();
    }

    public ContinuationClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, new BcelClassTransformer());
    }

    private static ClassLoader fixNullParent(ClassLoader classLoader) {
        if (classLoader != null) {
            return classLoader;
        }
        return ContinuationClassLoader.getSystemClassLoader();
    }

    public void setParentFirst(boolean parentFirst) {
        this.parentFirst = parentFirst;
    }

    public void setIsolated(boolean isolated) {
        this.ignoreBase = isolated;
    }

    public synchronized void addSystemPackageRoot(String packageRoot) {
        this.systemPackages.add(this.appendDot(packageRoot));
    }

    public synchronized void addLoaderPackageRoot(String packageRoot) {
        this.loaderPackages.add(this.appendDot(packageRoot));
    }

    private String appendDot(String str) {
        if (str.endsWith(".")) {
            str = str + '.';
        }
        return str;
    }

    public Class forceLoadClass(String classname) throws ClassNotFoundException {
        log.debug((Object)("force loading " + classname));
        Class theClass = this.findLoadedClass(classname);
        if (theClass == null) {
            theClass = this.findClass(classname);
        }
        return theClass;
    }

    private synchronized boolean isParentFirst(String resourceName) {
        String packageName;
        boolean useParentFirst = this.parentFirst;
        Iterator itr = this.systemPackages.iterator();
        while (itr.hasNext()) {
            packageName = (String)itr.next();
            if (!resourceName.startsWith(packageName)) continue;
            useParentFirst = true;
            break;
        }
        itr = this.loaderPackages.iterator();
        while (itr.hasNext()) {
            packageName = (String)itr.next();
            if (!resourceName.startsWith(packageName)) continue;
            useParentFirst = false;
            break;
        }
        return useParentFirst;
    }

    protected synchronized Class loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        Class<?> theClass = this.findLoadedClass(classname);
        if (theClass != null) {
            return theClass;
        }
        if (this.isParentFirst(classname)) {
            try {
                theClass = this.getParent().loadClass(classname);
                log.debug((Object)("Class " + classname + " loaded from parent loader " + "(parentFirst)"));
            }
            catch (ClassNotFoundException cnfe) {
                theClass = this.findClass(classname);
                log.debug((Object)("Class " + classname + " loaded from ant loader " + "(parentFirst)"));
            }
        } else {
            try {
                theClass = this.findClass(classname);
                log.debug((Object)("Class " + classname + " loaded from ant loader"));
            }
            catch (ClassNotFoundException cnfe) {
                if (this.ignoreBase) {
                    throw cnfe;
                }
                theClass = this.getParent().loadClass(classname);
                log.debug((Object)("Class " + classname + " loaded from parent loader"));
            }
        }
        if (resolve) {
            this.resolveClass(theClass);
        }
        return theClass;
    }

    protected Class defineClassFromData(final byte[] classData, final String classname) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String packageName;
                Package pkg;
                int i = classname.lastIndexOf(46);
                if (i > 0 && (pkg = ContinuationClassLoader.this.getPackage(packageName = classname.substring(0, i))) == null) {
                    ContinuationClassLoader.this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                byte[] newData = ContinuationClassLoader.this.transformer.transform(classData);
                ProtectionDomain domain = this.getClass().getProtectionDomain();
                return ContinuationClassLoader.this.defineClass(classname, newData, 0, newData.length, domain);
            }
        }, this.acc);
    }

    private Class getClassFromStream(InputStream stream, String classname) throws IOException, SecurityException {
        int bytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((bytesRead = stream.read(buffer, 0, 4096)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] classData = baos.toByteArray();
        return this.defineClassFromData(classData, classname);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        log.debug((Object)("Finding class " + name));
        String classFileName = name.replace('.', '/') + ".class";
        InputStream stream = this.getResourceAsStream(classFileName);
        if (stream == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            Class clazz = this.getClassFromStream(stream, name);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    public synchronized URL getResource(String name) {
        if (this.isParentFirst(name)) {
            return super.getResource(name);
        }
        URL url = this.findResource(name);
        if (url == null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

