/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.io;

import java.io.IOException;
import java.util.Iterator;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.util.Store;
import nickyb.sqleonardo.ctrl.querybuilder.QueryModel;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryExpression;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.io.FileStreamOLD;

public class FileStreamLQY {
    public static QueryModel read(String filename) throws IOException, ClassNotFoundException {
        QueryModel model;
        Store qstore = new Store();
        qstore.load(filename);
        qstore.mount("$INFO");
        String version = qstore.jump("version").get(0).toString();
        if (version.length() > 7) {
            version = version.substring(0, 7);
        }
        if (Double.valueOf(version) < 2006.05) {
            model = new QueryModel();
            FileStreamOLD.convert(qstore, model);
        } else {
            qstore.mount("$QUERY");
            Object schema = null;
            if (qstore.canJump("schema")) {
                schema = qstore.jump("schema").get(0);
            }
            model = new QueryModel(schema == null ? null : schema.toString());
            model.setQueryExpression(FileStreamLQY.read(qstore, 0));
            qstore.home();
            qstore.jump("order_by_clause");
            Iterator i = qstore.jump().iterator();
            while (i.hasNext()) {
                QueryTokens.Sort token = FileStreamLQY.toOrder(i.next());
                model.addOrderByClause(token);
            }
        }
        return model;
    }

    private static QueryExpression read(Store qstore, int idx) {
        QueryTokens._Base token;
        qstore.home();
        if (!qstore.canJump("query_expression_" + idx)) {
            return null;
        }
        QueryExpression qe = new QueryExpression();
        qstore.jump("query_expression_" + idx);
        qstore.jump("quantifier");
        qe.getQuerySpecification().setQuantifier(FileStreamLQY.toShort(qstore.jump().get(0)));
        qstore.home();
        qstore.jump("query_expression_" + idx);
        qstore.jump("is_asterisk");
        qe.getQuerySpecification().setAsterisk(FileStreamLQY.toBoolean(qstore.jump().get(0)));
        qstore.home();
        qstore.jump("query_expression_" + idx);
        qstore.jump("select_list");
        Iterator i = qstore.jump().iterator();
        while (i.hasNext()) {
            token = FileStreamLQY.toExpression(i.next());
            qe.getQuerySpecification().addSelectList((QueryTokens._Expression)token);
        }
        qstore.home();
        qstore.jump("query_expression_" + idx);
        qstore.jump("from_clause");
        i = qstore.jump().iterator();
        while (i.hasNext()) {
            token = FileStreamLQY.toTableReference(i.next());
            qe.getQuerySpecification().addFromClause((QueryTokens._TableReference)token);
        }
        qstore.home();
        qstore.jump("query_expression_" + idx);
        qstore.jump("where_clause");
        i = qstore.jump().iterator();
        while (i.hasNext()) {
            token = FileStreamLQY.toCondition(i.next());
            qe.getQuerySpecification().addWhereClause((QueryTokens.Condition)token);
        }
        qstore.home();
        qstore.jump("query_expression_" + idx);
        qstore.jump("group_by_clause");
        i = qstore.jump().iterator();
        while (i.hasNext()) {
            token = FileStreamLQY.toGroup(i.next());
            qe.getQuerySpecification().addGroupByClause((QueryTokens.Group)token);
        }
        qstore.home();
        qstore.jump("query_expression_" + idx);
        qstore.jump("having_clause");
        i = qstore.jump().iterator();
        while (i.hasNext()) {
            token = FileStreamLQY.toCondition(i.next());
            qe.getQuerySpecification().addHavingClause((QueryTokens.Condition)token);
        }
        qe.setUnion(FileStreamLQY.read(qstore, idx + 1));
        return qe;
    }

    private static Boolean toBoolean(Object o) {
        return o == null ? null : (Boolean)o;
    }

    private static Integer toInteger(Object o) {
        return o == null ? null : (Integer)o;
    }

    private static Short toShort(Object o) {
        return o == null ? null : (Short)o;
    }

    private static String toString(Object o) {
        return o == null ? null : (String)o;
    }

    private static QueryTokens._Expression toExpression(Object o) {
        if (o == null) {
            return new QueryTokens.DefaultExpression(null);
        }
        return o instanceof String ? new QueryTokens.DefaultExpression(o.toString()) : FileStreamLQY.toColumn(o);
    }

    private static QueryTokens._TableReference toTableReference(Object o) {
        return ((Object[])o).length == 3 ? FileStreamLQY.toTable(o) : FileStreamLQY.toJoin(o);
    }

    private static QueryTokens.Column toColumn(Object o) {
        Object[] a = (Object[])o;
        QueryTokens.Table table = FileStreamLQY.toTable(a[0]);
        QueryTokens.Column column = new QueryTokens.Column(table, FileStreamLQY.toString(a[1]));
        column.setAlias(FileStreamLQY.toString(a[2]));
        return column;
    }

    private static QueryTokens.Table toTable(Object o) {
        Object[] a = (Object[])o;
        QueryTokens.Table table = new QueryTokens.Table(FileStreamLQY.toString(a[0]), FileStreamLQY.toString(a[1]));
        table.setAlias(FileStreamLQY.toString(a[2]));
        return table;
    }

    private static QueryTokens.Join toJoin(Object o) {
        Object[] a = (Object[])o;
        QueryTokens.Condition condition = FileStreamLQY.toCondition(a[1]);
        return new QueryTokens.Join(FileStreamLQY.toInteger(a[0]), (QueryTokens.Column)condition.getLeft(), condition.getOperator(), (QueryTokens.Column)condition.getRight());
    }

    private static QueryTokens.Condition toCondition(Object o) {
        Object[] a = (Object[])o;
        return new QueryTokens.Condition(FileStreamLQY.toString(a[0]), FileStreamLQY.toExpression(a[1]), FileStreamLQY.toString(a[2]), FileStreamLQY.toExpression(a[3]));
    }

    private static QueryTokens.Group toGroup(Object o) {
        return new QueryTokens.Group(FileStreamLQY.toExpression(o));
    }

    private static QueryTokens.Sort toOrder(Object o) {
        Object[] a = (Object[])o;
        return new QueryTokens.Sort(FileStreamLQY.toExpression(a[0]), FileStreamLQY.toShort(a[1]));
    }

    public static void write(String filename, QueryModel model) throws IOException {
        Store qstore = new Store();
        qstore.mount("$INFO");
        qstore.jump("version").add(Application.getVersion());
        qstore.mount("$QUERY");
        qstore.jump("schema").add(model.getSchema());
        FileStreamLQY.write(qstore, model.getQueryExpression(), 0);
        qstore.home();
        qstore.jump("order_by_clause");
        FileStreamLQY.write(qstore, model.getOrderByClause());
        qstore.save(filename);
    }

    private static void write(Store qstore, QueryExpression qe, int idx) {
        if (qe == null) {
            return;
        }
        qstore.home();
        qstore.jump("query_expression_" + idx);
        qstore.jump("quantifier").add(new Short(qe.getQuerySpecification().getQuantifier()));
        qstore.home();
        qstore.jump("query_expression_" + idx);
        qstore.jump("is_asterisk").add(new Boolean(qe.getQuerySpecification().isAsteriskSet()));
        qstore.home();
        qstore.jump("query_expression_" + idx);
        qstore.jump("select_list");
        FileStreamLQY.write(qstore, qe.getQuerySpecification().getSelectList());
        qstore.home();
        qstore.jump("query_expression_" + idx);
        qstore.jump("from_clause");
        FileStreamLQY.write(qstore, qe.getQuerySpecification().getFromClause());
        qstore.home();
        qstore.jump("query_expression_" + idx);
        qstore.jump("where_clause");
        FileStreamLQY.write(qstore, qe.getQuerySpecification().getWhereClause());
        qstore.home();
        qstore.jump("query_expression_" + idx);
        qstore.jump("group_by_clause");
        FileStreamLQY.write(qstore, qe.getQuerySpecification().getGroupByClause());
        qstore.home();
        qstore.jump("query_expression_" + idx);
        qstore.jump("having_clause");
        FileStreamLQY.write(qstore, qe.getQuerySpecification().getHavingClause());
        FileStreamLQY.write(qstore, qe.getUnion(), idx + 1);
    }

    private static void write(Store qstore, Object[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            Object row = null;
            row = tokens[i] instanceof QueryTokens._Expression ? FileStreamLQY.toArray((QueryTokens._Expression)tokens[i]) : (tokens[i] instanceof QueryTokens.Condition ? FileStreamLQY.toArray((QueryTokens.Condition)tokens[i]) : (tokens[i] instanceof QueryTokens.Join ? FileStreamLQY.toArray((QueryTokens.Join)tokens[i]) : (tokens[i] instanceof QueryTokens.Sort ? FileStreamLQY.toArray((QueryTokens.Sort)tokens[i]) : (tokens[i] instanceof QueryTokens.Group ? FileStreamLQY.toArray((QueryTokens.Group)tokens[i]) : (tokens[i] instanceof QueryTokens.Table ? FileStreamLQY.toArray((QueryTokens.Table)tokens[i]) : tokens[i].toString())))));
            qstore.jump().add(row);
        }
    }

    private static Object toArray(QueryTokens._Expression token) {
        if (token == null) {
            return null;
        }
        return token instanceof QueryTokens.Column ? FileStreamLQY.toArray((QueryTokens.Column)token) : token.toString();
    }

    private static Object toArray(QueryTokens.Column token) {
        return new Object[]{FileStreamLQY.toArray(token.getTable()), token.getName(), token.getAlias()};
    }

    private static Object toArray(QueryTokens.Condition token) {
        return new Object[]{token.getAppend(), FileStreamLQY.toArray(token.getLeft()), token.getOperator(), FileStreamLQY.toArray(token.getRight())};
    }

    private static Object toArray(QueryTokens.Join token) {
        return new Object[]{new Integer(token.getType()), FileStreamLQY.toArray(token.getCondition())};
    }

    private static Object toArray(QueryTokens.Table token) {
        return new Object[]{token.getSchema(), token.getName(), token.getAlias()};
    }

    private static Object toArray(QueryTokens.Group token) {
        Object expr = token.getExpression().toString();
        if (token.getExpression() instanceof QueryTokens.Column) {
            expr = FileStreamLQY.toArray((QueryTokens.Column)token.getExpression());
        }
        return expr;
    }

    private static Object toArray(QueryTokens.Sort token) {
        Object expr = token.getExpression().toString();
        if (token.getExpression() instanceof QueryTokens.Column) {
            expr = FileStreamLQY.toArray((QueryTokens.Column)token.getExpression());
        }
        return new Object[]{expr, new Short(token.isAscending() ? (short)0 : 1)};
    }
}

