/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.querybuilder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramEntity;
import nickyb.sqleonardo.ctrl.querybuilder.MaskCondition;
import nickyb.sqleonardo.ctrl.querybuilder.QueryBuilder;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;

public class DiagramField
extends JCheckBox
implements ItemListener,
MouseListener,
PopupMenuListener {
    int position;
    QueryTokens.Column querytoken;
    DiagramEntity owner;
    private int joins;

    DiagramField(DiagramEntity entity, String name, boolean iskey) {
        this.owner = entity;
        this.addMouseListener(this);
        this.addItemListener(this);
        this.setText(iskey ? "<html><u>" + name : name);
        this.setName(name);
        this.setBorder(new EmptyBorder(0, 1, 0, 1));
        this.setBorderPainted(true);
        this.setFocusPainted(false);
        this.setOpaque(true);
        this.setDefaultQueryToken();
    }

    void setDefaultQueryToken() {
        this.querytoken = new QueryTokens.Column(this.owner.querytoken, this.getName());
        if (QueryBuilder.autoAlias) {
            String alias = this.querytoken.getTable().getAlias() + "." + this.querytoken.getName();
            if (alias.length() > QueryBuilder.maxColumnNameLength && QueryBuilder.maxColumnNameLength > 0) {
                alias = alias.substring(0, QueryBuilder.maxColumnNameLength);
            }
            this.querytoken.setAlias(alias);
        }
    }

    void setQueryToken(QueryTokens.Column token) {
        this.querytoken = token;
        this.setSelected(true);
    }

    public void itemStateChanged(ItemEvent ie) {
        this.owner.onSelectionChanged(this);
    }

    public void mouseReleased(MouseEvent me) {
        if (SwingUtilities.isRightMouseButton(me)) {
            JPopupMenu popup = new JPopupMenu(this.getName());
            popup.addPopupMenuListener(this);
            popup.add(new MenuItemSelect());
            popup.addSeparator();
            popup.add(new ActionAddWhere());
            popup.add(new ActionAddHaving());
            popup.addSeparator();
            popup.add(new ActionAddExpression());
            popup.show(this, me.getX(), me.getY());
        } else if (!this.isEnabled()) {
            this.owner.builder.diagram.join(this.owner, this);
        }
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
    }

    public void popupMenuCanceled(PopupMenuEvent pme) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
        this.setBorder(new EmptyBorder(0, 1, 0, 1));
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
        this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
    }

    boolean isJoined() {
        return this.joins > 0;
    }

    void joined() {
        ++this.joins;
    }

    void unjoined() {
        --this.joins;
    }

    private class ActionAddHaving
    extends ActionAddCondition {
        private ActionAddHaving() {
            this.putValue("Name", "add having condition...");
        }

        void add(QueryTokens.Condition token) {
            DiagramField.this.owner.builder.browser.addHavingClause(token);
        }

        boolean isFirst() {
            return DiagramField.this.owner.builder.browser.getQuerySpecification().getHavingClause().length == 0;
        }
    }

    private class ActionAddWhere
    extends ActionAddCondition {
        private ActionAddWhere() {
            this.putValue("Name", "add where condition...");
        }

        void add(QueryTokens.Condition token) {
            DiagramField.this.owner.builder.browser.addWhereClause(token);
        }

        boolean isFirst() {
            return DiagramField.this.owner.builder.browser.getQuerySpecification().getWhereClause().length == 0;
        }
    }

    private abstract class ActionAddCondition
    extends AbstractAction {
        private ActionAddCondition() {
        }

        abstract void add(QueryTokens.Condition var1);

        abstract boolean isFirst();

        public void actionPerformed(ActionEvent e) {
            MaskCondition mask;
            QueryTokens.Condition token = new QueryTokens.Condition();
            token.setLeft(new QueryTokens.DefaultExpression(DiagramField.this.querytoken.getIdentifier()));
            if (!this.isFirst()) {
                token.setAppend("AND");
            }
            if ((mask = new MaskCondition(token)).showDialog() == 0) {
                this.add(token);
            }
        }
    }

    private class ActionAddExpression
    extends AbstractAction {
        private ActionAddExpression() {
            super("add expression...");
        }

        public void actionPerformed(ActionEvent e) {
            Object[] functions = new String[]{"count", "max", "min", "sum"};
            Object choose = JOptionPane.showInputDialog(DiagramField.this.owner.builder, "choose function:", "add expression", -1, null, functions, null);
            if (choose != null) {
                String expr = choose.toString() + "(" + DiagramField.this.querytoken.getIdentifier() + ")";
                QueryTokens.DefaultExpression token = new QueryTokens.DefaultExpression(expr);
                DiagramField.this.owner.builder.browser.addSelectList(token);
            }
        }
    }

    private class MenuItemSelect
    extends JCheckBoxMenuItem
    implements ActionListener {
        private MenuItemSelect() {
            super("select");
            this.addActionListener(this);
            this.setSelected(DiagramField.this.isSelected());
        }

        public void actionPerformed(ActionEvent ae) {
            DiagramField.this.setSelected(this.isSelected());
        }
    }
}

