/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl;

import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.Preferences;
import nickyb.sqleonardo.api.gui.BorderLayoutPanel;
import nickyb.sqleonardo.api.gui.ListView;
import nickyb.sqleonardo.api.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.api.jdbc.ConnectionHandler;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;

public class DefinitionPane
extends BorderLayoutPanel
implements ChangeListener {
    private ListView lvColumns;
    private ListView lvPrimaryKeys;
    private ListView lvIndexInfo;
    private ListView lvExportedKeys;
    private ListView lvImportedKeys;
    private String keycah;
    private QueryTokens.Table table;

    public DefinitionPane(String keycah, QueryTokens.Table table) {
        this.keycah = keycah;
        this.table = table;
        JTabbedPane tp = new JTabbedPane();
        tp.addChangeListener(this);
        tp.setBorder(LineBorder.createGrayLineBorder());
        this.lvColumns = new ListView();
        tp.addTab("columns", this.lvColumns);
        this.lvPrimaryKeys = new ListView();
        tp.addTab("primary keys", this.lvPrimaryKeys);
        this.lvIndexInfo = new ListView();
        tp.addTab("indices", this.lvIndexInfo);
        this.lvExportedKeys = new ListView();
        tp.addTab("exported keys", this.lvExportedKeys);
        this.lvImportedKeys = new ListView();
        tp.addTab("imported keys", this.lvImportedKeys);
        this.setComponentCenter(tp);
    }

    private ConnectionHandler getConnection() {
        return ConnectionAssistant.getHandler(this.keycah);
    }

    private void list(String metaview, ListView lv, ResultSet rs) throws SQLException {
        int i = this.keycah.lastIndexOf(46);
        Preferences.listMetadata(this.keycah.substring(0, i), metaview, lv, rs);
    }

    private void listColumns(JTabbedPane tp) throws SQLException {
        ConnectionHandler ch = this.getConnection();
        String catalog = this.table.getSchema() == null ? null : ch.get().getCatalog();
        ResultSet rs = ch.get().getMetaData().getColumns(catalog, this.table.getSchema(), this.table.getName(), "%");
        this.list("columns", this.lvColumns, rs);
        tp.setTitleAt(0, "columns (" + this.lvColumns.getRowCount() + ")");
    }

    private void listPrimaryKeys(JTabbedPane tp) throws SQLException {
        ConnectionHandler ch = this.getConnection();
        String catalog = this.table.getSchema() == null ? null : ch.get().getCatalog();
        ResultSet rs = ch.get().getMetaData().getPrimaryKeys(catalog, this.table.getSchema(), this.table.getName());
        this.list("primary keys", this.lvPrimaryKeys, rs);
        tp.setTitleAt(1, "primary keys (" + this.lvPrimaryKeys.getRowCount() + ")");
    }

    private void listIndexInfo(JTabbedPane tp) throws SQLException {
        ConnectionHandler ch = this.getConnection();
        String catalog = this.table.getSchema() == null ? null : ch.get().getCatalog();
        ResultSet rs = ch.get().getMetaData().getIndexInfo(catalog, this.table.getSchema(), this.table.getName(), false, false);
        this.list("indices", this.lvIndexInfo, rs);
        tp.setTitleAt(2, "indices (" + this.lvIndexInfo.getRowCount() + ")");
    }

    private void listExportedKeys(JTabbedPane tp) throws SQLException {
        ConnectionHandler ch = this.getConnection();
        String catalog = this.table.getSchema() == null ? null : ch.get().getCatalog();
        ResultSet rs = ch.get().getMetaData().getExportedKeys(catalog, this.table.getSchema(), this.table.getName());
        this.list("exported keys", this.lvExportedKeys, rs);
        tp.setTitleAt(3, "exported keys (" + this.lvExportedKeys.getRowCount() + ")");
    }

    private void listImportedKeys(JTabbedPane tp) throws SQLException {
        ConnectionHandler ch = this.getConnection();
        String catalog = this.table.getSchema() == null ? null : ch.get().getCatalog();
        ResultSet rs = ch.get().getMetaData().getImportedKeys(catalog, this.table.getSchema(), this.table.getName());
        this.list("imported keys", this.lvImportedKeys, rs);
        tp.setTitleAt(4, "imported keys (" + this.lvImportedKeys.getRowCount() + ")");
    }

    public String getSelectedTitle() {
        int idx;
        JTabbedPane tp = (JTabbedPane)this.getComponent(0);
        if (tp.getTitleAt(idx = tp.getSelectedIndex()).endsWith(")")) {
            String title = tp.getTitleAt(idx);
            return title.substring(0, title.indexOf(" ("));
        }
        return tp.getTitleAt(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stateChanged(ChangeEvent ce) {
        int idx;
        JTabbedPane tp = (JTabbedPane)ce.getSource();
        if (tp.getTitleAt(idx = tp.getSelectedIndex()).endsWith(")")) {
            return;
        }
        try {
            this.setCursor(new Cursor(3));
            switch (idx) {
                case 0: {
                    this.listColumns(tp);
                    return;
                }
                case 1: {
                    this.listPrimaryKeys(tp);
                    return;
                }
                case 2: {
                    this.listIndexInfo(tp);
                    return;
                }
                case 3: {
                    this.listExportedKeys(tp);
                    return;
                }
                case 4: {
                    this.listImportedKeys(tp);
                    return;
                }
            }
            return;
        }
        catch (SQLException e) {
            String title = tp.getTitleAt(idx);
            tp.setTitleAt(idx, title + " (?)");
            Application.println(e, true);
            return;
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }
}

