/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.api.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.Arrays;
import nickyb.sqleonardo.api.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.api.jdbc.ConnectionHandler;
import nickyb.sqleonardo.api.jdbc._TaskSource;
import nickyb.sqleonardo.api.jdbc._TaskTarget;

public class Task
implements Runnable {
    private static final int MAX_DISPLAY_SIZE = 50;
    private _TaskSource source;
    private _TaskTarget target;
    private Statement stmt = null;
    private ResultSet rs = null;

    public Task(_TaskSource source, _TaskTarget target) {
        this.source = source;
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.target.onTaskStarting();
        try {
            String syntax = this.source.getSyntax().trim();
            if (ConnectionAssistant.hasHandler(this.source.getHandlerKey())) {
                if (syntax.length() > 6) {
                    this.target.message("waiting response...");
                    ConnectionHandler ch = ConnectionAssistant.getHandler(this.source.getHandlerKey());
                    this.stmt = ch.get().createStatement();
                    String sqlcmd = syntax.toUpperCase().substring(0, 6);
                    if (sqlcmd.equals("SELECT")) {
                        this.rs = this.stmt.executeQuery(syntax);
                        this.printSelect();
                        this.rs.close();
                    } else {
                        this.rs = null;
                        int rows = this.stmt.executeUpdate(syntax);
                        if (sqlcmd.startsWith("DELETE") || sqlcmd.startsWith("INSERT") || sqlcmd.startsWith("UPDATE")) {
                            this.target.write(rows + " row(s) affected");
                        } else {
                            this.target.write("command has been executed successfully");
                        }
                    }
                    this.stmt.close();
                    if (!this.target.continueRun()) {
                        this.target.message("stopped!");
                    }
                }
            } else {
                this.target.message("No connection!");
            }
        }
        catch (SQLException sqle) {
            this.target.write(sqle.toString());
        }
        finally {
            this.target.onTaskFinished();
        }
    }

    private void printSelect() throws SQLException {
        if (this.rs == null) {
            return;
        }
        long started = System.currentTimeMillis();
        this.target.message("reading...");
        StringBuffer header = new StringBuffer("| ");
        StringBuffer divider = new StringBuffer("+-");
        int[] columnDisplaySize = new int[this.getColumnCount()];
        for (int i = 1; i <= this.getColumnCount(); ++i) {
            header.append(this.getColumnLabel(i));
            char[] filler = new char[this.getColumnLabel(i).length()];
            Arrays.fill(filler, '-');
            divider.append(filler);
            columnDisplaySize[i - 1] = this.getColumnDisplaySize(i);
            int diff = columnDisplaySize[i - 1] - this.getColumnLabel(i).length();
            if (diff > 0) {
                if (diff > 50) {
                    diff = 50 - this.getColumnLabel(i).length();
                    columnDisplaySize[i - 1] = 50;
                }
                filler = new char[diff];
                Arrays.fill(filler, ' ');
                header.append(filler);
                Arrays.fill(filler, '-');
                divider.append(filler);
            } else {
                columnDisplaySize[i - 1] = this.getColumnLabel(i).length();
            }
            header.append(" | ");
            divider.append("-+-");
        }
        divider.deleteCharAt(divider.length() - 1);
        header.deleteCharAt(header.length() - 1);
        this.target.write(divider.toString() + "\n");
        this.target.write(header.toString() + "\n");
        this.target.write(divider.toString() + "\n");
        int bytes = 0;
        int rowcount = 0;
        while (this.rs.next() && this.target.continueRun()) {
            this.target.message("reading record " + ++rowcount + " , bytes " + bytes);
            StringBuffer row = new StringBuffer("| ");
            for (int i = 1; i <= this.getColumnCount(); ++i) {
                String value = this.rs.getString(i);
                if (value == null) {
                    value = new String();
                }
                bytes += value.length();
                int diff = columnDisplaySize[i - 1] - value.length();
                if (diff > 0) {
                    char[] filler = new char[diff];
                    Arrays.fill(filler, ' ');
                    row.append(value + new String(filler));
                } else if (diff < 0) {
                    value = value.substring(0, columnDisplaySize[i - 1] - 3);
                    row.append(value + "...");
                } else {
                    row.append(value);
                }
                row.append(" | ");
            }
            row.deleteCharAt(row.length() - 1);
            this.target.write(row.toString() + "\n");
        }
        long ended = System.currentTimeMillis();
        long millis = ended - started;
        double seconds = (double)millis / 1000.0;
        if (rowcount > 0) {
            this.target.write(divider.toString() + "\n");
        }
        this.target.write("record(s): " + NumberFormat.getInstance().format(rowcount) + " [ seconds: " + NumberFormat.getInstance().format(seconds) + " bytes: " + NumberFormat.getInstance().format(bytes) + " ]");
    }

    public int getColumnCount() throws SQLException {
        return this.rs.getMetaData().getColumnCount();
    }

    public int getColumnDisplaySize(int index) throws SQLException {
        int type = this.rs.getMetaData().getColumnType(index);
        if (type == 93) {
            return 21;
        }
        return this.rs.getMetaData().getColumnDisplaySize(index);
    }

    public String getColumnLabel(int index) throws SQLException {
        return this.rs.getMetaData().getColumnLabel(index);
    }
}

