/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.notification;

import javax.management.AttributeChangeNotification;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.modelmbean.ModelMBean;
import org.springframework.jmx.export.notification.NotificationPublisher;
import org.springframework.jmx.export.notification.UnableToSendNotificationException;
import org.springframework.util.Assert;

public class ModelMBeanNotificationPublisher
implements NotificationPublisher {
    private final ModelMBean modelMBean;

    public ModelMBeanNotificationPublisher(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    public void sendNotification(Notification notification) {
        Assert.notNull(notification, "Notification must not be null");
        try {
            if (notification instanceof AttributeChangeNotification) {
                this.modelMBean.sendAttributeChangeNotification((AttributeChangeNotification)notification);
            } else {
                this.modelMBean.sendNotification(notification);
            }
        }
        catch (MBeanException ex) {
            throw new UnableToSendNotificationException("Unable to send notification [" + notification + "]", ex);
        }
    }
}

