/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import it.businesslogic.ireport.FontsLoaderMonitor;
import it.businesslogic.ireport.IRFont;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class FontListLoader {
    public static Font loadFont(String file) {
        Font f = null;
        try {
            f = Font.createFont(0, new FileInputStream(file));
        }
        catch (IllegalArgumentException ett) {
            System.out.println(ett.getMessage() + " No TrueType font");
        }
        catch (FontFormatException ef) {
            System.out.println(ef.getMessage() + " FontFormatException");
        }
        catch (IOException ioex) {
            System.out.println(ioex.getMessage() + " IOException");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage() + " General Exception");
        }
        return f;
    }

    public static Vector loadTTFFonts() {
        return FontListLoader.loadTTFFonts(null);
    }

    public static Vector loadTTFFonts(FontsLoaderMonitor monitor) {
        if (monitor != null) {
            monitor.fontsLoadingStarted();
        }
        if (monitor != null) {
            monitor.fontsLoadingStatusUpdated(I18n.getString("fontsLoader.loadingFontsInit", "Initializing font loader"));
        }
        Vector fonts = new Vector();
        Vector fontsPaths = MainFrame.getMainInstance().getFontspath();
        System.out.flush();
        if (fontsPaths == null || fontsPaths.size() == 0) {
            String path = System.getProperty("java.class.path");
            if (path != null && path.length() > 0) {
                StringTokenizer st = new StringTokenizer(path, System.getProperty("path.separator"));
                while (st.hasMoreTokens()) {
                    String path_str = st.nextToken();
                    try {
                        FontListLoader.addFont(fonts, path_str, monitor);
                    }
                    catch (Exception ex) {
                        MainFrame.getMainInstance().logOnConsole("Invalid font found in: " + path_str);
                    }
                }
            }
        } else {
            Enumeration e_fonts = fontsPaths.elements();
            while (e_fonts.hasMoreElements()) {
                String path_str = (String)e_fonts.nextElement();
                try {
                    FontListLoader.addFont(fonts, path_str, monitor);
                }
                catch (Exception ex) {
                    MainFrame.getMainInstance().logOnConsole("Invalid font found in: " + path_str);
                }
            }
        }
        if (monitor != null) {
            monitor.fontsLoadingFinished();
        }
        return fonts;
    }

    public static void addFont(Vector fonts, String path_str, FontsLoaderMonitor monitor) {
        MessageFormat formatter = new MessageFormat(I18n.getString("fontsLoader.loadedFont", "Loaded font {0}"), I18n.getCurrentLocale());
        File file = new File(path_str);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] files = file.list(new FilenameFilter(){

                public boolean accept(File dir, String filename) {
                    return filename.toUpperCase().endsWith(".TTF") || filename.toUpperCase().endsWith(".TTC");
                }
            });
            DefaultFontMapper fontMapper = new DefaultFontMapper();
            if (files == null) {
                System.out.println("Unable to list files in: " + file);
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].toUpperCase().endsWith(".TTC")) {
                    try {
                        String[] names = BaseFont.enumerateTTCNames((String)(file.getPath() + File.separator + files[i]));
                        for (int a = 0; a < names.length; ++a) {
                            Font f = fontMapper.pdfToAwt(FontFactory.getFont((String)(file.getPath() + File.separator + files[i])).getBaseFont(), 10);
                            if (f != null) {
                                fonts.addElement(new IRFont(f, files[i]));
                            } else {
                                System.out.println("Failed to load font " + file.getPath() + File.separator + files[i]);
                            }
                            if (monitor == null) continue;
                            Object[] objectArray = new Object[1];
                            objectArray[0] = file.getPath() + File.separator + files[i];
                            monitor.fontsLoadingStatusUpdated(formatter.format(objectArray));
                        }
                        continue;
                    }
                    catch (DocumentException de) {
                        System.out.println((Object)de);
                        continue;
                    }
                    catch (IOException ioe) {
                        System.out.println(ioe);
                        continue;
                    }
                }
                Font f = FontListLoader.loadFont(file.getPath() + File.separator + files[i]);
                if (f != null) {
                    fonts.addElement(new IRFont(f, files[i]));
                } else {
                    System.out.println("Failed to load font " + file.getPath() + File.separator + files[i]);
                }
                if (monitor == null) continue;
                Object[] objectArray = new Object[1];
                objectArray[0] = file.getPath() + File.separator + files[i];
                monitor.fontsLoadingStatusUpdated(formatter.format(objectArray));
            }
        } else if (path_str.toUpperCase().endsWith(".TTF")) {
            System.out.println("m" + path_str);
        } else if (path_str.toUpperCase().endsWith(".TTC")) {
            System.out.println("TTC: " + path_str);
        }
    }
}

