/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import mondrian.rolap.cache.SmartCache;

public class SoftSmartCache
implements SmartCache {
    Map cache = new HashMap();
    ReferenceQueue queue = new ReferenceQueue();

    public synchronized Object put(Object key, Object value) {
        CacheReference ref;
        while ((ref = (CacheReference)this.queue.poll()) != null) {
            this.cache.remove(ref.key);
        }
        ref = new CacheReference(key, value);
        if ((ref = this.cache.put(key, ref)) != null) {
            return ref.get();
        }
        return null;
    }

    public synchronized Object get(Object key) {
        SoftReference ref = (SoftReference)this.cache.get(key);
        if (ref == null) {
            return null;
        }
        Object value = ref.get();
        if (value == null) {
            this.cache.remove(key);
        }
        return value;
    }

    public void clear() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }

    class CacheReference
    extends SoftReference {
        Object key;

        public CacheReference(Object key, Object value) {
            super(value, SoftSmartCache.this.queue);
            this.key = key;
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }
}

