/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import mondrian.olap.Category;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.CubeType;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.SymbolType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;

public class FunDefBase
extends FunUtil
implements FunDef {
    protected final int flags;
    private final String name;
    private final String description;
    protected final int returnType;
    protected final int[] parameterTypes;

    FunDefBase(String name, String signature, String description, Syntax syntax, int returnType, int[] parameterTypes) {
        this.name = name;
        Util.discard((Object)signature);
        this.description = description;
        this.flags = syntax.ordinal;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
    }

    protected FunDefBase(String name, String signature, String description, String flags) {
        this(name, signature, description, FunDefBase.decodeSyntacticType(flags), FunDefBase.decodeReturnType(flags), FunDefBase.decodeParameterTypes(flags));
    }

    FunDefBase(Resolver resolver, int returnType, int[] parameterTypes) {
        this(resolver.getName(), null, null, resolver.getSyntax(), returnType, parameterTypes);
    }

    FunDefBase(FunDef funDef) {
        this(funDef.getName(), funDef.getSignature(), funDef.getDescription(), funDef.getSyntax(), funDef.getReturnCategory(), funDef.getParameterTypes());
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Syntax getSyntax() {
        return Syntax.get(this.flags);
    }

    public int getReturnCategory() {
        return this.returnType;
    }

    public int[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Exp validateCall(Validator validator, FunCall call) {
        Exp[] args;
        int[] types = this.getParameterTypes();
        Util.assertTrue(types.length == (args = call.getArgs()).length);
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.validateArg(validator, call, i, types[i]);
        }
        Type type = this.getResultType(validator, args);
        if (type == null) {
            throw Util.newInternal("could not derive type");
        }
        call.setType(type);
        return call;
    }

    protected Exp validateArg(Validator validator, FunCall call, int i, int type) {
        Exp arg = call.getArgs()[i];
        return validator.convert(arg, type);
    }

    static Type guessResultType(Exp[] args, int category, String name) {
        switch (category) {
            case 5: {
                return new BooleanType();
            }
            case 7: {
                return new NumericType();
            }
            case 15: {
                return new DecimalType(Integer.MAX_VALUE, 0);
            }
            case 9: {
                return new StringType();
            }
            case 11: {
                return new SymbolType();
            }
            case 13: {
                return new ScalarType();
            }
            case 12: {
                if (args.length <= 0 || !(args[0] instanceof Cube)) break;
                return new CubeType((Cube)args[0]);
            }
            case 2: {
                if (args.length <= 0) break;
                Type type = args[0].getTypeX();
                Hierarchy hierarchy = type.getHierarchy();
                Dimension dimension = hierarchy == null ? null : hierarchy.getDimension();
                return new DimensionType(dimension);
            }
            case 3: {
                if (args.length <= 0) break;
                Type type = args[0].getTypeX();
                Hierarchy hierarchy = type.getHierarchy();
                return new HierarchyType(hierarchy);
            }
            case 4: {
                if (args.length <= 0 || !(args[0] instanceof Level)) break;
                Type type = args[0].getTypeX();
                Level level = TypeUtil.typeToLevel(type);
                return new LevelType(level.getHierarchy(), level);
            }
            case 6: 
            case 10: {
                if (args.length <= 0) break;
                Type type = args[0].getTypeX();
                return TypeUtil.toMemberType(type);
            }
            case 8: {
                if (args.length <= 0) break;
                Type type = args[0].getTypeX();
                return new SetType(TypeUtil.toMemberType(type));
            }
            default: {
                throw Category.instance.badValue(category);
            }
        }
        throw Util.newInternal("Cannot deduce type of call to function '" + name + "'");
    }

    public Type getResultType(Validator validator, Exp[] args) {
        return FunDefBase.guessResultType(args, this.getReturnCategory(), this.name);
    }

    public Object evaluate(Evaluator evaluator, Exp[] args) {
        throw Util.newInternal("function '" + this.getSignature() + "' has not been implemented");
    }

    public String getSignature() {
        return this.getSyntax().getSignature(this.getName(), this.getReturnCategory(), this.getParameterTypes());
    }

    public void unparse(Exp[] args, PrintWriter pw) {
        this.getSyntax().unparse(this.getName(), args, pw);
    }

    public boolean callDependsOn(FunCall call, Dimension dimension) {
        Exp[] args = call.getArgs();
        for (int i = 0; i < args.length; ++i) {
            Exp arg = args[i];
            if (arg == null || !arg.dependsOn(dimension)) continue;
            return true;
        }
        return false;
    }
}

