/*
 * Copyright (C) 2005 - 2006 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * TranslationStatusDetailDialog.java
 * 
 * Created on March 27, 2006, 8:06 PM
 *
 */

package it.businesslogic.ireport.plugin.locale;


import it.businesslogic.ireport.plugin.locale.ResourceKey;
import it.businesslogic.ireport.util.Misc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JFileChooser;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/**
 *
 * @author  gtoffoli
 */
public class TranslationStatusDetailDialog extends javax.swing.JDialog {
    
    private java.util.Properties properties = null;
    private String fileName = "";
    
    /** Creates new form TranslationStatusDialog */
    public TranslationStatusDetailDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initAll();
    }
    
    /**
     */
    public TranslationStatusDetailDialog(java.awt.Dialog parent, boolean modal) {
        super(parent, modal);
        initAll();
    }
    
    private void initAll()
    {
        initComponents();
        
        TableColumnModel tcm = jTableLanguages.getColumnModel();
        TableColumn tc = tcm.getColumn(0);
        tc.setCellRenderer(new MissingResourceCellRenderer());
        
        DefaultListSelectionModel dsm = new DefaultListSelectionModel();
        dsm.setSelectionMode( dsm.SINGLE_SELECTION );
        dsm.addListSelectionListener( new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                jButtonDetails.setEnabled( jTableLanguages.getSelectedRow() >= 0);
            }
        });
        jTableLanguages.setSelectionModel( dsm );
        
        pack();
        Misc.centerFrame(this);
        
        javax.swing.KeyStroke escape =  javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0, false);
            javax.swing.Action escapeAction = new javax.swing.AbstractAction() {
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    jButtonOkActionPerformed(e);
                }
            };

            getRootPane().getInputMap(javax.swing.JComponent.WHEN_IN_FOCUSED_WINDOW).put(escape, "ESCAPE");
            getRootPane().getActionMap().put("ESCAPE", escapeAction);


            //to make the default button ...
            this.getRootPane().setDefaultButton(this.jButtonOk);
    }
    
    /*
     * languageFile (es. ireport_it.properties)
     */
    public void setLanguage(String language, Properties defaultTranslations)
    {
        DefaultTableModel dtm = (DefaultTableModel)jTableLanguages.getModel();
        dtm.setRowCount(0);
        properties = new Properties();
        this.fileName = language;
        try {
        properties.load( this.getClass().getResourceAsStream("/it/businesslogic/ireport/locale/" + language ) );
        } catch (Exception ex){}
        
        Iterator namesIterator = defaultTranslations.keySet().iterator();
        String[] names = new String[defaultTranslations.keySet().size()];
        for (int i=0; i<names.length; ++i)
        {
            names[i] = (String)namesIterator.next();
            
        }
        java.util.Arrays.sort(names);
        
        
        double translated = 0;
        for (int i=0; i<names.length; ++i)
        {
            String name = ""+names[i];
            ResourceKey rk = new ResourceKey(name);
            if (properties.getProperty(name) == null)
            {
                rk.setMissing(true);
            }
            dtm.addRow(new Object[]{rk, ((!rk.isMissing()) ? properties.getProperty(name) : ""), it.businesslogic.ireport.util.I18n.getString(name) });
            
        }
        
        jTableLanguages.updateUI();
    }
    
       
    /** This method is called from within the constructor to
     * initialize the form
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        jTableLanguages = new javax.swing.JTable();
        jButtonOk = new javax.swing.JButton();
        jButtonDetails = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        jTableLanguages.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Key", "Translation", "Default"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class, java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTableLanguages.setGridColor(new java.awt.Color(204, 204, 204));
        jTableLanguages.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTableLanguagesMouseClicked(evt);
            }
        });

        jScrollPane1.setViewportView(jTableLanguages);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jScrollPane1, gridBagConstraints);

        jButtonOk.setText("Close");
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        getContentPane().add(jButtonOk, gridBagConstraints);

        jButtonDetails.setText("Export");
        jButtonDetails.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDetailsActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jButtonDetails, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed

        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_jButtonOkActionPerformed

    private void jButtonDetailsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDetailsActionPerformed
// jfilechooser...
        try {
	    JFileChooser jfc = new JFileChooser();          
            jfc.setSelectedFile(new File(getFileName()));
	    if (jfc.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
                
                    FileOutputStream fos = new FileOutputStream(jfc.getSelectedFile());
                    this.getProperties().store(fos, "");
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter(fos));
                    pw.println("\n\n# ---------- Missing translations -------------");
                    
                    for (int i=0; i<jTableLanguages.getRowCount(); ++i)
                    {
                        ResourceKey rk = (ResourceKey)jTableLanguages.getValueAt(i,0);
                        if (rk.isMissing())
                        {
                            pw.println("#"+rk+"="+jTableLanguages.getValueAt(i,2));
                        }
                    }
                    
                    pw.close();
	    }
        } catch (Exception ex)
        {
            ex.printStackTrace();
        }
        
    }//GEN-LAST:event_jButtonDetailsActionPerformed

    private void jTableLanguagesMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTableLanguagesMouseClicked

        if (evt.getClickCount() == 2 &&
            evt.getButton() == evt.BUTTON1)
        {
            jButtonDetailsActionPerformed(null);
        }
        
    }//GEN-LAST:event_jTableLanguagesMouseClicked
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new TranslationStatusDialog(new javax.swing.JFrame(), true).setVisible(true);
            }
        });
    }

    public java.util.Properties getProperties() {
        return properties;
    }

    public void setProperties(java.util.Properties properties) {
        this.properties = properties;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonDetails;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTableLanguages;
    // End of variables declaration//GEN-END:variables
    
}
