/*
 * Copyright (C) 2005 - 2006 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * JDragTable.java
 * 
 * Created on 14 novembre 2003, 0.43
 *
 */

package it.businesslogic.ireport.gui;
import java.awt.dnd.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.gui.dnd.*;
import java.awt.datatransfer.*;

/**
 *
 * @author  Administrator
 */
public class JDragTable extends javax.swing.JTable implements DragGestureListener,
                DragSourceListener {    

   public JDragTable() {

      DragSource dragSource = DragSource.getDefaultDragSource();

      // creating the recognizer is all that's necessary - it
      // does not need to be manipulated after creation
      dragSource.createDefaultDragGestureRecognizer(
         this, // component where drag originates
         DnDConstants.ACTION_COPY, // actions
         this); // drag gesture listener
      }
      
       public void dragGestureRecognized(DragGestureEvent e) {
         // drag anything ...
         
         TransferableObject  to =   new TransferableObject(this.getValueAt(this.getSelectedRow(), this.getSelectedColumn() ));
         
         try{
         if (to != null)
         e.startDrag(DragSource.DefaultCopyDrop , // cursor
            to); //, // transferable
            //this); // drag source listener
         } catch (Exception ex) {

            ex.printStackTrace();

         }

      }

      public void dragDropEnd(DragSourceDropEvent e) {}
      public void dragEnter(DragSourceDragEvent e) {}
      public void dragExit(DragSourceEvent e) {}
      public void dragOver(DragSourceDragEvent e) {}
      public void dropActionChanged(DragSourceDragEvent e) {}

}
