/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Vector;
import org.eigenbase.xom.AssertFailure;
import org.eigenbase.xom.XMLAttrVector;
import org.eigenbase.xom.XMLUtil;
import org.eigenbase.xom.XOMUtil;

public class XMLOutput {
    private PrintWriter out;
    private Vector tagStack;
    private int indent;
    private int tagsWritten;
    private boolean compact;
    private String indentString = "\t";
    private boolean glob;
    private boolean inTag;
    private boolean alwaysQuoteCData;
    private boolean ignorePcdata;

    private void displayIndent(PrintWriter printWriter, int n) {
        if (!this.compact) {
            for (int i = 0; i < n; ++i) {
                printWriter.print(this.indentString);
            }
        }
    }

    public XMLOutput(Writer writer) {
        this.out = new PrintWriter(writer, true);
        this.indent = 0;
        this.tagsWritten = 0;
        this.tagStack = new Vector();
    }

    public void setCompact(boolean bl) {
        this.compact = bl;
    }

    public boolean getCompact() {
        return this.compact;
    }

    public void setIndentString(String string) {
        this.indentString = string;
    }

    public void setGlob(boolean bl) {
        this.glob = bl;
    }

    public void setAlwaysQuoteCData(boolean bl) {
        this.alwaysQuoteCData = bl;
    }

    public void setIgnorePcdata(boolean bl) {
        this.ignorePcdata = bl;
    }

    public boolean getIgnorePcdata() {
        return this.ignorePcdata;
    }

    public void print(String string) {
        this.out.print(string);
    }

    public void beginTag(String string, XMLAttrVector xMLAttrVector) {
        this.beginBeginTag(string);
        if (xMLAttrVector != null) {
            xMLAttrVector.display(this.out, this.indent);
        }
        this.endBeginTag(string);
    }

    public void beginBeginTag(String string) {
        if (this.inTag) {
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
            this.inTag = false;
        }
        this.displayIndent(this.out, this.indent);
        this.out.print("<");
        this.out.print(string);
    }

    public void endBeginTag(String string) {
        if (this.glob) {
            this.inTag = true;
        } else if (this.compact) {
            this.out.print(">");
        } else {
            this.out.println(">");
        }
        this.out.flush();
        this.tagStack.addElement(string);
        ++this.indent;
        ++this.tagsWritten;
    }

    public void attribute(String string, String string2) {
        XMLUtil.printAtt(this.out, string, string2);
    }

    public void beginNode() {
        if (this.inTag) {
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
            this.inTag = false;
        }
    }

    public void endTag(String string) {
        int n = this.tagStack.size();
        String string2 = (String)this.tagStack.elementAt(n - 1);
        if (!string.equalsIgnoreCase(string2)) {
            throw new AssertFailure("End tag <" + string + "> does not match " + " start tag <" + string2 + ">");
        }
        this.tagStack.removeElementAt(n - 1);
        --this.indent;
        if (this.inTag) {
            if (this.compact) {
                this.out.print("/>");
            } else {
                this.out.println("/>");
            }
            this.inTag = false;
        } else {
            this.displayIndent(this.out, this.indent);
            this.out.print("</");
            this.out.print(string);
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
        }
        this.out.flush();
    }

    public void emptyTag(String string, XMLAttrVector xMLAttrVector) {
        if (this.inTag) {
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
            this.inTag = false;
        }
        this.displayIndent(this.out, this.indent);
        this.out.print("<");
        this.out.print(string);
        if (xMLAttrVector != null) {
            this.out.print(" ");
            xMLAttrVector.display(this.out, this.indent);
        }
        if (this.compact) {
            this.out.print("/>");
        } else {
            this.out.println("/>");
        }
        this.out.flush();
        ++this.tagsWritten;
    }

    public void cdata(String string) {
        this.cdata(string, false);
    }

    public void cdata(String string, boolean bl) {
        if (this.inTag) {
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
            this.inTag = false;
        }
        if (string == null) {
            string = "";
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (XOMUtil.stringHasXMLSpecials(string)) {
            bl2 = true;
            if (string.indexOf("]]>") > -1) {
                bl3 = true;
            }
        }
        this.displayIndent(this.out, this.indent);
        if (bl || this.alwaysQuoteCData) {
            this.out.print("<![CDATA[");
            this.out.print(string);
            this.out.println("]]>");
        } else if (!bl2 && !bl3) {
            this.out.print(string);
        } else {
            XMLUtil.stringEncodeXML(string, this.out);
        }
        this.out.flush();
        ++this.tagsWritten;
    }

    public void stringTag(String string, String string2) {
        this.beginTag(string, null);
        this.cdata(string2);
        this.endTag(string);
    }

    public void content(String string) {
        if (string != null) {
            ++this.indent;
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
            try {
                String string2;
                while ((string2 = lineNumberReader.readLine()) != null) {
                    this.displayIndent(this.out, this.indent);
                    this.out.println(string2);
                }
            }
            catch (IOException iOException) {
                throw new AssertFailure(iOException);
            }
            --this.indent;
            this.out.flush();
        }
        ++this.tagsWritten;
    }

    public void header() {
        this.out.println("<? xml version=\"1.0\" ?>");
        this.out.flush();
        ++this.tagsWritten;
    }

    public void header(String string) {
        this.out.print("<? xml version=\"");
        this.out.print(string);
        this.out.println("\" ?>");
        this.out.flush();
        ++this.tagsWritten;
    }

    public int numTagsWritten() {
        return this.tagsWritten;
    }
}

